/*
 * Decompiled with CFR 0.152.
 */
package sr;

import java.util.Random;
import org.bouncycastle.crypto.digests.SHA1Digest;

public class SecureRandom
extends Random {
    private static SecureRandom rand = new SecureRandom();
    private long counter = 1L;
    private SHA1Digest digest = new SHA1Digest();
    private byte[] state = new byte[this.digest.getDigestSize()];
    private byte[] intBytes = new byte[4];
    private byte[] longBytes = new byte[8];

    public SecureRandom() {
        super(0L);
        this.setSeed(System.currentTimeMillis());
    }

    public SecureRandom(byte[] inSeed) {
        super(0L);
        this.setSeed(inSeed);
    }

    public static SecureRandom getInstance(String algorithm) {
        return new SecureRandom();
    }

    public static SecureRandom getInstance(String algorithm, String provider) {
        return new SecureRandom();
    }

    public static byte[] getSeed(int numBytes) {
        byte[] rv = new byte[numBytes];
        rand.setSeed(System.currentTimeMillis());
        rand.nextBytes(rv);
        return rv;
    }

    public byte[] generateSeed(int numBytes) {
        byte[] rv = new byte[numBytes];
        this.nextBytes(rv);
        return rv;
    }

    public void setSeed(byte[] inSeed) {
        this.digest.update(inSeed, 0, inSeed.length);
    }

    public void nextBytes(byte[] bytes) {
        int stateOff = 0;
        this.digest.doFinal(this.state, 0);
        int i = 0;
        while (i != bytes.length) {
            if (stateOff == this.state.length) {
                byte[] b = this.longToBytes(this.counter++);
                this.digest.update(b, 0, b.length);
                this.digest.update(this.state, 0, this.state.length);
                this.digest.doFinal(this.state, 0);
                stateOff = 0;
            }
            bytes[i] = this.state[stateOff++];
            ++i;
        }
        byte[] b = this.longToBytes(this.counter++);
        this.digest.update(b, 0, b.length);
        this.digest.update(this.state, 0, this.state.length);
    }

    public void setSeed(long rSeed) {
        if (rSeed != 0L) {
            this.setSeed(this.longToBytes(rSeed));
        }
    }

    public int nextInt() {
        this.nextBytes(this.intBytes);
        int result = 0;
        int i = 0;
        while (i < 4) {
            result = (result << 8) + (this.intBytes[i] & 0xFF);
            ++i;
        }
        return result;
    }

    protected final int next(int numBits) {
        int size = (numBits + 7) / 8;
        byte[] bytes = new byte[size];
        this.nextBytes(bytes);
        int result = 0;
        int i = 0;
        while (i < size) {
            result = (result << 8) + (bytes[i] & 0xFF);
            ++i;
        }
        return result & (1 << numBits) - 1;
    }

    private byte[] longToBytes(long val) {
        int i = 0;
        while (i != 8) {
            this.longBytes[i] = (byte)val;
            val >>>= 8;
            ++i;
        }
        return this.longBytes;
    }
}

