/*
 * Decompiled with CFR 0.152.
 */
package at.calista.app.gui.data;

import javax.microedition.lcdui.Image;

public class GraphicLibrary {
    public static final Image grayGradiant(int n2, int n3, int n4, int n5) {
        int[] nArray = new int[n4 * n5];
        for (int i2 = 0; i2 < n5; ++i2) {
            int n6 = GraphicLibrary.HSVtoRGB(0, 0, (n3 - n2) * i2 / n5 + n2);
            for (int i3 = 0; i3 < n4; ++i3) {
                nArray[i2 * n4 + i3] = n6;
            }
        }
        Image image = Image.createRGBImage((int[])nArray, (int)n4, (int)n5, (boolean)false);
        return image;
    }

    public static final Image colorGradiant(int n2, int n3, int n4, int n5, int n6) {
        int[] nArray = new int[n5 * n6];
        for (int i2 = 0; i2 < n6; ++i2) {
            int n7 = GraphicLibrary.HSVtoRGB(n2, (n4 - n3) * i2 / n6 + n3, 100);
            for (int i3 = 0; i3 < n5; ++i3) {
                nArray[i2 * n5 + i3] = n7;
            }
        }
        Image image = Image.createRGBImage((int[])nArray, (int)n5, (int)n6, (boolean)false);
        return image;
    }

    public static final Image colorGradiantDark(int n2, int n3, int n4, int n5, int n6) {
        int[] nArray = new int[n5 * n6];
        for (int i2 = 0; i2 < n6; ++i2) {
            int n7 = GraphicLibrary.HSVtoRGB(n2, 100, (n4 - n3) * i2 / n6 + n3);
            for (int i3 = 0; i3 < n5; ++i3) {
                nArray[i2 * n5 + i3] = n7;
            }
        }
        Image image = Image.createRGBImage((int[])nArray, (int)n5, (int)n6, (boolean)false);
        return image;
    }

    public static int HSVtoRGB(int n2, int n3, int n4) {
        double d2 = (double)n3 / 100.0;
        double d3 = (double)n4 / 100.0;
        double d4 = n2 / 60;
        double d5 = Math.toDegrees(n2) / Math.toDegrees(60.0) - d4;
        double d6 = d3 * (1.0 - d2);
        double d7 = d3 * (1.0 - d2 * d5);
        double d8 = d3 * (1.0 - d2 * (1.0 - d5));
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        if (d2 == 0.0) {
            d9 = d3 * 255.0;
            d10 = d3 * 255.0;
            d11 = d3 * 255.0;
        } else {
            switch ((int)d4) {
                case 0: {
                    d9 = d3;
                    d10 = d8;
                    d11 = d6;
                    break;
                }
                case 1: {
                    d9 = d7;
                    d10 = d3;
                    d11 = d6;
                    break;
                }
                case 2: {
                    d9 = d6;
                    d10 = d3;
                    d11 = d8;
                    break;
                }
                case 3: {
                    d9 = d6;
                    d10 = d7;
                    d11 = d3;
                    break;
                }
                case 4: {
                    d9 = d8;
                    d10 = d6;
                    d11 = d3;
                    break;
                }
                case 5: {
                    d9 = d3;
                    d10 = d6;
                    d11 = d7;
                }
            }
            d9 *= 255.0;
            d10 *= 255.0;
            d11 *= 255.0;
        }
        return (int)d9 << 16 | (int)d10 << 8 | (int)d11;
    }
}

