/*
 * Decompiled with CFR 0.152.
 */
package com.pacmobile.yp.mypcard.rms;

import com.pacmobile.yp.mypcard.utility.Locale;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotFoundException;

public class RegistrationRMS {
    public static boolean isRegistered() {
        boolean result = false;
        try {
            RecordStore rs = RecordStore.openRecordStore((String)"MYPRegistration", (boolean)true);
            if (rs != null) {
                result = rs.getNumRecords() >= 3;
            }
            rs.closeRecordStore();
        }
        catch (RecordStoreException e) {
            System.err.println(e.getMessage());
        }
        return result;
    }

    public static String getMYPCardNum() {
        String result = "";
        try {
            RecordStore rs = RecordStore.openRecordStore((String)"MYPRegistration", (boolean)true);
            if (rs != null) {
                if (rs.getNumRecords() >= 3) {
                    String string = new String(rs.getRecord(1), "UTF8");
                    if (string != null && string.length() > 0) {
                        result = string;
                    }
                } else {
                    result = "";
                }
            }
            rs.closeRecordStore();
        }
        catch (RecordStoreException e) {
            System.err.println(e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            System.err.println(e.getMessage());
        }
        return result;
    }

    public static String getEmail() {
        String result = "";
        try {
            String string;
            RecordStore rs = RecordStore.openRecordStore((String)"MYPRegistration", (boolean)true);
            if (rs != null && rs.getNumRecords() >= 3 && rs.getRecord(2) != null && (string = new String(rs.getRecord(2), "UTF8")) != null && string.length() > 0) {
                result = string;
            }
            rs.closeRecordStore();
        }
        catch (RecordStoreException e) {
            System.err.println(e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            System.err.println(e.getMessage());
        }
        return result;
    }

    public static Date getDate() {
        Date result = new Date();
        try {
            long time;
            Date date;
            RecordStore rs = RecordStore.openRecordStore((String)"MYPRegistration", (boolean)true);
            if (rs != null && rs.getNumRecords() >= 3 && (date = new Date(time = Long.parseLong(new String(rs.getRecord(3), "UTF8")))) != null) {
                result = date;
            }
            rs.closeRecordStore();
        }
        catch (RecordStoreException e) {
            System.err.println(e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            System.err.println(e.getMessage());
        }
        return result;
    }

    public static void saveRegistration(String mypCardNum, String email, Date date) {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)"MYPRegistration", (boolean)true);
            byte[] mypCardNumData = mypCardNum.getBytes();
            byte[] emailData = email.getBytes();
            byte[] dateData = Long.toString(date.getTime()).getBytes();
            if (rs != null) {
                if (rs.getNumRecords() >= 3) {
                    rs.setRecord(1, mypCardNumData, 0, mypCardNumData.length);
                    rs.setRecord(2, emailData, 0, emailData.length);
                    rs.setRecord(3, dateData, 0, dateData.length);
                } else {
                    System.out.println(Locale.getDefaultLocale().getLanguage());
                    rs.addRecord(mypCardNumData, 0, mypCardNumData.length);
                    rs.addRecord(emailData, 0, emailData.length);
                    rs.addRecord(dateData, 0, dateData.length);
                }
            }
            rs.closeRecordStore();
        }
        catch (RecordStoreException e) {
            System.err.println(e.getMessage());
        }
    }

    public static void deleteRecordStore() {
        if (!RegistrationRMS.isRegistered()) {
            return;
        }
        try {
            RecordStore.deleteRecordStore((String)"MYPRegistration");
        }
        catch (RecordStoreNotFoundException e) {
            e.printStackTrace();
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
    }
}

