/*
 * Decompiled with CFR 0.152.
 */
package com.pacmobile.yp.mypcard.scene;

import com.pacmobile.yp.mypcard.midlet.MYPCardMIDlet;
import com.pacmobile.yp.mypcard.scene.Scene;
import com.pacmobile.yp.mypcard.scene.SceneController;
import com.pacmobile.yp.mypcard.scene.canvas.BaseCanvas;
import com.pacmobile.yp.mypcard.scene.canvas.DisplayMypCardCanvas;
import com.pacmobile.yp.mypcard.utility.MsgUtility;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;

public class DisplayMypCardScene
extends Scene {
    private static final String PREVIOUS_SCENE_NAME = "MainMenuScene";
    DisplayMypCardCanvas canvas = null;
    private Command backCmd = null;
    private Command exitCmd = null;
    private Command helpCmd = null;

    public DisplayMypCardScene() {
        this.setPrevSceneName(PREVIOUS_SCENE_NAME);
        this.canvas = new DisplayMypCardCanvas();
        this.loadPage();
    }

    public void unloadPage() {
        this.canvas.clearAllItems();
        this.canvas.resetSelectedItemIndex();
        this.canvas.removeAllCommands();
        this.backCmd = null;
        this.exitCmd = null;
        this.helpCmd = null;
        System.gc();
    }

    public void loadPage() {
        this.unloadPage();
        this.backCmd = new Command(MsgUtility.getMessage("label.back"), 2, 1);
        this.canvas.addCommand(this.backCmd, BaseCanvas.COMMAND_SOFTKEY_SIDE_LEFT);
        this.canvas.setBackCommand(this.backCmd);
        this.helpCmd = new Command(MsgUtility.getMessage("label.help"), 1, 1);
        this.canvas.addCommand(this.helpCmd, BaseCanvas.COMMAND_SOFTKEY_SIDE_RIGHT);
    }

    public void disableCancelButton() {
    }

    public void display() {
        this.canvas.setCommandListener(this);
        this.canvas.repaint();
    }

    public Displayable getDisplayable() {
        return this.canvas;
    }

    public void commandAction(Command cmd, Displayable arg1) {
        if (cmd == this.exitCmd) {
            if (this.midlet instanceof MYPCardMIDlet) {
                ((MYPCardMIDlet)this.midlet).quit(false);
            }
        } else if (cmd.getCommandType() == 2) {
            if (this.prevSceneName != null) {
                SceneController.getInstance().forward(this.prevSceneName, this);
            }
        } else if (cmd == this.helpCmd) {
            SceneController.getInstance().forward("HelpScene", this);
        }
    }

    public void draw() {
        try {
            if (this.canvas != null) {
                this.canvas.draw();
            }
        }
        catch (Throwable e) {
            BaseCanvas.setErrorMsg(e.getMessage());
        }
    }

    protected void unload() {
        if (this.canvas != null) {
            this.canvas.unload();
            this.canvas = null;
        }
        this.backCmd = null;
        this.exitCmd = null;
        System.gc();
        super.unload();
    }
}

