/*
 * Decompiled with CFR 0.152.
 */
package com.pacmobile.yp.mypcard.utility;

import com.pacmobile.yp.mypcard.utility.Locale;
import com.pacmobile.yp.mypcard.utility.StrUtility;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.midlet.MIDlet;

public class Props {
    private static MIDlet midlet = null;
    private static Props instance = null;
    private static Hashtable propertiesMap = new Hashtable();
    private String className = this.getClass().getName();

    private Props() {
    }

    public static synchronized Props getInstance() {
        if (instance == null) {
            instance = new Props();
        }
        return instance;
    }

    public static void init(MIDlet parent) {
        midlet = parent;
    }

    public String readPropertiesFile(String fileName, boolean isEncoded) throws Exception {
        String result;
        block18: {
            InputStream is = null;
            InputStreamReader reader = null;
            result = "";
            try {
                if (midlet == null) {
                    System.out.println("midlet==null");
                }
                if ((is = midlet.getClass().getResourceAsStream(fileName)) != null) {
                    StringBuffer data = new StringBuffer();
                    char[] buf = new char[1024];
                    int readCnt = 0;
                    reader = new InputStreamReader(is, "UTF-8");
                    while ((readCnt = reader.read(buf)) != -1) {
                        data.append(new String(buf, 0, readCnt));
                    }
                    result = data.toString();
                    break block18;
                }
                throw new Exception();
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {}
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return result;
    }

    private Hashtable parseProperties(String data) {
        return StrUtility.linesToHashtable(data);
    }

    private String appendSuffix(String name, Locale locale) {
        StringBuffer bundleFileName = new StringBuffer();
        bundleFileName.append("/");
        bundleFileName.append(name);
        bundleFileName.append("_");
        bundleFileName.append(locale.getLanguage());
        bundleFileName.append("_");
        bundleFileName.append(locale.getCountry());
        bundleFileName.append(".properties");
        return bundleFileName.toString();
    }

    private String appendSuffix(String name) {
        StringBuffer bundleFileName = new StringBuffer();
        bundleFileName.append("/");
        bundleFileName.append(name);
        bundleFileName.append(".properties");
        return bundleFileName.toString();
    }

    public synchronized Hashtable getProperties(String bundleName, Locale locale) {
        StringBuffer bundleKeyBuf = new StringBuffer();
        bundleKeyBuf.append(bundleName);
        bundleKeyBuf.append("_");
        bundleKeyBuf.append(locale.getLanguage());
        bundleKeyBuf.append("_");
        bundleKeyBuf.append(locale.getCountry());
        StringBuffer fallbackBundleKeyBuf = new StringBuffer();
        fallbackBundleKeyBuf.append(bundleName);
        fallbackBundleKeyBuf.append("_");
        fallbackBundleKeyBuf.append(locale.getLanguage());
        StringBuffer finalFallbackBundleKeyBuf = new StringBuffer();
        finalFallbackBundleKeyBuf.append(bundleName);
        finalFallbackBundleKeyBuf.append("_en");
        String[] searchFiles = new String[]{bundleKeyBuf.toString(), fallbackBundleKeyBuf.toString(), finalFallbackBundleKeyBuf.toString()};
        Hashtable properties = null;
        int i = 0;
        while (i < searchFiles.length) {
            block4: {
                block3: {
                    properties = (Hashtable)propertiesMap.get(bundleKeyBuf.toString());
                    try {
                        String data = null;
                        String fileName = this.appendSuffix(searchFiles[i]);
                        data = this.readPropertiesFile(fileName, false);
                        properties = this.parseProperties(data);
                        if (properties == null) break block3;
                        propertiesMap.put(bundleKeyBuf.toString(), properties);
                    }
                    catch (Exception ioe) {
                        break block4;
                    }
                }
                if (properties != null) break;
            }
            ++i;
        }
        return properties;
    }

    public void reloadProperties(Vector reloadList) {
        boolean isBundleReloaded = false;
        int i = 0;
        while (i < reloadList.size()) {
            String key = (String)reloadList.elementAt(i);
            int offset = key.indexOf("_");
            if (offset == -1) {
                Hashtable prevTable = (Hashtable)propertiesMap.remove(key);
                if (prevTable != null) {
                    prevTable.clear();
                }
                this.getProperties(key);
            } else if (offset != -1 && !isBundleReloaded) {
                Locale defaultLocale = Locale.getDefaultLocale();
                String bundleName = key.substring(0, offset);
                String bundleKey = String.valueOf(bundleName) + "_" + defaultLocale.getLanguage() + "_" + defaultLocale.getCountry();
                Hashtable prevTable = (Hashtable)propertiesMap.remove(bundleKey);
                if (prevTable != null) {
                    prevTable.clear();
                }
                this.getProperties(bundleName, defaultLocale);
                isBundleReloaded = true;
            }
            ++i;
        }
    }

    public synchronized Hashtable getProperties(String propertiesName) {
        Hashtable properties = (Hashtable)propertiesMap.get(propertiesName);
        if (properties == null) {
            try {
                String data = null;
                String fileName = this.appendSuffix(propertiesName);
                data = this.readPropertiesFile(fileName, false);
                properties = this.parseProperties(data);
                propertiesMap.put(propertiesName, properties);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return properties;
    }

    public synchronized Hashtable getEncodedProperties(String propertiesName) {
        Hashtable properties = (Hashtable)propertiesMap.get(propertiesName);
        if (properties == null) {
            String fileName = this.appendSuffix(propertiesName);
            try {
                String data = this.readPropertiesFile(fileName, true);
                properties = this.parseProperties(data);
                propertiesMap.put(propertiesName, properties);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return properties;
    }
}

