/*
 * Decompiled with CFR 0.152.
 */
package viewer;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import net.kbox.ActionController;
import net.kbox.component.KGameCanvas;
import search.Promotion;

public class BranchList
extends KGameCanvas {
    private Font font;
    private int selected = 0;
    private String str1;
    private String str2;
    private int fontColor;
    private int bgColor;
    private int selectedBorderColor;
    private Promotion[] promotions;
    private Promotion proms;
    private int num;
    private ActionController ac;

    public void paint(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        int rowHeight = height / 12;
        int rowSpace = rowHeight / 4;
        g.setColor(this.bgColor);
        g.fillRect(0, 0, width - 2, height - 2);
        int fixedY = this.font.getHeight();
        g.setColor(this.selectedBorderColor);
        int i = 0;
        while (i < this.promotions.length) {
            if (i % 2 == 0) {
                g.setColor(255, 192, 203);
                g.fillRect(2, rowHeight * (i * 2 + 1) + i * rowSpace, this.getWidth() - 4, rowHeight * 2 - 2);
            }
            ++i;
        }
        g.setFont(this.font);
        g.setColor(this.fontColor);
        g.drawString(this.str1, 2, 2, 20);
        g.drawString(this.str2, this.getWidth() - g.getFont().stringWidth(this.str2) - 2, 2, 20);
        String rstName = "";
        String brefDesc = "";
        int j = 0;
        while (j < this.promotions.length) {
            int cw;
            char c;
            int i2;
            if (this.selected == j) {
                g.setColor(-363140);
                g.fillRect(1, rowHeight * (j * 2 + 1) + j * rowSpace - 1, 3, rowHeight * 2);
                g.fillRect(1, rowHeight * (j * 2 + 1) + j * rowSpace - 1, this.getWidth() - 2, 3);
                g.fillRect(1, rowHeight * (j * 2 + 1) + j * rowSpace + rowHeight * 2 - 4, this.getWidth() - 2, 3);
                g.fillRect(this.getWidth() - 4, rowHeight * (j * 2 + 1) + j * rowSpace - 1, 3, rowHeight * 2 - 3);
            }
            g.setColor(this.fontColor);
            rstName = this.promotions[j].getRestaurantName();
            brefDesc = this.promotions[j].getBriefDesc();
            int fixedX = 4;
            if (g.getFont().stringWidth(rstName) + 11 > width) {
                i2 = 0;
                while (i2 < rstName.length()) {
                    c = rstName.charAt(i2);
                    cw = this.font.charWidth(c);
                    if (fixedX + cw + 15 >= width) {
                        g.drawString("\u2026", fixedX, rowHeight * (j * 2 + 1) + j * rowSpace, 20);
                        break;
                    }
                    g.drawChar(c, fixedX, rowHeight * (j * 2 + 1) + j * rowSpace, 20);
                    fixedX += cw;
                    ++i2;
                }
            }
            fixedX = 4;
            if (g.getFont().stringWidth(rstName) + 11 <= width) {
                g.drawString(rstName, 4, rowHeight * (j * 2 + 1) + j * rowSpace, 20);
            }
            if (g.getFont().stringWidth(brefDesc) + 11 > width) {
                i2 = 0;
                while (i2 < brefDesc.length()) {
                    c = brefDesc.charAt(i2);
                    cw = this.font.charWidth(c);
                    if (fixedX + cw + 15 >= width) {
                        g.drawString("\u2026", fixedX, rowHeight * (j * 2 + 2) + j * rowSpace, 20);
                        break;
                    }
                    g.drawChar(c, fixedX, rowHeight * (j * 2 + 2) + j * rowSpace, 20);
                    fixedX += cw;
                    ++i2;
                }
            }
            if (g.getFont().stringWidth(brefDesc) + 11 <= width) {
                g.drawString(brefDesc, 4, rowHeight * (j * 2 + 2) + j * rowSpace, 20);
            }
            ++j;
        }
    }

    public BranchList(Promotion[] promotions, String uniqueID, Font font, String str1, String str2, int fontColor, int bgColor, int selectedBGColor) {
        super(uniqueID);
        this.promotions = promotions;
        this.font = font;
        this.str1 = str1;
        this.str2 = str2;
        this.fontColor = fontColor;
        this.bgColor = bgColor;
        this.selectedBorderColor = bgColor;
        this.num = promotions.length;
    }

    protected void keyPressed(int keyCode) {
        String keyName = this.mapKeyCode(keyCode);
        if (keyName != null && keyName.trim().length() != 0) {
            super.keyPressed(keyCode);
            if (this.ac != null && (keyName.equals("*") || keyName.equals("#") || keyName.equals("0"))) {
                this.ac.keyPressedAction("PRESSED", keyName, this);
            }
        }
    }

    protected String mapKeyCode(int keyCode) {
        String mapName;
        block0 : switch (keyCode) {
            case 35: {
                mapName = "#";
                break;
            }
            case 42: {
                mapName = "*";
                break;
            }
            case 48: {
                mapName = "0";
                break;
            }
            case 50: {
                mapName = "";
                if (--this.selected >= 0) break;
                this.selected += this.num;
                break;
            }
            case 52: {
                mapName = "";
                this.selected = (this.selected + 1) % this.num;
                break;
            }
            case 54: {
                mapName = "";
                if (--this.selected >= 0) break;
                this.selected += this.num;
                break;
            }
            case 56: {
                mapName = "";
                this.selected = (this.selected + 1) % this.num;
                break;
            }
            default: {
                int gameAction = this.getGameAction(keyCode);
                switch (gameAction) {
                    case 1: {
                        mapName = "";
                        if (--this.selected >= 0) break block0;
                        this.selected += this.num;
                        break block0;
                    }
                    case 6: {
                        this.selected = (this.selected + 1) % this.num;
                        mapName = "";
                        break block0;
                    }
                    case 2: {
                        mapName = "";
                        if (--this.selected >= 0) break block0;
                        this.selected += this.num;
                        break block0;
                    }
                    case 5: {
                        this.selected = (this.selected + 1) % this.num;
                        mapName = "";
                        break block0;
                    }
                    case 8: {
                        mapName = "FIRE";
                        break block0;
                    }
                    default: {
                        mapName = "";
                    }
                }
            }
        }
        this.repaint();
        this.serviceRepaints();
        return mapName;
    }

    public void showNotify() {
        this.repaint();
    }

    public Promotion[] getPromotions() {
        return this.promotions;
    }

    public void setPromotions(Promotion[] promotions) {
        this.promotions = promotions;
    }

    public Promotion getProms() {
        return this.proms;
    }

    public void setProms(Promotion proms) {
        this.proms = proms;
    }

    public int getSelected() {
        return this.selected;
    }

    public void setSelected(int selected) {
        this.selected = selected;
    }

    public int getNum() {
        return this.num;
    }

    public void setNum(int num) {
        this.num = num;
    }
}

