/*
 * Decompiled with CFR 0.152.
 */
package com.pacmobile.yp.mypcard.scene.canvas;

import com.pacmobile.yp.mypcard.MYPConstants;
import com.pacmobile.yp.mypcard.scene.canvas.Color;
import com.pacmobile.yp.mypcard.scene.canvas.item.CanvasItem;
import com.pacmobile.yp.mypcard.utility.LineEnumeration;
import com.pacmobile.yp.mypcard.utility.MsgUtility;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

public class BaseCanvas
extends GameCanvas {
    public int SIDE_PADDING_WIDTH = 3;
    boolean isDisabled = false;
    Vector canvasItems = null;
    int selectedItemIndex = -1;
    static Graphics graphics = null;
    static LineEnumeration lineEnumeration = null;
    public static int DISPLAY_STATUS_NORMAL = 0;
    public static int DISPLAY_STATUS_LEFT_COMMAND_MENU = 1;
    public static int DISPLAY_STATUS_RIGHT_COMMAND_MENU = 2;
    Thread repaintThread = null;
    public static long REPAINT_TIME_INTERVAL_MS = 75L;
    public static long SYSTEM_GC_TIME_INTERVAL_MS = 2000L;
    public static String IMG_PATH_SCROLL_BAR_AXIS = "/images/scrollaxis.png";
    public static String IMG_PATH_SCROLL_BAR_TOP = "/images/scrolltop.png";
    public static String IMG_PATH_SCROLL_BAR_MID = "/images/scrollmid.png";
    public static String IMG_PATH_SCROLL_BAR_BOTTOM = "/images/scrollbot.png";
    public static int POPUP_MENU_PADDING = 5;
    public static int KEY_LEFT_SOFTKEY = -6;
    public static int KEY_RIGHT_SOFTKET = -7;
    public static int KEY_UP = -1;
    public static int KEY_DOWN = -2;
    public static int KEY_LEFT = -3;
    public static int KEY_RIGHT = -4;
    public static int KEY_FIRE = -5;
    public static int KEY_2 = 50;
    public static int KEY_4 = 52;
    public static int KEY_5 = 53;
    public static int KEY_6 = 54;
    public static int KEY_8 = 56;
    public static int KEY_9 = 57;
    public static int KEY_0 = 48;
    public static int KEY_1 = 49;
    public static int KEY_3 = 51;
    public static int KEY_7 = 55;
    public static int KEY_STAR = 42;
    public static int KEY_WELL = 35;
    public static int KEY_BACK = -11;
    public static int COMMAND_SOFTKEY_SIDE_LEFT = 0;
    public static int COMMAND_SOFTKEY_SIDE_RIGHT = 1;
    public static int COMMAND_SOFTKEY_SIDE_CENTER = 2;
    public static int SCROLLBAR_RCET_WIDTH = 5;
    public static int MIN_SCROLLBAR_HEIGHT = 50;
    public static int BACKGROUND_RADIAL_GARDIENT_CENTER_COLOR = 15771792;
    public static int BACKGROUND_RADIAL_GARDIENT_EDGE_COLOR = 9899777;
    public static int SOFTKEY_BAR_GARDIENT_TOP_COLOR = Color.DEFAULT_SOFTKEY_BAR_COLOR;
    public static int SOFTKEY_BAR_GARDIENT_BOTTOM_COLOR = Color.DEFAULT_SOFTKEY_BAR_COLOR;
    public static int SOFTKEY_TEXT_COLOR = Color.DEFAULT_BACKGROUNG_FONT_COLOR;
    public static int BACKGROUND_COLOR = Color.DEFAULT_BACKGROUNG_COLOR;
    public static int TICKER_BAR_COLOR = 0;
    public static int CONTENT_TITLE_COLOR = 0xFFFFFF;
    public static int CONTENT_TEXT_COLOR = 0xFFFFFF;
    public static int SCROLLBAR_RECT_COLOR = 255;
    public static int SCROLLBAR_COLOR = 0x5555FF;
    public static int DEFAULT_FONT_COLOR = 0xFFFFFF;
    public static int HIGHLIGHTED_FONT_COLOR = 0;
    public static int LOADING_SCREEN_FONT_COLOR = 0;
    public static int HIGHLIGHTED_ITEM_COLOR = 14536681;
    public static int HIGHLIGHTED_TEXT_COLOR = 0;
    protected Timer timer = null;
    protected TimerTask timerTask = null;
    protected boolean on = false;
    Vector commandRightSideList;
    Vector commandLeftSideList;
    CommandListener commandListener;
    Command selectCommand;
    Command backCommand;
    int displayStatus = 0;
    int screenWidth = 1;
    int screenHeight = 1;
    int selectedLeftCommandMenuItemIndex = 0;
    boolean isScreenSizeUpdated = false;
    static Font smallFont = Font.getFont((int)64, (int)0, (int)8);
    static Font mediumFont = Font.getFont((int)64, (int)0, (int)0);
    static Font mediumBoldFont = Font.getFont((int)64, (int)1, (int)0);
    static Font largeFont = Font.getFont((int)64, (int)0, (int)16);
    static Font largeBoldFont = Font.getFont((int)64, (int)1, (int)16);
    Font softKeyFont = mediumFont;
    int softKeyFontColor = DEFAULT_FONT_COLOR;
    long systemGcLastUpdateTime;
    int selectedIndex = 0;
    Font topBarFont = mediumBoldFont;
    int topBarFontColor = DEFAULT_FONT_COLOR;
    int topBarGradientColor1 = 15444358;
    int topBarGradientColor2 = 9764898;
    int topBarGradientColor3 = 15444358;
    int tickerMessageRelativeOffsetX;
    long tickerLastFrameUpdateTime;
    Font tickerFont = mediumFont;
    int tickerFontColor = DEFAULT_FONT_COLOR;
    Image topBarImg;
    int topBarHeight = 30;
    int tickerHeight = 15;
    int softKeyBarHeight = 20;
    int drawableX;
    int drawableY;
    int drawableWidth;
    int drawableHeight;
    String sceneName = "";
    int contentHeight = -1;
    int contentRelativeY;
    int scrollBarX;
    int scrollBarY;
    int scrollBarWidth = 9;
    int scrollBarHeight;
    int scrollBarRectWidth = 5;
    int scrollBarRectHeight = 0;
    int scrollBarMovableLength = -1;
    String topBarTitle = "K-Mobile";
    String tickerMessage = "";
    Image scrollBarAxisImage;
    Image scrollBarTopImage;
    Image scrollBarMidImage;
    Image scrollBarBottomImage;
    static boolean isShowDebugMsg = false;
    static long freeMem = 0L;
    static String errorMsg = "no error";

    public void unloadCanvasItems() {
        if (this.canvasItems != null) {
            int i = 0;
            while (i < this.canvasItems.size()) {
                CanvasItem canvasItem = (CanvasItem)this.canvasItems.elementAt(i);
                if (canvasItem != null) {
                    canvasItem.unload();
                }
                ++i;
            }
            this.canvasItems.removeAllElements();
        }
        System.gc();
    }

    public int getWidth() {
        if (super.getWidth() < MYPConstants.DEFAULT_SCREEN_WIDTH) {
            return super.getWidth();
        }
        return MYPConstants.DEFAULT_SCREEN_WIDTH;
    }

    public int getHeight() {
        if (super.getHeight() < MYPConstants.DEFAULT_SCREEN_HEIGHT) {
            return super.getHeight();
        }
        return MYPConstants.DEFAULT_SCREEN_HEIGHT;
    }

    public boolean isDisabled() {
        return this.isDisabled;
    }

    public void setIsDisabled(boolean isDisabled) {
        this.isDisabled = isDisabled;
    }

    public void setContentRelativeY(int contentRelativeY) {
        this.contentRelativeY = contentRelativeY;
    }

    public int getContentRelativeY() {
        return this.contentRelativeY;
    }

    public int getSoftKeyBarHeight() {
        return this.softKeyBarHeight;
    }

    public int getScrollBarWidth() {
        return this.scrollBarWidth;
    }

    public int getItemsHeight() {
        int height = 0;
        if (this.canvasItems != null && this.canvasItems.size() > 0) {
            int i = 0;
            while (i < this.canvasItems.size()) {
                height += ((CanvasItem)this.canvasItems.elementAt(i)).getItemHeight();
                ++i;
            }
        }
        return height;
    }

    public void setDrawableHeight(int drawableHeight) {
        this.drawableHeight = drawableHeight;
    }

    public int getDrawableHeight() {
        return this.drawableHeight;
    }

    public void setDrawableWidth(int drawableWidth) {
        this.drawableWidth = drawableWidth;
    }

    public int getDrawableWidth() {
        return this.drawableWidth;
    }

    public BaseCanvas() {
        super(false);
        System.gc();
        this.setFullScreenMode(true);
        this.loadScrollBarImages();
        this.initDrawableData();
        this.commandLeftSideList = new Vector();
        this.commandRightSideList = new Vector();
        this.selectedIndex = 0;
        this.systemGcLastUpdateTime = System.currentTimeMillis();
        this.canvasItems = new Vector();
        this.scrollBarWidth = this.scrollBarAxisImage != null ? this.scrollBarAxisImage.getWidth() : 9;
    }

    public BaseCanvas(String title) {
        this();
        this.topBarTitle = title;
    }

    public void addItem(CanvasItem item) {
        if (this.canvasItems != null && item != null) {
            this.canvasItems.addElement(item);
            if (this.selectedItemIndex == -1 && item.isSelectable()) {
                this.selectedItemIndex = this.canvasItems.size() - 1;
            }
        }
    }

    public void clearAllItems() {
        if (this.canvasItems != null) {
            this.canvasItems.removeAllElements();
        }
    }

    public int getDrawableX() {
        return this.drawableX;
    }

    public void setDrawableX(int drawableX) {
        this.drawableX = drawableX;
    }

    public int getDrawableY() {
        return this.drawableY;
    }

    public void setDrawableY(int drawableY) {
        this.drawableY = drawableY;
    }

    public CanvasItem getSelectedItem() {
        if (this.canvasItems != null && this.selectedItemIndex >= 0 && this.selectedItemIndex < this.canvasItems.size()) {
            return (CanvasItem)this.canvasItems.elementAt(this.selectedItemIndex);
        }
        return null;
    }

    public int getSelectedItemIndex() {
        return this.selectedItemIndex;
    }

    public int getItemTopRelativeY(int index) {
        int relativeY = 0;
        if (this.canvasItems != null && this.canvasItems.size() > 0 && this.canvasItems.size() > index) {
            int i = 1;
            while (i < index) {
                relativeY += ((CanvasItem)this.canvasItems.elementAt(i - 1)).getItemHeight();
                ++i;
            }
        }
        return relativeY;
    }

    public int getItemButtomRelativeY(int index) {
        int relativeY = 0;
        if (this.canvasItems != null && this.canvasItems.size() > 0 && this.canvasItems.size() > index) {
            int i = 0;
            while (i <= index) {
                relativeY += ((CanvasItem)this.canvasItems.elementAt(i)).getItemHeight();
                ++i;
            }
        }
        return relativeY;
    }

    public void prevSelectableItem() {
        int prevSelectableItem = this.selectedItemIndex;
        if (this.canvasItems == null || prevSelectableItem < 0 || prevSelectableItem > this.canvasItems.size()) {
            return;
        }
        int i = this.selectedItemIndex - 1;
        while (i >= 0) {
            if (((CanvasItem)this.canvasItems.elementAt(i)).isSelectable()) {
                prevSelectableItem = i;
                break;
            }
            --i;
        }
        if (-this.contentRelativeY <= this.getItemTopRelativeY(prevSelectableItem)) {
            if (prevSelectableItem == this.selectedItemIndex) {
                this.contentRelativeY += this.getDrawableHeight() / 2;
            } else {
                this.selectItem(prevSelectableItem);
            }
        } else {
            this.contentRelativeY += this.getDrawableHeight() / 2;
            if (-this.contentRelativeY <= this.getItemTopRelativeY(prevSelectableItem)) {
                this.selectItem(prevSelectableItem);
            }
        }
        if (-this.contentRelativeY < 0) {
            this.contentRelativeY = 0;
        }
        if (this.getItemsHeight() <= this.getDrawableHeight()) {
            this.contentRelativeY = 0;
        }
    }

    public void nextSelectableItem() {
        int nextSelectableItem = this.selectedItemIndex;
        int i = this.selectedItemIndex + 1;
        while (i < this.canvasItems.size()) {
            if (((CanvasItem)this.canvasItems.elementAt(i)).isSelectable()) {
                nextSelectableItem = i;
                break;
            }
            ++i;
        }
        if (-this.contentRelativeY + this.getDrawableHeight() >= this.getItemButtomRelativeY(nextSelectableItem)) {
            if (nextSelectableItem == this.selectedItemIndex) {
                this.contentRelativeY -= this.getDrawableHeight() / 2;
            } else {
                this.selectItem(nextSelectableItem);
            }
        } else {
            this.contentRelativeY -= this.getDrawableHeight() / 2;
            if (-this.contentRelativeY + this.getDrawableHeight() >= this.getItemButtomRelativeY(nextSelectableItem)) {
                this.selectItem(nextSelectableItem);
            }
        }
        if (-this.contentRelativeY + this.getDrawableHeight() > this.getItemsHeight()) {
            this.contentRelativeY = -(this.getItemsHeight() - this.getDrawableHeight());
        }
        if (this.getItemsHeight() <= this.getDrawableHeight()) {
            this.contentRelativeY = 0;
        }
    }

    public void moveToItem(int item) {
        this.contentRelativeY = -this.getItemTopRelativeY(item);
        if (-this.contentRelativeY + this.getDrawableHeight() > this.getItemsHeight()) {
            this.contentRelativeY = -(this.getItemsHeight() - this.getDrawableHeight());
        }
    }

    public void moveToItem(CanvasItem item) {
        this.contentRelativeY = 0;
        int nextItemIndex = 0;
        int i = 0;
        while (i < this.canvasItems.size()) {
            if (item == this.canvasItems.elementAt(i)) {
                nextItemIndex = i;
                break;
            }
            ++i;
        }
        this.contentRelativeY = -this.getItemTopRelativeY(nextItemIndex);
        if (-this.contentRelativeY + this.getDrawableHeight() > this.getItemsHeight()) {
            this.contentRelativeY = -(this.getItemsHeight() - this.getDrawableHeight());
        }
    }

    public void selectItem(int index) {
        if (this.canvasItems != null && index >= 0 && index < this.canvasItems.size() && this.selectedItemIndex >= 0 && this.selectedItemIndex < this.canvasItems.size()) {
            ((CanvasItem)this.canvasItems.elementAt(this.selectedItemIndex)).setHightlighted(false);
            this.selectedItemIndex = index;
            if (((CanvasItem)this.canvasItems.elementAt(this.selectedItemIndex)).isSelectable()) {
                ((CanvasItem)this.canvasItems.elementAt(this.selectedItemIndex)).setHightlighted(true);
            }
        }
    }

    public void resetSelectedItemIndex() {
        this.setSelectedItemIndex(-1);
    }

    public void setSelectedItemIndex(int selectedItemIndex) {
        this.selectedItemIndex = selectedItemIndex;
    }

    public int getFirstSelectableItemIndex() {
        if (this.canvasItems != null) {
            int i = 0;
            while (i < this.canvasItems.size()) {
                if (((CanvasItem)this.canvasItems.elementAt(i)).isSelectable()) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public void selectFirstSelectableItem() {
        int i = this.getFirstSelectableItemIndex();
        if (i >= 0) {
            this.selectItem(i);
        }
    }

    public void selectLastSelectableItem() {
        int i = this.getLastSelectableItemIndex();
        if (i >= 0) {
            this.selectItem(i);
        }
    }

    public int getLastSelectableItemIndex() {
        if (this.canvasItems != null) {
            int i = this.canvasItems.size() - 1;
            while (i >= 0) {
                if (((CanvasItem)this.canvasItems.elementAt(i)).isSelectable()) {
                    return i;
                }
                --i;
            }
        }
        return -1;
    }

    public Graphics getStaticGraphics() {
        if (graphics == null) {
            graphics = this.getGraphics();
        } else if (graphics != this.getGraphics()) {
            graphics = null;
            System.gc();
            graphics = this.getGraphics();
        }
        return graphics;
    }

    public void loadScrollBarImages() {
        try {
            this.scrollBarAxisImage = Image.createImage((String)IMG_PATH_SCROLL_BAR_AXIS);
            this.scrollBarTopImage = Image.createImage((String)IMG_PATH_SCROLL_BAR_TOP);
            this.scrollBarMidImage = Image.createImage((String)IMG_PATH_SCROLL_BAR_MID);
            this.scrollBarBottomImage = Image.createImage((String)IMG_PATH_SCROLL_BAR_BOTTOM);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateTickerRollingText() {
        if (this.tickerMessage != null) {
            this.tickerMessageRelativeOffsetX -= this.drawableWidth / 150;
            if (this.tickerMessageRelativeOffsetX < -this.tickerFont.stringWidth(this.tickerMessage)) {
                this.tickerMessageRelativeOffsetX = this.drawableWidth;
            }
        } else {
            this.tickerMessageRelativeOffsetX = 0;
        }
    }

    public boolean isScreenSizeUpdated() {
        boolean result = this.screenWidth != this.getWidth() || this.screenHeight != this.getHeight();
        this.screenWidth = this.getWidth();
        this.screenHeight = this.getHeight();
        return result;
    }

    public void initDrawableData() {
        this.topBarHeight = this.topBarFont.getHeight();
        this.tickerHeight = this.tickerFont.getHeight();
        this.softKeyBarHeight = this.softKeyFont.getHeight();
        this.scrollBarRectWidth = this.scrollBarAxisImage != null ? this.scrollBarAxisImage.getWidth() : SCROLLBAR_RCET_WIDTH;
        this.drawableX = 0;
        this.drawableY = this.topBarHeight + this.tickerHeight;
        this.drawableWidth = this.getWidth() - this.scrollBarRectWidth;
        this.scrollBarRectHeight = this.drawableHeight = this.getHeight() - this.drawableY - this.softKeyBarHeight;
    }

    public int drawStringAtCenter(Graphics g, Font font, String string, int y) {
        g.drawString(string, (this.getWidth() - font.stringWidth(string)) / 2, y, 0);
        return y + font.getHeight();
    }

    public void drawGradientBackground(Graphics g, int startColor, int endColor, int direction) {
        int width = this.getWidth();
        int height = this.getHeight();
        int color = 0;
        int startColorR = (startColor & 0xFF0000) >> 16;
        int startColorG = (startColor & 0xFF00) >> 8;
        int startColorB = startColor & 0xFF;
        int endColorR = (endColor & 0xFF0000) >> 16;
        int endColorG = (endColor & 0xFF00) >> 8;
        int endColorB = endColor & 0xFF;
        int diffR = startColorR - endColorR;
        int diffG = startColorG - endColorG;
        int diffB = startColorB - endColorB;
        int i = 0;
        while (i < height) {
            int tmpR = i * 100 / height * diffR / 100;
            int tmpG = i * 100 / height * diffG / 100;
            int tmpB = i * 100 / height * diffB / 100;
            color = startColorR - tmpR << 16;
            color += startColorG - tmpG << 8;
            g.setColor(color += startColorB - tmpB);
            g.drawLine(0, i, width, i);
            ++i;
        }
        this.drawRadialGradientRect(g, 0, 0, width, height, 0, 0xFF0000);
    }

    public void drawGradientRect(Graphics g, int x, int y, int width, int height, int startColor, int midColor, int endColor) {
        this.drawGradientRect(g, x, y, width, height / 2, startColor, midColor);
        if (height % 2 == 1) {
            this.drawGradientRect(g, x, height / 2, width, height / 2 + 1, midColor, endColor);
        } else {
            this.drawGradientRect(g, x, height / 2, width, height / 2, midColor, endColor);
        }
    }

    public void drawGradientRect(Graphics g, int x, int y, int width, int height, int startColor, int endColor) {
        int color = 0;
        int startColorR = (startColor & 0xFF0000) >> 16;
        int startColorG = (startColor & 0xFF00) >> 8;
        int startColorB = startColor & 0xFF;
        int endColorR = (endColor & 0xFF0000) >> 16;
        int endColorG = (endColor & 0xFF00) >> 8;
        int endColorB = endColor & 0xFF;
        int diffR = startColorR - endColorR;
        int diffG = startColorG - endColorG;
        int diffB = startColorB - endColorB;
        int i = 0;
        while (i < height) {
            int tmpR = i * 100 / height * diffR / 100;
            int tmpG = i * 100 / height * diffG / 100;
            int tmpB = i * 100 / height * diffB / 100;
            color = startColorR - tmpR << 16;
            color += startColorG - tmpG << 8;
            g.setColor(color += startColorB - tmpB);
            g.drawLine(x, y + i, width, y + i);
            ++i;
        }
    }

    public void drawRadialGradientBackground(Graphics g) {
        this.drawRadialGradientRect(g, 0, 0, this.getWidth(), this.getHeight(), BACKGROUND_RADIAL_GARDIENT_CENTER_COLOR, BACKGROUND_RADIAL_GARDIENT_EDGE_COLOR);
    }

    public void drawRadialGradientRect(Graphics g, int x, int y, int width, int height, int centerColor, int endColor) {
        int maxLength = width < height ? height : width;
        int centerX = (x + width) / 2;
        int centerY = (x + height) / 2;
        int color = 0;
        int startColorR = (centerColor & 0xFF0000) >> 16;
        int startColorG = (centerColor & 0xFF00) >> 8;
        int startColorB = centerColor & 0xFF;
        int endColorR = (endColor & 0xFF0000) >> 16;
        int endColorG = (endColor & 0xFF00) >> 8;
        int endColorB = endColor & 0xFF;
        int diffR = startColorR - endColorR;
        int diffG = startColorG - endColorG;
        int diffB = startColorB - endColorB;
        g.setColor(endColor);
        g.fillRect(x, y, width, height);
        int i = maxLength;
        while (i >= 0) {
            if (i == maxLength || i % 5 == 0) {
                int tmpR = i * 100 / height * diffR / 100;
                int tmpG = i * 100 / height * diffG / 100;
                int tmpB = i * 100 / height * diffB / 100;
                color = startColorR - tmpR << 16;
                color += startColorG - tmpG << 8;
                g.setColor(color += startColorB - tmpB);
                g.fillArc(centerX - i, centerY - i, i * 2, i * 2, 0, 360);
            }
            --i;
        }
    }

    public void drawBackground(Graphics g) {
        g.setColor(BACKGROUND_COLOR);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public int drawTopBar(Graphics g, int positionY) {
        this.drawGradientRect(g, 0, positionY, this.getWidth(), this.topBarHeight, this.topBarGradientColor1, this.topBarGradientColor2, this.topBarGradientColor3);
        if (this.topBarTitle != null) {
            g.setFont(this.topBarFont);
            g.setColor(this.topBarFontColor);
            int stringWidth = this.topBarFont.stringWidth(this.topBarTitle);
            g.drawString(this.topBarTitle, (this.getWidth() - stringWidth) / 2, positionY, 0);
        }
        return positionY + this.topBarHeight;
    }

    public int drawTicker(Graphics g, int positionY) {
        g.setFont(this.tickerFont);
        g.setColor(TICKER_BAR_COLOR);
        g.fillRect(0, positionY, this.getWidth(), this.tickerHeight);
        if (this.tickerMessage != null) {
            g.setFont(this.tickerFont);
            g.setColor(this.tickerFontColor);
            g.drawString(this.tickerMessage, this.tickerMessageRelativeOffsetX, positionY, 0);
        }
        return positionY + this.tickerHeight;
    }

    public void drawSoftKeyBar(Graphics g) {
        this.drawGradientRect(g, 0, this.getHeight() - this.softKeyBarHeight, this.getWidth(), this.softKeyBarHeight, SOFTKEY_BAR_GARDIENT_TOP_COLOR, SOFTKEY_BAR_GARDIENT_BOTTOM_COLOR);
        this.drawSoftKey(g);
    }

    public void drawSoftKey(Graphics g) {
        g.setFont(this.softKeyFont);
        g.setColor(this.softKeyFontColor);
        g.setColor(SOFTKEY_TEXT_COLOR);
        if (this.commandLeftSideList != null) {
            String leftSoftKey;
            if (this.commandLeftSideList.size() == 1 && !((Command)this.commandLeftSideList.elementAt(0)).getLabel().equals(MsgUtility.getMessage("label.exit"))) {
                leftSoftKey = ((Command)this.commandLeftSideList.elementAt(0)).getLabel();
                g.drawString(leftSoftKey, 0, this.getHeight(), 36);
            } else if (this.commandLeftSideList.size() >= 1) {
                leftSoftKey = MsgUtility.getMessage("label.option");
                if (leftSoftKey != null) {
                    g.drawString(leftSoftKey, 0, this.getHeight(), 36);
                }
                if (this.displayStatus == DISPLAY_STATUS_LEFT_COMMAND_MENU) {
                    int posY = this.getHeight() - this.softKeyBarHeight - this.commandLeftSideList.size() * this.softKeyFont.getHeight() - 2 * POPUP_MENU_PADDING;
                    int rectWidth = this.getMaxStringWidth(this.commandLeftSideList, this.softKeyFont) + 2 * POPUP_MENU_PADDING;
                    int rectHeight = this.commandLeftSideList.size() * this.softKeyFont.getHeight() + 2 * POPUP_MENU_PADDING;
                    g.setColor(BACKGROUND_COLOR);
                    g.fillRect(0, posY, rectWidth, rectHeight);
                    g.setColor(SOFTKEY_TEXT_COLOR);
                    g.drawRect(0, posY, rectWidth, rectHeight);
                    posY += POPUP_MENU_PADDING;
                    int i = 0;
                    while (i < this.commandLeftSideList.size()) {
                        if (i == this.selectedLeftCommandMenuItemIndex) {
                            g.setColor(HIGHLIGHTED_ITEM_COLOR);
                            g.fillRoundRect(POPUP_MENU_PADDING, posY, rectWidth - 2 * POPUP_MENU_PADDING, this.softKeyFont.getHeight(), POPUP_MENU_PADDING, POPUP_MENU_PADDING);
                            g.setColor(HIGHLIGHTED_FONT_COLOR);
                        }
                        g.drawString(((Command)this.commandLeftSideList.elementAt(i)).getLabel(), POPUP_MENU_PADDING, posY, 0);
                        posY += this.softKeyFont.getHeight();
                        g.setColor(SOFTKEY_TEXT_COLOR);
                        ++i;
                    }
                }
            }
        }
        if (this.commandRightSideList != null && this.commandRightSideList.size() == 1) {
            String rightSoftKey = ((Command)this.commandRightSideList.elementAt(0)).getLabel();
            g.drawString(rightSoftKey, this.getWidth(), this.getHeight(), 40);
        }
        if (this.selectCommand != null) {
            String string = this.selectCommand.getLabel();
        }
    }

    public int getMaxStringWidth(Vector vector, Font font) {
        String[] strings = null;
        if (vector != null && vector.size() > 0 && font != null) {
            strings = new String[vector.size()];
            int i = 0;
            while (i < vector.size()) {
                strings[i] = ((Command)vector.elementAt(i)).getLabel();
                ++i;
            }
            int result = this.getMaxStringWidth(strings, font);
            if (strings != null) {
                int i2 = 0;
                while (i2 < strings.length) {
                    strings[i2] = null;
                    ++i2;
                }
                strings = null;
            }
            return result;
        }
        return 0;
    }

    public int getMaxStringWidth(String[] strings, Font font) {
        int result = 0;
        if (strings != null && font != null) {
            int i = 0;
            while (i < strings.length) {
                if (strings[i] != null && result < font.stringWidth(strings[i])) {
                    result = font.stringWidth(strings[i]);
                }
                ++i;
            }
        }
        return result;
    }

    public void drawRoundRect(Graphics g, int x, int y, int width, int height) {
        int arcLength = 1;
        arcLength = width > height ? height : width;
        if ((arcLength /= 5) < 3) {
            arcLength = 3;
        }
        g.fillRoundRect(x, y, width, height, arcLength, arcLength);
    }

    public void drawScrollBar(Graphics g, int offsetY) {
        this.drawScrollBar(g, this.getWidth() - this.getScrollBarWidth(), offsetY, this.getItemsHeight(), this.getDrawableHeight(), this.getContentRelativeY(), this.getDrawableHeight());
    }

    public void drawScrollBar(Graphics g, int x, int y, int contentHeight, int drawableHeight, int contentRelativeY, int scrollBarHeight) {
        int scrollBarAxisImageHeight = this.scrollBarAxisImage.getHeight();
        if (scrollBarAxisImageHeight <= 0) {
            scrollBarAxisImageHeight = 1;
        }
        if (contentHeight == drawableHeight) {
            --contentHeight;
        }
        this.scrollBarRectHeight = drawableHeight;
        int i = 0;
        while (i < this.scrollBarRectHeight / scrollBarAxisImageHeight) {
            g.drawImage(this.scrollBarAxisImage, x, y + i * scrollBarAxisImageHeight, 0);
            ++i;
        }
        g.drawImage(this.scrollBarAxisImage, x, y + this.scrollBarRectHeight - scrollBarAxisImageHeight, 0);
        if (contentHeight <= 0) {
            contentHeight = 1;
        }
        if ((scrollBarHeight = 1000 * this.scrollBarRectHeight * drawableHeight / contentHeight / 1000) < MIN_SCROLLBAR_HEIGHT) {
            scrollBarHeight = MIN_SCROLLBAR_HEIGHT;
        } else if (scrollBarHeight > drawableHeight) {
            scrollBarHeight = drawableHeight;
        }
        this.scrollBarMovableLength = drawableHeight - scrollBarHeight;
        this.scrollBarX = x;
        if (contentHeight == drawableHeight) {
            ++contentHeight;
        }
        this.scrollBarY = y + 100 * this.scrollBarMovableLength * contentRelativeY / (-contentHeight + drawableHeight) / 100;
        int scrollBarTopImageHeight = 1;
        int scrollBarMidImageHeight = 1;
        int scrollBarBottomImageHeight = 1;
        if (this.scrollBarTopImage != null) {
            scrollBarTopImageHeight = this.scrollBarTopImage.getHeight();
        }
        if (this.scrollBarMidImage != null) {
            scrollBarMidImageHeight = this.scrollBarMidImage.getHeight();
        }
        if (this.scrollBarBottomImage != null) {
            scrollBarBottomImageHeight = this.scrollBarBottomImage.getHeight();
        }
        int scrollBarMidLength = scrollBarHeight - scrollBarTopImageHeight - scrollBarBottomImageHeight;
        g.drawImage(this.scrollBarTopImage, this.scrollBarX, this.scrollBarY, 0);
        int i2 = 0;
        while (i2 < scrollBarMidLength / scrollBarAxisImageHeight) {
            if (this.scrollBarMidImage != null) {
                g.drawImage(this.scrollBarMidImage, this.scrollBarX, this.scrollBarY + scrollBarTopImageHeight + i2 * scrollBarMidImageHeight, 0);
            }
            ++i2;
        }
        if (this.scrollBarMidImage != null) {
            g.drawImage(this.scrollBarMidImage, this.scrollBarX, this.scrollBarY + scrollBarTopImageHeight + scrollBarMidLength - scrollBarMidImageHeight, 0);
        }
        if (this.scrollBarBottomImage != null) {
            g.drawImage(this.scrollBarBottomImage, this.scrollBarX, this.scrollBarY + scrollBarTopImageHeight + scrollBarMidLength, 0);
        }
    }

    public void drawScrollBar(Graphics g, int x, int y) {
        int scrollBarAxisImageHeight = this.scrollBarAxisImage.getHeight();
        if (scrollBarAxisImageHeight <= 0) {
            scrollBarAxisImageHeight = 1;
        }
        if (this.contentHeight == this.drawableHeight) {
            --this.contentHeight;
        }
        int i = 0;
        while (i < this.scrollBarRectHeight / scrollBarAxisImageHeight) {
            g.drawImage(this.scrollBarAxisImage, x, y + i * scrollBarAxisImageHeight, 0);
            ++i;
        }
        g.drawImage(this.scrollBarAxisImage, x, y + this.scrollBarRectHeight - scrollBarAxisImageHeight, 0);
        this.scrollBarHeight = 100 * this.scrollBarRectHeight * this.drawableHeight / this.contentHeight / 100;
        if (this.scrollBarHeight < MIN_SCROLLBAR_HEIGHT) {
            this.scrollBarHeight = MIN_SCROLLBAR_HEIGHT;
        } else if (this.scrollBarHeight > this.drawableHeight) {
            this.scrollBarHeight = this.drawableHeight;
        }
        this.scrollBarWidth = this.scrollBarRectWidth - 2;
        if (this.scrollBarMovableLength == -1) {
            this.scrollBarMovableLength = this.drawableHeight - this.scrollBarHeight;
        }
        this.scrollBarX = x;
        this.scrollBarY = y + 100 * this.scrollBarMovableLength * this.contentRelativeY / (-this.contentHeight + this.drawableHeight) / 100;
        int scrollBarTopImageHeight = this.scrollBarTopImage.getHeight();
        int scrollBarMidImageHeight = this.scrollBarMidImage.getHeight();
        int scrollBarBottomImageHeight = this.scrollBarBottomImage.getHeight();
        int scrollBarMidLength = this.scrollBarHeight - scrollBarTopImageHeight - scrollBarBottomImageHeight;
        g.drawImage(this.scrollBarTopImage, this.scrollBarX, this.scrollBarY, 0);
        int i2 = 0;
        while (i2 < scrollBarMidLength / scrollBarAxisImageHeight) {
            g.drawImage(this.scrollBarMidImage, this.scrollBarX, this.scrollBarY + scrollBarTopImageHeight + i2 * scrollBarMidImageHeight, 0);
            ++i2;
        }
        g.drawImage(this.scrollBarMidImage, this.scrollBarX, this.scrollBarY + scrollBarTopImageHeight + scrollBarMidLength - scrollBarMidImageHeight, 0);
        g.drawImage(this.scrollBarBottomImage, this.scrollBarX, this.scrollBarY + scrollBarTopImageHeight + scrollBarMidLength, 0);
    }

    protected void draw(Graphics g) {
        this.drawRadialGradientBackground(g);
    }

    public void addCommand(Command cmd, int sofyKeySide) {
        if (sofyKeySide == COMMAND_SOFTKEY_SIDE_LEFT) {
            this.commandLeftSideList.addElement(cmd);
        } else if (sofyKeySide == COMMAND_SOFTKEY_SIDE_RIGHT) {
            this.commandRightSideList.addElement(cmd);
        }
    }

    public void setCommandListener(CommandListener commandListener) {
        this.commandListener = commandListener;
    }

    public void setTitle(String title) {
        this.topBarTitle = title;
    }

    public void setSelectCommand(Command cmd) {
        this.selectCommand = cmd;
    }

    public void removeSelectCommand() {
        this.selectCommand = null;
    }

    public void setBackCommand(Command cmd) {
        this.backCommand = cmd;
    }

    public void removeBackCommand() {
        this.backCommand = null;
    }

    public void removeAllCommands() {
        this.removeSelectCommand();
        this.removeBackCommand();
        this.removeAllCommands(COMMAND_SOFTKEY_SIDE_LEFT);
        this.removeAllCommands(COMMAND_SOFTKEY_SIDE_RIGHT);
    }

    public void setSelectedIndex(int selectedIndex) {
        this.selectedIndex = selectedIndex;
    }

    public void setSelectedItemIndex(CanvasItem item) {
        if (this.canvasItems != null && this.canvasItems.size() > 0) {
            int i = 0;
            while (i < this.canvasItems.size()) {
                if (item == this.canvasItems.elementAt(i)) {
                    this.selectItem(i);
                    break;
                }
                ++i;
            }
        }
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void keyPressed(int keyCode) {
        if (this.displayStatus == DISPLAY_STATUS_LEFT_COMMAND_MENU) {
            if (keyCode == KEY_UP || keyCode == KEY_2) {
                --this.selectedLeftCommandMenuItemIndex;
                if (this.selectedLeftCommandMenuItemIndex < 0) {
                    this.selectedLeftCommandMenuItemIndex = this.commandLeftSideList.size() - 1;
                }
            }
            if (keyCode == KEY_DOWN || keyCode == KEY_8) {
                ++this.selectedLeftCommandMenuItemIndex;
                if (this.selectedLeftCommandMenuItemIndex >= this.commandLeftSideList.size()) {
                    this.selectedLeftCommandMenuItemIndex = 0;
                }
            }
            if (keyCode == KEY_FIRE || keyCode == KEY_5) {
                if (this.commandListener != null) {
                    this.commandListener.commandAction((Command)this.commandLeftSideList.elementAt(this.selectedLeftCommandMenuItemIndex), (Displayable)this);
                }
                this.displayStatus = DISPLAY_STATUS_NORMAL;
            }
            if (keyCode == KEY_LEFT_SOFTKEY || keyCode == KEY_RIGHT_SOFTKET) {
                this.displayStatus = DISPLAY_STATUS_NORMAL;
            }
            return;
        }
        if (keyCode == KEY_RIGHT_SOFTKET && this.commandListener != null && this.commandRightSideList.size() == 1) {
            this.commandListener.commandAction((Command)this.commandRightSideList.elementAt(0), (Displayable)this);
        }
        if (keyCode == KEY_LEFT_SOFTKEY && this.commandListener != null) {
            if (this.commandLeftSideList.size() == 1) {
                if (((Command)this.commandLeftSideList.elementAt(0)).getLabel().equals(MsgUtility.getMessage("label.exit"))) {
                    this.triggerCommandMenu(COMMAND_SOFTKEY_SIDE_LEFT);
                } else {
                    this.commandListener.commandAction((Command)this.commandLeftSideList.elementAt(0), (Displayable)this);
                }
            } else if (this.commandLeftSideList.size() > 1) {
                this.triggerCommandMenu(COMMAND_SOFTKEY_SIDE_LEFT);
            }
        }
        if ((keyCode == KEY_FIRE || keyCode == KEY_5) && this.commandListener != null && this.selectCommand != null) {
            this.commandListener.commandAction(this.selectCommand, (Displayable)this);
        }
        if (keyCode == KEY_BACK && this.commandListener != null && this.backCommand != null) {
            this.commandListener.commandAction(this.backCommand, (Displayable)this);
        }
    }

    public void triggerCommandMenu(int softKeySide) {
        if (softKeySide == COMMAND_SOFTKEY_SIDE_LEFT) {
            if (this.displayStatus == DISPLAY_STATUS_LEFT_COMMAND_MENU) {
                this.displayStatus = DISPLAY_STATUS_NORMAL;
                return;
            }
            if (this.commandLeftSideList != null && this.commandLeftSideList.size() >= 1) {
                this.displayStatus = DISPLAY_STATUS_LEFT_COMMAND_MENU;
                this.selectedLeftCommandMenuItemIndex = 0;
            } else {
                this.displayStatus = DISPLAY_STATUS_NORMAL;
            }
        } else if (softKeySide == COMMAND_SOFTKEY_SIDE_RIGHT) {
            if (this.displayStatus == DISPLAY_STATUS_RIGHT_COMMAND_MENU) {
                this.displayStatus = DISPLAY_STATUS_NORMAL;
                return;
            }
            this.displayStatus = this.commandRightSideList != null && this.commandRightSideList.size() > 1 ? DISPLAY_STATUS_RIGHT_COMMAND_MENU : DISPLAY_STATUS_NORMAL;
        }
    }

    public void setTickerMessage(String text) {
        this.tickerMessage = text;
    }

    public String getTickerMessage() {
        return this.tickerMessage;
    }

    public LineEnumeration getLineEnumeration(Font font, String text, int width) {
        if (lineEnumeration == null) {
            lineEnumeration = new LineEnumeration(font, text, width);
        } else {
            lineEnumeration.reset(font, text, width);
        }
        return lineEnumeration;
    }

    public void removeAllCommands(int sofyKeySide) {
        if (sofyKeySide == COMMAND_SOFTKEY_SIDE_LEFT) {
            this.commandLeftSideList.removeAllElements();
        } else if (sofyKeySide == COMMAND_SOFTKEY_SIDE_RIGHT) {
            this.commandRightSideList.removeAllElements();
        }
    }

    public synchronized void stopRepaint() {
        this.on = false;
        this.repaintThread = null;
        if (this.timerTask != null) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
    }

    public synchronized void unload() {
        if (this.commandRightSideList != null) {
            this.commandRightSideList.removeAllElements();
            this.commandRightSideList = null;
        }
        if (this.commandLeftSideList != null) {
            this.commandLeftSideList.removeAllElements();
            this.commandLeftSideList = null;
        }
        this.unloadCanvasItems();
        this.topBarImg = null;
        this.scrollBarAxisImage = null;
        this.scrollBarTopImage = null;
        this.scrollBarMidImage = null;
        this.scrollBarBottomImage = null;
        if (lineEnumeration != null) {
            lineEnumeration.unload();
            lineEnumeration = null;
        }
        System.gc();
    }

    public static void drawDebugMsg(Graphics g) {
        if (isShowDebugMsg) {
            g.setColor(0xFF0000);
            int y = 0;
            y = BaseCanvas.drawFreeMem(g, y);
            int n = BaseCanvas.drawErrorMsg(g, y);
        }
    }

    public static int drawFreeMem(Graphics g, int y) {
        g.setColor(0xFF0000);
        Font font = g.getFont();
        int fontHeight = font.getHeight();
        freeMem = Runtime.getRuntime().freeMemory();
        g.drawString("FreeMem: " + freeMem, 0, y, 0);
        long totalMem = Runtime.getRuntime().totalMemory();
        g.drawString("TotalMem: " + totalMem, 0, y += fontHeight, 0);
        return y += fontHeight;
    }

    public static void setErrorMsg(String msg) {
        errorMsg = msg;
    }

    public static int drawErrorMsg(Graphics g, int y) {
        if (errorMsg != null) {
            Font font = g.getFont();
            int fontHeight = font.getHeight();
            g.drawString(errorMsg, 0, y, 0);
            y += fontHeight;
        }
        return y;
    }

    public static char keyCodeToChar(int keyCode) {
        if (keyCode == KEY_0) {
            return '0';
        }
        if (keyCode == KEY_1) {
            return '1';
        }
        if (keyCode == KEY_2) {
            return '2';
        }
        if (keyCode == KEY_3) {
            return '3';
        }
        if (keyCode == KEY_4) {
            return '4';
        }
        if (keyCode == KEY_5) {
            return '5';
        }
        if (keyCode == KEY_6) {
            return '6';
        }
        if (keyCode == KEY_7) {
            return '7';
        }
        if (keyCode == KEY_8) {
            return '8';
        }
        if (keyCode == KEY_9) {
            return '9';
        }
        if (keyCode == KEY_STAR) {
            return '*';
        }
        if (keyCode == KEY_WELL) {
            return '#';
        }
        return '_';
    }
}

