/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.twitter;

import com.sonyericsson.twitter.LinkedText;
import com.sonyericsson.twitter.TwitterClient;
import com.sonyericsson.twitter.Utils;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import se.vitamin.ui.Button;
import se.vitamin.ui.UI;
import se.vitamin.ui.Window;

public class TwitterButton
extends Button {
    protected static Image[] _pressed = null;
    protected static Image[] _unpressed = null;
    private LinkedText _subtitleImageActive;
    private LinkedText _subtitleImageInactive;
    private String _str2;
    private String _str3;
    private boolean singleLine = true;
    public String secondary = null;

    public TwitterButton(Window parent, int id, String str, String descr, Font f1, Font f2) {
        super(parent, id, -1, -1, f1, f2);
        this._str2 = str;
        this._str3 = descr;
        this._h = f1.getHeight() + 10;
        if (descr != null) {
            this._subtitleImageActive = new LinkedText(descr, 0xFFFFFF, 255, 0xFFFFFF, 16, 255, 1, true, false, false);
            this._subtitleImageInactive = new LinkedText(descr, 549498, 0xFFFFFF, 549498, 16, 255, 1, true, false, false);
            this._h += this._subtitleImageActive.getHeight();
            this.singleLine = false;
        }
        this._titleW = f1.stringWidth(this._str2);
        if (this._str3 != null) {
            this._subtitleW = this._font2 != null ? f2.stringWidth(this._str3) : f1.stringWidth(this._str3);
        }
        this._minW = this._titleW < this._subtitleW ? this._subtitleW + 10 : this._titleW;
        this._w = this._minW;
        this._titleX = (this._minW - this._titleW) / 2;
        this._subtitleX = (this._minW - this._subtitleW) / 2;
    }

    public TwitterButton(Window parent, int id, int str, int descr, Font f1, Font f2) {
        super(parent, id, str, descr, f1, f2);
        this._h = f1.getHeight() + 10;
        if (descr >= 0) {
            this._subtitleImageActive = new LinkedText(UI.getString(descr), 0xFFFFFF, 255, 0xFFFFFF, 16, 212, 2, true, false, false);
            this._subtitleImageInactive = new LinkedText(UI.getString(descr), 549498, 0xFFFFFF, 549498, 16, 212, 2, true, false, false);
            this._h += this._subtitleImageActive.getHeight();
            this.singleLine = false;
        }
    }

    private void paintGradientBackground(Graphics g, int x, int y, int color) {
        if (this._active) {
            Utils.drawGradient(x, y, this._w - 1, this._h, 1, g);
        } else {
            Utils.drawGradient(x, y, this._w - 1, this._h, 0, g);
        }
        TwitterClient.drawRoundBorder(g, x, y, this._w, this._h, this._active);
    }

    protected void paintBackground(Graphics g, int x, int y) {
        this.paintGradientBackground(g, x, y, 0);
    }

    public boolean handleKeyDown(int keyCode) {
        if (keyCode == -5) {
            this._parent.widgetEvent(this._id, Integer.MIN_VALUE);
            return true;
        }
        return false;
    }

    public void paint(Graphics g, int x, int y) {
        this.paintBackground(g, x + this._x, y + this._y);
        int textY = y + this._y + 4 + 2;
        if (this._title >= 0) {
            this._str2 = UI.getString(this._title);
        }
        if (this.singleLine) {
            textY = this._y + y + (this._h - this._font1.getHeight()) / 2;
        }
        if (this._active) {
            g.setColor(this._activeColor);
            g.setFont(this._font1);
            if (this._str2 != null) {
                g.setColor(549498);
                g.drawString(this._str2, x + this._x + this._titleX, 1 + textY, 0);
                g.setColor(0xFFFFFF);
                g.drawString(this._str2, x + this._x + this._titleX, textY, 0);
            }
            if (this._subtitle > 0 || this._str3 != null) {
                this._subtitleImageActive.drawLinklessTextCentered(g, y + this._y + this._subtitleY + 2);
            }
        } else {
            g.setColor(this._inactiveColor);
            g.setFont(this._font1);
            if (this._str2 != null) {
                g.setColor(0xFFFFFF);
                g.drawString(this._str2, x + this._x + this._titleX, 1 + textY, 0);
                g.setColor(549498);
                g.drawString(this._str2, x + this._x + this._titleX, textY, 0);
            }
            if (this._subtitle > 0 || this._str3 != null) {
                this._subtitleImageInactive.drawLinklessTextCentered(g, y + this._y + this._subtitleY + 2);
            }
        }
    }

    public void reCenter() {
        if (this._title == -1) {
            return;
        }
        this._str2 = UI.getString(this._title);
        this._titleW = this._font1.stringWidth(this._str2);
        int minw = this._w;
        if (this._str3 != null) {
            this._subtitleW = this._font2 != null ? this._font2.stringWidth(this._str3) : this._font1.stringWidth(this._str3);
        }
        this._minW = this._titleW < this._subtitleW ? this._subtitleW + 10 : this._titleW;
        this._w = this._minW;
        this._titleX = (this._minW - this._titleW) / 2;
        this._subtitleX = (this._minW - this._subtitleW) / 2;
        this.setDimensions(Math.max(minw, this._titleW + 20), 0);
    }
}

