/*
 * Decompiled with CFR 0.152.
 */
package se.vitamin.ui;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TextShrinker {
    private Vector cutVec = new Vector(10, 10);

    public Image solidHalfSizeSingleLine(String text, int textColor, int bgColor, int size, int alpha, int maxWidth, boolean centered, boolean arabic) {
        Font f = Font.getFont((int)64, (int)0, (int)size);
        int fh = f.getHeight();
        if (fh % 2 == 1) {
            ++fh;
        }
        int fl = f.stringWidth(text);
        if (maxWidth != -1) {
            while (fl > maxWidth * 2) {
                text = text.substring(0, text.length() - 1);
                fl = f.stringWidth(text);
            }
        }
        if (fl % 2 == 1) {
            ++fl;
        }
        int oh = fh;
        int ow = fl;
        int os = ow * oh;
        int nh = fh / 2;
        int nw = fl / 2;
        int ns = nh * nw;
        Image img = Image.createImage((int)ow, (int)oh);
        Graphics g = img.getGraphics();
        g.setColor(bgColor);
        g.fillRect(0, 0, ow, oh);
        g.setColor(textColor);
        g.setFont(f);
        g.drawString(text, centered ? ow / 2 : (arabic ? ow : 0), 0, centered ? 17 : (arabic ? 24 : 0));
        int[] oldimg = new int[os];
        int[] newimg = new int[ns];
        img.getRGB(oldimg, 0, ow, 0, 0, ow, oh);
        int j = 0;
        if (alpha > 255) {
            alpha = 255;
        }
        alpha <<= 24;
        for (int i = 0; i < ns; ++i) {
            int R = (oldimg[j] & 0xFF0000) + (oldimg[j + 1] & 0xFF0000) + (oldimg[j + ow] & 0xFF0000) + (oldimg[j + ow + 1] & 0xFF0000) >> 2 & 0xFF0000;
            int G = (oldimg[j] & 0xFF00) + (oldimg[j + 1] & 0xFF00) + (oldimg[j + ow] & 0xFF00) + (oldimg[j + ow + 1] & 0xFF00) >> 2 & 0xFF00;
            int B = (oldimg[j] & 0xFF) + (oldimg[j + 1] & 0xFF) + (oldimg[j + ow] & 0xFF) + (oldimg[j + ow + 1] & 0xFF) >> 2 & 0xFF;
            newimg[i] = alpha | R | G | B;
            j += 2;
            if (i % nw != nw - 1) continue;
            j += ow;
        }
        return Image.createRGBImage((int[])newimg, (int)nw, (int)nh, (alpha < -16777216 ? 1 : 0) != 0);
    }

    public Image solidHalfSizeMultiLine(String text, int textColor, int bgColor, int size, int alpha, int width, int hMargin, int vMargin, int maxLines, boolean centered, boolean arabic) {
        int fh;
        text = text.replace('\n', ' ');
        text = text.replace('\r', ' ');
        text = text.replace('\u2029', ' ');
        text = this.spaceClean(text);
        Font f = Font.getFont((int)64, (int)0, (int)size);
        String[] textLines = this.splitText(text, 2 * width, f, false);
        if (maxLines == -1 || textLines.length < maxLines) {
            maxLines = textLines.length;
        }
        if ((fh = f.getHeight() * maxLines) % 2 == 1) {
            ++fh;
        }
        int fw = 2 * width + 4 * hMargin;
        int oh = fh += 4 * vMargin;
        int ow = fw;
        int os = ow * oh;
        int nh = fh / 2;
        int nw = fw / 2;
        int ns = nh * nw;
        Image img = Image.createImage((int)ow, (int)oh);
        Graphics g = img.getGraphics();
        g.setColor(bgColor);
        g.fillRect(0, 0, ow, oh);
        g.setColor(textColor);
        g.setFont(f);
        for (int i = 0; i < maxLines; ++i) {
            g.drawString(textLines[i], centered ? ow / 2 : (arabic ? ow - 2 * hMargin : 2 * hMargin), f.getHeight() * i + 2 * vMargin, centered ? 17 : (arabic ? 24 : 0));
        }
        int[] oldimg = new int[os];
        int[] newimg = new int[ns];
        img.getRGB(oldimg, 0, ow, 0, 0, ow, oh);
        int j = 0;
        if (alpha > 255) {
            alpha = 255;
        }
        alpha <<= 24;
        for (int i = 0; i < ns; ++i) {
            int R = (oldimg[j] & 0xFF0000) + (oldimg[j + 1] & 0xFF0000) + (oldimg[j + ow] & 0xFF0000) + (oldimg[j + ow + 1] & 0xFF0000) >> 2 & 0xFF0000;
            int G = (oldimg[j] & 0xFF00) + (oldimg[j + 1] & 0xFF00) + (oldimg[j + ow] & 0xFF00) + (oldimg[j + ow + 1] & 0xFF00) >> 2 & 0xFF00;
            int B = (oldimg[j] & 0xFF) + (oldimg[j + 1] & 0xFF) + (oldimg[j + ow] & 0xFF) + (oldimg[j + ow + 1] & 0xFF) >> 2 & 0xFF;
            newimg[i] = alpha | R | G | B;
            j += 2;
            if (i % nw != nw - 1) continue;
            j += ow;
        }
        return Image.createRGBImage((int[])newimg, (int)nw, (int)nh, (alpha < -16777216 ? 1 : 0) != 0);
    }

    public Image transparentHalfSizeSingleLine(String text, int textColor, int size, int alpha, int maxWidth) {
        Font f = Font.getFont((int)64, (int)0, (int)size);
        int fh = f.getHeight();
        if (fh % 2 == 1) {
            ++fh;
        }
        int fl = f.stringWidth(text);
        if (maxWidth != -1) {
            maxWidth *= 2;
            while (fl > maxWidth) {
                text = text.substring(0, text.length() - 1);
                fl = f.stringWidth(text);
            }
        }
        if (fl % 2 == 1) {
            ++fl;
        }
        int oh = fh;
        int ow = fl;
        int os = ow * oh;
        int nh = fh / 2;
        int nw = fl / 2;
        int ns = nh * nw;
        Image img = Image.createImage((int)ow, (int)oh);
        Graphics g = img.getGraphics();
        g.setColor(0);
        g.fillRect(0, 0, ow, oh);
        g.setColor(0xFFFFFF);
        g.setFont(f);
        g.drawString(text, 0, 0, 0);
        int[] oldimg = new int[os];
        int[] newimg = new int[ns];
        img.getRGB(oldimg, 0, ow, 0, 0, ow, oh);
        int j = 0;
        int l = nw - 1;
        textColor &= 0xFFFFFF;
        if (alpha >= 255 || alpha < 0) {
            for (int i = 0; i < ns; ++i) {
                int A = (oldimg[j] & 0xFF) + (oldimg[j + 1] & 0xFF) + (oldimg[j + ow] & 0xFF) + (oldimg[j + ow + 1] & 0xFF) >> 2;
                newimg[i] = (A <<= 24) | textColor;
                j += 2;
                if (i % nw != l) continue;
                j += ow;
            }
        } else {
            for (int i = 0; i < ns; ++i) {
                int A = (oldimg[j] & 0xFF) + (oldimg[j + 1] & 0xFF) + (oldimg[j + ow] & 0xFF) + (oldimg[j + ow + 1] & 0xFF) >> 2;
                A *= alpha;
                A >>= 8;
                newimg[i] = (A <<= 24) | textColor;
                j += 2;
                if (i % nw != l) continue;
                j += ow;
            }
        }
        return Image.createRGBImage((int[])newimg, (int)nw, (int)nh, (boolean)true);
    }

    public Image transparentHalfSizeMultiLine(String text, int textColor, int size, int alpha, int width, int maxLines, boolean centered, boolean arabic) {
        int fh;
        text = text.replace('\n', ' ');
        text = text.replace('\r', ' ');
        text = text.replace('\u2029', ' ');
        text = this.spaceClean(text);
        Font f = Font.getFont((int)64, (int)0, (int)size);
        String[] textLines = this.splitText(text, 2 * width, f, false);
        if (maxLines == -1 || textLines.length < maxLines) {
            maxLines = textLines.length;
        }
        if ((fh = f.getHeight() * maxLines) % 2 == 1) {
            ++fh;
        }
        int fw = 2 * width;
        int oh = fh;
        int ow = fw;
        int os = ow * oh;
        int nh = fh / 2;
        int nw = fw / 2;
        int ns = nh * nw;
        Image img = Image.createImage((int)ow, (int)oh);
        Graphics g = img.getGraphics();
        g.setColor(0);
        g.fillRect(0, 0, ow, oh);
        g.setColor(0xFFFFFF);
        g.setFont(f);
        for (int i = 0; i < maxLines; ++i) {
            g.drawString(textLines[i], centered ? ow / 2 : (arabic ? ow : 0), f.getHeight() * i, centered ? 17 : (arabic ? 24 : 0));
        }
        int[] oldimg = new int[os];
        int[] newimg = new int[ns];
        img.getRGB(oldimg, 0, ow, 0, 0, ow, oh);
        int j = 0;
        int l = nw - 1;
        textColor &= 0xFFFFFF;
        if (alpha >= 255 || alpha < 0) {
            for (int i = 0; i < ns; ++i) {
                int A = (oldimg[j] & 0xFF) + (oldimg[j + 1] & 0xFF) + (oldimg[j + ow] & 0xFF) + (oldimg[j + ow + 1] & 0xFF) >> 2;
                newimg[i] = (A <<= 24) | textColor;
                j += 2;
                if (i % nw != l) continue;
                j += ow;
            }
        } else {
            for (int i = 0; i < ns; ++i) {
                int A = (oldimg[j] & 0xFF) + (oldimg[j + 1] & 0xFF) + (oldimg[j + ow] & 0xFF) + (oldimg[j + ow + 1] & 0xFF) >> 2;
                A *= alpha;
                A >>= 8;
                newimg[i] = (A <<= 24) | textColor;
                j += 2;
                if (i % nw != l) continue;
                j += ow;
            }
        }
        return Image.createRGBImage((int[])newimg, (int)nw, (int)nh, (boolean)true);
    }

    public Image transparentHalfSizeMultiLine(String text, int textColor, int linkColor, int size, int alpha, int width, int maxLines, boolean centered, boolean arabic, Vector links) {
        int fh;
        Font f = Font.getFont((int)64, (int)0, (int)size);
        String[] textLines = this.splitText(text, 2 * width, f, false);
        if (maxLines == -1 || textLines.length < maxLines) {
            maxLines = textLines.length;
        }
        if ((fh = f.getHeight() * maxLines) % 2 == 1) {
            ++fh;
        }
        int fw = 2 * width;
        int oh = fh;
        int ow = fw;
        int os = ow * oh;
        int nh = fh / 2;
        int nw = fw / 2;
        int ns = nh * nw;
        Image img = Image.createImage((int)ow, (int)oh);
        Graphics g = img.getGraphics();
        g.setColor(0);
        g.fillRect(0, 0, ow, oh);
        g.setColor(0xFFFFFF);
        g.setFont(f);
        for (int i = 0; i < maxLines; ++i) {
            g.drawString(textLines[i], centered ? ow / 2 : (arabic ? ow : 0), f.getHeight() * i, centered ? 17 : (arabic ? 24 : 0));
        }
        int[] oldimg = new int[os];
        int[] newimg = new int[ns];
        img.getRGB(oldimg, 0, ow, 0, 0, ow, oh);
        int j = 0;
        int l = nw - 1;
        textColor &= 0xFFFFFF;
        if (alpha >= 255 || alpha < 0) {
            for (int i = 0; i < ns; ++i) {
                int A = (oldimg[j] & 0xFF) + (oldimg[j + 1] & 0xFF) + (oldimg[j + ow] & 0xFF) + (oldimg[j + ow + 1] & 0xFF) >> 2;
                newimg[i] = (A <<= 24) | textColor;
                j += 2;
                if (i % nw != l) continue;
                j += ow;
            }
        } else {
            for (int i = 0; i < ns; ++i) {
                int A = (oldimg[j] & 0xFF) + (oldimg[j + 1] & 0xFF) + (oldimg[j + ow] & 0xFF) + (oldimg[j + ow + 1] & 0xFF) >> 2;
                A *= alpha;
                A >>= 8;
                newimg[i] = (A <<= 24) | textColor;
                j += 2;
                if (i % nw != l) continue;
                j += ow;
            }
        }
        return Image.createRGBImage((int[])newimg, (int)nw, (int)nh, (boolean)true);
    }

    private String spaceClean(String in) {
        StringBuffer sb = new StringBuffer(in.length());
        int lastChar = -1;
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (c != ' ' || lastChar != 32) {
                sb.append(c);
            }
            lastChar = c;
        }
        return sb.toString();
    }

    private String[] splitText(String s, int w, Font f, boolean continued) {
        int i;
        int t;
        if (!continued) {
            if (f.stringWidth(s) <= w) {
                String[] out = new String[]{s};
                return out;
            }
            this.cutVec.removeAllElements();
        }
        int b = 0;
        int space = f.stringWidth(" ");
        int p = s.indexOf(" ");
        if (p == -1 || p == s.length() - 1) {
            t = 0;
            for (i = 0; i <= s.length(); ++i) {
                if (f.stringWidth(s.substring(t, i)) <= w) continue;
                this.cutVec.addElement(s.substring(t, i - 1));
                t = i - 1;
            }
            this.cutVec.addElement(s.substring(t));
        } else {
            block1: while (b != -1) {
                String s2 = "";
                int currX = 0;
                while (true) {
                    if ((b = s.indexOf(" ")) == -1) {
                        t = f.stringWidth(s);
                        if (currX + t > w) {
                            if (currX == 0) {
                                this.splitText(s, w, f, true);
                                continue block1;
                            }
                            if (t > w) {
                                i = 0;
                                while (currX + f.stringWidth(s.substring(0, i)) < w) {
                                    ++i;
                                }
                                if (i < 2) {
                                    this.cutVec.addElement(s2);
                                    this.splitText(s, w, f, true);
                                    continue block1;
                                }
                                this.cutVec.addElement(s2 + s.substring(0, i - 1));
                                this.splitText(s.substring(i - 1), w, f, true);
                                continue block1;
                            }
                            this.cutVec.addElement(s2);
                            this.cutVec.addElement(s);
                            continue block1;
                        }
                        this.cutVec.addElement(s2 + s);
                        continue block1;
                    }
                    t = f.stringWidth(s.substring(0, b + 1));
                    if (currX + t > w + space) {
                        if (currX == 0) {
                            s2 = this.cutVec.isEmpty() ? "" : (String)this.cutVec.lastElement();
                            currX = f.stringWidth(s2);
                            i = 0;
                            while (currX + f.stringWidth(s.substring(0, i)) < w) {
                                ++i;
                            }
                            if (i <= 1) {
                                this.splitText(s.substring(0, b + 1), w, f, true);
                                s = (String)this.cutVec.lastElement() + s.substring(b + 1);
                                this.cutVec.removeElementAt(this.cutVec.size() - 1);
                                continue block1;
                            }
                            if (this.cutVec.isEmpty()) {
                                this.cutVec.addElement(s2 + s.substring(0, i - 1));
                            } else {
                                this.cutVec.setElementAt(s2 + s.substring(0, i - 1), this.cutVec.size() - 1);
                            }
                            s = s.substring(i - 1);
                            continue block1;
                        }
                        this.cutVec.addElement(s2);
                        continue block1;
                    }
                    currX += t;
                    s2 = s2 + s.substring(0, b + 1);
                    s = s.substring(b + 1);
                }
            }
        }
        if (continued) {
            return null;
        }
        String[] out = new String[this.cutVec.size()];
        for (int i2 = 0; i2 < out.length; ++i2) {
            out[i2] = (String)this.cutVec.elementAt(i2);
        }
        this.cutVec.removeAllElements();
        return out;
    }
}

