/*
 * Decompiled with CFR 0.152.
 */
package se.vitamin.ui;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import se.vitamin.ui.TextBox;
import se.vitamin.ui.UI;
import se.vitamin.ui.Window;

public abstract class TextField
extends TextBox {
    public TextField(Window parent, int id, int left, int top, Font f, boolean forceDefault) {
        super(parent, id, left, top, f, forceDefault);
        this._selectable = true;
        this._h = f.getHeight();
        this.caretRow = 0;
    }

    public void paintCapitalIndicator(Graphics g, int x, int y) {
        if (this.capitalMode == 0) {
            g.drawString("Aa", 20, 240, 0);
        } else if (this.capitalMode == 1) {
            g.drawString("A", 20, 240, 0);
        } else {
            g.drawString("a", 20, 240, 0);
        }
    }

    public void paint(Graphics g, int x, int y) {
        this._screenX = x + this._x;
        this._screenY = y + this._y;
        this.caretPos = this.insertPos;
        this._h = this.output.length * this._font.getHeight();
        if (this._h < this._minH) {
            this._h = this._minH;
        }
        this.drawBackground(g, this._screenX, this._screenY);
        g.setFont(this._font);
        g.setColor(0);
        if (UI.rightToLeft && !this.forceDefault) {
            this.paintRTL(g);
            return;
        }
        g.setColor(0);
        if (this._active && (UI.hasUppercase() || this.forceDefault)) {
            this.paintCapitalIndicator(g, this._screenX, this._screenY);
        }
        int caretX = 0;
        int caretY = 0;
        caretY = this._screenY + this._font.getHeight();
        g.setClip(this._screenX, this._screenY, this._w, this._h);
        if (this.caretPos == -1) {
            int width = this._font.stringWidth(this.output[0]);
            if (width > this._w) {
                g.drawString(this.output[0], this._screenX - width + this._w, this._screenY, 0);
                caretX = this._font.stringWidth(this.output[0]) - width + this._w;
            } else {
                g.drawString(this.output[0], this._screenX, this._screenY, 0);
                caretX = this._font.stringWidth(this.output[0]);
                this.caretScreenX = this.output[0].length();
            }
        } else if (this.caretPos == 0) {
            g.drawString(this.output[0], x + this._x, this._screenY, 0);
            caretX = this.lastToken.equals("") ? 0 : this._font.stringWidth(this.lastToken);
        } else {
            int start = 0;
            int cp = 0;
            int width = this._font.stringWidth(this.output[0]);
            int subWidth = this._font.stringWidth(this.output[0].substring(0, this.caretPos));
            if (width > this._w) {
                if (subWidth > this._w) {
                    g.drawString(this.output[0], this._screenX + this._w - subWidth, this._screenY, 0);
                    caretX = this._w - subWidth + this._font.stringWidth(this.output[0].substring(0, this.caretPos) + this.lastToken);
                    this.caretScreenX = this.output[0].substring(0, this.caretPos).length() + this._w - subWidth;
                } else {
                    g.drawString(this.output[0], this._screenX, this._screenY, 0);
                    caretX = this._font.stringWidth(this.output[0].substring(0, this.caretPos) + this.lastToken);
                }
            } else {
                if (start < this.caretPos && start + this.output[0].length() >= this.caretPos) {
                    cp = this.caretPos - start;
                    g.drawString(this.output[0], this._screenX, this._screenY, 0);
                    caretX = this._font.stringWidth(this.output[0].substring(0, cp) + this.lastToken);
                } else {
                    g.drawString(this.output[0], this._screenX, this._screenY, 0);
                }
                start += this.output[0].length();
            }
        }
        g.setClip(0, 0, UI.SCREEN_WIDTH, UI.SCREEN_HEIGHT);
        if (this.dropTime > 0) {
            this.drawDropDown(g, 0, this._screenY);
        }
        if (this.caretCounter > 0) {
            g.drawLine(this._screenX + caretX, caretY, this._screenX + caretX, caretY - this._font.getHeight());
        }
    }
}

