/*
 * Decompiled with CFR 0.152.
 */
package com.fw.j2me.util;

import com.fw.j2me.util.Deserializable;
import com.fw.j2me.util.IoUtil;
import com.fw.j2me.util.Serializable;
import com.fw.j2me.util.log.CntLog;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;

public class Http {
    private static CntLog log = new CntLog("Http");
    private int status;
    private byte[] body;
    protected Hashtable reqHdr;
    protected Serializable reqDat;
    protected Deserializable repDat;
    protected String expectedType;
    private boolean throwIfNotOk;

    public byte[] get(String url) throws Exception {
        this.body = null;
        this.exec("GET", url);
        return this.body;
    }

    public void post(String url) throws Exception {
        this.exec("POST", url);
    }

    protected void exec(String method, String url) throws Exception {
        HttpConnection c = null;
        OutputStream os = null;
        InputStream is = null;
        try {
            log.debug(method + " " + url);
            c = (HttpConnection)Connector.open((String)url);
            c.setRequestMethod(method);
            this.setRequestHeader(c);
            if (method.equals("GET")) {
                c.setRequestProperty("Content-Length", "0");
            }
            os = c.openOutputStream();
            this.setRequestData(os);
            if (this.getReply(c.getResponseCode(), c)) {
                is = c.openInputStream();
                this.getReplyData(c.getType(), is);
            }
        }
        catch (ClassCastException ex) {
            log.info("Http.make: " + url + "is not an HTTP URL");
            throw new IllegalArgumentException("Not an HTTP URL");
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
            if (c != null) {
                c.close();
            }
        }
    }

    public void setRequestHeader(Hashtable h) {
        this.reqHdr = h;
    }

    public void setRequestHeader(HttpConnection c) throws IOException {
        if (this.reqHdr != null) {
            Enumeration iter = this.reqHdr.keys();
            while (iter.hasMoreElements()) {
                String k = (String)iter.nextElement();
                String v = (String)this.reqHdr.get(k);
                c.setRequestProperty(k, v);
            }
        }
    }

    public void setRequestData(Serializable reqDat) {
        this.reqDat = reqDat;
    }

    public void setRequestData(OutputStream os) throws Exception {
        log.info("Http.setRequestData:[reqDat=" + this.reqDat + "]");
        if (this.reqDat != null) {
            this.reqDat.serialize(os);
        }
    }

    public boolean getThrowIfNotOk() {
        return this.throwIfNotOk;
    }

    public void setThrowIfNotOk(boolean flag) {
        this.throwIfNotOk = flag;
    }

    public boolean getReply(int code, HttpConnection c) throws Exception {
        boolean res;
        this.status = code;
        boolean bl = res = code == 200;
        if (this.throwIfNotOk && !res) {
            throw new IOException("HTTP response code: " + code);
        }
        return res;
    }

    public void setReplyData(Deserializable repDat) {
        this.repDat = repDat;
    }

    public void setExpectedType(String ty) {
        this.expectedType = ty.toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getReplyData(String type, InputStream is) throws Exception {
        if (this.repDat != null) {
            this.repDat.deserialize(is);
        } else {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                IoUtil.copy(is, bos);
                this.body = bos.toByteArray();
            }
            finally {
                bos.close();
            }
        }
    }

    public int getStatus() {
        return this.status;
    }

    public byte[] getBody() {
        return this.body;
    }
}

