/*
 * Decompiled with CFR 0.152.
 */
package com.fw.j2me.util;

import com.fw.j2me.util.Base64;
import com.fw.j2me.util.IoUtil;
import com.fw.j2me.util.MiscUtil;
import com.fw.j2me.util.log.CntLog;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;
import javax.microedition.lcdui.Image;
import javax.microedition.pim.Contact;
import javax.microedition.pim.ContactList;
import javax.microedition.pim.PIMException;

public class PimUtil {
    private static CntLog log = new CntLog("PimUtil");

    private PimUtil() {
    }

    public static void verifyPimSupport() throws IOException {
        String version = System.getProperty("microedition.pim.version");
        if (version != null) {
            if (!version.equals("1.0")) {
                throw new IOException("PIM: Package is not version 1.0");
            }
        } else {
            throw new IOException("PIM optional package is not available.");
        }
        log.debug("PimUtil.verifyPIMSupport: version =" + version);
    }

    public static void verifyFileConnectionSupport() throws IOException {
        String version = System.getProperty("microedition.io.file.FileConnection.version");
        if (version != null) {
            if (!version.equals("1.0")) {
                throw new IOException("FileConnection: Package is not version 1.0");
            }
        } else {
            throw new IOException("File connection optional package is not available");
        }
        log.debug("PimUtil.verifyFileConnectionSupport: version =" + version);
    }

    public static void closeContactList(ContactList ctList) {
        if (ctList == null) {
            return;
        }
        try {
            ctList.close();
        }
        catch (Exception e) {
            log.error("Util.closeContactList", e);
        }
    }

    public static String getRootDir() throws Exception {
        Enumeration roots = FileSystemRegistry.listRoots();
        if (roots.hasMoreElements()) {
            return (String)roots.nextElement();
        }
        return null;
    }

    public static boolean fileExists(String fileUrl) throws Exception {
        FileConnection fc = (FileConnection)Connector.open((String)fileUrl, (int)1);
        boolean f = fc.exists();
        fc.close();
        return f;
    }

    public static void createDir(String fileUrl) throws Exception {
        FileConnection fc = (FileConnection)Connector.open((String)fileUrl, (int)3);
        fc.mkdir();
        fc.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveByteArrayToFile(String fileUrl, byte[] b) throws Exception {
        log.debug("PimUtil.saveByteArrayToFile: fileUrl=" + fileUrl);
        log.debug("PimUtil.saveByteArrayToFile: b.length=" + b.length);
        FileConnection fc = null;
        DataOutputStream dos = null;
        try {
            fc = (FileConnection)Connector.open((String)fileUrl, (int)3);
            if (fc.exists()) {
                fc.delete();
                fc.close();
                fc = (FileConnection)Connector.open((String)fileUrl);
            }
            fc.create();
            dos = new DataOutputStream(fc.openDataOutputStream());
            ((OutputStream)dos).write(b);
        }
        finally {
            if (dos != null) {
                dos.flush();
                dos.close();
            }
            if (fc != null) {
                fc.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteFile(String fileUrl) throws Exception {
        FileConnection fc = null;
        try {
            fc = (FileConnection)Connector.open((String)fileUrl, (int)3);
            if (fc.exists()) {
                fc.delete();
            }
        }
        finally {
            if (fc != null) {
                fc.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void moveFile(String fromFileUrl, String toFileUrl) throws Exception {
        String toFile = PimUtil.getToFileUrl(toFileUrl);
        FileConnection fromFc = null;
        FileConnection toFc = null;
        InputStream is = null;
        OutputStream os = null;
        try {
            fromFc = (FileConnection)Connector.open((String)fromFileUrl, (int)3);
            is = fromFc.openInputStream();
            toFc = (FileConnection)Connector.open((String)toFile, (int)2);
            toFc.create();
            os = toFc.openOutputStream();
            int len = IoUtil.copy(is, os);
            log.debug("PimUtil.copyFile: len=" + len);
            os.flush();
            fromFc.delete();
        }
        catch (Throwable throwable) {
            PimUtil.closeFile(fromFc, toFc, is, os);
            throw throwable;
        }
        PimUtil.closeFile(fromFc, toFc, is, os);
    }

    private static void closeFile(FileConnection fromFc, FileConnection toFc, InputStream is, OutputStream os) throws IOException {
        if (is != null) {
            is.close();
        }
        if (os != null) {
            os.close();
        }
        if (fromFc != null) {
            fromFc.close();
        }
        if (toFc != null) {
            toFc.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String copyFile(String fromFileUrl, String toFileUrl) throws Exception {
        String string;
        String toFile = PimUtil.getToFileUrl(toFileUrl);
        FileConnection fromFc = null;
        FileConnection toFc = null;
        InputStream is = null;
        OutputStream os = null;
        try {
            fromFc = (FileConnection)Connector.open((String)fromFileUrl, (int)1);
            is = fromFc.openInputStream();
            toFc = (FileConnection)Connector.open((String)toFile, (int)2);
            toFc.create();
            os = toFc.openOutputStream();
            int len = IoUtil.copy(is, os);
            log.debug("PimUtil.copyFile: len=" + len);
            os.flush();
            string = toFile;
        }
        catch (Throwable throwable) {
            PimUtil.closeFile(fromFc, toFc, is, os);
            throw throwable;
        }
        PimUtil.closeFile(fromFc, toFc, is, os);
        return string;
    }

    private static String getToFileUrl(String toFileUrl) throws Exception {
        int len = toFileUrl.length();
        int idx = toFileUrl.lastIndexOf(46);
        if (idx < 0) {
            idx = len;
        }
        String tmp = toFileUrl.substring(0, idx);
        String ext = "";
        if (idx < len) {
            ext = toFileUrl.substring(idx + 1, toFileUrl.length());
        }
        int i = 0;
        String name = tmp;
        while (PimUtil.fileExists(name + "." + ext)) {
            name = tmp + "(" + ++i + ")";
        }
        return name + "." + ext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getImageFromFile(String fileUrl) throws Exception {
        FileConnection fc = null;
        InputStream is = null;
        try {
            fc = (FileConnection)Connector.open((String)fileUrl, (int)1);
            if (!fc.exists()) {
                throw new Exception("file not exists:" + fileUrl);
            }
            is = fc.openInputStream();
            Image image = Image.createImage((InputStream)is);
            return image;
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (fc != null) {
                fc.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream getInputStreamFromFile(String fileUrl) throws Exception {
        FileConnection fc = null;
        try {
            fc = (FileConnection)Connector.open((String)fileUrl, (int)1);
            if (!fc.exists()) {
                throw new Exception("file not exists:" + fileUrl);
            }
            InputStream inputStream = fc.openInputStream();
            return inputStream;
        }
        finally {
            if (fc != null) {
                fc.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataOutputStream getDataOutputStreamFromFile(String fileUrl) throws Exception {
        FileConnection fc = null;
        try {
            fc = (FileConnection)Connector.open((String)fileUrl, (int)3);
            if (!fc.exists()) {
                throw new Exception("file not exists:" + fileUrl);
            }
            DataOutputStream dataOutputStream = fc.openDataOutputStream();
            return dataOutputStream;
        }
        finally {
            if (fc != null) {
                fc.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getImageByteArrayFromFile(String fileUrl) throws Exception {
        FileConnection fc = null;
        InputStream is = null;
        try {
            fc = (FileConnection)Connector.open((String)fileUrl, (int)1);
            if (!fc.exists()) {
                throw new Exception("file not exists:" + fileUrl);
            }
            is = fc.openInputStream();
            byte[] byArray = IoUtil.readInputStream(is, fc.fileSize());
            return byArray;
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (fc != null) {
                fc.close();
            }
        }
    }

    public static Image getContactPhoto(Contact contact, boolean base64Decode) throws IOException {
        byte[] b = contact.getBinary(110, 0);
        if (b == null || b.length <= 0) {
            return null;
        }
        if (base64Decode) {
            b = Base64.decode(b);
        }
        return Image.createImage((byte[])b, (int)0, (int)b.length);
    }

    public static String getContactPhotoUrl(Contact contact) {
        String photoUrl = null;
        if (contact.countValues(111) > 0) {
            photoUrl = contact.getString(111, 0);
        }
        return photoUrl;
    }

    public static void updateContactPhoto(int photoField, Contact contact, byte[] imgByteArray) throws PIMException {
        log.debug("PimUtil.updateContactPhoto: imgByteArray=" + imgByteArray);
        if (contact.countValues(photoField) > 0) {
            contact.removeValue(photoField, 0);
        }
        if (imgByteArray != null) {
            contact.addBinary(photoField, 0, imgByteArray, 0, imgByteArray.length);
        }
        if (contact.isModified()) {
            contact.commit();
        }
        log.debug("PimUtil.updateContactPhoto: contact.commit()");
    }

    public static void updateContactPhotoUrl(int photoField, Contact contact, String fileUrl) throws Exception {
        if (contact.countValues(photoField) > 0) {
            contact.removeValue(photoField, 0);
        }
        if (fileUrl != null) {
            contact.addString(photoField, 0, fileUrl);
        }
        if (contact.isModified()) {
            contact.commit();
        }
    }

    public static long getFileSize(String fileUrl) {
        long ret = Integer.MIN_VALUE;
        try {
            FileConnection fc = (FileConnection)Connector.open((String)fileUrl, (int)1);
            ret = fc.fileSize();
            fc.close();
        }
        catch (IllegalArgumentException e) {
            log.debug("getFileSize() ", e);
        }
        catch (ConnectionNotFoundException e) {
            log.debug("getFileSize() ", e);
        }
        catch (IOException e) {
            log.debug("getFileSize() ", e);
        }
        catch (SecurityException e) {
            log.debug("getFileSize() ", e);
        }
        return ret;
    }

    public static String tryToGetAvailableFileUrl(String fileUrl) {
        String ret = fileUrl;
        String tmp = MiscUtil.decodeUrl(fileUrl);
        long size = PimUtil.getFileSize(tmp);
        if (size >= 0L) {
            ret = tmp;
        }
        return ret;
    }
}

