/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.ykjc.engine;

import com.fw.j2me.protocol.ISession;
import com.fw.j2me.ui.UiCallback;
import com.fw.j2me.util.CntThread;
import com.fw.j2me.util.Device;
import com.fw.j2me.util.ImageCache;
import com.fw.j2me.util.log.CntLog;
import com.fw.j2me.util.video.VideoFile;
import com.sonyericsson.ykjc.model.Channel;
import com.sonyericsson.ykjc.model.DataChannelVideos;
import com.sonyericsson.ykjc.model.DataModel;
import com.sonyericsson.ykjc.model.DataMyYouKu;
import com.sonyericsson.ykjc.model.SearchResult;
import com.sonyericsson.ykjc.model.UserInfo;
import com.sonyericsson.ykjc.model.VideoInfo;
import com.sonyericsson.ykjc.protocol.YkSession;
import com.sonyericsson.ykjc.proxy.IYkProxy;
import com.sun.lwuit.Image;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class EngineBase
implements IYkProxy {
    private static final int VIDEO_NUMBER_PER_PAGE = 5;
    private static final int KEYWORDS_NUM = 5;
    private static CntLog log = new CntLog("Engine");
    protected UiCallback callBack;
    protected DataModel model = new DataModel();
    protected ISession session = new YkSession();

    public EngineBase(UiCallback cb) {
        this.callBack = cb;
    }

    public void doGetChannels() {
        log.error("in doGetChannels()");
        if (this.checkRoaming()) {
            this.session.doJob(103, null);
        }
    }

    public void doGetLatestVideoList() {
        log.error("in doGetLatestVideoList()");
        throw new RuntimeException("The method has not implement. ");
    }

    public void doGetRecommendVideoList() {
        log.error("in doGetSeRecommendlVideo()");
        if (this.checkRoaming()) {
            this.session.doJob(100, null);
        }
    }

    public void doSearch(String keyword, int page) {
        if (this.checkRoaming()) {
            this.model.setLastestSearchWord(keyword);
            Hashtable<String, Object> param = new Hashtable<String, Object>();
            param.put("keyword", keyword);
            param.put("page", new Integer(page));
            int number = Device.getPropertyInt("VideoNumberPerPage", 5);
            param.put("num", new Integer(number));
            this.session.doJob(111, param);
        }
    }

    public void doGetMyYouKu(String strEMail, String strPwd, int pg) {
        if (this.checkRoaming()) {
            Hashtable<String, Object> param = new Hashtable<String, Object>();
            param.put("email", strEMail);
            param.put("pwd", strPwd);
            param.put("pg", new Integer(pg));
            int pz = Device.getPropertyInt("VideoNumberPerPage", 5);
            param.put("pz", new Integer(pz));
            this.session.doJob(161, param);
        }
    }

    public VideoInfo[] getRecommendVideoList() {
        return this.getVideoArrayFromVector(this.model.getRecommendList());
    }

    public VideoInfo[] getLatestVideoList() {
        return this.getVideoArrayFromVector(this.model.getRecommendList());
    }

    public DataMyYouKu getMyYouKu() {
        return this.model.getMyYouKu();
    }

    public SearchResult getSearchResult(String keyword) {
        SearchResult ret = this.model.getSearchResult();
        if (null != keyword && null != ret && !keyword.equals(ret.getKeyword())) {
            ret = null;
        }
        return ret;
    }

    public Channel[] listChannel() {
        return this.getChannelArrayFromVector(this.model.getChannels());
    }

    public VideoInfo[] getRelativeList() {
        return this.getVideoArrayFromVector(this.model.getRelativeList());
    }

    public VideoInfo getCurrentVideo() {
        return this.model.getCurrentVideo();
    }

    public void setCurrentVideo(VideoInfo video) {
        this.model.setCurrentVideo(video);
    }

    public Channel getCurrentChannel() {
        return this.model.getCurrentChannel();
    }

    public void setCurrentChannel(Channel channel) {
        this.model.setCurrentChannel(channel);
    }

    public void exit() {
        CntThread.closeAll();
        log.debug("Exit called");
    }

    private Channel[] getChannelArrayFromVector(Vector cs) {
        Object[] ret = null;
        if (null != cs) {
            ret = new Channel[cs.size()];
            cs.copyInto(ret);
        }
        return ret;
    }

    private VideoInfo[] getVideoArrayFromVector(Vector vs) {
        Object[] ret = null;
        if (null != vs) {
            ret = new VideoInfo[vs.size()];
            vs.copyInto(ret);
        }
        return ret;
    }

    public void doGetRelateVideoList() {
        if (this.checkRoaming()) {
            this.session.doJob(101, this.model.getCurrentVideo().getId());
        }
    }

    public SearchResult getSearchResult() {
        return this.model.getSearchResult();
    }

    public String[] getHotKeywords() {
        return this.model.getHotKeywords();
    }

    public void doComment(VideoInfo vInfo, boolean bIsUP) {
        if (this.checkRoaming()) {
            Hashtable<String, Object> param = new Hashtable<String, Object>();
            vInfo.disableComment();
            param.put("vidinfo", vInfo);
            param.put("up", new Boolean(bIsUP));
            this.session.doJob(1073741945, param);
        }
    }

    public void doLogin(String strUser, String strPwd) {
        if (this.checkRoaming()) {
            Hashtable<String, String> param = new Hashtable<String, String>();
            param.put("user", strUser);
            param.put("pwd", strPwd);
            this.session.doJob(131, param);
        }
    }

    public void doRegister(String strEMail, String strPwd) {
        if (this.checkRoaming()) {
            Hashtable<String, String> param = new Hashtable<String, String>();
            param.put("email", strEMail);
            param.put("pwd", strPwd);
            this.session.doJob(151, param);
        }
    }

    public void doGetChannelVideos(String strCID, int pg) {
        if (this.checkRoaming()) {
            Hashtable<String, Object> param = new Hashtable<String, Object>();
            param.put("cid", strCID);
            param.put("pg", new Integer(pg));
            int number = Device.getPropertyInt("VideoNumberPerPage", 5);
            param.put("pz", new Integer(number));
            this.session.doJob(141, param);
        }
    }

    public DataChannelVideos getChannelVideos() {
        return this.model.getChannelVideos();
    }

    protected void loadVideoThumbnail(Object videoList) {
        Enumeration iterator = ((Vector)videoList).elements();
        while (iterator.hasMoreElements()) {
            VideoInfo info = (VideoInfo)iterator.nextElement();
            Image image = ImageCache.getImage(info.getImgUrl());
            if (image != null) {
                info.setImg(image);
                continue;
            }
            this.session.doJob(0x40000066, info);
        }
    }

    protected void loadChannelThumbnail(Object response) {
        Vector vec = (Vector)response;
        for (int i = 0; i < vec.size(); ++i) {
            Channel c = (Channel)vec.elementAt(i);
            Hashtable<String, Object> param = new Hashtable<String, Object>();
            param.put("channle", c);
            param.put("iconid", new Integer(1));
            this.session.doJob(1073741928, param);
            param.put("iconid", new Integer(2));
            this.session.doJob(1073741928, param);
        }
    }

    public void doGetKeywords() {
        if (this.checkRoaming()) {
            Hashtable<String, Integer> param = new Hashtable<String, Integer>();
            int kn = Device.getPropertyInt("KeyWordNumber", 5);
            param.put("kn", new Integer(kn));
            this.session.doJob(171, param);
        }
    }

    public void doForgetPwd(String strEMail) {
        if (this.checkRoaming()) {
            Hashtable<String, String> param = new Hashtable<String, String>();
            param.put("email", strEMail);
            this.session.doJob(181, param);
        }
    }

    public boolean getLoginStatus() {
        return this.model.getLoginStatus();
    }

    public void setLoginStatus(boolean loginState) {
        this.model.setLoginStatus(loginState);
    }

    public UserInfo getUserInfo() {
        return this.model.getUserInfo();
    }

    public VideoFile getUploadVideo() {
        return this.model.getUploadVideo();
    }

    public void freeze4PlayVideo() {
        this.session.pause();
    }

    public void meltAfterPlayVideo() {
        this.session.resume();
    }

    public boolean checkRoaming() {
        boolean allow = true;
        return allow;
    }

    public String getLatestSearchWord() {
        return this.model.getLastestSearchWord();
    }

    public void setLatestSearchWord(String str) {
        this.model.setLastestSearchWord(str);
    }

    public int getloginFailCount() {
        return this.model.getLoginFailCount();
    }
}

