/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.ykjc.ui.component;

import com.sonyericsson.ykjc.ui.YkUiContext;
import com.sonyericsson.ykjc.ui.component.ChannelContainer;
import com.sun.lwuit.Button;
import com.sun.lwuit.Component;
import com.sun.lwuit.Image;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.events.FocusListener;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.plaf.Style;
import java.util.Hashtable;

public class ChannelContainerList
extends ChannelContainer
implements FocusListener {
    private static final int ICON_MAX_HEIGHT = 42;
    private static int iconMaxHeight = YkUiContext.uiConfig.getIntProperty("max_channel_icon_height", 42);

    protected void createButtons(ActionListener listener, Hashtable channelHash) {
        for (int i = 0; i < this.channels.length; ++i) {
            Image icon = this.channels[i].getIcon1();
            if (icon == null) {
                icon = this.defaultUnFocusImg;
            }
            if (icon.getHeight() > iconMaxHeight) {
                icon = icon.scaledHeight(iconMaxHeight);
            }
            this.buttons[i] = new Button(this.channels[i].getName() + YkUiContext.strMgr.getString("channel"), icon);
            icon = this.channels[i].getIcon2();
            if (icon == null) {
                icon = this.defaultFocusImg;
            }
            if (icon.getHeight() > iconMaxHeight) {
                icon = icon.scaledHeight(iconMaxHeight);
            }
            this.buttons[i].setRolloverIcon(icon);
            this.buttons[i].addFocusListener(this);
            this.buttons[i].setTextPosition(3);
            Style s = this.buttons[i].getStyle();
            s.setPadding(0, 0, 0, 0);
            s.setMargin(1, 1, 0, 0);
            s.setBorder(null);
            s.setBgTransparency(0);
            this.buttons[i].setAlignment(4);
            this.addComponent(this.buttons[i]);
            if (i == 0) {
                this.buttons[i].setFocus(true);
            }
            this.buttons[i].addActionListener(listener);
            channelHash.put(this.buttons[i], this.channels[i]);
        }
        this.setLayout(new BoxLayout(2));
        this.setScrollable(true);
    }

    public void focusGained(Component cmp) {
        Button b = (Button)cmp;
        b.getStyle().setBgImage(YkUiContext.imgMgr.getImage("bigButtonBg"));
    }

    public void focusLost(Component cmp) {
        Button b = (Button)cmp;
        b.getStyle().setBgImage(null);
    }
}

