/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.ykjc.ui.component;

import com.sonyericsson.ykjc.ui.YkUiContext;
import com.sun.lwuit.Font;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.plaf.Style;

public class LoadingAnimation
extends Label {
    protected static final int BLACK = 0;
    protected static Font f = Font.createSystemFont(32, 0, 8);
    protected Image[] animationImgs;
    protected int currentImage = 0;
    private long lastInvoke;
    protected String text;
    protected int posX;
    protected int posY;
    public static final int TYPE_BAR_ANIM = 0;
    public static final int TYPE_CIRCLE_ANIM = 1;
    public int type;

    public LoadingAnimation() {
        this(YkUiContext.strMgr.getString("splashInfo"), -1, -1);
    }

    public LoadingAnimation(String text) {
        this(text, -1, -1);
    }

    public LoadingAnimation(String text, int x, int y) {
        this(text, x, y, 0);
    }

    public LoadingAnimation(String text, int x, int y, int type) {
        this.type = type;
        this.text = text;
        this.posX = x;
        this.posY = y;
        Style s = this.getStyle();
        s.setBorder(null);
        if (text != null) {
            this.setAlignment(4);
        }
        this.setText(text);
        s.setBgTransparency(0);
        this.initImages();
    }

    public void initImages() {
        switch (this.type) {
            case 0: {
                int i;
                this.animationImgs = new Image[9];
                for (i = 0; i < this.animationImgs.length; ++i) {
                    this.animationImgs[i] = YkUiContext.imgMgr.getImage("barloading" + i);
                }
                break;
            }
            case 1: {
                int i;
                this.animationImgs = new Image[4];
                for (i = 0; i < this.animationImgs.length; ++i) {
                    this.animationImgs[i] = YkUiContext.imgMgr.getImage("loading" + i);
                }
                break;
            }
        }
        int preferH = this.animationImgs[0].getHeight();
        int preferW = this.animationImgs[0].getWidth();
        if (this.text != null) {
            preferH += f.getHeight() * 4;
            int stringW = f.stringWidth(this.text);
            if (preferW < stringW) {
                preferW = stringW;
            }
        }
        this.setPreferredSize(new Dimension(preferW, preferH));
    }

    public boolean animate() {
        long current = System.currentTimeMillis();
        if (current - this.lastInvoke > 200L) {
            this.lastInvoke = current;
            ++this.currentImage;
            if (this.currentImage == this.animationImgs.length) {
                this.currentImage = 0;
            }
            return true;
        }
        return false;
    }

    public void paint(Graphics g) {
        int tmpY;
        int tmpX;
        Image aniImg = this.animationImgs[this.currentImage];
        g.setFont(f);
        g.setColor(0);
        if (this.posX > 0 && this.posY > 0) {
            tmpX = this.posX - aniImg.getWidth() / 2 - g.getTranslateX();
            tmpY = this.posY - aniImg.getHeight() / 2 - g.getTranslateY();
        } else {
            tmpX = this.getX() + (this.getPreferredW() - aniImg.getWidth()) / 2;
            tmpY = this.getY() + (this.getPreferredH() - aniImg.getHeight()) / 2;
        }
        g.drawImage(aniImg, tmpX, tmpY + (this.text != null ? f.getHeight() * 2 : 0));
        if (this.text != null) {
            g.drawString(this.text, tmpX += (aniImg.getWidth() - f.stringWidth(this.text)) / 2, tmpY);
        }
    }
}

