/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.ykjc.ui.component;

import com.fw.j2me.util.MiscUtil;
import com.sonyericsson.ykjc.ui.YkUiContext;
import com.sun.lwuit.Component;
import com.sun.lwuit.Display;
import com.sun.lwuit.Font;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.geom.Dimension;

public class ProgressBar
extends Component {
    public static final int HEIGHT = 80;
    private int value;
    public static final Image PROGRESS_BG_IMG = YkUiContext.imgMgr.getImage("progressBg");
    private static final Image PROGRESS_BAR_IMG = YkUiContext.imgMgr.getImage("progressBar");
    private static final Font FONT = Font.createSystemFont(32, 0, 8);
    private static final String STR_UPLOADING = YkUiContext.strMgr.getString("uploading");
    private static String text;
    private int allWidth = PROGRESS_BAR_IMG.getWidth();

    public ProgressBar() {
        text = MiscUtil.replaceString(STR_UPLOADING, "%1", "0");
        this.setPreferredSize(new Dimension(Display.getInstance().getDisplayWidth(), 80));
    }

    public void setValue(int value) {
        if (value < 0) {
            value = 0;
        }
        if (value > 100) {
            value = 100;
        }
        boolean needRepaint = this.value != value;
        this.value = value;
        text = MiscUtil.replaceString(STR_UPLOADING, "%1", "" + value);
        if (needRepaint) {
            this.repaint();
        }
    }

    public int getValue() {
        return this.value;
    }

    public void paint(Graphics g) {
        g.setFont(FONT);
        g.setColor(0);
        int space = this.getHeight() - PROGRESS_BG_IMG.getHeight() - FONT.getHeight();
        int tmpX = 0;
        int tmpY = 0;
        tmpX = this.getX() + (this.getPreferredW() - PROGRESS_BG_IMG.getWidth()) / 2;
        tmpY = this.getY() + space * 2 / 5;
        g.drawString(text, tmpX + (PROGRESS_BG_IMG.getWidth() - FONT.stringWidth(text) >> 1), tmpY);
        tmpY = this.getY() + space * 3 / 5 + FONT.getHeight();
        this.drawProgress(g, tmpX, tmpY);
    }

    private void drawProgress(Graphics g, int tmpX, int tmpY) {
        g.drawImage(PROGRESS_BG_IMG, tmpX, tmpY);
        g.setClip(tmpX += PROGRESS_BG_IMG.getWidth() - PROGRESS_BAR_IMG.getWidth() >> 1, this.getY(), this.allWidth * this.value / 100, this.getPreferredH());
        g.drawImage(PROGRESS_BAR_IMG, tmpX, tmpY + (PROGRESS_BG_IMG.getHeight() - PROGRESS_BAR_IMG.getHeight() >> 1));
        g.setClip(this.getX(), this.getY(), this.getPreferredW(), this.getPreferredH());
    }
}

