/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.ykjc.ui.pages;

import com.fw.j2me.ui.IWaiting;
import com.fw.j2me.uiimpl.UiContext;
import com.fw.j2me.util.CntEvent;
import com.fw.j2me.util.CntThread;
import com.fw.j2me.util.Device;
import com.fw.j2me.util.log.CntLog;
import com.sonyericsson.ykjc.ui.component.YNotice;
import com.sonyericsson.ykjc.ui.pages.YkPageBase;
import com.sun.lwuit.Command;
import com.sun.lwuit.events.ActionEvent;

public abstract class PageWaiting
extends YkPageBase
implements IWaiting {
    private CntLog log = new CntLog("PageWaiting");
    private static final long UI_TIMEOUT = 60000L;
    private int exceptEvent;
    protected CntEvent event;
    private boolean finish = false;
    protected boolean canceled = false;
    private Object timeObj = new Object();
    private TimeoutThread timeThread;
    private long timeout = 60000L;

    public PageWaiting(int id) {
        super(id);
        this.setTimeout(Device.getPropertyInt("UiTimeout", 60000));
        this.timeThread = new TimeoutThread(this.getPageName());
        this.timeThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleEvent(CntEvent event) {
        if (!this.canceled) {
            this.event = event;
            int eventType = event.getEventType();
            boolean success = (eventType & Integer.MIN_VALUE) == 0;
            eventType &= Integer.MAX_VALUE;
            boolean reqIdMatch = true;
            try {
                int reqId = event.getAttrInt(0);
                reqIdMatch = reqId == UiContext.pageMgr.getSyncEvent().getAttrInt(0);
            }
            catch (Exception e) {
                this.log.debug("handleEvent: " + e.getMessage());
            }
            if (eventType == this.exceptEvent && reqIdMatch) {
                Object object = this.timeObj;
                synchronized (object) {
                    this.finish = true;
                    this.timeObj.notify();
                }
                if (success) {
                    this.gotoNextPage();
                } else {
                    this.handleFail();
                }
                return true;
            }
            if (eventType == 100) {
                this.refreshVideoImage(event);
            }
        }
        return false;
    }

    protected void refreshVideoImage(CntEvent event) {
    }

    protected void popWarningDialog() {
        YNotice.showNotice(4);
    }

    public void setExceptEvent(int exceptEvent) {
        this.exceptEvent = exceptEvent;
    }

    public int getExceptEvent() {
        return this.exceptEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancel() {
        Object object = this.timeObj;
        synchronized (object) {
            this.canceled = true;
            this.timeObj.notify();
        }
    }

    protected void handleFail() {
        int curPageId = UiContext.pageMgr.getCurrentPageID();
        if (curPageId == this.getPageID()) {
            UiContext.pageMgr.changePage(0x10000000);
            if (!this.canceled) {
                this.popWarningDialog();
            }
        }
    }

    protected void doActionPerformed(ActionEvent evt) {
        Command cmd = evt.getCommand();
        switch (cmd.getId()) {
            case 0: {
                this.cancel();
                break;
            }
        }
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    protected abstract void gotoNextPage();

    private class TimeoutThread
    extends CntThread {
        public TimeoutThread(String name) {
            super(name);
        }

        protected void closeMe() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void runMe() {
            Object object = PageWaiting.this.timeObj;
            synchronized (object) {
                if (!PageWaiting.this.finish) {
                    try {
                        PageWaiting.this.timeObj.wait(PageWaiting.this.timeout);
                    }
                    catch (InterruptedException e) {
                        PageWaiting.this.log.error("page: " + PageWaiting.this.getPageName() + " timeout!");
                    }
                }
            }
            if (!PageWaiting.this.finish || PageWaiting.this.canceled) {
                PageWaiting.this.handleFail();
            }
        }
    }
}

