/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.ykjc.util;

import com.fw.j2me.util.Device;
import com.fw.j2me.util.log.CntLog;

public class SEDevice {
    private static CntLog log = new CntLog("SEDevice");
    public static final String APPLICATION_REVISION = SEDevice.getRevision();
    private static final String FORMAT_H263 = "1";
    private static final String FORMAT_H264 = "2";
    private static final String FORMAT_MPEG4 = "3";
    private static String videoFormat = null;

    private SEDevice() {
    }

    private static String getRevision() {
        String revision = Device.getProperty("MIDlet-Version");
        if (revision == null) {
            log.debug("No MIDlet-Version found, using default (1.0.0).");
            revision = "1.0.0";
        }
        return revision;
    }

    public static String getModel() {
        String model = SEDevice.getUserAgent();
        int firmwareIndex = model.indexOf("/");
        if (firmwareIndex > 0) {
            model = model.substring(0, firmwareIndex);
        }
        return model;
    }

    public static String getModelShort() {
        String vendor;
        String model = SEDevice.getModel();
        if (model.startsWith(vendor = "SonyEricsson")) {
            model = model.substring(vendor.length());
        }
        return model;
    }

    private static String getUserAgent() {
        String userAgent = System.getProperty("microedition.platform");
        if (userAgent == null) {
            log.debug("No User-Agent found, using default (SonyEricssonJ2ME/1.0).");
            userAgent = "SonyEricssonJ2ME/1.0";
        }
        log.debug("UserAgent:" + userAgent);
        return userAgent;
    }

    public static String getLanguage() {
        String language = System.getProperty("microedition.locale");
        if (language == null) {
            language = "en-US";
        }
        log.debug("Current language is: " + language);
        return language;
    }

    public static String getVideoFormat() {
        return videoFormat;
    }

    public static void initVideoFormat() {
        String innerFormat;
        String strModel;
        String innerFormat2;
        String strDefaultFormat = FORMAT_H263;
        String strModelFormatMap = Device.getProperty("ModelFormatMap");
        if (null == strModelFormatMap) {
            videoFormat = strDefaultFormat;
            log.debug("yy videoFormat: " + videoFormat);
            return;
        }
        String tmp = SEDevice.findFormat(strModelFormatMap = strModelFormatMap.toLowerCase(), "default");
        if (null != tmp && null != (innerFormat2 = SEDevice.mapFormat(tmp))) {
            strDefaultFormat = innerFormat2;
        }
        if (null == (strModel = SEDevice.getModel().toLowerCase())) {
            videoFormat = strDefaultFormat;
            log.debug("yy videoFormat: " + videoFormat);
            return;
        }
        tmp = SEDevice.findFormat(strModelFormatMap, strModel);
        if (null != tmp && null != (innerFormat = SEDevice.mapFormat(tmp))) {
            videoFormat = innerFormat;
            log.debug("yy videoFormat: " + videoFormat);
            return;
        }
        videoFormat = strDefaultFormat;
        log.debug("yy videoFormat: " + videoFormat);
    }

    private static String findFormat(String formatMap, String model) {
        int index = formatMap.indexOf(model);
        String strFormat = null;
        if (-1 != index) {
            int idxHead = formatMap.indexOf("@", index) + 1;
            int idxEnd = formatMap.indexOf(";", index);
            if (-1 != idxHead && -1 != idxEnd) {
                strFormat = formatMap.substring(idxHead, idxEnd);
            }
        }
        return strFormat;
    }

    private static String mapFormat(String format) {
        String strInnerFormat = null;
        if (format.equals("h263")) {
            strInnerFormat = FORMAT_H263;
        } else if (format.equals("h264")) {
            strInnerFormat = FORMAT_H264;
        } else if (format.equals("mpeg4")) {
            strInnerFormat = FORMAT_MPEG4;
        }
        return strInnerFormat;
    }
}

