/*
 * Decompiled with CFR 0.152.
 */
package com.fw.j2me.util;

import com.fw.j2me.CntMidlet;
import com.fw.j2me.util.PimUtil;
import com.fw.j2me.util.log.CntLog;
import java.io.IOException;
import javax.microedition.content.ContentHandlerException;
import javax.microedition.content.ContentHandlerServer;
import javax.microedition.content.Invocation;
import javax.microedition.content.Registry;
import javax.microedition.content.RequestListener;

public abstract class ContentHandlerUtil
implements RequestListener {
    private static CntLog log = new CntLog("ContentHandlerUtil");
    private static final String ACTION_SEND = "send";
    protected String handlerID = "";
    protected ContentHandlerServer server = null;

    protected void init(String contentHandlerID) {
        this.handlerID = contentHandlerID;
        if (this.server == null) {
            try {
                this.server = Registry.getServer((String)this.handlerID);
                this.server.setListener((RequestListener)this);
            }
            catch (Exception e) {
                log.error("Get Server " + this.handlerID + " fail");
            }
        }
    }

    public String getRequestUrl() {
        if (this.server == null) {
            return null;
        }
        Invocation invocation = this.server.getRequest(false);
        if (invocation != null) {
            return this.getUrl(invocation);
        }
        return null;
    }

    private String getUrl(Invocation invocation) {
        String ret = invocation.getURL();
        log.debug("in getUrl() before tryToGetAvailableFileUrl() url = " + ret);
        ret = PimUtil.tryToGetAvailableFileUrl(ret);
        log.debug("in getUrl() after tryToGetAvailableFileUrl() url = " + ret);
        return ret;
    }

    public void invocationRequestNotify(ContentHandlerServer handler) {
        if (this.server == null) {
            return;
        }
        Invocation invocation = this.server.getRequest(false);
        while (invocation != null) {
            String url = this.getUrl(invocation);
            try {
                String[] response = this.handleRequest(url);
                if (invocation.getResponseRequired()) {
                    invocation.setArgs(response);
                }
            }
            catch (Exception e) {
                log.error("Could not handle requets ", e);
            }
            this.server.finish(invocation, 5);
            invocation = this.server.getRequest(false);
        }
    }

    protected abstract String[] handleRequest(String var1);

    public static void doSend(String id, String url) {
        Invocation invocation = new Invocation(url);
        invocation.setID(id);
        invocation.setAction(ACTION_SEND);
        try {
            Registry registry = Registry.getRegistry((String)((Object)((Object)CntMidlet.getInstance())).getClass().getName());
            registry.invoke(invocation);
        }
        catch (IllegalArgumentException e) {
            log.debug("in doShare() ", e);
        }
        catch (ContentHandlerException e) {
            log.debug("in doShare() ", e);
        }
        catch (SecurityException e) {
            log.debug("in doShare() ", e);
        }
        catch (IOException e) {
            log.debug("in doShare() ", e);
        }
    }
}

