/*
 * Decompiled with CFR 0.152.
 */
package com.fw.j2me.util;

import com.fw.j2me.util.Deserializable;
import com.fw.j2me.util.Http;
import com.fw.j2me.util.Serializable;
import com.fw.j2me.util.log.CntLog;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public class IoUtil {
    private static CntLog log = new CntLog("IoUtil");

    private IoUtil() {
    }

    public static String readTill(InputStreamReader rd, char delim, boolean raw, int ch) throws IOException {
        StringBuffer res = new StringBuffer();
        if (ch == -1) {
            ch = rd.read();
        }
        if (ch == -1) {
            return null;
        }
        while (ch != -1 && ch != delim) {
            if (92 != ch || raw) {
                res.append((char)ch);
            } else {
                ch = rd.read();
                switch (ch) {
                    case 110: {
                        res.append('\n');
                        break;
                    }
                    case 114: {
                        res.append('\r');
                        break;
                    }
                    case 116: {
                        res.append('\t');
                        break;
                    }
                    default: {
                        res.append(ch);
                    }
                }
            }
            ch = rd.read();
        }
        return res.toString();
    }

    public static int copy(InputStream is, OutputStream os) throws IOException, InterruptedException {
        int INTRCHK_PARAM = 512;
        int res = 0;
        Thread.sleep(0L);
        int c = is.read();
        int n = 512;
        while (c != -1) {
            if (--n == 0) {
                n = 512;
                Thread.sleep(0L);
            }
            os.write(c);
            ++res;
            c = is.read();
        }
        return res;
    }

    public static byte[] readInputStream(InputStream is, long totalLength) throws IOException {
        int ch = 0;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int i = 0;
        while ((long)i < totalLength && -1 != (ch = is.read())) {
            baos.write(ch);
            ++i;
        }
        return baos.toByteArray();
    }

    public static byte[] readInputStream(InputStream is) throws Exception {
        DataInputStream dis = new DataInputStream(is);
        int length = 0;
        int chunkSize = 512;
        int index = 0;
        int readLength = 0;
        byte[] data = new byte[chunkSize];
        do {
            if (data.length < index + chunkSize) {
                byte[] newData = new byte[index + chunkSize];
                System.arraycopy(data, 0, newData, 0, data.length);
                data = newData;
            }
            if ((readLength = dis.read(data, index, chunkSize)) == -1) break;
            if (readLength == -1) continue;
            index += readLength;
        } while (readLength != chunkSize || readLength != -1);
        length = index;
        log.debug("IoUtil.readInputStream: length=" + length);
        if (data.length > length) {
            byte[] b = new byte[length];
            System.arraycopy(data, 0, b, 0, length);
            data = b;
        }
        dis = null;
        return data;
    }

    public static char[] readInputStream(InputStreamReader isr) throws Exception {
        int length = 0;
        int chunkSize = 512;
        int index = 0;
        int readLength = 0;
        char[] data = new char[chunkSize];
        do {
            if (data.length < index + chunkSize) {
                char[] newData = new char[index + chunkSize];
                System.arraycopy(data, 0, newData, 0, data.length);
                data = newData;
            }
            readLength = isr.read(data, index, chunkSize);
            log.debug("Util.readInputStream: readLegnth=" + readLength);
            if (readLength == -1) break;
            if (readLength != -1) {
                index += readLength;
            }
            log.debug("Util.readInputStream: index=" + index);
        } while (readLength != chunkSize || readLength != -1);
        if (data.length > (length = index)) {
            char[] b = new char[length];
            System.arraycopy(data, 0, b, 0, length);
            data = b;
        }
        return data;
    }

    public static void writeSmallArray(String[] arr, DataOutput dos) throws IOException {
        IoUtil.writeArray(arr, dos, true);
    }

    public static String[] readSmallArray(DataInput dis, String[] arr) throws IOException {
        return IoUtil.readArray(dis, arr, true);
    }

    public static void writeArray(String[] arr, DataOutput dos) throws IOException {
        IoUtil.writeArray(arr, dos, false);
    }

    public static String[] readArray(DataInput dis, String[] arr) throws IOException {
        return IoUtil.readArray(dis, arr, false);
    }

    public static void writeSmallArray(boolean[] arr, DataOutput dos) throws IOException {
        IoUtil.writeArray(arr, dos, true);
    }

    public static boolean[] readSmallArray(DataInput dis, boolean[] arr) throws IOException {
        return IoUtil.readArray(dis, arr, true);
    }

    public static void writeArray(boolean[] arr, DataOutput dos) throws IOException {
        IoUtil.writeArray(arr, dos, false);
    }

    public static boolean[] readArray(DataInput dis, boolean[] arr) throws IOException {
        return IoUtil.readArray(dis, arr, false);
    }

    public static void writeSmallArray(byte[] arr, DataOutput dos) throws IOException {
        IoUtil.writeArray(arr, dos, true);
    }

    public static byte[] readSmallArray(DataInput dis, byte[] arr) throws IOException {
        return IoUtil.readArray(dis, arr, true);
    }

    public static void writeArray(byte[] arr, DataOutput dos) throws IOException {
        IoUtil.writeArray(arr, dos, false);
    }

    public static byte[] readArray(DataInput dis, byte[] arr) throws IOException {
        return IoUtil.readArray(dis, arr, false);
    }

    public static void writeSmallArray(int[] arr, DataOutput dos) throws IOException {
        IoUtil.writeArray(arr, dos, true);
    }

    public static int[] readSmallArray(DataInput dis, int[] arr) throws IOException {
        return IoUtil.readArray(dis, arr, true);
    }

    public static void writeArray(int[] arr, DataOutput dos) throws IOException {
        IoUtil.writeArray(arr, dos, false);
    }

    public static int[] readArray(DataInput dis, int[] arr) throws IOException {
        return IoUtil.readArray(dis, arr, false);
    }

    public static void writeSmallArray(long[] arr, DataOutput dos) throws IOException {
        IoUtil.writeArray(arr, dos, true);
    }

    public static long[] readSmallArray(DataInput dis, long[] arr) throws IOException {
        return IoUtil.readArray(dis, arr, true);
    }

    public static void writeArray(long[] arr, DataOutput dos) throws IOException {
        IoUtil.writeArray(arr, dos, false);
    }

    public static long[] readArray(DataInput dis, long[] arr) throws IOException {
        return IoUtil.readArray(dis, arr, false);
    }

    private static void writeLen(DataOutput dos, int n, boolean small) throws IOException {
        if (small) {
            dos.writeByte(n);
        } else {
            dos.writeInt(n);
        }
    }

    private static int readLen(DataInput dis, boolean small) throws IOException {
        int res = small ? dis.readByte() : dis.readInt();
        return res;
    }

    public static void writeArray(String[] arr, DataOutput dos, boolean small) throws IOException {
        if (arr != null) {
            IoUtil.writeLen(dos, arr.length, small);
            for (int i = 0; i < arr.length; ++i) {
                dos.writeUTF(arr[i]);
            }
        } else {
            IoUtil.writeLen(dos, 0, small);
        }
    }

    public static String[] readArray(DataInput dis, String[] arr, boolean small) throws IOException {
        String[] res;
        int n = IoUtil.readLen(dis, small);
        if (n >= 0) {
            res = arr == null || arr.length != n ? new String[n] : arr;
            for (int i = 0; i < n; ++i) {
                res[i] = dis.readUTF();
            }
        } else {
            res = null;
        }
        return res;
    }

    public static void writeArray(boolean[] arr, DataOutput dos, boolean small) throws IOException {
        if (arr != null) {
            IoUtil.writeLen(dos, arr.length, small);
            for (int i = 0; i < arr.length; ++i) {
                dos.writeBoolean(arr[i]);
            }
        } else {
            IoUtil.writeLen(dos, 0, small);
        }
    }

    public static boolean[] readArray(DataInput dis, boolean[] arr, boolean small) throws IOException {
        boolean[] res;
        int n = IoUtil.readLen(dis, small);
        if (n >= 0) {
            res = arr == null || arr.length != n ? new boolean[n] : arr;
            for (int i = 0; i < n; ++i) {
                res[i] = dis.readBoolean();
            }
        } else {
            res = null;
        }
        return res;
    }

    public static void writeArray(byte[] arr, DataOutput dos, boolean small) throws IOException {
        if (arr != null) {
            IoUtil.writeLen(dos, arr.length, small);
            for (int i = 0; i < arr.length; ++i) {
                dos.writeByte(arr[i]);
            }
        } else {
            IoUtil.writeLen(dos, 0, small);
        }
    }

    public static byte[] readArray(DataInput dis, byte[] arr, boolean small) throws IOException {
        byte[] res;
        int n = IoUtil.readLen(dis, small);
        if (n >= 0) {
            res = arr == null || arr.length != n ? new byte[n] : arr;
            for (int i = 0; i < n; ++i) {
                res[i] = dis.readByte();
            }
        } else {
            res = null;
        }
        return res;
    }

    public static void writeArray(int[] arr, DataOutput dos, boolean small) throws IOException {
        if (arr != null) {
            IoUtil.writeLen(dos, arr.length, small);
            for (int i = 0; i < arr.length; ++i) {
                dos.writeInt(arr[i]);
            }
        } else {
            IoUtil.writeLen(dos, 0, small);
        }
    }

    public static int[] readArray(DataInput dis, int[] arr, boolean small) throws IOException {
        int[] res;
        int n = IoUtil.readLen(dis, small);
        if (n >= 0) {
            res = arr == null || arr.length != n ? new int[n] : arr;
            for (int i = 0; i < n; ++i) {
                res[i] = dis.readInt();
            }
        } else {
            res = null;
        }
        return res;
    }

    public static void writeArray(long[] arr, DataOutput dos, boolean small) throws IOException {
        if (arr != null) {
            IoUtil.writeLen(dos, arr.length, small);
            for (int i = 0; i < arr.length; ++i) {
                dos.writeLong(arr[i]);
            }
        } else {
            IoUtil.writeLen(dos, 0, small);
        }
    }

    public static long[] readArray(DataInput dis, long[] arr, boolean small) throws IOException {
        long[] res;
        int n = IoUtil.readLen(dis, small);
        if (n >= 0) {
            res = arr == null || arr.length != n ? new long[n] : arr;
            for (int i = 0; i < n; ++i) {
                res[i] = dis.readLong();
            }
        } else {
            res = null;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBytes(Serializable dat) throws Exception {
        ByteArrayOutputStream bos = null;
        byte[] res = null;
        try {
            bos = new ByteArrayOutputStream();
            dat.serialize(bos);
            res = bos.toByteArray();
        }
        finally {
            if (bos != null) {
                bos.close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fromBytes(Deserializable dat, byte[] buf) throws Exception {
        ByteArrayInputStream bis = null;
        try {
            bis = new ByteArrayInputStream(buf);
            dat.deserialize(bis);
        }
        finally {
            if (bis != null) {
                bis.close();
            }
        }
    }

    public static void loadFromUrl(Deserializable data, String url) throws Exception {
        Http http = new Http();
        http.setReplyData(data);
        http.setThrowIfNotOk(true);
        http.get(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream getInputStreamFromFile(String fileUrl) throws Exception {
        FileConnection fc = null;
        try {
            fc = (FileConnection)Connector.open((String)fileUrl, (int)1);
            if (!fc.exists()) {
                throw new Exception("file not exists:" + fileUrl);
            }
            InputStream inputStream = fc.openInputStream();
            return inputStream;
        }
        finally {
            if (fc != null) {
                fc.close();
            }
        }
    }
}

