/*
 * Decompiled with CFR 0.152.
 */
package com.fw.j2me.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class LinkedHashtable {
    private Hashtable ht;
    private Vector keyList;
    private int maxSize = Integer.MAX_VALUE;

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        if (0 > maxSize) {
            throw new IllegalArgumentException("argument maxSize must no less than 0. ");
        }
        this.maxSize = maxSize;
    }

    public LinkedHashtable() {
        this.ht = new Hashtable();
        this.keyList = new Vector();
    }

    public LinkedHashtable(int maxSize) {
        this();
        if (0 > maxSize) {
            throw new IllegalArgumentException("argument maxSize must no less than 0. ");
        }
        this.maxSize = maxSize;
    }

    synchronized boolean containsValue(Object value) {
        return this.ht.contains(value);
    }

    private synchronized boolean removeEldestEntry() {
        return this.ht.size() > this.maxSize;
    }

    public synchronized void clear() {
        this.ht.clear();
        this.keyList.removeAllElements();
    }

    public synchronized boolean contains(Object value) {
        return this.ht.contains(value);
    }

    public synchronized boolean containsKey(Object key) {
        return this.ht.containsKey(key);
    }

    public synchronized Enumeration elements() {
        return this.ht.elements();
    }

    public synchronized Enumeration listKeys() {
        return this.keyList.elements();
    }

    public synchronized Object get(Object key) {
        Object ret = this.ht.get(key);
        if (this.ht.contains(key)) {
            this.addKeyToFirst(key);
        }
        return ret;
    }

    private void addKeyToFirst(Object key) {
        this.removeKeyFromList(key);
        this.keyList.insertElementAt(key, 0);
    }

    private void removeKeyFromList(Object key) {
        if (!this.keyList.removeElement(key)) {
            Enumeration enu = this.keyList.elements();
            while (enu.hasMoreElements()) {
                Object tmp = enu.nextElement();
                if (!tmp.equals(key)) continue;
                this.keyList.removeElement(tmp);
                return;
            }
        }
    }

    public synchronized boolean isEmpty() {
        return this.ht.isEmpty();
    }

    public synchronized Enumeration keys() {
        return this.ht.keys();
    }

    public synchronized Object put(Object key, Object value) {
        Object ret = this.ht.put(key, value);
        this.addKeyToFirst(key);
        while (this.removeEldestEntry()) {
            this.remove(this.keyList.lastElement());
        }
        return ret;
    }

    public synchronized Object remove(Object key) {
        Object ret = this.ht.remove(key);
        this.removeKeyFromList(key);
        return ret;
    }

    public synchronized int size() {
        return this.ht.size();
    }

    public synchronized String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("LinkedHashtable current size = ");
        sb.append(this.size());
        sb.append(", ");
        if (Integer.MAX_VALUE != this.maxSize) {
            sb.append("maxSize = ");
            sb.append(this.maxSize);
            sb.append(", ");
        }
        sb.append(this.ht.toString());
        return sb.toString();
    }

    public synchronized Object elementAt(int index) {
        Object ret = null;
        Object key = this.keyList.elementAt(index);
        if (null != key) {
            ret = this.ht.get(key);
        }
        return ret;
    }
}

