/*
 * Decompiled with CFR 0.152.
 */
package com.fw.j2me.util;

import com.fw.j2me.util.CntThread;
import com.fw.j2me.util.ExcludeIntf;
import com.fw.j2me.util.IoUtil;
import com.fw.j2me.util.MiscUtil;
import com.fw.j2me.util.MutexSyncQueue;
import com.fw.j2me.util.StreamPlayerObserver;
import com.fw.j2me.util.SyncQueue;
import com.fw.j2me.util.log.CntLog;
import com.nokia.mid.ui.DeviceControl;
import java.io.InputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VideoControl;

public class StreamPlayer
extends CntThread
implements PlayerListener {
    private static CntLog log = new CntLog("StreamPlayer");
    private Object playerLock = new Object();
    private Player player = null;
    private long duration;
    private long lastTime = 0L;
    private VideoControl vidc;
    private boolean suspended = false;
    private long restartMediaTime;
    private InputStream is;
    private StreamPlayerObserver observer;
    private static StreamPlayer instance;
    private boolean isHide = false;
    private static SyncQueue queue;
    private Canvas parentCanvas;
    private AsistantThread asistantThread;

    public void setObserver(StreamPlayerObserver o) {
        this.observer = o;
    }

    public static synchronized StreamPlayer getInstance() {
        if (instance == null) {
            instance = new StreamPlayer();
            instance.start();
        }
        return instance;
    }

    public void open(String url) {
        PlayerCommand cmd = new PlayerCommand(0);
        cmd.setParameter(url);
        queue.put(cmd);
    }

    public void show(int x, int y, int w, int h, Canvas c) {
        PlayerCommand cmd = new PlayerCommand(1);
        cmd.setParameter(new int[]{x, y, w, h});
        this.parentCanvas = c;
        queue.put(cmd);
    }

    public void pausePlayer() {
        PlayerCommand cmd = new PlayerCommand(2);
        queue.put(cmd);
    }

    public void startPlayer() {
        PlayerCommand cmd = new PlayerCommand(3);
        queue.put(cmd);
    }

    public void resumePlayer() {
        PlayerCommand cmd = new PlayerCommand(-3);
        queue.put(cmd);
    }

    public void closePlayer() {
        queue.clearQueue();
        PlayerCommand cmd = new PlayerCommand(7);
        queue.put(cmd);
    }

    public void reset() {
        queue.clearQueue();
        this.lastTime = 0L;
        this.isHide = false;
    }

    public void hideNotify() {
        PlayerCommand cmd = new PlayerCommand(5);
        queue.put(cmd);
    }

    public void showNotify() {
        log.debug("isHide:" + this.isHide);
        PlayerCommand cmd = new PlayerCommand(6);
        queue.put(cmd);
    }

    private StreamPlayer() {
        super("StreamPlayer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClose() {
        log.debug("doClose()");
        try {
            Object object = this.playerLock;
            synchronized (object) {
                if (this.player != null) {
                    this.player.stop();
                    this.player.deallocate();
                    this.player.close();
                    System.gc();
                    System.gc();
                    System.gc();
                    System.gc();
                }
                if (this.asistantThread != null) {
                    this.asistantThread.close();
                }
            }
            if (this.is != null) {
                this.is.close();
            }
        }
        catch (Exception e) {
            log.error("close Player: ", e);
        }
        finally {
            this.player = null;
            this.is = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOpen(String url) {
        log.debug("doOpen()");
        try {
            Object object = this.playerLock;
            synchronized (object) {
                if (url.startsWith("rtsp")) {
                    this.player = Manager.createPlayer((String)url);
                } else if (url.startsWith("file:///")) {
                    this.is = IoUtil.getInputStreamFromFile(url);
                    this.player = Manager.createPlayer((InputStream)this.is, (String)MiscUtil.guessContentType(url));
                } else {
                    this.is = url.getClass().getResourceAsStream(url);
                    this.player = Manager.createPlayer((InputStream)this.is, (String)MiscUtil.guessContentType(url));
                }
                this.player.addPlayerListener((PlayerListener)this);
                this.player.realize();
                this.vidc = (VideoControl)this.player.getControl("VideoControl");
                this.player.prefetch();
                this.observer.playerOpened();
            }
        }
        catch (Exception e) {
            log.error("openPlayer(): ", e);
            this.observer.playerFailed(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doShow(int x, int y, int w, int h, Canvas c) {
        try {
            log.debug("doShow() x=" + x + ", y=" + y + ", w=" + w + ", h=" + h);
            Object object = this.playerLock;
            synchronized (object) {
                if (this.vidc != null) {
                    this.vidc.initDisplayMode(81, (Object)c);
                    this.vidc.setDisplayLocation(x, y);
                    this.vidc.setDisplaySize(w, h);
                    this.vidc.setVisible(true);
                    this.asistantThread = new AsistantThread();
                    this.asistantThread.start();
                }
                DeviceControl.setLights((int)0, (int)100);
            }
        }
        catch (Exception e) {
            log.error("show(): ", e);
            this.observer.playerFailed(3);
        }
    }

    public void playerUpdate(Player plyr, String evt, Object evtData) {
        log.debug("playerUpdate() " + evt);
        if (evt == "endOfMedia") {
            this.lastTime = this.duration;
            this.observer.playerFinish();
        } else if (evt == "started") {
            if (this.isHide) {
                this.doPause();
            } else if (this.lastTime <= 0L) {
                this.lastTime = 1L;
                this.observer.playerStarted();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPause() {
        log.debug("doPause()");
        try {
            Object object = this.playerLock;
            synchronized (object) {
                if (this.player != null && this.player.getState() >= 400) {
                    this.suspended = true;
                    this.restartMediaTime = this.player.getMediaTime();
                    if (this.restartMediaTime <= 0L) {
                        log.debug("before stop: ");
                        this.player.stop();
                        log.debug("after stop: ");
                    } else {
                        this.player.deallocate();
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("pause()", e);
            this.observer.playerFailed(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStart() {
        log.debug("doStart()");
        try {
            Object object = this.playerLock;
            synchronized (object) {
                this.suspended = false;
                if (this.player != null) {
                    log.debug("state: " + this.player.getState());
                    if (this.player.getState() != 400) {
                        if (this.restartMediaTime > 0L) {
                            this.player.prefetch();
                            this.player.setMediaTime(this.restartMediaTime);
                        }
                        this.duration = this.player.getDuration();
                        log.debug("before start: ");
                        this.player.start();
                        log.debug("after start: ");
                    }
                }
            }
        }
        catch (Exception me) {
            log.error("doStart(): ", me);
            this.observer.playerFailed(1);
        }
    }

    public boolean hasStarted() {
        return this.lastTime > 0L;
    }

    public boolean isSuspend() {
        return this.suspended;
    }

    public long getLasttime() {
        return this.lastTime;
    }

    public long getDuration() {
        return this.duration;
    }

    public int getFrameHeight() {
        if (this.vidc != null) {
            return this.vidc.getSourceHeight();
        }
        return 0;
    }

    public int getFrameWidth() {
        if (this.vidc != null) {
            return this.vidc.getSourceWidth();
        }
        return 0;
    }

    private void doHideNotify() {
        this.isHide = true;
        this.doPause();
    }

    private void doShowNotify() {
        log.debug("doShowNotify");
        this.isHide = false;
        this.doStart();
    }

    protected void closeMe() {
        log.debug("StreamPlayer - closeMe");
    }

    protected void runMe() {
        while (!this.stop) {
            PlayerCommand cmd = (PlayerCommand)queue.get(this);
            if (this.stop) break;
            try {
                if (cmd == null) continue;
                cmd.execute();
            }
            catch (Exception e) {
                log.error("runMe: " + e);
                e.printStackTrace();
                this.observer.playerFailed(100);
            }
        }
    }

    static {
        queue = new MutexSyncQueue();
    }

    private class AsistantThread
    extends CntThread {
        private long lightTime = 0L;

        public AsistantThread() {
            super("AsistantThread of PagePlayer");
        }

        protected void closeMe() {
        }

        protected void runMe() {
            while (!this.stop && StreamPlayer.this.player != null && StreamPlayer.this.player.getState() != 0) {
                try {
                    long t;
                    long mediaTime = StreamPlayer.this.player.getMediaTime();
                    if (mediaTime > StreamPlayer.this.lastTime) {
                        StreamPlayer.this.lastTime = mediaTime;
                        StreamPlayer.this.observer.playerTimeUpdate();
                    }
                    if ((t = System.currentTimeMillis()) < this.lightTime) {
                        this.lightTime = t;
                    }
                    if (t - this.lightTime > 5000L) {
                        DeviceControl.setLights((int)0, (int)100);
                        this.lightTime = t;
                    }
                    do {
                        Thread.sleep(100L);
                    } while (StreamPlayer.this.player != null && StreamPlayer.this.suspended);
                }
                catch (Exception e) {
                    log.error("run(): ", e);
                    break;
                }
            }
        }
    }

    private class PlayerCommand
    implements ExcludeIntf {
        public static final int COMMAND_OPEN = 0;
        public static final int COMMAND_SHOW = 1;
        public static final int COMMAND_PAUSE = 2;
        public static final int COMMAND_START = 3;
        public static final int COMMAND_RESUME = -3;
        public static final int COMMAND_HIDE_NOTIFY = 5;
        public static final int COMMAND_SHOW_NOTIFY = 6;
        public static final int COMMAND_CLOSE = 7;
        private int cmd;
        private Object parameter;

        private PlayerCommand(int cmd) {
            this.cmd = cmd;
        }

        public void execute() {
            log.debug("cmd: " + this.cmd);
            switch (this.cmd) {
                case 0: {
                    StreamPlayer.this.doOpen((String)this.parameter);
                    break;
                }
                case 1: {
                    int[] pos = (int[])this.parameter;
                    StreamPlayer.this.doShow(pos[0], pos[1], pos[2], pos[3], StreamPlayer.this.parentCanvas);
                    break;
                }
                case 2: {
                    StreamPlayer.this.doPause();
                    break;
                }
                case -3: 
                case 3: {
                    StreamPlayer.this.doStart();
                    break;
                }
                case 5: {
                    StreamPlayer.this.doHideNotify();
                    break;
                }
                case 6: {
                    StreamPlayer.this.doShowNotify();
                    break;
                }
                case 7: {
                    StreamPlayer.this.doClose();
                    break;
                }
            }
        }

        public void setParameter(Object url) {
            this.parameter = url;
        }

        public Object getParameter() {
            return this.parameter;
        }

        public boolean exclude(ExcludeIntf e) {
            return (this.cmd ^ ((PlayerCommand)e).getCmd()) == -1;
        }

        private int getCmd() {
            return this.cmd;
        }

        public String toString() {
            return "" + this.cmd;
        }
    }
}

