/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.ykjc.ui.component;

import com.fw.j2me.ui.IWaiting;
import com.fw.j2me.uiimpl.UiContext;
import com.sonyericsson.ykjc.model.Channel;
import com.sonyericsson.ykjc.ui.IndependentComponent;
import com.sonyericsson.ykjc.ui.YkUiContext;
import com.sonyericsson.ykjc.ui.component.IndependentComponentCreator;
import com.sonyericsson.ykjc.ui.component.KeyConsumer;
import com.sonyericsson.ykjc.ui.pages.YkPageBase;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Font;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.events.FocusListener;
import com.sun.lwuit.geom.Dimension;
import java.util.Timer;
import java.util.TimerTask;

public class ChannelsBar
extends Container
implements KeyConsumer,
IndependentComponentCreator,
FocusListener {
    private static final int MAX_CHANNELS_PER_GROUP = 3;
    private static final int OFFSET = 3;
    private static final int CHANNELS_CHANGE_INTERVAL = 3000;
    private static final int X_PADDING = 5;
    private static final int COLOR_MY_BLUE = 17151;
    private static final int COLOR_MY_WHITE = 0xFFFFFF;
    private static final int COLOR_DISABLE = 0x8C8C8C;
    private Channel[] mChannels = null;
    private YkPageBase mParentPage;
    private int mTotalGroups;
    private int mCurGroup;
    private int mFocusedIndex = -1;
    private int mCurGroupChsNum = 0;
    private boolean disabled = true;
    private boolean isTop;
    private Timer mTimer = new Timer();
    private Image indicator0;
    private Image indicator1;
    private Font font = Font.createSystemFont(32, 0, 8);

    public ChannelsBar(Dimension dim, Channel[] chs, YkPageBase parentPage) {
        this.mParentPage = parentPage;
        this.mChannels = chs;
        this.mTotalGroups = (this.mChannels.length + 3 - 1) / 3;
        this.mCurGroup = 0;
        this.isTop = false;
        this.addFocusListener(this);
        this.setPreferredSize(dim);
        this.startTimer();
        this.indicator0 = YkUiContext.imgMgr.getImage("channelIndicator");
        this.indicator1 = YkUiContext.imgMgr.getImage("channelIndicatorDisable");
    }

    public void setDisable(boolean b) {
        this.disabled = b;
    }

    public void paint(Graphics g) {
        Font font = Font.createSystemFont(32, 0, 8);
        int posX = this.getX();
        int posY = this.getY();
        if (this.getHeight() > font.getHeight()) {
            posY += (this.getHeight() - font.getHeight()) / 2 + 3;
        }
        g.setColor(this.disabled ? 0x8C8C8C : 17151);
        g.setFont(font);
        g.drawString(YkUiContext.strMgr.getString("hotChannel"), posX + 5, posY);
        this.drawChannels(g);
        this.drawIndicator(g);
    }

    private void drawIndicator(Graphics g) {
        if (this.mTotalGroups > 1) {
            int posX = this.getX() + this.getPreferredW() - 5 - this.indicator0.getWidth();
            int posY = this.getY() + (this.getHeight() - this.indicator0.getHeight()) / 2 + 3;
            g.drawImage(this.disabled ? this.indicator1 : this.indicator0, posX, posY);
        }
    }

    private void drawChannels(Graphics g) {
        if (this.mChannels.length > 0) {
            int i;
            int expectWidth = (this.getWidth() - this.font.stringWidth(YkUiContext.strMgr.getString("hotChannel")) - 5) / 3 - 5;
            int posX = this.getX() + 5 + this.font.stringWidth(YkUiContext.strMgr.getString("hotChannel"));
            int posY = this.getY();
            if (this.getHeight() > this.font.getHeight()) {
                posY += (this.getHeight() - this.font.getHeight()) / 2 + 3;
            }
            for (i = 0; i < 3 && this.mCurGroup * 3 + i < this.mChannels.length; ++i) {
                String chName = this.mChannels[this.mCurGroup * 3 + i].getName();
                if (this.mFocusedIndex == i) {
                    g.setColor(17151);
                    g.fillRect(posX, posY, this.font.stringWidth(chName), this.font.getHeight());
                    g.setColor(0xFFFFFF);
                    g.drawString(chName, posX, posY);
                } else {
                    g.setColor(this.disabled ? 0x8C8C8C : 17151);
                    g.drawString(chName, posX, posY);
                }
                posX += expectWidth;
            }
            this.mCurGroupChsNum = i;
        }
    }

    public void stopTimer() {
        if (this.mTimer != null) {
            this.mTimer.cancel();
            this.mTimer = null;
        }
    }

    private void doOpenChannel(Channel c) {
        if (c == null) {
            return;
        }
        YkUiContext.proxy.setCurrentChannel(c);
        IWaiting waiting = (IWaiting)((Object)UiContext.pageMgr.changePage(134217751));
        waiting.setExceptEvent(11);
        YkUiContext.proxy.doGetChannelVideos(c.getId(), 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void focusGained(Component arg0) {
        ChannelsBar channelsBar = this;
        synchronized (channelsBar) {
            this.mParentPage.buildPageCommand();
            this.mFocusedIndex = 0;
            this.stopTimer();
            this.setDisable(false);
            this.repaint(this.getAbsoluteX(), this.getAbsoluteY(), this.getPreferredW(), this.getPreferredH());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void focusLost(Component arg0) {
        ChannelsBar channelsBar = this;
        synchronized (channelsBar) {
            this.mParentPage.buildPageCommand();
            this.mFocusedIndex = -1;
            this.startTimer();
            this.setDisable(true);
            this.repaint(this.getAbsoluteX(), this.getAbsoluteY(), this.getPreferredW(), this.getPreferredH());
        }
    }

    public void startTimer() {
        this.stopTimer();
        this.mTimer = new Timer();
        TimerTask task = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ChannelsBar channelsBar = ChannelsBar.this;
                synchronized (channelsBar) {
                    if (++ChannelsBar.this.mCurGroup == ChannelsBar.this.mTotalGroups) {
                        ChannelsBar.this.mCurGroup = 0;
                    }
                    ChannelsBar.this.repaint(ChannelsBar.this.getAbsoluteX(), ChannelsBar.this.getAbsoluteY(), ChannelsBar.this.getPreferredW(), ChannelsBar.this.getPreferredH());
                }
            }
        };
        this.mTimer.schedule(task, 3000L, 3000L);
    }

    public void setIsTop(boolean b) {
        this.isTop = b;
    }

    public boolean isTop() {
        return this.isTop;
    }

    public IndependentComponent genIndependentComponent() {
        int[] actions = new int[]{1, 2, 5, 8};
        IndependentComponent ic = new IndependentComponent(this, actions);
        return ic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean consumeKey(int keyCode) {
        boolean consumed = true;
        ChannelsBar channelsBar = this;
        synchronized (channelsBar) {
            int gameAction = Display.getInstance().getGameAction(keyCode);
            if (gameAction == 8) {
                if (this.mFocusedIndex >= 0 && this.mFocusedIndex < this.mCurGroupChsNum) {
                    this.doOpenChannel(this.mChannels[this.mFocusedIndex + this.mCurGroup * 3]);
                }
            } else if (gameAction == 2) {
                --this.mFocusedIndex;
                if (this.mFocusedIndex < 0) {
                    if (this.mTotalGroups == 1) {
                        this.mFocusedIndex = 0;
                    } else {
                        --this.mCurGroup;
                        if (this.mCurGroup < 0) {
                            this.mCurGroup = this.mTotalGroups - 1;
                        }
                        if (null != this.mChannels) {
                            this.mFocusedIndex = this.mCurGroup != this.mTotalGroups - 1 ? 2 : this.mChannels.length % 3 - 1;
                        }
                    }
                }
            } else if (gameAction == 5) {
                ++this.mFocusedIndex;
                if (this.mFocusedIndex == this.mCurGroupChsNum) {
                    if (this.mTotalGroups == 1) {
                        --this.mFocusedIndex;
                    } else {
                        this.mFocusedIndex = 0;
                        ++this.mCurGroup;
                        if (this.mCurGroup == this.mTotalGroups) {
                            this.mCurGroup = 0;
                        }
                    }
                }
            } else if (gameAction == 1) {
                consumed = this.isTop();
            }
            this.repaint();
        }
        return consumed;
    }
}

