/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.ykjc.ui.component;

import com.sonyericsson.ykjc.ui.YkUiContext;
import com.sun.lwuit.Button;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Font;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.events.FocusListener;
import com.sun.lwuit.layouts.BoxLayout;

public abstract class NavigationSimpleBar
extends Container
implements ActionListener {
    private Button pre;
    private Label pageInfo;
    private Label currentPageInfo;
    private Button next;
    private int curPage;
    private int allPage;

    public NavigationSimpleBar(int width, int all, int curPage, int allPage) {
        super(new BoxLayout(1));
        if (curPage < 0) {
            curPage = 0 + (allPage > 0 ? 1 : 0);
        }
        if (curPage > allPage) {
            curPage = allPage;
        }
        this.curPage = curPage;
        this.allPage = allPage;
        this.setWidth(width);
        this.getStyle().setBgTransparency(0);
        boolean canPre = 1 < curPage;
        boolean canNext = allPage > curPage;
        this.pre = new ArrowButton(true, canPre);
        this.next = new ArrowButton(false, canNext);
        this.pre.setNextFocusLeft(canNext ? this.next : this.pre);
        this.next.setNextFocusLeft(canPre ? this.pre : this.next);
        this.pre.setNextFocusRight(canNext ? this.next : this.pre);
        this.next.setNextFocusRight(canPre ? this.pre : this.next);
        Font font = Font.createSystemFont(0, 1, 8);
        String curPageNum = this.getCurrentPageNumberStr();
        this.currentPageInfo = new Label(curPageNum);
        this.currentPageInfo.getStyle().setFont(font);
        this.currentPageInfo.setGap(0);
        this.currentPageInfo.getStyle().setFgColor(0);
        this.currentPageInfo.getStyle().setBgTransparency(0);
        this.currentPageInfo.getStyle().setMargin(0, 0, 0, 0);
        this.currentPageInfo.getStyle().setPadding(0, 0, 0, 0);
        this.currentPageInfo.setAlignment(3);
        String totalPageNumber = this.getPageNumberStr();
        this.pageInfo = new Label(totalPageNumber);
        this.pageInfo.setGap(0);
        this.pageInfo.getStyle().setFgColor(0);
        this.pageInfo.getStyle().setMargin(0, 0, 0, 0);
        this.pageInfo.getStyle().setPadding(0, 0, 0, 0);
        this.pageInfo.getStyle().setBgTransparency(0);
        this.pageInfo.setAlignment(4);
        Container mergerContainer = new Container();
        mergerContainer.setLayout(new BoxLayout(1));
        mergerContainer.getStyle().setFgColor(0);
        mergerContainer.getStyle().setBgTransparency(0);
        mergerContainer.addComponent(this.currentPageInfo);
        mergerContainer.addComponent(this.pageInfo);
        this.addComponent(this.pre);
        this.pre.addActionListener(this);
        this.addComponent(mergerContainer);
        this.addComponent(this.next);
        this.next.addActionListener(this);
        int w = (Display.getInstance().getDisplayWidth() - this.getPreferredW()) / 2;
        this.getStyle().setMargin(0, 0, w, w);
    }

    private String getCurrentPageNumberStr() {
        String curPageStr = Integer.toString(this.curPage);
        return curPageStr;
    }

    private String getPageNumberStr() {
        return "/" + this.allPage + YkUiContext.strMgr.getString("page");
    }

    public Button getPreButton() {
        return this.pre;
    }

    public Button getNextButton() {
        return this.next;
    }

    public void setPage(int page) {
        this.curPage = page;
        this.pageInfo.setText(this.getPageNumberStr());
    }

    public void setAllPage(int allPage) {
        this.allPage = allPage;
        this.pageInfo.setText(this.getPageNumberStr());
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (this.pre.hasFocus()) {
            this.getPage(this.curPage - 1);
        } else if (this.next.hasFocus()) {
            this.getPage(this.curPage + 1);
        }
    }

    public void setFocusUp(Component c) {
        this.pre.setNextFocusUp(c.isFocusable() ? c : this.pre);
        this.next.setNextFocusUp(c.isFocusable() ? c : this.next);
    }

    public void setFocusDown(Component c) {
        this.pre.setNextFocusDown(c.isFocusable() ? c : this.pre);
        this.next.setNextFocusDown(c.isFocusable() ? c : this.next);
    }

    protected abstract void getPage(int var1);

    public void setFocusListener(FocusListener listener) {
        this.pre.addFocusListener(listener);
        this.next.addFocusListener(listener);
    }

    public String getIndicateString() {
        String ret = YkUiContext.strMgr.getString("select");
        if (this.pre.hasFocus()) {
            ret = YkUiContext.strMgr.getString("prev_page");
        } else if (this.next.hasFocus()) {
            ret = YkUiContext.strMgr.getString("next_page");
        }
        return ret;
    }

    public boolean hasFocus() {
        return this.pre.hasFocus() || this.next.hasFocus();
    }

    class ArrowButton
    extends Button
    implements FocusListener {
        private boolean pre;

        public ArrowButton(boolean pre, boolean available) {
            this.pre = pre;
            this.setCellRenderer(false);
            this.getStyle().setBorder(null);
            this.setFocusable(available);
            this.addFocusListener(this);
            this.setIcon(this.getIcon(false));
        }

        public void focusGained(Component c) {
            this.setIcon(this.getIcon(true));
        }

        public void focusLost(Component c) {
            this.setIcon(this.getIcon(false));
        }

        private Image getIcon(boolean focus) {
            if (this.pre) {
                return this.getPreIcon(focus);
            }
            return this.getNextIcon(focus);
        }

        private Image getPreIcon(boolean focus) {
            if (this.isFocusable()) {
                return YkUiContext.imgMgr.getImage(focus ? "preFocus" : "unPre");
            }
            return YkUiContext.imgMgr.getImage("preUnavailable");
        }

        private Image getNextIcon(boolean focus) {
            if (this.isFocusable()) {
                return YkUiContext.imgMgr.getImage(focus ? "nextFocus" : "unNext");
            }
            return YkUiContext.imgMgr.getImage("nextUnavailable");
        }

        protected boolean isSelectableInteraction() {
            return false;
        }
    }
}

