/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.ykjc.ui.component;

import com.fw.j2me.util.MiscUtil;
import com.sonyericsson.ykjc.model.VideoInfo;
import com.sonyericsson.ykjc.ui.IndependentComponent;
import com.sonyericsson.ykjc.ui.YkUiContext;
import com.sonyericsson.ykjc.ui.component.ClipBrowserListener;
import com.sonyericsson.ykjc.ui.component.IndependentComponentCreator;
import com.sonyericsson.ykjc.ui.component.KeyConsumer;
import com.sonyericsson.ykjc.ui.component.VideoThumbnail;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.FocusListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.plaf.Style;

public class VideoList
extends Container
implements FocusListener,
IndependentComponentCreator,
KeyConsumer {
    private static final int VISIBLE_ITEM_NUMBER = 3;
    private static final String[] POSITION = new String[]{"West", "Center", "East"};
    private static final int PREFER_WIDTH = 64;
    private static final int PREFER_HEIGHT = 48;
    private static final int BORDER_SIZE = 4;
    private static final int INTERVAL_SIZE = 4;
    private Container[] videoClip;
    private VideoThumbnail[] items;
    private Label[] titles;
    private int firstVisible;
    private int highLightIndex;
    private ClipBrowserListener listener;
    private int totalHeight;
    private int preferWidth = YkUiContext.uiConfig.getIntProperty("relate_video_width", 64) + 16;
    private int preferHeight = YkUiContext.uiConfig.getIntProperty("relate_video_height", 48) + 8;

    public VideoList(VideoInfo[] videos) {
        this.videoClip = new Container[videos.length];
        this.items = new VideoThumbnail[videos.length];
        this.titles = new Label[videos.length];
        for (int i = 0; i < videos.length; ++i) {
            this.videoClip[i] = new Container();
            this.videoClip[i].setLayout(new BoxLayout(2));
            this.items[i] = new VideoThumbnail(videos[i], new Dimension(this.preferWidth, this.preferHeight), 0);
            this.items[i].setThinBorderWidth();
            this.items[i].getStyle().setMargin(0, 0);
            this.items[i].setFocusable(false);
            this.videoClip[i].addComponent(this.items[i]);
            this.titles[i] = new Label(videos[i].getTitle());
            Style style = this.titles[i].getStyle();
            style.setMargin(0, 0, 2, 2);
            boolean exceed = style.getFont().stringWidth(videos[i].getTitle()) > this.preferWidth - style.getMargin(1) - style.getMargin(3) - style.getPadding(1) - style.getPadding(3);
            this.titles[i].setTickerEnabled(exceed);
            this.titles[i].setEndsWith3Points(exceed);
            this.videoClip[i].addComponent(this.titles[i]);
            Label dc = new Label("" + videos[i].getSize());
            dc.getStyle().setMargin(0, 0, 3, 2);
            this.videoClip[i].addComponent(dc);
            if (this.totalHeight < this.preferHeight + this.titles[i].getPreferredH() + dc.getPreferredH()) {
                this.totalHeight = this.preferHeight + this.titles[i].getPreferredH() + dc.getPreferredH();
            }
            this.videoClip[i].setPreferredSize(new Dimension(this.preferWidth, this.totalHeight));
        }
        this.firstVisible = 0;
        this.highLightIndex = 0;
        this.setFocus(false);
        this.setFocusable(true);
        this.setLayout(new BorderLayout());
        this.buildContent(false);
        this.addFocusListener(this);
        this.setPreferredSize(new Dimension(Display.getInstance().getDisplayWidth(), this.totalHeight));
    }

    public void setListener(ClipBrowserListener listener) {
        this.listener = listener;
    }

    public void keyPressed(int keyCode) {
        int gameAction = Display.getInstance().getGameAction(keyCode);
        if (gameAction == 5) {
            if (this.highLightIndex < 2) {
                ++this.highLightIndex;
            } else {
                this.firstVisible = (this.firstVisible + 1) % this.videoClip.length;
            }
        } else if (gameAction == 2) {
            if (this.highLightIndex > 0) {
                --this.highLightIndex;
            } else {
                this.firstVisible = (this.firstVisible + this.videoClip.length - 1) % this.videoClip.length;
            }
        }
        this.buildContent(true);
        this.startTitleTicker();
        this.listener.selectClipChanged((this.firstVisible + this.highLightIndex) % this.videoClip.length);
        this.repaint();
    }

    public void buildContent(boolean focused) {
        int i;
        if (MiscUtil.isEmpty(this.videoClip)) {
            return;
        }
        this.removeAll();
        this.stopTitleTicker();
        boolean full = this.videoClip.length > 3;
        for (i = 0; i < this.videoClip.length && i < POSITION.length; ++i) {
            this.addComponent(POSITION[i], (Component)this.videoClip[((full ? this.firstVisible : 0) + i) % this.videoClip.length]);
        }
        while (i < 3 && i < POSITION.length) {
            Label space = new Label(" ");
            space.getStyle().setMargin(0, 0, 0, 0);
            space.getStyle().setPadding(0, 0, 0, 0);
            space.getStyle().setBorder(null);
            space.setPreferredSize(new Dimension(this.preferWidth, this.totalHeight));
            this.addComponent(POSITION[i], (Component)space);
            ++i;
        }
        this.items[(this.firstVisible + this.highLightIndex) % this.videoClip.length].setHighlight(focused);
        this.repaint();
    }

    public int getCurrentSelectClip() {
        return (this.firstVisible + this.highLightIndex) % this.videoClip.length;
    }

    public void setVideo(VideoInfo info, int i) {
        this.items[i].setImage(info.getImg());
    }

    public void focusGained(Component cmp) {
        this.items[(this.firstVisible + this.highLightIndex) % this.items.length].setHighlight(true);
        this.startTitleTicker();
    }

    public void focusLost(Component cmp) {
        this.stopTitleTicker();
    }

    public void startTitleTicker() {
        if (this.titles[(this.firstVisible + this.highLightIndex) % this.items.length].isTickerEnabled()) {
            this.titles[(this.firstVisible + this.highLightIndex) % this.items.length].startTicker(100L, true);
        }
    }

    public void stopTitleTicker() {
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i].setHighlight(false);
            this.titles[i].stopTicker();
        }
    }

    public IndependentComponent genIndependentComponent() {
        int[] actions = new int[]{2, 5, 6};
        IndependentComponent ic = new IndependentComponent(this, actions);
        return ic;
    }

    public boolean consumeKey(int keyCode) {
        this.keyPressed(keyCode);
        return true;
    }
}

