/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.ykjc.ui.component;

import com.fw.j2me.util.log.CntLog;
import com.sonyericsson.ykjc.model.VideoInfo;
import com.sonyericsson.ykjc.ui.YkUiContext;
import com.sun.lwuit.Component;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.geom.Dimension;

public class VideoThumbnail
extends Component {
    private static CntLog log = new CntLog("VideoThumbnail");
    private Image img;
    private static final int BORDER_SIZE = 4;
    private static final int INTERVAL_SIZE = 4;
    private boolean isHighlight;
    private int preferW;
    private int preferH;
    private boolean thinBorderWidth;

    public VideoThumbnail(VideoInfo videoInfo, Dimension d, int topMargin) {
        this.setPreferredSize(d);
        this.preferW = d.getWidth() - 16;
        this.preferH = d.getHeight() - 8 - topMargin;
        this.setImage(videoInfo.getImg());
        this.isHighlight = false;
        this.thinBorderWidth = false;
        this.setFocusable(true);
    }

    public void paint(Graphics g) {
        int x = (this.preferW - this.img.getWidth()) / 2 + 4 + 4 + 2;
        int y = (this.preferH - this.img.getHeight()) / 2 + 4 + this.getStyle().getMargin(0);
        this.paintBg(g, x, y, this.img.getWidth(), this.img.getHeight());
        g.drawImage(this.img, x, y);
        if (this.hasFocus() || this.isHighlight) {
            Image videoplay = YkUiContext.imgMgr.getImage("videoplay");
            g.drawImage(videoplay, x + (this.img.getWidth() - videoplay.getWidth()) / 2, y + (this.img.getHeight() - videoplay.getHeight()) / 2);
        }
    }

    public void setThinBorderWidth() {
        this.thinBorderWidth = true;
    }

    private void paintBg(Graphics g, int x, int y, int w, int h) {
        g.setColor(0);
        g.drawRect(x - 1, y - 1, w + 1, h + 1);
        if (this.thinBorderWidth) {
            if (this.hasFocus() || this.isHighlight) {
                g.setColor(12182261);
                g.drawRect(x - 2, y - 2, w + 3, h + 3);
                g.setColor(1406633);
                g.drawRect(x - 3, y - 3, w + 5, h + 5);
            } else {
                g.setColor(6194331);
                g.drawRect(x - 2, y - 2, w + 3, h + 3);
                g.setColor(0x2C2C2E);
                g.drawRect(x - 3, y - 3, w + 5, h + 5);
            }
        } else if (this.hasFocus() || this.isHighlight) {
            g.setColor(12182261);
            g.drawRect(x - 2, y - 2, w + 3, h + 3);
            g.drawRect(x - 3, y - 3, w + 5, h + 5);
            g.setColor(1406633);
            g.drawRect(x - 4, y - 4, w + 7, h + 7);
        } else {
            g.setColor(6194331);
            g.drawRect(x - 2, y - 2, w + 3, h + 3);
            g.drawRect(x - 3, y - 3, w + 5, h + 5);
            g.setColor(0x2C2C2E);
            g.drawRect(x - 4, y - 4, w + 7, h + 7);
        }
    }

    public void setHighlight(boolean isHighlight) {
        this.isHighlight = isHighlight;
    }

    public void setImage(Image image) {
        this.img = image;
        if (this.img == null) {
            this.img = YkUiContext.imgMgr.getImage("defaultClipImage");
        }
        if (this.img.getWidth() != this.preferW || this.img.getHeight() != this.preferH) {
            this.img = this.img.scaled(this.preferW, this.preferH);
        }
    }
}

