/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.ykjc.ui.pages;

import com.fw.j2me.ui.IWaiting;
import com.fw.j2me.uiimpl.UiContext;
import com.fw.j2me.util.CntEvent;
import com.sonyericsson.ykjc.model.DataMyYouKu;
import com.sonyericsson.ykjc.model.DataTemplateB;
import com.sonyericsson.ykjc.model.VideoInfo;
import com.sonyericsson.ykjc.ui.YkUiContext;
import com.sonyericsson.ykjc.ui.component.BoldLabel;
import com.sonyericsson.ykjc.ui.component.NavigationBar;
import com.sonyericsson.ykjc.ui.component.Seperator;
import com.sonyericsson.ykjc.ui.component.YBrowser;
import com.sonyericsson.ykjc.ui.component.YForm;
import com.sonyericsson.ykjc.ui.pages.YkPageBase;
import com.sonyericsson.ykjc.util.YkContentHandlerUtil;
import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Font;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.FocusListener;
import com.sun.lwuit.layouts.BoxLayout;
import java.util.Vector;

public class PageMyYouKu
extends YkPageBase
implements FocusListener {
    private static final int PLAY_COMMAND = 1;
    private static final int LOGOUT_COMMAND = 2;
    private static final int HELP_COMMAND = 3;
    private static final int SHARE_COMMAND = 4;
    private static final int PAGE_NAV_COMMAND = 5;
    private DataTemplateB mData = null;
    private VideoInfo[] videos;
    private String mTitle = null;
    private YBrowser yBrowser;
    private NavigationBar pageNavBar;
    private Command cmdPlay = new Command(YkUiContext.strMgr.getString("play"), 1);
    private Command cmdLogout = new Command(YkUiContext.strMgr.getString("logout"), 2);
    private Command cmdHelp = new Command(YkUiContext.strMgr.getString("help"), 3);
    private Command cmdShare = new Command(YkUiContext.strMgr.getString("share_menu"), 4);

    public PageMyYouKu(int id) {
        super(id);
        String strUser = YkUiContext.proxy.getUserInfo().getUserId();
        String strWelcome = YkUiContext.strMgr.getString("welcome") + ", ";
        if (strUser != null) {
            strUser = strUser.substring(0, strUser.indexOf("@"));
            strWelcome = strWelcome + strUser;
        }
        this.setTitle(strWelcome);
    }

    public void buildPageCommand() {
        this.form.removeAllCommands();
        this.mData = this.prepareData();
        if (this.mData.getResult() != null && this.mData.getResult().size() > 0) {
            if (this.yBrowser != null && this.yBrowser.hasFocus()) {
                this.form.addCommand(this.cmdPlay);
            } else if (this.pageNavBar != null && this.pageNavBar.hasFocus()) {
                Command cmdPageNav = new Command(this.pageNavBar.getIndicateString(), 5);
                this.form.addCommand(cmdPageNav);
            }
            this.form.addCommand(this.cmdBack);
            this.form.addCommand(this.cmdLogout);
            this.form.addCommand(this.cmdHelp);
            this.form.addCommand(this.cmdShare);
        } else {
            this.form.addCommand(this.cmdHelp);
            this.form.addCommand(this.cmdBack);
            this.form.addCommand(this.cmdLogout);
        }
    }

    protected void buildPageContent() {
        this.form.addComponent(new BoldLabel(this.mTitle));
        this.form.setCommandListener(this);
        this.mData = this.prepareData();
        if (null == this.mData) {
            return;
        }
        this.form.setLayout(new BoxLayout(2));
        if (this.mData.getResult() != null && this.mData.getResult().size() > 0) {
            this.addNavBar();
            this.addVideoComponents();
            this.pageNavBar.setFocusUp(this.pageNavBar);
            this.pageNavBar.setFocusDown(this.yBrowser.getReal());
        } else {
            this.addComponentsWhenNoVideo();
        }
    }

    protected DataTemplateB prepareData() {
        return YkUiContext.proxy.getMyYouKu();
    }

    protected void addNavBar() {
        this.pageNavBar = new NavigationBar(this.form.getWidth(), this.getData().getAllResult(), this.getData().getCurPage(), this.getData().getAllPage(), null){

            protected void getPage(int page) {
                IWaiting waiting = (IWaiting)((Object)UiContext.pageMgr.changePage(0x8000018));
                waiting.setExceptEvent(13);
                PageMyYouKu.this.doGetPage(page);
            }
        };
        this.pageNavBar.setFocusListener(this);
        this.pageNavBar.setTitle(YkUiContext.strMgr.getString("my_upload_videos"));
        this.form.addComponent(this.pageNavBar);
    }

    protected void doGetPage(int page) {
        DataMyYouKu data = (DataMyYouKu)this.getData();
        YkUiContext.proxy.doGetMyYouKu(data.getEmail(), data.getPwd(), page);
    }

    private void addVideoComponents() {
        Vector videoInfoVec = this.mData.getResult();
        this.videos = new VideoInfo[videoInfoVec.size()];
        videoInfoVec.copyInto(this.videos);
        this.yBrowser = new YBrowser(this.videos, this);
        this.form.addComponent(this.yBrowser);
        this.form.setFocused(this.yBrowser.getReal());
        ((YForm)this.form).addIndependentComponents(this.yBrowser);
    }

    protected void addComponentsWhenNoVideo() {
        Font fontPlain = Font.createSystemFont(32, 0, 8);
        Font fontBold = Font.createSystemFont(0, 1, 8);
        Seperator sep = new Seperator();
        this.form.addComponent(sep);
        Label imageLabel = new Label("");
        imageLabel.setIcon(YkUiContext.imgMgr.getImage("default never upload"));
        imageLabel.setAlignment(4);
        this.form.addComponent(imageLabel);
        Label emptyTitle = new Label("");
        String emptyText = YkUiContext.strMgr.getString("myyouku_empty");
        emptyTitle.getStyle().setFont(fontBold);
        emptyTitle.setText(emptyText);
        emptyTitle.getStyle().setFgColor(0);
        emptyTitle.setAlignment(4);
        emptyTitle.getStyle().setBgTransparency(0);
        this.form.addComponent(emptyTitle);
        BoldLabel suggest = new BoldLabel(YkUiContext.strMgr.getString("searchAdviceTitle"));
        suggest.getStyle().setFgColor(0x707070);
        suggest.setAlignment(1);
        suggest.getStyle().setFont(fontPlain);
        suggest.getStyle().setMargin(2, suggest.getStyle().getMargin(2) / 4);
        this.form.addComponent(suggest);
        Label suggest1 = new Label(YkUiContext.strMgr.getString("uploadSuggestion1"));
        suggest1.getStyle().setFont(fontPlain);
        suggest1.setAlignment(1);
        suggest1.getStyle().setMargin(0, suggest1.getStyle().getMargin(0) / 4);
        suggest1.getStyle().setMargin(2, suggest1.getStyle().getMargin(2) / 4);
        this.form.addComponent(suggest1);
        Label suggest2 = new Label(YkUiContext.strMgr.getString("uploadSuggestion2"));
        suggest2.getStyle().setFont(fontPlain);
        suggest2.setAlignment(1);
        suggest2.getStyle().setMargin(0, suggest2.getStyle().getMargin(0) / 4);
        suggest2.getStyle().setMargin(2, suggest2.getStyle().getMargin(2) / 4);
        this.form.addComponent(suggest2);
    }

    public void doActionPerformed(ActionEvent evt) {
        Command cmd = evt.getCommand();
        switch (cmd.getId()) {
            case 0: {
                UiContext.pageMgr.changePage(0x10000000);
                break;
            }
            case 1: {
                this.playVideo(this.yBrowser.getCurVideoInfo());
                break;
            }
            case 2: {
                if (!this.doActionLogoutOption()) break;
                UiContext.pageMgr.changePage(0x4000001);
                break;
            }
            case 3: {
                this.changePage(5);
                break;
            }
            case 4: {
                YkContentHandlerUtil.shareViaSms(this.yBrowser.getCurVideoInfo().getVideoUrl());
                break;
            }
            case 5: {
                this.pageNavBar.navigate(evt);
                break;
            }
        }
    }

    public boolean handleEvent(CntEvent event) {
        boolean handle = false;
        if (event == null) {
            return handle;
        }
        int type = event.getEventType();
        switch (type) {
            case 100: {
                Vector videoVec = this.mData.getResult();
                if (videoVec == null) break;
                String videoId = event.getAttrString(100);
                for (int i = 0; i < videoVec.size(); ++i) {
                    VideoInfo vInfo = (VideoInfo)videoVec.elementAt(i);
                    if (!vInfo.getId().equals(videoId)) continue;
                    if (this.yBrowser != null) {
                        this.yBrowser.setClip(vInfo.getImg(), i);
                    }
                    handle = true;
                }
                this.yBrowser.repaint();
                break;
            }
        }
        return handle;
    }

    protected void setTitle(String title) {
        this.mTitle = title;
    }

    protected DataTemplateB getData() {
        return this.mData;
    }

    public void refresh() {
        super.refresh();
        if (this.yBrowser != null && this.videos != null && this.videos.length > 0) {
            this.yBrowser.refresh();
            this.form.setFocused(this.yBrowser.getReal());
        }
        this.buildPageCommand();
    }

    public void focusGained(Component cmp) {
        this.buildPageCommand();
    }

    public void focusLost(Component cmp) {
        this.buildPageCommand();
    }
}

