/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.ykjc.ui.pages;

import com.fw.j2me.CntMidlet;
import com.fw.j2me.ui.IPage;
import com.fw.j2me.ui.IWaiting;
import com.fw.j2me.ui.lwuit.FwCanvas;
import com.fw.j2me.uiimpl.UiContext;
import com.fw.j2me.util.CntEvent;
import com.fw.j2me.util.CntThread;
import com.fw.j2me.util.MiscUtil;
import com.fw.j2me.util.StreamPlayer;
import com.fw.j2me.util.StreamPlayerObserver;
import com.fw.j2me.util.log.CntLog;
import com.sonyericsson.ykjc.model.VideoInfo;
import com.sonyericsson.ykjc.ui.YkUiContext;
import com.sonyericsson.ykjc.ui.component.YNotice;
import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class PagePlayer2
extends Canvas
implements StreamPlayerObserver,
IPage {
    private static final int MENU_BAR_H = 19;
    private static final int BUTTON_MARGIN = 18;
    private static final int PROGRESS_BAR_W = 7;
    private static final int PLAYER_WIDTH_FACTOR = 4;
    private static final int PLAYER_HEIGHT_FACTOR = 3;
    private static final int BUFFER_ANIM_FRAME = 9;
    private static CntLog log = new CntLog("PagePlayer2");
    private static Font font = Font.getFont((int)0, (int)0, (int)8);
    private static int fontHeight = font.getHeight();
    private static final int FIX_BORDER_W = fontHeight + 8 + 7;
    private static final long BUFFERING_DURATION = 10000L;
    private static final long BUFFERING_REFRESH = 100L;
    private int canvasW;
    private int canvasH;
    private int videoW;
    private int videoH;
    private int verticalB;
    private int horizenB;
    private int frameX;
    private int frameY;
    private int frameW;
    private int frameH;
    private AsistantThread asistantThread;
    private Image[] animImage;
    private long startBuffering;
    private double bufProgressValue;
    private Image imageBack;
    private Image imagePause;
    private Image imageStop;
    private Image imagePlay;
    private Image progressBgImg;
    private Image progressBarImg;
    private Image progressFocusImg;
    private Image bg;
    private Image slot;
    private Image progress;
    private Image progressHead;
    private Object finishObj = new Object();
    private boolean finished;
    private boolean paused;
    private StreamPlayer player = StreamPlayer.getInstance();
    private VideoInfo video;
    private boolean playerShown;
    private boolean loadFail;
    private boolean playerOpened;
    private Graphics gfx;

    public PagePlayer2() {
        this.player.reset();
        this.player.setObserver(this);
        try {
            this.imageBack = Image.createImage((String)"/back.png");
            this.imagePause = Image.createImage((String)"/pause.png");
            this.imageStop = Image.createImage((String)"/stop.png");
            this.imagePlay = Image.createImage((String)"/play.png");
            this.bg = Image.createImage((String)"/playbg.png");
            this.slot = Image.createImage((String)"/slot.png");
            this.progress = Image.createImage((String)"/progress.png");
            this.progressHead = Image.createImage((String)"/progressdot.png");
            this.animImage = new Image[9];
            for (int i = 0; i < 9; ++i) {
                this.animImage[i] = Image.createImage((String)("/" + i + ".png"));
            }
            this.progressBgImg = Image.createImage((String)"/uploadProgressBg.png");
            this.progressBarImg = Image.createImage((String)"/uploadProgressBar.png");
            this.progressFocusImg = Image.createImage((String)"/uploadProgressFocus.png");
        }
        catch (IOException e) {
            log.error("PagePlayer-" + e);
        }
        this.setFullScreenMode(true);
        CntMidlet.getInstance().getJDisplay().setCurrent((Displayable)this);
    }

    private void initDimension() {
        this.canvasW = this.getWidth();
        this.canvasH = this.getHeight();
        this.horizenB = 0;
        this.verticalB = 0;
        if (57 > FIX_BORDER_W * 4) {
            this.verticalB = (this.canvasW - FIX_BORDER_W - (this.canvasH - 19) * 3 / 4) / 2;
        } else {
            this.horizenB = (this.canvasH - 19 - (this.canvasW - FIX_BORDER_W) * 4 / 3) / 2;
        }
        this.videoW = this.canvasW - FIX_BORDER_W - this.verticalB * 2;
        this.videoH = this.canvasH - 19 - this.horizenB * 2;
    }

    public void paint(Graphics g) {
        try {
            this.gfx = g;
            this.paintBg();
            if (this.loadFail) {
                this.paintLoadFail();
            } else if (!this.player.hasStarted()) {
                this.paintBufferProgressBar();
            } else {
                this.paintProgressBar();
                this.paintControlButtons();
            }
        }
        catch (RuntimeException e) {
            log.error("paint-" + e);
            e.printStackTrace();
        }
    }

    private void paintLoadFail() {
        Font f = Font.getFont((int)0, (int)0, (int)8);
        String failString = YkUiContext.strMgr.getString("playfail");
        int totalH = f.getHeight();
        int totalW = f.stringWidth(failString);
        Image img = Image.createImage((int)totalW, (int)totalH);
        Graphics tempG = img.getGraphics();
        tempG.setColor(-1);
        tempG.setFont(f);
        tempG.drawRegion(this.bg, (this.canvasW - totalH) / 2, (this.canvasH - totalW) / 2, totalH, totalW, 5, 0, 0, 0);
        tempG.drawString(failString, 0, 0, 0);
        this.gfx.drawRegion(img, 0, 0, totalW, totalH, 5, (this.canvasW - totalH) / 2, (this.canvasH - totalW) / 2, 0);
        int buttonSize = this.imageBack.getWidth();
        int buttonY = this.canvasH - 19;
        this.gfx.drawImage(this.imageBack, this.canvasW - buttonSize - 18, buttonY, 0);
    }

    private void paintBufferProgressBar() {
        Font f = Font.getFont((int)0, (int)0, (int)8);
        String waitingString = YkUiContext.strMgr.getString("playBuffering");
        waitingString = MiscUtil.replaceString(waitingString, "%1", "" + (int)this.bufProgressValue);
        int totalH = f.getHeight() * 2 + this.progressBgImg.getHeight();
        int totalW = f.stringWidth(waitingString);
        if (totalW < this.progressBgImg.getWidth()) {
            totalW = this.progressBgImg.getWidth();
        }
        Image img = Image.createImage((int)totalW, (int)totalH);
        Graphics tempG = img.getGraphics();
        tempG.setColor(-1);
        tempG.setFont(f);
        tempG.drawRegion(this.bg, (this.canvasW - totalH) / 2, (this.canvasH - totalW) / 2, totalH, totalW, 5, 0, 0, 0);
        tempG.drawString(waitingString, (totalW - f.stringWidth(waitingString)) / 2, 0, 0);
        int tmpX = totalW - this.progressBgImg.getWidth() >> 1;
        int tmpY = f.getHeight() << 1;
        int allWidth = this.progressBarImg.getWidth();
        tempG.drawImage(this.progressBgImg, tmpX, tmpY, 0);
        tempG.setClip(tmpX += this.progressBgImg.getWidth() - this.progressBarImg.getWidth() >> 1, 0, (int)((double)allWidth * this.bufProgressValue / 100.0), totalH);
        tempG.drawImage(this.progressBarImg, tmpX, tmpY + (this.progressBgImg.getHeight() - this.progressBarImg.getHeight() >> 1), 0);
        tempG.setClip(0, 0, totalW, totalH);
        tempG.drawImage(this.progressFocusImg, tmpX + (int)((double)allWidth * this.bufProgressValue / 100.0) - (this.progressFocusImg.getWidth() >> 1), tmpY + (this.progressBgImg.getHeight() - this.progressFocusImg.getHeight() >> 1), 0);
        this.gfx.drawRegion(img, 0, 0, totalW, totalH, 5, (this.canvasW - totalH) / 2, (this.canvasH - totalW) / 2, 0);
        int buttonSize = this.imageBack.getWidth();
        int buttonY = this.canvasH - 19;
        this.gfx.drawImage(this.imageBack, this.canvasW - buttonSize - 18, buttonY, 0);
    }

    private void paintControlButtons() {
        this.gfx.drawRegion(this.bg, 0, this.frameY + this.frameH, this.bg.getWidth(), this.bg.getHeight() - this.frameY - this.frameH, 0, 0, this.frameY + this.frameH, 0);
        int buttonSize = this.imageBack.getWidth();
        int buttonY = this.canvasH - 19;
        this.gfx.drawImage(this.imageBack, this.canvasW - buttonSize - 18, buttonY, 0);
        this.gfx.drawImage(this.imageStop, 18, buttonY, 0);
        this.gfx.drawImage(this.paused ? this.imagePlay : this.imagePause, this.canvasW / 2, buttonY, 17);
    }

    private void paintBar(Image barImg, int x, int y, int length) {
        int roundRadius = 3;
        if (length == 0) {
            return;
        }
        int half = length / 2;
        if (half == 0) {
            this.gfx.drawRegion(barImg, 0, 0, 7, 1, 0, x, y, 0);
        } else if (half <= 3) {
            this.gfx.drawRegion(barImg, 0, 0, 7, half, 0, x, y, 0);
            this.gfx.drawRegion(barImg, 0, barImg.getHeight() - (length - half), 7, length - half, 0, x, y + half, 0);
        } else {
            this.gfx.drawRegion(barImg, 0, 0, 7, 3, 0, x, y, 0);
            this.gfx.drawRegion(barImg, 0, barImg.getHeight() - 3, 7, 3, 0, x, y + length - 3, 0);
            this.gfx.drawRegion(barImg, 0, 3, 7, length - 6, 0, x, y + 3, 0);
        }
    }

    private void paintProgressBar() {
        this.gfx.drawRegion(this.bg, 0, 0, FIX_BORDER_W + this.verticalB, this.canvasH - 19 - this.horizenB, 0, 0, 0, 0);
        int x = this.frameX - 7 - 6;
        long lastTime = this.player.getLasttime();
        long duration = this.player.getDuration();
        if (duration <= 0L) {
            duration = MiscUtil.string2Duration(this.video.getDuration());
        }
        int p = this.time2pix(lastTime, duration);
        this.paintBar(this.slot, x, this.frameY, this.frameH);
        this.paintBar(this.progress, x, this.frameY, p);
        this.paintProgressHead(x + (this.slot.getWidth() - this.progressHead.getWidth()) / 2, this.frameY + p - this.progressHead.getHeight() / 2);
        String timeInfo = MiscUtil.duratioin2String(lastTime) + "/" + MiscUtil.duratioin2String(duration);
        Image img = Image.createImage((int)font.stringWidth(timeInfo), (int)fontHeight);
        Graphics buffG = img.getGraphics();
        buffG.drawRegion(this.bg, x - 1 - fontHeight, this.frameY + this.frameH - img.getWidth(), img.getHeight(), img.getWidth(), 5, 0, 0, 0);
        buffG.setFont(font);
        buffG.setColor(-1);
        buffG.drawString(timeInfo, 0, 0, 0);
        this.gfx.drawRegion(img, 0, 0, img.getWidth(), img.getHeight(), 5, x - 1 - fontHeight, this.frameY + this.frameH - img.getWidth(), 0);
    }

    private void paintProgressHead(int x, int y) {
        this.gfx.drawImage(this.progressHead, x, y, 0);
    }

    private void paintBg() {
        this.gfx.drawImage(this.bg, 0, 0, 0);
    }

    private int time2pix(long time, long duration) {
        if (duration > 0L) {
            return (int)(time * (long)this.frameH / duration);
        }
        return 0;
    }

    public void openPlayer(VideoInfo info) {
        YkUiContext.proxy.setCurrentVideo(info);
        YkUiContext.proxy.freeze4PlayVideo();
        String url = info.getVideoUrl();
        this.video = info;
        this.playerShown = false;
        this.playerOpened = false;
        this.loadFail = false;
        this.player.open(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish(boolean prev, boolean fail) {
        Object object = this.finishObj;
        synchronized (object) {
            if (!this.finished) {
                this.finished = true;
                YkUiContext.proxy.meltAfterPlayVideo();
                if (prev) {
                    CntMidlet.getInstance().getJDisplay().setCurrent((Displayable)FwCanvas.getInstance());
                    FwCanvas.getInstance().flushGraphics();
                    UiContext.pageMgr.changePage(0x10000000);
                } else if (fail) {
                    if (this.playerShown) {
                        UiContext.pageMgr.changePage(134217754);
                        CntMidlet.getInstance().getJDisplay().setCurrent((Displayable)FwCanvas.getInstance());
                        FwCanvas.getInstance().flushGraphics();
                        YNotice.showNotice(9);
                        IWaiting waiting = (IWaiting)((Object)UiContext.pageMgr.changePage(134217749));
                        waiting.setExceptEvent(9);
                        YkUiContext.proxy.doGetRelateVideoList();
                    } else {
                        this.loadFail = true;
                    }
                } else {
                    IWaiting waiting = (IWaiting)((Object)UiContext.pageMgr.changePage(134217749));
                    CntMidlet.getInstance().getJDisplay().setCurrent((Displayable)FwCanvas.getInstance());
                    FwCanvas.getInstance().flushGraphics();
                    waiting.setExceptEvent(9);
                    YkUiContext.proxy.doGetRelateVideoList();
                }
                this.player.closePlayer();
            }
        }
    }

    public void show() {
    }

    public boolean testPageFlag(int flag) {
        return (0x8000009 & flag) != 0;
    }

    public int getPageID() {
        return 0x8000009;
    }

    public boolean handleEvent(CntEvent event) {
        return false;
    }

    public void init() {
        this.initDimension();
        this.finished = false;
        this.asistantThread = new AsistantThread();
        this.asistantThread.start();
        this.startBuffering = System.currentTimeMillis();
        this.repaint();
    }

    public void refresh() {
        log.error("Not implements");
    }

    public String getPageName() {
        return "PagePlayer2";
    }

    public void cleanup() {
        if (this.asistantThread != null) {
            this.asistantThread.close();
        }
    }

    protected void keyPressed(int keyCode) {
        switch (keyCode) {
            case -5: {
                if (this.paused) {
                    this.player.resumePlayer();
                } else {
                    this.player.pausePlayer();
                }
                this.paused = !this.paused;
                this.repaint();
                break;
            }
            case -6: {
                if (this.player.getLasttime() <= 0L) break;
                this.finish(false, false);
                break;
            }
            case -7: {
                if (this.loadFail) {
                    CntMidlet.getInstance().getJDisplay().setCurrent((Displayable)FwCanvas.getInstance());
                    FwCanvas.getInstance().flushGraphics();
                    UiContext.pageMgr.changePage(0x10000000);
                    break;
                }
                this.finish(true, false);
                break;
            }
        }
    }

    protected void hideNotify() {
        log.debug("hideNotify");
        if (!this.finished) {
            this.player.hideNotify();
        }
        super.hideNotify();
    }

    protected void showNotify() {
        log.debug("showNotify");
        if (this.playerOpened) {
            this.player.showNotify();
            this.repaint();
        }
        super.showNotify();
    }

    public void playerBufferFinish() {
    }

    public void playerBufferStart() {
    }

    public void playerFailed(int reason) {
        this.finish(false, true);
    }

    public void playerFinish() {
        this.finish(false, false);
    }

    public void playerPaused() {
    }

    public void playerStarted() {
        this.player.show(this.frameX, this.frameY, this.frameW, this.frameH, this);
        this.playerShown = true;
    }

    public void playerTimeUpdate() {
        this.repaint(0, 0, this.frameX, this.canvasH);
    }

    public void playerOpened() {
        this.frameW = this.player.getFrameHeight();
        this.frameH = this.player.getFrameWidth();
        if (this.frameW * 4 > this.frameH * 3) {
            this.frameH = this.frameH * this.videoW / this.frameW;
            this.frameW = this.videoW;
        } else {
            this.frameW = this.frameW * this.videoH / this.frameH;
            this.frameH = this.videoH;
        }
        this.frameX = FIX_BORDER_W + this.verticalB + (this.videoW - this.frameW) / 2;
        this.frameY = this.horizenB + (this.videoH - this.frameH) / 2;
        log.debug(" frameX = " + this.frameX + " frameY = " + this.frameY + " frameW = " + this.frameW + " frameH = " + this.frameH);
        this.player.startPlayer();
        this.playerOpened = true;
    }

    public class AsistantThread
    extends CntThread {
        public AsistantThread() {
            super("AsistantThread of PagePlayer");
        }

        protected void closeMe() {
        }

        protected void runMe() {
            while (!this.stop) {
                PagePlayer2.this.repaint();
                try {
                    Thread.sleep(100L);
                    long past = System.currentTimeMillis() - PagePlayer2.this.startBuffering;
                    if (past < 8000L) {
                        PagePlayer2.this.bufProgressValue = past * 100L / 10000L;
                    } else {
                        PagePlayer2.this.bufProgressValue += (100.0 - PagePlayer2.this.bufProgressValue) / 100.0;
                    }
                    if (!(PagePlayer2.this.bufProgressValue >= 96.0)) continue;
                    PagePlayer2.this.bufProgressValue = 96.0;
                }
                catch (InterruptedException e) {
                    log.error("paint buff Animation" + e);
                }
            }
        }
    }
}

