/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.ykjc.ui.pages;

import com.fw.j2me.ui.IWaiting;
import com.fw.j2me.uiimpl.UiContext;
import com.sonyericsson.ykjc.ui.YkUiContext;
import com.sonyericsson.ykjc.ui.component.BoldLabel;
import com.sonyericsson.ykjc.ui.component.EditBox;
import com.sonyericsson.ykjc.ui.component.Seperator;
import com.sonyericsson.ykjc.ui.component.YNotice;
import com.sonyericsson.ykjc.ui.pages.YkPageBase;
import com.sun.lwuit.Command;
import com.sun.lwuit.Font;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.layouts.BoxLayout;

public class PageRegister
extends YkPageBase {
    private static final int COMMAND_REGISTER = 1;
    private EditBox email;
    private EditBox password;
    private EditBox passwordConfirm;

    public PageRegister(int pageID) {
        super(pageID);
    }

    public void buildPageCommand() {
        Command register = new Command(YkUiContext.strMgr.getString("register"), 1);
        this.form.addCommand(this.cmdBack);
        this.form.addCommand(register);
    }

    public void doActionPerformed(ActionEvent evt) {
        Command cmd = evt.getCommand();
        switch (cmd.getId()) {
            case 1: {
                this.doRegister(this.email.getEditorText(), this.password.getEditorText(), this.passwordConfirm.getEditorText());
                break;
            }
            case 0: {
                this.changePage(0x800000B);
                break;
            }
            case 300: {
                if (this.email.editor == this.form.getFocused()) {
                    this.email.editor.handleEditCmd();
                    break;
                }
                if (this.password.editor == this.form.getFocused()) {
                    this.password.editor.handleEditCmd();
                    break;
                }
                if (this.passwordConfirm.editor != this.form.getFocused()) break;
                this.passwordConfirm.editor.handleEditCmd();
                break;
            }
        }
    }

    protected void buildPageContent() {
        try {
            this.form.setLayout(new BoxLayout(2));
            Font labelFont = Font.createSystemFont(32, 0, 8);
            int labelColor = 0;
            BoldLabel title = new BoldLabel(YkUiContext.strMgr.getString("register"));
            this.form.addComponent(title);
            this.form.addComponent(new Seperator());
            this.email = new EditBox(YkUiContext.strMgr.getString("email"), 1);
            this.email.setLabelFont(labelFont, labelColor);
            this.form.addComponent(this.email);
            int passwordLimit = 16;
            this.password = new EditBox(YkUiContext.strMgr.getString("password"), 65537);
            this.password.setLabelFont(labelFont, labelColor);
            this.password.setMaxLength(passwordLimit);
            this.form.addComponent(this.password);
            this.passwordConfirm = new EditBox(YkUiContext.strMgr.getString("passwordConfirm"), 65537);
            this.passwordConfirm.setLabelFont(labelFont, labelColor);
            this.passwordConfirm.setMaxLength(passwordLimit);
            this.form.addComponent(this.passwordConfirm);
            this.email.getReal().setNextFocusLeft(this.email.getReal());
            this.email.getReal().setNextFocusRight(this.email.getReal());
            this.email.getReal().setNextFocusUp(this.email.getReal());
            this.password.getReal().setNextFocusLeft(this.password.getReal());
            this.password.getReal().setNextFocusRight(this.password.getReal());
            this.passwordConfirm.getReal().setNextFocusLeft(this.passwordConfirm.getReal());
            this.passwordConfirm.getReal().setNextFocusRight(this.passwordConfirm.getReal());
            this.passwordConfirm.getReal().setNextFocusDown(this.passwordConfirm.getReal());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void doRegister(String id, String pwd, String pwdConfirm) {
        if (this.checkInput(id, pwd, pwdConfirm)) {
            IWaiting waiting = (IWaiting)((Object)UiContext.pageMgr.changePage(0x8000003));
            waiting.setExceptEvent(12);
            YkUiContext.proxy.doRegister(id, pwd);
        }
    }

    private boolean checkInput(String id, String pwd, String pwdConfirm) {
        if (id == null || pwd == null || pwdConfirm == null) {
            YNotice.showNotice(3);
            return false;
        }
        if (id.length() < 3 || pwd.length() == 0 || pwdConfirm.length() == 0) {
            YNotice.showNotice(3);
            return false;
        }
        int atCnt = 0;
        for (int i = 0; i < id.length(); ++i) {
            if (id.charAt(i) != '@') continue;
            ++atCnt;
        }
        if (atCnt != 1) {
            YNotice.showNotice(3);
            return false;
        }
        if (!pwd.equals(pwdConfirm)) {
            YNotice.showNotice(3);
            return false;
        }
        return true;
    }
}

