/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.ykjc.util;

import com.fw.j2me.CntMidlet;
import com.fw.j2me.util.Device;
import com.fw.j2me.util.log.CntLog;
import com.sonyericsson.ykjc.util.SEDevice;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;

public class UpgradeService {
    private static final int BUFFER_SIZE = 4096;
    private static final String DEFAULT_BASE_URL = "http://wap-test-am.sonyericsson.com/youku";
    private static String baseURL;
    private String mainUpgradeURL;
    private String mainResourceLocation;
    private static UpgradeService instance;
    private static CntLog log;

    private UpgradeService() {
        log.debug("Constrcutor");
        baseURL = this.getBaseURL();
        this.mainUpgradeURL = baseURL + "?model=" + SEDevice.getModel() + "&ver=" + SEDevice.APPLICATION_REVISION + "&type=java";
    }

    public static UpgradeService getInstance() {
        log.debug("getInstance");
        if (instance == null) {
            instance = new UpgradeService();
        }
        log.debug("getInstance Over");
        return instance;
    }

    public boolean upgradeAvailable() {
        log.debug("upgradeAvailable START ");
        this.mainResourceLocation = this.upgradeAvailable(this.mainUpgradeURL);
        log.debug("upgradeAvailable END " + this.mainResourceLocation);
        return this.mainResourceLocation.length() > 0;
    }

    public void doUpgrade() throws Exception {
        if (this.mainResourceLocation.length() == 0) {
            throw new Exception("There is no valid upgrade URL");
        }
        if (this.mainResourceLocation.length() > 0) {
            log.debug("Installing main application");
            this.install(this.mainResourceLocation);
        }
    }

    private String getBaseURL() {
        String url = Device.getProperty("Upgrade-Base-URL");
        if (url == null) {
            log.debug("No upgrade base url found, using default http://wap-test-am.sonyericsson.com/youku");
            url = DEFAULT_BASE_URL;
        }
        if (url.endsWith("?")) {
            url = url.substring(0, url.length() - 2);
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String upgradeAvailable(String url) {
        String upgradeURL;
        block56: {
            log.debug("Upgrade URL:" + url);
            upgradeURL = "";
            HttpConnection connection = null;
            try {
                int bytesRead;
                log.debug("Connection to upgrade server: " + url);
                connection = (HttpConnection)Connector.open((String)url);
                connection.setRequestMethod("GET");
                connection.setRequestProperty("Accept", "*/*");
                int responseCode = connection.getResponseCode();
                log.debug("Response code: " + responseCode + " " + connection.getResponseMessage());
                int i = 0;
                while (true) {
                    String key = connection.getHeaderFieldKey(i);
                    String value = connection.getHeaderField(i);
                    if (key == null || value == null) break;
                    log.debug(key + ": " + value);
                    ++i;
                }
                InputStream in = connection.openInputStream();
                byte[] buffer = new byte[4096];
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                while ((bytesRead = in.read(buffer)) != -1) {
                    bytes.write(buffer, 0, bytesRead);
                }
                bytes.flush();
                log.debug(bytes.toString());
                bytes.close();
                if (responseCode == 200) {
                    log.debug("Got a HTTP_OK from the server which is odd! Non specified behaviour.");
                    break block56;
                }
                if (responseCode == 301) {
                    String redirected = connection.getHeaderField("Location");
                    log.debug("Upgrade URL has been redirected to: " + redirected);
                    try {
                        connection.close();
                        connection = null;
                    }
                    catch (IOException e) {
                        log.debug("Could not HTTP connection to server when redirecting.");
                    }
                    String string = this.upgradeAvailable(redirected);
                    return string;
                }
                if (responseCode == 302) {
                    String redirected;
                    upgradeURL = redirected = connection.getHeaderField("Location");
                    log.debug("There is an upgrade available at: " + upgradeURL);
                    String string = upgradeURL;
                    return string;
                }
                if (responseCode == 550) {
                    log.debug("Response Code: 550; Description: Unsupported device; Description: Device/model can\u93b6\ufffdbe identified, service is rejected.");
                } else if (responseCode == 551) {
                    log.debug("Response Code: 551; Description: Unsupported device; Description: Requested service can\u93b6\ufffdbe identified. Service is rejected.");
                } else if (responseCode == 552) {
                    log.debug("Response Code: 552; Description: Discontinued service; Description: This service has been discontinued. Service is rejected.");
                } else if (responseCode == 560) {
                    log.debug("Response Code: 560; Description: This service is not available for your device.; Description: Service and device is identified but service is rejected for this device.");
                } else if (responseCode == 561) {
                    log.debug("Response Code: 561; Description: This service is not available in your network.; Description: Service and device is identified but service is rejected in this network.");
                } else if (responseCode == 562) {
                    log.debug("Response Code: 562; Description: This service is not available outside your home network.; Description: Service and device is identified but service is rejected when roaming.");
                } else if (responseCode == 570) {
                    log.debug("Response Code: 570; Description: <Service message>; Description: Service is rejected and specific service message should be presented.");
                } else {
                    log.debug("Unsupported response code according to the upgrade protocol.");
                }
            }
            catch (IllegalArgumentException e) {
                log.debug("Could not connect to the upgrade server.");
            }
            catch (ConnectionNotFoundException e) {
                log.debug("Could not connect to the upgrade server.");
            }
            catch (IOException e) {
                log.debug("Could not connect to the upgrade server.");
            }
            catch (SecurityException e) {
                log.debug("Could not connect to the upgrade server.");
            }
            catch (Exception e) {
                log.debug("Could not connect to the upgrade server.");
            }
            finally {
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (IOException e) {
                    log.debug("Could not close HTTP connection.");
                }
            }
        }
        if (!upgradeURL.startsWith("http") || !upgradeURL.endsWith(".jad") || upgradeURL.endsWith(".jar")) {
            upgradeURL = "";
        }
        return upgradeURL;
    }

    private void install(String url) throws IOException {
        String jar = "";
        String jad = "";
        log.debug("Installing application jad(" + jad + ") and jar(" + jar + ").");
        log.debug("Start platformRequest(" + url + ")");
        CntMidlet.getInstance().destroyApp(false);
        CntMidlet.getInstance().platformRequest(url);
    }

    static {
        instance = null;
        log = new CntLog("UpgradeService");
    }
}

