/*
 * Decompiled with CFR 0.152.
 */
package se.vitamin.ui;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import se.vitamin.ui.UI;
import se.vitamin.ui.Window;

public abstract class Widget {
    public int _x;
    public int _y;
    protected int _w;
    protected int _h;
    protected int _minH = 0;
    protected int _maxH = 64436;
    protected int _minW = 0;
    protected int _activeColor = 0xFFFFFF;
    protected int _inactiveColor = 0;
    protected int _backgroundColor = 0;
    protected int _inactiveBackgroundColor = 0xFFFFFF;
    protected int _borderColor = 0;
    protected int _align = 1;
    protected Window _parent;
    protected int _screenX;
    protected int _screenY;
    protected int _id;
    protected boolean _visible = true;
    protected boolean _selectable = false;
    protected boolean _enabled = true;
    protected boolean _active = false;

    public Widget(Window parent, int ID) {
        this._parent = parent;
        this._id = ID;
        if (this._parent != null) {
            this._parent.add(this);
        }
    }

    public boolean isActive() {
        return this._active;
    }

    public void enable() {
        this._enabled = true;
    }

    public void disable() {
        this._enabled = false;
    }

    public void show() {
        this._visible = true;
    }

    public boolean isVisible() {
        return this._visible;
    }

    public void hide() {
        this._visible = false;
    }

    public abstract void setDimensions(int var1, int var2, int var3, int var4);

    public abstract void paint(Graphics var1, int var2, int var3);

    public abstract boolean handleKeyDown(int var1);

    public abstract boolean handleKeyUp(int var1);

    public abstract boolean handleLongPress(int var1);

    public abstract void activate();

    public abstract void deactivate();

    public abstract void select();

    public abstract void update();

    public abstract void setFont(Font var1);

    public void setMinimumHeight(int h) {
        this._minH = h;
    }

    public void setMaximumHeight(int h) {
        this._maxH = h;
    }

    public int getMinimumHeight() {
        return this._minH;
    }

    public void adjustWidth() {
    }

    public void setPosition(int x, int y) {
        this._x = x;
        this._y = y;
    }

    public int getHeight() {
        return this._h;
    }

    public void setDimensions(int w, int h) {
        if (w > 0) {
            this._w = w;
        }
        if (h > this._minH && h < this._maxH) {
            this._h = h;
        }
    }

    public void setAlignment(int align) {
        this._align = align;
    }

    public boolean isSelectable() {
        return this._selectable && this._enabled;
    }

    public void calcScreenCoords(int x, int y) {
        switch (this._align) {
            case 0: {
                if (this._parent != null) {
                    this._screenX = x + (this._parent._w - this._w) / 2;
                    break;
                }
                this._screenX = x + (UI.SCREEN_WIDTH - this._w) / 2;
                break;
            }
            case 1: {
                this._screenX = x + this._x;
                break;
            }
            case 2: {
                this._screenX = this._parent != null ? x + this._parent._w - this._w - this._x : x + UI.SCREEN_WIDTH - this._w - this._x;
            }
        }
        this._screenY = this._y + y;
    }

    public int getScreenX() {
        return this._screenX;
    }

    public int getScreenY() {
        return this._screenY;
    }

    public boolean isContainer() {
        return false;
    }

    public void selectLast() {
    }

    public void selectFirst() {
    }
}

