/*
 * Decompiled with CFR 0.152.
 */
package se.vitamin.ui;

import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import se.vitamin.ui.Canvas;
import se.vitamin.ui.UI;
import se.vitamin.ui.Widget;
import se.vitamin.ui.Window;

public abstract class TextBox
extends Widget
implements CommandListener {
    protected String s = "";
    protected Font _font;
    protected int startLine = 0;
    protected int endLine = 0;
    private Command textOkCommand = new Command("Ok", 8, 1);
    private Command textBackCommand = new Command("Back", 8, 1);
    javax.microedition.lcdui.TextBox tb = new javax.microedition.lcdui.TextBox("Text", "", 140, 0);
    protected int maxLineCount = 0;
    protected int tokenIndex = 0;
    protected String[] output;
    protected String lastToken = "";
    protected int _lastkey = 0;
    protected int caretCounter;
    protected int dropTime;
    protected int capitalTime;
    protected int caretRow;
    protected int caretScreenX;
    protected static final int DROP_PERIOD = 750;
    protected static final int CARET_PERIOD = 500;
    protected static final int DROPDOWN_OFFSET = 20;
    protected static final int SELECTION_COLOR = 0xAAAAAA;
    protected static final int BACKGROUND_COLOR = 0xFFFFFF;
    protected static final int TEXT_COLOR = 0;
    protected static final int DROPDOWN_SPACING = 2;
    protected int keywordIndex = 0;
    protected boolean _fixedHeight = true;
    protected boolean _systemBox = false;
    protected int capitalMode = 0;
    int caretPos = -1;
    int insertPos = -1;
    private static Vector[] keywords = null;
    protected boolean forceDefault = false;
    private boolean capitalize = true;
    protected boolean _password = false;
    protected int _maxSize = 255;
    protected int _textHeight = 0;
    int lastLength;

    public TextBox(Window parent, int id, int left, int top, Font f, boolean forceDefault) {
        super(parent, id);
        this.forceDefault = forceDefault;
        this._x = left;
        this._y = top;
        this._font = f;
        this._selectable = true;
        this.init();
        this._w = parent != null ? parent._w - 2 * this._x : UI.SCREEN_WIDTH - 2 * this._x;
        this._h = this._font.getHeight();
        this.output = new String[1];
        this._textHeight = this.output.length * this._font.getHeight();
        this.output[0] = "";
    }

    private synchronized boolean init() {
        if (keywords == null) {
            keywords = new Vector[10];
            for (int i = 0; i < 10; ++i) {
                TextBox.keywords[i] = new Vector();
            }
        }
        return true;
    }

    public void addKeyWord(int key, String keyword) {
        if (key >= 48 && key <= 57) {
            keywords[key - 48].addElement(keyword);
        }
    }

    public int getRequiredHeight() {
        return this.output.length * this._font.getHeight();
    }

    public void setString(String str) {
        if (str.length() > this._maxSize) {
            System.out.println("Text to big");
            this.s = str.substring(0, this._maxSize);
        } else {
            this.s = str;
        }
        this.insertPos = -1;
        this.output = this.toStringArray(this.s, this._w, this._font);
        this._textHeight = this.output.length * this._font.getHeight();
        this.endLine = this.output.length;
        this.checkCaret();
    }

    public String getString() {
        this.addString();
        return this.s;
    }

    public void setFont(Font f) {
        this._font = f;
        this._h = f.getHeight();
    }

    public boolean isCapitalized() {
        return this.capitalize;
    }

    public boolean isPassword() {
        return this._password;
    }

    public void setCaptalization(boolean enabled) {
        this.capitalize = enabled;
        if (!this.capitalize && this.capitalMode == 0) {
            this.capitalMode = 2;
            this.capitalTime = 750;
        }
        this.checkCaret();
    }

    protected void drawBackground(Graphics g, int x, int y) {
        g.setColor(0xFFFFFF);
        g.fillRect(x, y, this._w, this._h);
        g.setColor(0);
    }

    protected void drawDropDownBackground(Graphics g, int x, int y, int w, int h) {
        g.setColor(0xFFFFFF);
        g.fillRect(x - 4, y - 2, w + 8, h + 4);
        g.setColor(0);
        g.drawRect(x - 4, y - 2, w + 8, h + 4);
    }

    public void drawDropDown(Graphics g, int x, int y) {
        int i;
        if (this._lastkey < 48 || this._lastkey > 57) {
            return;
        }
        int LETTER_SPACING = 2;
        int rows = 1;
        int drop_y = y;
        String s = UI.getkeyMap(this.capitalMode != 2, this.forceDefault)[this._lastkey - 48];
        int drop_w = this._font.stringWidth(s) + LETTER_SPACING * s.length();
        int drop_h = (rows += keywords[this._lastkey - 48].size()) * this._font.getHeight();
        int drop_x = x;
        for (int i2 = 0; i2 < keywords[this._lastkey - 48].size(); ++i2) {
            if (this._font.stringWidth((String)keywords[this._lastkey - 48].elementAt(i2)) <= drop_w) continue;
            drop_w = this._font.stringWidth((String)keywords[this._lastkey - 48].elementAt(i2));
        }
        g.setFont(this._font);
        this.drawDropDownBackground(g, drop_x - 2, drop_y - 2, drop_w, drop_h + 4);
        int left = drop_x;
        int width = 0;
        for (i = 0; i < s.length(); ++i) {
            width = this._font.charWidth(s.charAt(i));
            if (i == this.tokenIndex && this.keywordIndex == 0) {
                g.setColor(0xAAAAAA);
                g.fillRect(left - LETTER_SPACING / 2, drop_y, width + LETTER_SPACING, this._font.getHeight());
                g.setColor(0);
            }
            g.drawChar(s.charAt(i), left, drop_y, 0);
            left += width + LETTER_SPACING;
        }
        drop_y += this._font.getHeight();
        for (i = 0; i < keywords[this._lastkey - 48].size(); ++i) {
            if (i == this.keywordIndex - 1) {
                g.setColor(0xAAAAAA);
                g.fillRect(drop_x, drop_y, drop_w, this._font.getHeight());
                g.setColor(0);
                g.drawString((String)keywords[this._lastkey - 48].elementAt(i), drop_x, drop_y, 0);
                g.setColor(0);
            } else {
                g.drawString((String)keywords[this._lastkey - 48].elementAt(i), drop_x, drop_y, 0);
            }
            drop_y += this._font.getHeight();
        }
    }

    void paintRTL(Graphics g) {
        int top = this._screenY;
        int caretX = 0;
        int caretY = 0;
        g.setColor(0);
        if (this.caretPos == -1) {
            for (int i = this.startLine; i < this.endLine; ++i) {
                g.drawString(this.output[i], this._screenX + this._w, top, 24);
                top += this._font.getHeight();
            }
            caretX = this._font.stringWidth(this.output[this.output.length - 1]);
            this.caretScreenX = this.output[this.output.length - 1].length();
            caretY = top;
            this.caretRow = this.output.length - 1;
        } else if (this.caretPos == 0) {
            for (int i = this.startLine; i < this.endLine; ++i) {
                g.drawString(this.output[i], this._screenX + this._w, top, 24);
                top += this._font.getHeight();
            }
            caretX = this._font.stringWidth(this.lastToken);
            caretY = this._screenY + this._font.getHeight();
            this.caretRow = 0;
        } else {
            int start = 0;
            for (int i = 0; i < this.startLine; ++i) {
                start += this.output[i].length();
            }
            int cp = 0;
            for (int i = this.startLine; i < this.endLine; ++i) {
                if (start < this.caretPos && start + this.output[i].length() >= this.caretPos) {
                    cp = this.caretPos - start;
                    g.drawString(this.output[i], this._screenX + this._w, top, 24);
                    caretY = top + this._font.getHeight();
                    caretX = this._font.stringWidth(this.output[i].substring(0, cp) + this.lastToken);
                    this.caretScreenX = this.output[i].substring(0, cp).length();
                    this.caretRow = i;
                } else {
                    g.drawString(this.output[i], this._screenX + this._w, top, 24);
                }
                start += this.output[i].length();
                top += this._font.getHeight();
            }
        }
        if (this.dropTime > 0) {
            this.drawDropDown(g, 0, this._screenY);
        }
        if (this.caretCounter > 0) {
            g.drawLine(this._screenX + this._w - caretX, caretY, this._screenX + this._w - caretX, caretY - this._font.getHeight());
            g.drawLine(this._screenX + this._w - caretX - 1, caretY, this._screenX + this._w - caretX, caretY - this._font.getHeight());
        }
    }

    public void paintCapitalIndicator(Graphics g, int x, int y) {
        g.setColor(0xFFFFFF);
        g.fillRect(x - 12, y - 25, 24, this._font.getHeight());
        g.setColor(0);
        g.drawRect(x - 12, y - 25, 24, this._font.getHeight());
        if (this.capitalMode == 0) {
            g.drawString("Aa", x, y - 25, 17);
        } else if (this.capitalMode == 1) {
            g.drawString("A", x, y - 25, 17);
        } else {
            g.drawString("a", x, y - 25, 17);
        }
    }

    protected void calculateMaxLines() {
        this.maxLineCount = this._h / this._font.getHeight();
    }

    public void paint(Graphics g, int x, int y) {
        int i;
        int i2;
        this.caretPos = this.insertPos;
        if (!this._fixedHeight) {
            this._h = this.output.length * this._font.getHeight();
        }
        if (this._h < this._minH) {
            this._h = this._minH;
            this.calculateMaxLines();
        }
        int top = this._screenY;
        int caretX = 0;
        int caretY = 0;
        if (this.caretPos < 0) {
            this.caretRow = this.output.length - 1;
        } else if (this.caretPos == 0) {
            this.caretRow = 0;
        } else {
            int temp = this.caretPos;
            i2 = 0;
            this.caretRow = 0;
            while (temp > this.output[i2].length()) {
                ++this.caretRow;
                temp -= this.output[i2].length();
                ++i2;
            }
        }
        if (this._h < this._textHeight) {
            if (this.endLine >= this.output.length) {
                this.endLine = this.output.length;
            }
            if (this.endLine <= this.caretRow) {
                this.endLine = this.caretRow + 1;
                this.startLine = this.endLine - this.maxLineCount;
            } else if (this.startLine > this.caretRow) {
                this.startLine = this.caretRow;
                this.endLine = this.maxLineCount;
            } else {
                this.endLine = this.startLine + this.maxLineCount;
                if (this.endLine > this.output.length) {
                    this.endLine = this.output.length;
                }
            }
        } else {
            this.startLine = 0;
            this.endLine = this.output.length;
        }
        while (this.caretRow >= this.endLine) {
            ++this.startLine;
            ++this.endLine;
        }
        g.setFont(this._font);
        this.drawBackground(g, this._screenX, this._screenY);
        if (this._active && this.capitalTime > 0 && (UI.hasUppercase() || this.forceDefault)) {
            this.paintCapitalIndicator(g, this._screenX + this._w / 2, this._screenY);
        }
        if (UI.rightToLeft && !this.forceDefault) {
            this.paintRTL(g);
            return;
        }
        g.setColor(0);
        if (this.caretPos == -1) {
            for (i = this.startLine; i < this.endLine; ++i) {
                g.drawString(this.output[i], this._screenX, top, 0);
                top += this._font.getHeight();
            }
            caretX = this._font.stringWidth(this.output[this.output.length - 1]);
            this.caretScreenX = this.output[this.output.length - 1].length();
            caretY = top;
            this.caretRow = this.output.length - 1;
        } else if (this.caretPos == 0) {
            for (i = this.startLine; i < this.endLine; ++i) {
                g.drawString(this.output[i], this._screenX, top, 0);
                top += this._font.getHeight();
            }
            caretX = this._font.stringWidth(this.lastToken);
            caretY = this._screenY + this._font.getHeight();
            this.caretRow = 0;
        } else {
            int start = 0;
            for (i2 = 0; i2 < this.startLine; ++i2) {
                start += this.output[i2].length();
            }
            int cp = 0;
            for (int i3 = this.startLine; i3 < this.endLine; ++i3) {
                if (start < this.caretPos && start + this.output[i3].length() >= this.caretPos) {
                    cp = this.caretPos - start;
                    g.drawString(this.output[i3], this._screenX, top, 0);
                    caretY = top + this._font.getHeight();
                    caretX = this._font.stringWidth(this.output[i3].substring(0, cp) + this.lastToken);
                    this.caretScreenX = this.output[i3].substring(0, cp).length();
                    this.caretRow = i3;
                } else {
                    g.drawString(this.output[i3], this._screenX, top, 0);
                }
                start += this.output[i3].length();
                top += this._font.getHeight();
            }
        }
        if (this.dropTime > 0) {
            this.drawDropDown(g, 0, this._screenY);
        }
        if (this.caretCounter > 0) {
            g.drawLine(this._screenX + caretX, caretY, this._screenX + caretX, caretY - this._font.getHeight());
            g.drawLine(this._screenX + caretX + 1, caretY, this._screenX + caretX + 1, caretY - this._font.getHeight());
        }
    }

    void moveCursorLeft() {
        if (this.insertPos == -1) {
            this.insertPos = this.s.lastIndexOf(32);
        } else if (this.insertPos > 0) {
            this.insertPos = this.s.lastIndexOf(32, this.insertPos - 1);
        }
        if (this.insertPos < 0) {
            this.insertPos = 0;
        }
    }

    void moveCursorRight() {
        if (this.insertPos >= 0) {
            this.insertPos = this.s.indexOf(32, this.insertPos + 1);
        }
    }

    void moveCursorUp() {
        if (this.caretRow >= this.output.length) {
            --this.caretRow;
        }
        if (this.caretRow > 0) {
            int xpos = this._font.substringWidth(this.output[this.caretRow], 0, this.caretScreenX);
            --this.caretRow;
            this.insertPos = this.findCharacterPos(xpos, this.caretRow);
            for (int i = 0; i < this.caretRow; ++i) {
                this.insertPos += this.output[i].length();
            }
        }
    }

    void moveCursorDown() {
        if (this.caretRow < this.output.length - 1) {
            if (this.caretRow < 0) {
                this.caretRow = 0;
            }
            int xpos = this._font.substringWidth(this.output[this.caretRow], 0, this.caretScreenX);
            ++this.caretRow;
            this.insertPos = this.findCharacterPos(xpos, this.caretRow);
            for (int i = 0; i < this.caretRow; ++i) {
                this.insertPos += this.output[i].length();
            }
        }
    }

    protected int findCharacterPos(int x, int row) {
        String tmp = this.output[row];
        for (int i = 0; i < tmp.length(); ++i) {
            if (this._font.substringWidth(tmp, 0, i) <= x) continue;
            if (i > 0) {
                int x1 = this._font.substringWidth(tmp, 0, i - 1);
                int x2 = this._font.substringWidth(tmp, 0, i);
                if (Math.abs(x1 - x) < Math.abs(x2 - x)) {
                    return i - 1;
                }
                return i;
            }
            return i;
        }
        return tmp.length();
    }

    protected void addString() {
        if (!this.lastToken.equals("")) {
            if (this.insertPos == -1) {
                this.s = this.s + this.lastToken;
            } else {
                this.s = this.s.substring(0, this.insertPos) + this.lastToken + this.s.substring(this.insertPos);
                this.insertPos += this.lastToken.length();
            }
            this.lastToken = "";
            this.checkCaret();
        }
        this._lastkey = 0;
    }

    protected void deletePrevWord() {
        if (this.insertPos == -1) {
            if (this.s.endsWith(" ")) {
                this.s = this.s.substring(0, this.s.length() - 1);
            } else {
                int index = this.s.lastIndexOf(32) + 1;
                this.s = this.s.substring(0, index);
            }
        } else {
            int index = this.s.lastIndexOf(32, this.insertPos);
            if (index == this.insertPos) {
                index = this.s.lastIndexOf(32, this.insertPos - 1);
            }
            this.s = index < 0 ? this.s.substring(this.insertPos) : this.s.substring(0, index) + this.s.substring(this.insertPos);
            this.insertPos = index > 0 ? index : 0;
        }
        this.output = this.toStringArray(this.s, this._w, this._font);
    }

    protected void checkCaret() {
        if (this.insertPos == 0 && this.capitalize) {
            this.capitalMode = 0;
            this.capitalTime = 750;
        } else if (this.insertPos == -1) {
            if ((this.s.endsWith(". ") || this.s.endsWith("? ") || this.s.endsWith("! ") || this.s.length() == 0) && this.capitalize) {
                this.capitalMode = 0;
                this.capitalTime = 750;
            } else if (this.capitalMode == 0) {
                this.capitalMode = 2;
                this.capitalTime = 750;
            }
        } else {
            String tmp = this.s.substring(0, this.insertPos);
            if ((tmp.endsWith(". ") || tmp.endsWith("? ") || tmp.endsWith("! ")) && this.capitalize) {
                this.capitalMode = 0;
                this.capitalTime = 750;
            } else if (this.capitalMode == 0) {
                this.capitalMode = 2;
                this.capitalTime = 750;
            }
        }
    }

    private int findSplit(String s, int maxLength) {
        int index = 0;
        if (this._font.stringWidth(s) < maxLength) {
            return -1;
        }
        while (this._font.stringWidth(s.substring(0, index++)) < maxLength) {
        }
        return index - 1;
    }

    public String[] toStringArray(String s, int maxLength, Font f) {
        maxLength -= 5;
        int index = 0;
        int newPos = 0;
        boolean done = false;
        String tmp = s;
        Vector<String> strings = new Vector<String>();
        if (s.length() == 0) {
            strings.addElement(s);
        } else {
            while (!done) {
                newPos = tmp.indexOf(32, index);
                if (newPos > 0) {
                    if (f.stringWidth(tmp.substring(0, newPos)) > maxLength) {
                        if (index == 0) {
                            index = this.findSplit(tmp, maxLength);
                        }
                        strings.addElement(tmp.substring(0, index));
                        tmp = tmp.substring(index);
                        index = 0;
                        continue;
                    }
                    index = newPos + 1;
                    continue;
                }
                if (f.stringWidth(tmp) > maxLength) {
                    if (index > 0) {
                        strings.addElement(tmp.substring(0, index));
                        tmp = tmp.substring(index);
                        index = 0;
                    } else {
                        while (-1 != (index = this.findSplit(tmp, maxLength))) {
                            strings.addElement(tmp.substring(0, index));
                            tmp = tmp.substring(index);
                            index = 0;
                        }
                    }
                } else {
                    strings.addElement(tmp);
                    tmp = "";
                    index = 0;
                }
                if (tmp.length() != 0) continue;
                done = true;
            }
        }
        String[] out = new String[strings.size()];
        for (int i = 0; i < strings.size(); ++i) {
            out[i] = (String)strings.elementAt(i);
        }
        strings.removeAllElements();
        strings = null;
        this._textHeight = out.length * this._font.getHeight();
        int prevLength = this.lastLength;
        this.lastLength = out.length;
        if (this.lastLength == prevLength + 1 && this.caretPos == -1) {
            this.moveCursorDown();
        }
        return out;
    }

    public void activate() {
        this._active = true;
    }

    public void activate(boolean useSystemBox) {
        this._active = true;
        this._systemBox = useSystemBox;
    }

    public void deactivate() {
        this.addString();
        this._active = false;
        this.caretCounter = -1;
        this.dropTime = 0;
        this.capitalTime = 0;
    }

    public boolean handleKeyDown(int key) {
        if (this.dropTime == 0 && this.capitalTime == 0 && key == -5) {
            return false;
        }
        this.caretCounter = 1000;
        if (this.s.length() >= this._maxSize && key <= 57 && key >= 48) {
            return false;
        }
        if (this.dropTime > 0 && this.s.length() >= this._maxSize - 1 && key != this._lastkey && key <= 57 && key >= 48) {
            this.addString();
            this.keywordIndex = 0;
            this.dropTime = 0;
            return false;
        }
        if (key == this._lastkey && this._lastkey <= 57 && this._lastkey >= 48) {
            if (UI.rightToLeft && !this.forceDefault) {
                --this.tokenIndex;
                if (this.tokenIndex < 0) {
                    this.tokenIndex = UI.getkeyMap(false, this.forceDefault)[key - 48].length() - 1;
                }
            } else {
                ++this.tokenIndex;
                this.tokenIndex %= UI.getkeyMap(false, this.forceDefault)[key - 48].length();
            }
            this.lastToken = this.capitalMode != 2 ? UI.getkeyMap(true, this.forceDefault)[key - 48].substring(this.tokenIndex, this.tokenIndex + 1) : UI.getkeyMap(false, this.forceDefault)[key - 48].substring(this.tokenIndex, this.tokenIndex + 1);
            this.dropTime = 750;
        } else {
            this.addString();
            if (this.dropTime > 0) {
                switch (key) {
                    default: 
                }
                this.dropTime = 0;
            }
            if (this.dropTime == 0) {
                if (UI.rightToLeft && !this.forceDefault) {
                    if (key == -4) {
                        key = -3;
                    } else if (key == -3) {
                        key = -4;
                    }
                }
                switch (key) {
                    case -1: {
                        this._lastkey = key;
                        this.moveCursorUp();
                        this.checkCaret();
                        break;
                    }
                    case -2: {
                        this._lastkey = key;
                        if (this.caretRow == this.output.length - 1) {
                            return false;
                        }
                        this.moveCursorDown();
                        this.checkCaret();
                        break;
                    }
                    case -4: {
                        this._lastkey = key;
                        if (this.insertPos >= 0) {
                            ++this.insertPos;
                        }
                        if (this.insertPos >= this.s.length()) {
                            this.insertPos = -1;
                        }
                        this.dropTime = 0;
                        this.keywordIndex = 0;
                        this.checkCaret();
                        break;
                    }
                    case -3: {
                        this._lastkey = key;
                        if (this.insertPos == 0 || this.s.length() == 0 && this.insertPos == -1) break;
                        if (this.s.length() == 0) {
                            this.insertPos = -1;
                        } else if (this.insertPos == -1) {
                            this.insertPos = this.s.length() - 1;
                        } else if (this.insertPos > 0) {
                            --this.insertPos;
                        }
                        this.dropTime = 0;
                        this.keywordIndex = 0;
                        this.checkCaret();
                        break;
                    }
                    case 42: {
                        if (UI.newPlatform) break;
                        ++this.capitalMode;
                        this.capitalMode %= 3;
                        this.capitalTime = 750;
                        break;
                    }
                    case 35: {
                        if (UI.newPlatform) {
                            ++this.capitalMode;
                            this.capitalMode %= 3;
                            this.capitalTime = 750;
                            break;
                        }
                        if (this.s.length() >= this._maxSize) break;
                        this._lastkey = key;
                        this.lastToken = " ";
                        this.addString();
                        this.output = this.toStringArray(this.s, this._w, this._font);
                        break;
                    }
                    case -8: {
                        this._lastkey = -8;
                        if (this.dropTime > 0) {
                            this.dropTime = 0;
                            this.keywordIndex = 0;
                        } else if (this.s.length() > 0) {
                            if (this.insertPos == -1) {
                                this.s = this.s.substring(0, this.s.length() - 1);
                            } else if (this.insertPos != 0) {
                                this.s = this.s.substring(0, this.insertPos - 1) + this.s.substring(this.insertPos);
                                --this.insertPos;
                            }
                            this.checkCaret();
                        }
                        this.output = this.toStringArray(this.s, this._w, this._font);
                        break;
                    }
                    case -5: {
                        return false;
                    }
                    default: {
                        this.addString();
                        if (key > 57 || key < 48) break;
                        this.dropTime = 750;
                        this.keywordIndex = 0;
                        this.tokenIndex = UI.rightToLeft && !this.forceDefault ? UI.getkeyMap(false, this.forceDefault)[key -= 48].length() - 1 : 0;
                        this.lastToken = this.capitalMode != 2 ? UI.getkeyMap(true, this.forceDefault)[key].substring(this.tokenIndex, this.tokenIndex + 1) : UI.getkeyMap(false, this.forceDefault)[key].substring(this.tokenIndex, this.tokenIndex + 1);
                        this._lastkey = key + 48;
                    }
                }
            }
        }
        if (this.dropTime == 750) {
            if (this.insertPos == -1) {
                this.output = this.toStringArray(this.s + this.lastToken, this._w, this._font);
            } else {
                this.output = this.toStringArray(this.s.substring(0, this.insertPos) + this.lastToken + this.s.substring(this.insertPos), this._w, this._font);
                if (this.caretPos >= 0) {
                    this.caretPos = this.insertPos + this.lastToken.length();
                }
            }
        }
        if (this._systemBox) {
            this.tb.addCommand(this.textOkCommand);
            this.tb.addCommand(this.textBackCommand);
            this.tb.setCommandListener((CommandListener)this);
            this.tb.setMaxSize(5000);
            this.tb.setTitle("");
            this.tb.setString(this.s);
            if (this.isPassword()) {
                this.tb.setConstraints(65537);
            } else if (this.isCapitalized()) {
                this.tb.setConstraints(1);
            } else {
                this.tb.setConstraints(0);
            }
            Canvas.getDisplay().setCurrent((Displayable)this.tb);
        } else if (key == -5) {
            return false;
        }
        return true;
    }

    public boolean handleKeyUp(int key) {
        return false;
    }

    public boolean handleLongPress(int key) {
        this.caretCounter = 500;
        if (key <= 57 && key >= 48) {
            this.dropTime = 750;
            this._lastkey = key;
            this.tokenIndex = UI.getkeyMap(false, this.forceDefault)[key - 48].length() - 1;
            this.lastToken = UI.getkeyMap(false, this.forceDefault)[key - 48].substring(this.tokenIndex, this.tokenIndex + 1);
            if (this.insertPos == -1) {
                this.output = this.toStringArray(this.s + this.lastToken, this._w, this._font);
            } else {
                this.output = this.toStringArray(this.s.substring(0, this.insertPos) + this.lastToken + this.s.substring(this.insertPos), this._w, this._font);
                this.caretPos = this.insertPos + this.lastToken.length();
            }
        } else if (this.dropTime == 0) {
            switch (this._lastkey) {
                case -8: {
                    this.deletePrevWord();
                    this.checkCaret();
                    break;
                }
                case -3: {
                    if (this.insertPos == 0 || this.s.length() == 0 && this.insertPos == -1) break;
                    this.moveCursorLeft();
                    this.checkCaret();
                    break;
                }
                case -4: {
                    this.moveCursorRight();
                    this.checkCaret();
                    break;
                }
                case -1: {
                    this.moveCursorUp();
                    this.checkCaret();
                    break;
                }
                case -2: {
                    this.moveCursorDown();
                    this.checkCaret();
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public void setDimensions(int x, int y, int w, int h) {
    }

    public void setMinimumHeight(int h) {
        this._minH = h;
        this.maxLineCount = 1 + this._minH / this._font.getHeight();
    }

    public void setMaxSize(int maxSize) {
        this._maxSize = maxSize;
    }

    public int getCharsLeft() {
        return this._maxSize - (this.s.length() + this.lastToken.length());
    }

    public int getMaxSize() {
        return this._maxSize;
    }

    public void update(long deltaTime) {
        if (!this._active) {
            this.caretCounter = -500;
            this.dropTime = 0;
            return;
        }
        this.caretCounter = (int)((long)this.caretCounter - deltaTime);
        if (this.caretCounter <= -500) {
            this.caretCounter = 500;
        }
        if (this.dropTime > 0) {
            this.dropTime = (int)((long)this.dropTime - deltaTime);
            if (this.dropTime <= 0) {
                this.addString();
                this.keywordIndex = 0;
                this.dropTime = 0;
            }
        }
        if (this.capitalTime > 0) {
            this.capitalTime = (int)((long)this.capitalTime - deltaTime);
            if (this.capitalTime <= 0) {
                this.capitalTime = 0;
            }
        }
    }

    public void select() {
    }

    public void caretToStart() {
        this.caretPos = 0;
        this.insertPos = 0;
    }

    public void commandAction(Command arg0, Displayable arg1) {
        if (arg0 == this.textBackCommand) {
            Canvas.getDisplay().setCurrent((Displayable)Canvas.getInstance());
        } else if (arg0 == this.textOkCommand) {
            this.s = this.tb.getString();
            Canvas.getDisplay().setCurrent((Displayable)Canvas.getInstance());
            this.setString(this.s);
        }
    }
}

