function firstRun(){
}
global.chRootReload = true;
function stopTickers(){
	if(global.stripletUpdateService != null){
		window.clearinterval(global.stripletUpdateService);
	}
}

function chRoot(){
	if(global.chRootReload || global.chRoot == null){
		global.chRootReload = false;
		global.chRoot = channelmanager.getroot();
	}
	return global.chRoot;
}

function event(code, msg){
	if(code >= 210 && code < 220){
		var message = "itemName=" + global.focItemLabel;
		log.write(257,message);
	}
	if(code >= 220 && code < 230){
		var message = "itemName=" + global.focItemLabel;
		log.write(258,message);
	}
	if(code > 400 && code < 410){
		var message = "itemName=" + global.focItemLabel;
		log.write(259,message);
	}
	
	code = ""+code;
	if(global.eventCollection==null){
		global.eventCollection = new Collection();
	}
	
	var itm = global.eventCollection.item(code);
	if(itm == null){
		itm = new Object();
		itm.value=1;
		itm.name = code;
		global.eventCollection.add(itm);
	}else{
		itm.value++;
	}
}
function writeLogs(){
	//this function will only be called at the completion of (event 5)
	//the background sync as specified in startup.js in defCallBack();
	var eventSize = global.eventCollection.size();
	for(var n=0; n<eventSize; n++){
		var tmpObj =global.eventCollection.item(n);
		var message=tmpObj.name+"="+tmpObj.value;
		log.write(256,message);
	}
	
	
	//clear logs for next sync
	global.eventCollection=null;
}

function deployFilesWhenReady(){
	writeLogs();
	var curVersion = stringparser.parsexmlfile("inc/OTA_Version.xml").item(0);
	var preVersion = device.getappproperty("OTA",0);
	if(curVersion > preVersion){
		device.setappproperty("OTA",curVersion);
		stringparser.evalurl("/CA/startup.js");
		global.chRootReload = true;
		navigator.next('/CA/home.xml');
	}else{
		checkAllPanels();
		
		global.striplets = null;
		loadStriplets();
	}
}

global.displayMyPlaceOnload = false;
global.focusMyPlaceItemOnload = -1;
global.curPanel = 2;
global.panel1 = null;
global.panel2 = null;
global.panel3 = null;
global.okPanels=true;
global.striplets=null;
global.pageVars.curWidgetObject = null;

//Update related flags
global.subscribeFailedFlag = false;
global.noNetworkFlag = false;
global.noUpdateFlag = false;
global.syncActive = false;

function idleDoLsk()
{
    if(!global.shortcutslock){
        global.shortcutslock = true;
        //set to bogus value to avoid capture
        ui.cKey.keycode="-99";
        if(global.syncActive == true)
        {
            tempLsk();
        }
        else
        {	
            if(global.skMenuActive==0)
            {
                if(global.catNotAvailPopup == 1){
                    //do nothing
                }else if(global.searchActive==1){
                    submitSearchInput();
                }else if(global.removePrompt==1){
                    //do nothing
                }else if(global.moveShortcut==1){
        // 			confirmMoveShortcut();
                }else if(global.manageStriplets==1){
                	if(global.numselected!=0){
                    	confirmStriplets();
                    }
                }else if(global.catalogueUpdating == 1){
                    global.catalogueUpdating = 0;
                    hideNote(global.lastLskVal, global.lastRskVal, "Select");
                }else if(global.appNotFound == 1){
                    //do nothing
                }else
                {
                    global.visibleStriplets = ui.stripletItems.widget.size();
                    //ui.dBug.text = "Vis: "+ global.visibleStriplets + " tot:" +global.totalStriplets;
                    
                    if(global.curSection=='striplets'){
                        
                        
                        var curFocStructure = ui.getfocuseditemname();
                        var curCon = curFocStructure.split('.');
                    
                        if(curCon[2]=='fixed'){
                            //user has fixed items selected, these can not be moved
                            
                            if(global.totalStriplets==0 || global.totalStriplets==global.visibleStriplets){
                                //no striplets to show
                                global.skmState = new Array(global.catalogueSKM, global.aboutSKM, global.helpSKM);
                            }else if(global.totalStriplets>global.visibleStriplets){
                            
                                global.skmState = new Array(global.catalogueSKM, global.showHiddenItemsSKM, global.aboutSKM, global.helpSKM);
                            }
                        }else{
	                        var curFoc = ui.getfocuseditemname();
							var objPathStr = curFoc.split("."); //the actual name of the striplet & widget
							var focName = objPathStr[3];
							var root = chRoot();
							var widgetRoot = chRoot().widgetPath;
							//var widgets = chRoot().item(widgetRoot);
							var chAttrs = root.item(widgetRoot).item(focName);
                        
                        	var skm_hide = new Object();
								skm_hide.name="hide";
								skm_hide.readName="Hide "+chAttrs.friendlyName;
								skm_hide.onclick="hideStriplet();";
								global.hideSKM = buildListItem(skm_hide);
                        	
                    		var skm_move = new Object();
								skm_move.name="move";
								skm_move.readName="Move "+chAttrs.friendlyName;
								skm_move.onclick="moveStriplet();";
								global.moveSKM = buildListItem(skm_move);
                        	
                     		if(global.visibleStriplets ==1 && global.visibleStriplets == global.totalStriplets){
                     			global.skmState = new Array(global.catalogueSKM, global.hideSKM, global.aboutSKM, global.helpSKM);
                         	}else if(global.visibleStriplets ==1 && global.visibleStriplets < global.totalStriplets){
                         		global.skmState = new Array(global.catalogueSKM, global.hideSKM, global.showHiddenItemsSKM, global.aboutSKM, global.helpSKM);
                     		}else if(global.visibleStriplets>1 && global.visibleStriplets == global.totalStriplets){
                            	//more than one visible striplet (i.e. 2 or more) with some not displayed (hidden)
								global.skmState = new Array(global.catalogueSKM, global.hideSKM, global.moveSKM, global.aboutSKM, global.helpSKM);
                            }else if(global.visibleStriplets>1 && global.visibleStriplets<global.totalStriplets){
								//less visible striplets than those available
                            	global.skmState = new Array(global.catalogueSKM, global.hideSKM, global.moveSKM, global.showHiddenItemsSKM, global.aboutSKM, global.helpSKM);
                         		
                            }else if(global.visibleStriplets <=1 && global.visibleStriplets == global.totalStriplets){
                                //all striplets are visible, nothing hidden
                                global.skmState = new Array(global.catalogueSKM, global.hideSKM, global.showHiddenItemsSKM, global.aboutSKM, global.helpSKM);
                         	}
                            //this should capture all scenarios
                        }
                    }else if(global.curSection=="dock"){
                        //ui.dBug.text = ("visible: "+global.visibleStriplets+" total: " +global.totalStriplets);
                        if(global.visibleStriplets<global.totalStriplets){
                            global.skmState=global.skmState_idle_1showStriplets;
                        }else{
                            global.skmState=global.skmState_idle_1;
                        }
                    }
                    //to include the names, include the following:
                    
                    else if(global.curSection=="panels" && global.skmState.length==5){
                        
                        if(global.curXIndex==-1)global.curXIndex=0;
                        //if(global.curXIndex==null)global.curXIndex=0;
                        
                        var curPan = ui.panels.item('p'+global.curPanel);
                        var curObj = curPan.item('icon_'+global.curXIndex+'_'+global.curYIndex);
                        //window.alert(curName);
                        var skm_move = new Object();
                            skm_move.name="move";
                            skm_move.readName="Move "+curObj.text;
                            skm_move.onclick="moveItem();";
                        global.moveSKM = buildListItem(skm_move);
            
                        var skm_remove = new Object();
                            skm_remove.name="remove";
                            skm_remove.readName="Remove "+curObj.text;
                            skm_remove.onclick="removeShortcut();";	
                        global.removeSKM = buildListItem(skm_remove);
                        
                        global.skmState[1] =  global.moveSKM;
                        global.skmState[2] =  global.removeSKM;
                    }
                    if(!global.manSync){
                    	ui.panels.textHighlight.visible=false;
                    	displaySkMenu('idle');
                    }
                }
            }
            else
            {
    // 		navigator.executefocused();
            }	
        }
    }
    global.shortcutslock = false;
}

function idleDoRsk(){
	ui.cKey.keycode="-8";
	if(global.syncActive == true)
	{
		tempRsk();
	}
	else
	{
		if(global.skMenuActive==0){
			//no menu visible, do whatever configured to
			if(global.catNotAvailPopup == 1){
				//Do nothing
			}else if(global.searchActive==1){
				cancelSearchInput();
			}else if(global.appNotFound == 1){
				global.appNotFound = 0;
				hideNote("Options", "Back", "Select");
				ui.panels.item("p"+global.curPanel).focus();		
			}else if(global.removePrompt==1){
				global.removePrompt=0;
				hideNote("Options", "Back", "Select");
				var curPan = ui.panels.item("p"+global.curPanel);
				var index = global.curYIndex * 4 + global.curXIndex;
				curPan.item(index).focus();
				global.pageVars.curWidgetObject = null;
			}else if(global.moveShortcut==1){
				if(global.curSection == 'striplets'){
					cancelStripletMove();
				}else{
					cancelMoveShortcut();
				}
			//bugfix for issue where myplace can sometimes present over the striplets - this will always capture and return client
			//to normal state of operations
			}else if(global.curSection == "panels" || ui.panels.yscrollpos>-266){
			  if(!global.manSync)
				toggleShortcuts();
			}else if(global.manageStriplets==1){
				cancelStriplets();
			}else{
				
				launchApp("menu","com.sonyericsson.mainmenu.general");
			}
		}else{
			if(global.highlightInUse==true)	ui.panels.textHighlight.visible=true;
			cancelSkMenu();
		}
	}	
}

function doLoadIdle(){
if(!global.idleLoad){
	global.idleLoad=true;
	global.endKeyTimer = window.settimeout("idlescreen.activateendkey();",15000);
	//Note if you change the number of objects in the docks this number will need to be changed
	if(global.dockObjects.size() == 13){
		ui.dock.addcontents(global.dockObjects);
	}else{
		global.dockObjects = stringparser.preprocessxmlfile('inc/dockObjects.xml');
		ui.dock.addcontents(global.dockObjects);
	}
	global.updateUI.updatePopup.visible=0;	
	global.updateUI.updatePopup.updateContents.progressIndicator.w = 10;
	if(sync.isupdating() && global.manSync)
	{
		sync.reset();
		global.syncActive = false;
	}
	
	global.manSync = false;
	global.skMenuActive=0;
	global.skmState = global.skmState_idle_1;
		
	global.curSection = "dock";
	global.appNotFound=0;
	global.catNotAvailPopup = 0;
	global.panelsActive=0;
	//this variable gets used when 
	global.searchActive=0;
	global.removePrompt=0;
	//this variable gets set 1 when user selects move shortcut functionality
	if(global.moveShortcut==1){
		global.striplets = null;
		//loading client after user presses hangup and potentially requires new build of panels
		//failsafe method to ensure the panels are correct
		global.panel1=null;
		global.panel2=null;
		global.panel3=null;
		//cancelMoveShortcut('noUI');
		
	}

	ui.panels.scrollsmooth=2;
	ui.panelsVStatic.scrollsmooth=2;
    var popup = stringparser.preprocessxmlfile("/CA/inc/aboutNotePopup.xml");
    if (popup != null) {
        ui.addcontents(popup);
    }
	if(global.displayMyPlaceOnload == true)
	{	
		ui.dock.visible=0;
 		buildAllPanels();
		ui.panels.add(global.highlightObj);
		global.skmState = global.skmState_idle_2;
		ui.idle=false;
		
		var lsk = buildSkLabelObj("Options", "doLsk();");
		var rsk = buildSkLabelObj("Back", "doRsk();");
		var msk = buildSkLabelObj("Select", "if(!global.manSync)navigator.executefocused();");
		fillSkLabels(lsk, rsk, msk);
		focusPanel();
		global.focusMyPlaceItemOnload = -1;
		global.displayMyPlaceOnload = false;

	} else {
		global.skmState = global.skmState_idle_1;
		ui.dock.visible=1;
		//workaround that ensures whenj the panels are created, there is an object to
		//focus on, but due to the z index, it needs to be removed and re added
		buildAllPanels();
		ui.panels.add(global.highlightObj);
		
		if(global.dockIndexFoc==null){
			ui.dock.focus();
		}else{
			//ui.dock.focus();
			var itemToFoc = ui.dock.item("dock_"+global.dockIndexFoc);
			itemToFoc.focus();
			//global.dockIndexFoc
		}
		global.curSection = "dock";
		updateTime();
		ui.idle='true';
		var lsk = buildSkLabelObj("Options", "doLsk();");
		var rsk = buildSkLabelObj("Menu", "doRsk();");
		var msk = buildSkLabelObj("Select", "navigator.executefocused();");
		fillSkLabels(lsk, rsk, msk);
 	}
	
	buildStriplets();
	loadStriplets();  //build to add debug
	
	resetUpdateTime();
	
	global.moveShortcut=0;
	
	if(ui.stripletItems.widget == null){
		global.visibleStriplets = 0;
	}else{
		global.visibleStriplets = ui.stripletItems.widget.size();
	}
	var totalStriplets = stringparser.parsexmlfile("var/stripletConfig.xml");
	if(totalStriplets == null){
		global.totalStriplets = 0;
	}else{
		global.totalStriplets = totalStriplets.size();
	}
	
	if(global.updateUI != null) {
        ui.addcontents(global.updateUI);
    }
	
	window.cleartimeout(global.endKeyTimer);
	idlescreen.activateendkey();
	global.idleLoad=false;
	//add the highlight area to ensure it sits on top of all other items

}
}

function updateMyFoc(myObj){
	global.focItemLabel = myObj.text;
	if(global.moveShortcut!=1){
		//1 - figure out the required size
		//by creating a label with the text and getting the content width
		var textObj = new Label();
			textObj.text = myObj.text;
			textObj.font = "/CA/fonts/x_small_black.bf2";
			textObj.name = "tmpLabel";
		ui.add(textObj);
		var curW = ui.tmpLabel.w;
		ui.remove(textObj);
		
		if(curW<52){
			ui.panels.textHighlight.visible=0;
			global.highlightInUse=false;
		}else{
			global.highlightInUse=true;
			ui.panels.textHighlight.visible=1;
			var parentObj = '';
			var curParent = ui.panels.item("p"+global.curPanel);
			
			//90 is max width, meaning 82 (for label), plus 4 pixel padding
			//on both sides makes 90
			if(curW>82)curW=82;
			
			var colOffset;
			if(global.curXIndex==0){
				colOffset=0;
			}else if(global.curXIndex==3){
				var myCalc = (curW + 8 - 60);
				colOffset=-myCalc;
			}else{
				//must be in middle sections - need to center
				var myCalc = (curW + 8 - 60)/2;
				colOffset=-myCalc;
			}
			var xOff = (240*(global.curPanel-2))+colOffset;
			var yOff = 45;
			
			
			
			
			var focExp = ui.panels.textHighlight;
				focExp.x = myObj.x+xOff;
				focExp.y = myObj.y+yOff;
				focExp.w = curW+8;
				focExp.midSect.w = curW;
				focExp.rightSect.x = curW+4;
			focExp.curText.text = myObj.text;
			focExp.curText.w=curW+8;
		}
	}
}
function configScrollbar(conNameAndPath){
	stringparser.eval("global.actualHeight = "+conNameAndPath+".contentheight; global.visibleHeight = "+conNameAndPath+".h; global.scrollbarConY = "+conNameAndPath+".y;");
	if(global.actualHeight > 0){
		global.scrollbarHeight = (global.visibleHeight*global.visibleHeight) / global.actualHeight;
	}else {
		global.scrollbarHeight = 0;
	}
	if(global.actualHeight>global.visibleHeight){
		ui.scrollbarCon.visible=1;
		global.targetCon = conNameAndPath;
		ui.scrollbarCon.y=global.scrollContainerYPos;
		ui.scrollbarCon.scrollCentre.h = global.scrollbarHeight-12;
		
		stringparser.eval("if((global.actualHeight - global.visibleHeight) < " +global.targetCon+".yscrollpos){"+global.targetCon+".yscrollpos = global.actualHeight - global.visibleHeight;}");
	}else{
		ui.scrollbarCon.visible=0;
		stringparser.eval(conNameAndPath+".yscrollpos = 0;");
	}
}
function updateScrollbar(timeout){
	if(timeout == null)
	{timeout = 200;}
	if(global.actualHeight>global.visibleHeight){
		window.settimeout('animateScrollbar();', timeout);
	}
}
function animateScrollbar(){
	stringparser.eval("global.moveSpeed = -(("+global.targetCon+".yscrollpos)/2); global.contScrollY = "+global.targetCon+".yscrollpos;");
	
	if((global.actualHeight - global.visibleHeight) != 0){
		global.movePos = 0 - (global.contScrollY * (global.visibleHeight - global.scrollbarHeight)) / (global.actualHeight - global.visibleHeight);
	}else{
		global.movePos = 0;
	}
	
	ui.scrollbarCon.yscrollpos = global.movePos;
}

function errorCallback( element, path, errorCode)
{
	//var errorString = "Element " + element + " Path " + path + " Error Code " + errorCode;
	//event(9999, errorString);
}

function launchApp(name,uid,uri,args)
{
//     var currentAppData = global.pageVars.shortcutPanels[global.curPanel - 1].item(name);
    var launcherObject = new Object();
    launcherObject.name = name;
    launcherObject.uid = uid;
    if(args != null)
    {
    	launcherObject.arguments = args;
    }
    if(uri != null)
    {
    	launcherObject.uri = uri;
    }
    // the app in question is just a JS object with the uid and other attributes filled in
    //window.alert(launcherObject.name + "," + launcherObject.uid);
    var idleStatus = ui.idle;
    ui.idle = true;
    var success = apploader.launchapplication(launcherObject);

    ui.idle = idleStatus;
}

function gotoCatalogue(version){
	//var lastHeartbeat = 9393902543;
	var timeLimit = 60*60*24;//24hours
	//for development in emulator, use the hardcoded lastUpdat value
	//var lastUpdate = 5000;
	var lastUpdate = device.getappproperty('lastHeartbeat', 0);
	var requireUpdate;
	if(lastUpdate==0 || lastUpdate < (device.gettime()-timeLimit)){
		requireUpdate=true;
	}
	//window.alert(device.gettime());
	if(version != null){
		device.setappproperty("lastViewedCat",version);
	}
	
	if(sync.isupdating() || lastUpdate == 0){	
		global.lastLskVal = ui.lskLabel.text;
		global.lastRskVal = ui.rskLabel.text;
		global.lastFocItem = ui.getfocuseditemname();
		global.catNotAvailPopup = 1;
		if(global.skMenuActive==1)
		{
			cancelSkMenu();
		}
		displayNote('The catalogue is being updated. Try again later.', 'i', "", "", "OK", "doMsk();");
// 	}else if(requireUpdate==true){
// 		standardSync("catalogue.xml", "Updating Catalogue");
	}else{
		global.catalogueUpdating = 0;
		event(200, 'Opening Catalogue');
		go('catalogue');
	}
}

function buildStriplets(){
	logNow("buildStriplets function called");
	global.stripletDataArray = new Array();
	var ctr = 0;
	var fixed = new List();
	fixed.name = "fixed";

	global.Updates = stringparser.parsexmlfile("inc/catUpdate.xml");
	var lastViewed = device.getappproperty("lastViewedCat",0);

	var us = ui.item('updated_striplet');
	
	if(lastViewed < global.Updates.item('version').value && us==null){
		var item0 = new Object();
			item0.name = "updated_striplet";
			item0.text = "Catalogue updated";
			item0.onclickAction = "gotoCatalogue(" + global.Updates.item('version').value + "); event(1002,'');";
			item0.icon = "/CA/img/List_sm_rhs_status_updated.png";
			item0.selectedicon = "/CA/img/List_sm_rhs_status_updated.png";
		global.stripletDataArray[ctr] = item0;	
		ctr++;	
	}else{
		global.Updates = null;
	}
	
	var viewVideo = device.getappproperty("viewVideo",true);
	us = ui.item('intro_striplet');
	
	if(viewVideo && us==null){
		var videoUrl = device.getappproperty('videoUrl');		
		var item1 = new Object();
			item1.name = "intro_striplet";
			item1.icon = "/CA/img/List_sm_play.png";
			item1.selectedicon = "/CA/img/List_sm_play_Focused.png";
			item1.text = "View introductory video";			
			item1.onclickAction = "device.setappproperty('viewVideo',false); global.fromHelp = false; navigator.next('/CA/introVideo.xml'); event(1001,'Striplet'); ";
			global.stripletDataArray[ctr] = item1;
			ctr++;					
	}
	
	global.fixedStriplets = ctr;
	
	for(var q=0; q < global.stripletDataArray.length; q++){
		var myItem = createListItem(335, global.stripletDataArray[q]);
			myItem.onfocus="updateScrollbar();";
			fixed.add(myItem);
	}
	if(global.fixedStriplets > 0){
		ui.stripletItems.add(fixed);
	}
	logNow("buildStriplets end of function");
	
}

function openMyPlace(){
	//Don't open MyPlace before panels are built
	if(ui.panels.size() > 1)
	{
		ui.dock.visible=0;
		toggleShortcuts();
	}
}

global.callCount=0;

function getWidgets(){
	channelmanager.rollback();
	var rootXmlObj = chRoot();	
	if(rootXmlObj.widgetPath == null || rootXmlObj == null){
		return null;
	}
	
	var widgetObj = rootXmlObj.item(rootXmlObj.widgetPath);
	
	if(widgetObj == null){
		return null;
	}

	var widgets = new Collection();
	
	for(var i=0; i<widgetObj.size(); i++){
		var widgetToCheck = widgetObj.item(i);
		if(widgetToCheck.subscribed){
			var widgetToAdd = new Object();
			widgetToAdd.name = widgetToCheck.name;
			widgetToAdd.friendlyName = widgetToCheck.friendlyName;
			widgetToAdd.uipath = "/CH/" + rootXmlObj.name + "/" + rootXmlObj.widgetPath + "/" + widgetToCheck.name;
			widgets.add(widgetToAdd);
		}
	}
	return widgets;
}

function checkAllPanels() {	
	var widgets = getWidgets();
	var changeWidgets = false;
	var test;
	
	if(global.panel2 != null){
		test = checkPanel(global.panel2,widgets);
		if(test){
			changeWidgets = true;
		}
	}
	if(global.panel3 != null){
		test = checkPanel(global.panel3,widgets);
		if(test){
			changeWidgets = true;
		}
	}
	if(global.panel1 != null){
		test = checkPanel(global.panel1,widgets);
		if(test){
			changeWidgets = true;
		}
	}
	if(widgets.size() > 0){
		addMissingWidgets(widgets);
		changeWidgets = true;
	}
	
	finalisePanel(global.panel2);
	finalisePanel(global.panel3);
	finalisePanel(global.panel1);
	
	if(changeWidgets){
		global.striplets = null;
		loadStriplets();
	}
}

function buildAllPanels() {	
	var widgets = getWidgets();
	var addWidgets = true;
	
	if(global.panel2 == null){
		global.panel2 = buildPanel(2,widgets);
	}else{
		addWidgets = false;
		ui.panels.add(global.panel2);
	}
	
	if(global.panel1 == null){
		global.panel1 = buildPanel(1,widgets);
	}else{
		addWidgets = false;
		ui.panels.add(global.panel1);
	}
	
	if(global.panel3 == null){
		global.panel3 = buildPanel(3,widgets);
	}else{
		addWidgets = false;
		ui.panels.add(global.panel3);
	}
	
	if(addWidgets){
		// WE have rebuilt the panels, toso curx and y are reset to 0,0
		global.curXIndex=0;
		global.curYIndex=0;
		
		addMissingWidgets(widgets);
	}
}
function addMissingWidgets(widgets){

	var curWidgObj;
	//Get the initial panel to add to
	var panelIndex = 2;
	var targetPanel = global.panel2;
	
	if(targetPanel.size()==12 && targetPanel.item(targetPanel.size()-1).text!="Add"){
		panelIndex = 3;
		targetPanel = global.panel3;
	}
	
	if(targetPanel.size()==12 && targetPanel.item(targetPanel.size()-1).text!="Add"){
		panelIndex = 1;
		targetPanel = global.panel1;
	}
	if(targetPanel.size()==12 && targetPanel.item(targetPanel.size()-1).text!="Add"){
		//All full, don't bother.
		return;
	}	
	//Add all remaining subscribed widgets

	for(var r=0; r < widgets.size(); r++){
		var curObj = widgets.item(r);
// We need to ensure we have the stuff we need here - will need to add it to the widgets collection
		curObj.image=curObj.uipath + "/preview/icon_sel.png";
		//change to go function and add event logging
		curObj.onclick="go('" + curObj.uipath + "/homecode');event(402, 'launch-widget');";
		var widgetName = curObj.name;
		curObj.name = curObj.friendlyName;
		
		var iconToAdd = buildIcon(curObj);
		iconToAdd.onfocus = "focusSection('panels', this);global.widgetName='"+widgetName+"';";
		targetPanel.add((targetPanel.size()-1),iconToAdd);
		
		if(targetPanel.size()>=12 && targetPanel.item(11).text!="Add"){
			finalisePanel(targetPanel);
			writePanelData('/CA/var/iconsPanel'+ panelIndex + '.xml',targetPanel);
			if(panelIndex == 1){
				//Now all full, we can't add anymore
				return;
			}
			panelIndex ++;
			if(panelIndex == 4){
				panelIndex=1;
			}
			stringparser.eval("targetPanel = global.panel"+panelIndex+";");
		}
		if(targetPanel.size()>=12 && targetPanel.item(11).text!="Add"){
			finalisePanel(targetPanel);
			writePanelData('/CA/var/iconsPanel'+ panelIndex + '.xml',targetPanel);
			if(panelIndex == 1){
				//Now all full, we can't add anymore
				return;
			}
			panelIndex ++;
			if(panelIndex == 4){
				panelIndex=1;
			}
			stringparser.eval("targetPanel = global.panel"+panelIndex+";");
		}
		
	}
	
	finalisePanel(targetPanel);
	writePanelData('/CA/var/iconsPanel'+ panelIndex + '.xml',targetPanel);
}

function checkPanel(panel, widgets){
	var sourceLength = panel.size();
	var changeToPanels = false;
	
	for(var n=0; n<sourceLength; n++){
		
		//fill in property values to parse to create function
		var curObj = panel.item(n);
		var addIcon = true;
		//check to see that widget IS infact subscribed
		var focusStr = curObj.onfocus;
		var lngth = focusStr.length() - 50;
		var widgetName = focusStr.substr(48,lngth);
		if(widgetName!=null && widgetName!="null"){
			var widgObj = widgets.item(widgetName);
			if(widgObj != null){
				widgets.remove(widgetName);
			}else{
				changeToPanels = true;
				panel.remove(n);
				n--;
				sourceLength--;
				//Delete Icon here
			}
		}
		
	}

	if(changeToPanels){
		return true;
	}else{
		return false;
	}
}


function buildPanel(screen, widgets){
	var panelHeight = global.bodyH;
	var panelToCreate = new Container();
	
	var xOffset=4;
	if(screen==1){
		xOffset=6;
	}else if(screen==3){
		xOffset=2;
	}
	panelToCreate.w = 240;
	panelToCreate.h = 260;
	panelToCreate.x = (screen-2)*240;
	panelToCreate.y = 0;
	var headingHeight = 29;
	//panelToCreate.bgimage="/CA/img/myplace_panel_narrow.png";
	panelToCreate.name = "p"+screen;
	var sourceRoot = stringparser.parsexmlfile("var/iconsPanel"+screen+".xml");
	if(sourceRoot == null){
		sourceRoot = stringparser.parsexmlfile("inc/iconsPanel"+screen+".xml");
	}
	global.pageVars.shortcutPanels[screen-1] = sourceRoot;
	var sourceLength = sourceRoot.size();
	var iconToAdd;
	var row = 0;
	var col = 0;
	var changeToPanels=false;
	var numberAdded=0;
	
	//window.alert("Screen: "+screen +"="+ sourceLength);
	for(var n=0; n<sourceLength; n++){
		
		//fill in property values to parse to create function
		var curObj = sourceRoot.item(n);
		var addIcon = true;
		//check to see that widget IS infact subscribed
		if(curObj.widgetName!=null && curObj.widgetName!="null"){
			var widgObj = widgets.item(curObj.widgetName);
			if(widgObj != null){
				widgets.remove(curObj.widgetName);
			}else{
				changeToPanels=true;
				addIcon = false;
			}
		}
		
		if(addIcon){
			iconToAdd = buildIcon(curObj);
			iconToAdd.x = (58 * col)+xOffset;
			iconToAdd.y= (60 * row)+headingHeight;
			//sw: added updateMyFoc(this); for focus highlight text to be higher 
			iconToAdd.onfocus = "focusSection('panels', this);global.widgetName='"+curObj.widgetName+"';";
			//global.curXIndex="+col+"; global.curYIndex="+row+";
			iconToAdd.name = "icon_"+col+"_"+row;
			iconToAdd.leftnavigation="horizNav(-1, "+col+", "+row+");";
			iconToAdd.rightnavigation="horizNav(1, "+col+", "+row+");";
			iconToAdd.upnavigation="vertNav(-1, "+col+", "+row+");";
			iconToAdd.downnavigation="vertNav(1, "+col+", "+row+");";
			col++;
			if(col > 3){
				col=0;
				row++;
			}
			panelToCreate.add(iconToAdd);
			numberAdded++;
		}
		
		
	}
	
	//if the icons do not fill up the screen
	if(numberAdded<12){
		//need to add an 'add' icon
		var addObj = new Object();
		addObj.name = "Add";
		addObj.onclick="gotoCatalogue();";
		addObj.image="/CA/img/tile_add_unfocused.png";
		
		iconToAdd = buildIcon(addObj);
		iconToAdd.x = (58 * col)+xOffset;
		iconToAdd.y= (60 * row) +headingHeight;
		//iconToAdd.onfocus = "global.curSection='panels';";
		iconToAdd.name = "icon_"+col+"_"+row;
	
		iconToAdd.leftnavigation="horizNav(-1, "+col+", "+row+");";
		iconToAdd.rightnavigation="horizNav(1, "+col+", "+row+");";
		iconToAdd.upnavigation="vertNav(-1, "+col+", "+row+");";
		iconToAdd.downnavigation="vertNav(1, "+col+", "+row+");";
		iconToAdd.onfocus = "focusSection('panelsAdd', this);";
		panelToCreate.add(iconToAdd);
	}
	
// 	var panSize = ui.panels.size();
// 		panSize -=1;
	//screen
	ui.panels.add(1, panelToCreate);
	
	if(changeToPanels)writePanelData('/CA/var/iconsPanel'+ screen + '.xml',ui.panels.item('p'+screen));
	
	return panelToCreate;
}

function focusPanel(){
	ui.panels.focusable=1;
	ui.stripletItems.focusable=0;
	ui.stripletItems.yscrollpos=global.bodyH;
	if(global.focusMyPlaceItemOnload == -1)
	{
		//global.curPanel - returns the correct panel, regardless
	//	window.alert("1 - "+global.curPanel);
			//fix to bug where removing widget results in null on options menu item
// 		global.curXIndex=0;
// 		global.curYIndex=0;
		
		if(global.curPanel==1){
			//ui.panels.xscrollpos=-240;
			ui.panels.p1.focus();
		}else if(global.curPanel==3){
			//ui.panels.xscrollpos=240;
			ui.panels.p3.focus();
		}else{
			ui.panels.p2.focus();
		}
	}
	else
	{	
		var itemToFoc = ui.panels.item("p" + global.curPanel).item(global.focusMyPlaceItemOnload);
		if(itemToFoc == null){
			ui.panels.item("p" + global.curPanel).item(0).focus();
			global.curXIndex=0;
			global.curYIndex=0;
		}else{
			ui.panels.item("p" + global.curPanel).item(global.focusMyPlaceItemOnload).focus();
			global.curXIndex=global.focusMyPlaceItemOnload % 4;
			global.curYIndex=global.focusMyPlaceItemOnload / 4;
		}
	}	

	global.curSection = "panels";
	ui.panelsVStatic.yscrollpos=-6;
}

function toggleShortcuts(){
    if(!global.shortcutslock){
        global.shortcutslock = true;
//  	if(ui.panels.item('p2') == null){
// 	    	buildPanel(2);
// 	    }
        if(global.curSection == "dock"){
            //	window.alert("foc");
            if(global.curXIndex==null){
                global.curXIndex=0;
            }
            if(global.curYIndex==null){
                global.curYIndex=0;
            }
            global.skmState = global.skmState_idle_2;
            //fillSkLabels("Options", "Close");
    // 		ui.idleStatus.visible="false";
            ui.idle=false;
            
            var lsk = buildSkLabelObj("Options", "doLsk();");
            var rsk = buildSkLabelObj("Back", "doRsk();");
            var msk = buildSkLabelObj("Select", "if(!global.manSync)navigator.executefocused();");
            fillSkLabels(lsk, rsk, msk);
            
            focusPanel();
        }else{
            //window.alert("boo");	
            ui.idle=true;
            global.skmState = global.skmState_idle_1;
    // 		ui.idleStatus.visible="true";
            var lsk = buildSkLabelObj("Options", "doLsk();");
            var rsk = buildSkLabelObj("Menu", "doRsk();");
            var msk = buildSkLabelObj("Select", "if(!global.manSync)navigator.executefocused();");
            fillSkLabels(lsk, rsk, msk);
            hidePanel();
            ui.dock.visible=1;
        }
        global.shortcutslock = false;
    }    
}

function hidePanel(){

	ui.panels.focusable=0;

	ui.panels.yscrollpos=-266;
	ui.panelsVStatic.yscrollpos=-266;

	ui.stripletItems.yscrollpos=0;
	ui.stripletItems.focusable=1;
	ui.dock.focus();
	global.curSection = "dock";
}

function moveItem(){
	if(global.curSection == 'panels'){
		moveShortcut();
	}else if(global.curSection == 'striplets'){
		moveStriplet();
	}
}
function moveStriplet(){
	cancelSkMenu();
	var lsk = buildSkLabelObj("", "");
	var rsk = buildSkLabelObj("Cancel", "cancelStripletMove();");
	var msk = buildSkLabelObj("Done", "confirmStripletMove();");
	//var msk = buildSkLabelObj("Confirm", "confirmStripletMove();");
	fillSkLabels(lsk, rsk, msk);
	
	var focused = global.lastFocItem.split('.');
	global.dest = focused[3];
	global.moveShortcut=1;
	
	//strinparser.eval();
	//img/striplet_moveFocus.png
	//change the backing graphic to the orange move image
	
	var widgetList = ui.stripletItems.item("widget");
	var targetCon = widgetList.item(global.dest);

	var rootXmlObj = chRoot();	
	if(rootXmlObj.widgetPath == null || rootXmlObj == null){
		global.striplets = null;
		return;
	}
	var widgetObj = rootXmlObj.item(rootXmlObj.widgetPath);
	if(widgetObj == null){
		global.striplets = null;
		return;
	}
	var widgetPathRoot = '/CH/'+rootXmlObj.name+'/'+widgetObj.name+'/'+ global.dest;
	stringparser.evalurl(widgetPathRoot + "/setMove.js");

	for(var i=0; i<widgetList.size(); i++){
		if(global.dest == widgetList.item(i).name){
			global.movIndex = i;
		}
	}

 	var stripletToMove = ui.stripletItems.widget.item(global.dest);
	setMove(stripletToMove);
	var selImage = new  Button();
	selImage.bgimage = "";
	selImage.name = "selImage";
	selImage.onclick="confirmStripletMove();";
	selImage.x = 2;
	selImage.upnavigation="stripletMove(-1);";
	selImage.downnavigation="stripletMove(1);";
	selImage.leftnavigation = "";
	selImage.rightnavigation = "";
	

	stripletToMove.add(0, selImage);
	selImage.focus();

}

function cancelStripletMove(){
	global.striplets=null;
	
	var lsk = buildSkLabelObj("Options", "doLsk();");
	var rsk = buildSkLabelObj("Menu", "doRsk();");
	var msk = buildSkLabelObj("Select", "if(!global.manSync)navigator.executefocused();");
	fillSkLabels(lsk, rsk, msk);
	loadStriplets();
	global.moveShortcut=0;
	ui.stripletItems.widget.item(global.dest).focus();
}
function confirmStripletMove(){
	event(303, 'move-striplet');
	var stripletOrder = stringparser.parsexmlfile("var/stripletConfig.xml");
	
	var tmpObj = stripletOrder.item(global.dest);
	stripletOrder.remove(global.dest);

	
	var widgetBefore = ui.stripletItems.widget.item(global.movIndex-1).name;
	
	if(widgetBefore == null){
		stripletOrder.add(0,tmpObj);
	}else{
		var dest = 0;
		for(var i=0; i<stripletOrder.size(); i++){
			if(widgetBefore == stripletOrder.item(i).name){
				dest = i + 1;
			}
		}
		stripletOrder.add(dest,tmpObj);
	}
	writeStripletXMLObj(stripletOrder);
	//ui.stripletItems.widget.clear();
	
	//no real need to reload striplets given UI is sorted
	global.striplets=null;
	
	loadStriplets();
		
	var lsk = buildSkLabelObj("Options", "doLsk();");
	var rsk = buildSkLabelObj("Back", "doRsk();");
	var msk = buildSkLabelObj("Select", "if(!global.manSync)navigator.executefocused();");
	fillSkLabels(lsk, rsk, msk);
	global.moveShortcut=0;
	//window.alert(global.dest);
	
	ui.stripletItems.widget.item(global.dest).focus();
	//restorStripletsAfterMove();
}
function restorStripletsAfterMove(){
	var obj = ui.stripletItems.widget.item(global.dest).item(0);
	ui.stripletItems.widget.item(global.dest).remove(0);
	obj.clear();
	
	
	var targetCon = ui.stripletItems.widget.item(global.dest);
	targetCon.myCon.btn.bgimage = "img/List_sm_btn_unfocused.png";
	
}

function stripletMove(dir){
	var listSize = ui.stripletItems.item("widget").size();
	global.movIndex = global.movIndex + dir;
	if(global.movIndex < 0){
		global.movIndex = 0;
	}else if(global.movIndex >= listSize){
		global.movIndex = listSize-1;
	}

	var tmpObj = ui.stripletItems.widget.item(global.dest);
	
	ui.stripletItems.widget.remove(global.dest);
	ui.stripletItems.widget.add(global.movIndex, tmpObj);
	tmpObj.item(selImage).focus();
}

function moveShortcut(){
	global.moveStartXIndex = global.curXIndex;
	global.moveStartYIndex = global.curYIndex;
	cancelSkMenu();
	global.moveShortcut=1;
	addMoveIcon();
	
	var lsk = buildSkLabelObj("", "doLsk();");
	var rsk = buildSkLabelObj("Cancel", "doRsk();");
	var msk = buildSkLabelObj("Done", "navigator.executefocused();");
	fillSkLabels(lsk, rsk, msk);
}

function addMoveIcon(){
	// Changing this to use a Background to the selected item
	ui.cKey.keycode = 99;
	global.movIndex = global.curYIndex * 4 + global.curXIndex;
	global.movStart = new Object();
	global.movStart.panel = ui.panels.item("p"+global.curPanel);
	global.movStart.index = global.curYIndex * 4 + global.curXIndex;
	global.movStart.panelNum = global.curPanel;
	
	var targetItem = ui.panels.item("p"+global.curPanel).item("icon_"+global.curXIndex+"_"+global.curYIndex);

	//get rid of the text highlight if its in use
	if(global.highlightInUse==true)	ui.panels.textHighlight.visible=false;

	event(301,targetItem.text);

	targetItem.selectedbgimage = "img/tile_moveFocus.png";
	global.funcHolder = targetItem.onclick;
	targetItem.onclick = "confirmMoveShortcut();";
}

function getPanelItem(panel, row, position, toMove){
	var curCon = ui.panels.item("p"+panel);
	global.curPanel = panel;
	ui.panelsVStatic.panelIndicator.src = "/CA/img/msk_pagination0"+panel+".png";
	
	if(position < 0){
		position = 3;
	}else{
		position = 0;
	}

	var itemToFoc = curCon.item((row * 4)+ position);
	var focNum = (row * 4) + position;

	if(itemToFoc == null){
		focNum = (curCon.size()-1)/4 * 4 + position;
		if(focNum >= curCon.size()){
			focNum = curCon.size()-1;
		}
		itemToFoc = curCon.item(focNum);
	}
	global.curXIndex = focNum %4;
	global.curYIndex = focNum/4; 
	if(toMove){
		return focNum;
	}else{
		return itemToFoc;
	}
}

function vertNav(dir, curXIndex, curYIndex){

if(!global.navlock){
	global.navlock=true;

	var itemToFoc;
	var curCon = ui.panels.item("p"+global.curPanel);
	if(global.curSection=='dock'){
		global.skmState = global.skmState_idle_3;
		if(ui.stripletItems.size() > 0 && (global.fixedStriplets + ui.stripletItems.widget.size()) > 0){ 
			itemToFoc = ui.item("stripletItems");
			itemToFoc.focus();
		}
	}else if(global.curSection=='panels'  || global.curSection == 'panelsAdd'){

		if(global.moveShortcut==1){
			var nextIndex = global.movIndex + (dir * 4);
			itemToFoc = curCon.item(nextIndex);
		
			if(itemToFoc.text != "Add" && itemToFoc != null){
				cascadeSwapIcons(curCon, global.movIndex, nextIndex);
				global.navlock=false;
				return;
			}else{
				global.navlock=false;
				return;
			}
		} else {
			var nextYIndex = curYIndex + dir;
			var navTo=(nextYIndex+1)*4;
			var sizeCont=curCon.size();
			
			if(sizeCont<navTo){
				var minus=navTo-sizeCont;
				if(curXIndex>(3-minus))	curXIndex=3-minus;
			}
			itemToFoc = curCon.item("icon_"+(curXIndex)+"_"+nextYIndex);
			if(itemToFoc!=null)	itemToFoc.focus();
			else curXIndex=global.curXIndex;
			itemToFoc.focus();
			
		}
		if(itemToFoc.name!=null){
			global.curYIndex = curYIndex + dir;
		}
		
		if(global.curYIndex < 0){
			global.curYIndex = 0;
		}
		global.curXIndex = curXIndex;
		
	}
	global.navlock=false;
}
}

function writePanelData(fileToOutput, dataToOutput)
{	
	
	var outputStr = "<items>\n";
	//connector.write(outputFile, '<items>\n');
		
	for(var i=0; i < dataToOutput.size(); i++)
	{
		var name;
		var onclick;
		var datOut = dataToOutput.item(i);
		if(datOut != null && datOut.text != "Add"){
			
			if(datOut.text == null){
				name= datOut.name;
			}else{
				name= datOut.text;
			}
			onclick = datOut.onclick;
			var toWrite = '\t<icon name="'+ stringparser.xmlencode(name) + '" onclick="' + stringparser.xmlencode(onclick);
			if(dataToOutput.item(i).icon != null)
			{
				toWrite += '" image="' + datOut.icon;
			}else if(datOut.image != null){
				toWrite += '" image="' + datOut.image;
			}
			if(dataToOutput.item(i).text == null)
			{
				toWrite += '" widgetName="' + datOut.widgetName;
			}else{
				//sw
				var focusStr = datOut.onfocus;
				var lngth = focusStr.length() - 50;
				var widgetName = focusStr.substr(48,lngth);
				
				//widgetName = 
				toWrite += '" widgetName="' +stringparser.xmlencode(widgetName);
			}
			toWrite += '" />\n';
			//connector.write(outputFile, toWrite, true);
			outputStr += toWrite;
		}
	}
	outputStr += "</items>";
	device.deletefile(fileToOutput);
	var outputFile = connector.open("file://" + fileToOutput);
	
	connector.write(outputFile, outputStr);
	connector.close(outputFile);
}

function getpanelOverFlow(pnl){
	var overFlows = new Array();
	overFlows[1] = new Array(1,2,3);
	overFlows[2] = new Array(2,3,1);
	overFlows[3] = new Array(3,2,1);

	for(var i = 0; i < 3; i++){
		var pnlNum = overFlows[pnl][i];
		var returnPanel = ui.panels.item("p" + pnlNum);
		if(returnPanel.size() < 12 || returnPanel.item(12).text == "Add"){
			return overFlows[pnl][i];
		}
	} 
}

function returnBystander(){
	if(global.bystander == null){
		return;
	}
	
	global.bystander.homePanel = getpanelOverFlow(global.bystander.homePanel);
	var returnPanel = ui.panels.item("p" + global.bystander.homePanel);
	
	if(returnPanel.item(returnPanel.size() - 1).text != "Add"){
		returnPanel.add((returnPanel.size()),global.bystander.target);
	}else{
		returnPanel.add((returnPanel.size() - 1),global.bystander.target);
	}
	positionPanel(returnPanel, (returnPanel.size() - 2), 11);
	global.bystander = null;
}

function cancelMoveShortcut(){
	global.moveShortcut=0;
	
	var targetItem = ui.panels.item("p"+global.curPanel).item(global.movIndex);
	targetItem.selectedbgimage = "img/textLabel_Focus.png";
	targetItem.onclick = global.funcHolder;	
 	ui.panels.item("p" + global.curPanel).remove(global.movIndex);
	
	
	returnBystander();
		
 	if(global.movStart.panelNum != global.curPanel){
 		positionPanel(ui.panels.item("p" + global.curPanel), 0, 12);
 		global.curPanel = global.movStart.panelNum;
 	} 

	global.movStart.panel.add(global.movStart.index, targetItem);
	
	var curSize = ui.panels.item("p" + global.curPanel).size();
	if(ui.panels.item("p" + global.curPanel).item(curSize-1).text!="Add"){
		finalisePanel(ui.panels.item("p" + global.curPanel));
	}

 	
	
	positionPanel(global.movStart.panel, 0, 12);
	
	var lsk = buildSkLabelObj("Options", "doLsk();");
	var rsk = buildSkLabelObj("Back", "doRsk();");
	var msk = buildSkLabelObj("Select", "if(!global.manSync)navigator.executefocused();");
	fillSkLabels(lsk, rsk, msk);
	global.curXIndex=global.moveStartXIndex;
	global.curYIndex = global.moveStartYIndex;
	
	var itemToFoc = global.movStart.panel.item(global.movStart.index);
	itemToFoc.focus();
	
	ui.panelsVStatic.panelIndicator.src = "/CA/img/msk_pagination0"+ global.movStart.panelNum +".png";
	global.movStart = null;
	ui.cKey.keycode = -8;
	
	for(var i=1;i<=3;i++){
		if(i != global.curPanel){
			finalisePanel(ui.panels.item('p'+i));
		}
	}
	
}

function confirmMoveShortcut(){
	var initialPanel = global.curPanel;
	global.moveShortcut=0;
	var targetItem = ui.panels.item("p"+initialPanel).item(global.movIndex);
	targetItem.selectedbgimage = "img/textLabel_Focus.png";
	targetItem.onclick = global.funcHolder;
	
	if(global.bystander != null){
		returnBystander();
	}else{
		global.bystander = null;
	}
	if(global.highlightInUse==true)	ui.panels.textHighlight.visible=true;
	
	//var curObj
	updateMyFoc(targetItem);
	
	finalisePanel(ui.panels.item("p"+initialPanel));
	var lsk = buildSkLabelObj("Options", "doLsk();");
	var rsk = buildSkLabelObj("Back", "doRsk();");
	var msk = buildSkLabelObj("Select", "if(!global.manSync)navigator.executefocused();");
	fillSkLabels(lsk, rsk, msk);
	ui.cKey.keycode = -8;
	for(var i=1;i<=3;i++){
		if(i != initialPanel){
			finalisePanel(ui.panels.item('p'+i));
		}
		writePanelData('/CA/var/iconsPanel'+ i + '.xml',ui.panels.item('p'+i));
	}
}
function removeShortcut(){
	if(global.skMenuActive==1){
		cancelSkMenu();
	}
	
	var curPan = ui.panels.item("p"+global.curPanel);
	var index = global.curYIndex * 4 + global.curXIndex;
	var lastItem = curPan.size()-1;
	var message = "default";
	var iconName = curPan.item(index).text;
	if(iconName == "Add"){
		return;
	}
	var tmpStr = global.widgetName;
	if(tmpStr == null || tmpStr == "" || tmpStr == "null"){
		message = "Are you sure you want to remove the shortcut to "+iconName+"?";
		displayNote(message, "q", "", "Cancel", "Remove", "doMsk();");
	}else{
		global.pageVars.curWidgetObject = grabWidgetInfo(global.widgetName);
		if(global.pageVars.curWidgetObject.billingInfo == "bill")
		{
			message = "Are you sure you want to unsubscribe from "+iconName+"? You will continue to have access until your subscription expires.";	
			displayNote(message, "q", "", "Cancel", "OK", "doMsk();");
		}
		else
		{
			message = "Are you sure you want to remove "+iconName+"? This will remove the widget and delete any of its data.";	
			displayNote(message, "q", "", "Cancel", "Remove", "doMsk();");
		}
		
	}
	global.removePrompt=1;
}
function confirmRemoveShortcut(){
	
	var curPan = ui.panels.item("p"+global.curPanel);
	var index = global.curYIndex * 4 + global.curXIndex;
	var lastItem = curPan.size()-1;

	global.indexToRemove = index;
	var tmpStr = ""+global.widgetName;
	if(tmpStr == null || tmpStr == "" || tmpStr == "null"){
		ui.cKey.keycode="-8";
		removeShortcutFromPanel(index, curPan);
	}else{
		
		removeSubscribedWidget(global.widgetName);
	}
}

function removeSubscribedWidget(widgetName){
	var widgetRoot = chRoot().widgetPath;
	chRoot().item(widgetRoot).item(widgetName).unsubscribe();
	//now commit the change
	global.syncType = "removeWidgetFromIdle";
	global.striplets=null;
	ui.cKey.keycode="99";
	subscribeSync("Now Removing " + widgetName + ". Please wait");
	
}

function finishRemoveWidgetSync(){
	global.pageVars.curWidgetObject = null;
	//navigator.refresh();
	var curPan = ui.panels.item("p"+global.curPanel);
	//window.alert(global.indexToRemove + " " + global.curPanel);
	ui.updatePopup.visible = 0;
	ui.updatePopup.updateContents.progressIndicator.w = 10;
	window.clearinterval(global.animateDotsObj);
	removeShortcutFromPanel(global.indexToRemove, curPan);
	ui.curtain.visible = 0;
	var lsk = buildSkLabelObj("Options", "doLsk();");
	var rsk = buildSkLabelObj("Back", "doRsk();");
	var msk = buildSkLabelObj("Select", "if(!global.manSync)navigator.executefocused();");
	fillSkLabels(lsk, rsk, msk);
	//now update the striplet data
	ui.cKey.keycode="-8";
	global.striplets=null;
	loadStriplets();
}
function removeShortcutFromPanel(index, curPan){
	event(302,curPan.item(index).text);
	curPan.remove(index);
	finalisePanel(curPan);
	curPan.item(index).focus();
	writePanelData('/CA/var/iconsPanel'+ global.curPanel + '.xml', curPan);
}

function swapIcons(curPan, dir, curXIndex, curYIndex, samePanel){
	var index = global.curYIndex * 4 + global.curXIndex + dir;
	cascadeSwapIcons(curPan, global.movIndex, index);
}

function positionPanel(panel, from, to){
	var row = from/4;
	var col = from % 4;
	var curItem;
	
	var xOffset=4;
	if(panel==1){
		xOffset=6;
	}else if(panel==3){
		xOffset=2;
	}
	
	
	for(var i=from; i<=to; row++){
		for(; col < 4 && i<=to; col++){
			curItem = panel.item(i);
			curItem.x = (58 * col)+xOffset;;
			curItem.y= (60 * row)+29;
			i++;
		}
		col = 0;
	}
	if(panel.item(12).text == "Add"){
		panel.remove(12);
	}
}

function finalisePanel(panel){
	var row = 0;
	var curItem;
	if(panel.size() < 12 && panel.item(panel.size()-1).text != "Add"){
		//need to add an 'add' icon
		var addObj = new Object();
		addObj.name = "Add";
		addObj.onclick="gotoCatalogue();";
		addObj.image="/CA/img/tile_add_unfocused.png";
		
		var iconToAdd = buildIcon(addObj);
		iconToAdd.name = "icon_"+col+"_"+row;
		iconToAdd.x = 180;
		iconToAdd.y = 149;
	
		iconToAdd.leftnavigation="horizNav(-1, "+col+", "+row+");";
		iconToAdd.rightnavigation="horizNav(1, "+col+", "+row+");";
		iconToAdd.upnavigation="vertNav(-1, "+col+", "+row+");";
		iconToAdd.downnavigation="vertNav(1, "+col+", "+row+");";
		iconToAdd.onfocus = "focusSection('panelsAdd', this);";
		panel.add(iconToAdd);
	}
	if(panel.size() > 12){
		panel.remove(panel.size()-1);
	}
	
	var xOffset=4;
	if(screen==1){
		xOffset=6;
	}else if(screen==3){
		xOffset=2;
	}
	
	for(var i=0; i<panel.size(); row++){
		for(var col=0; col < 4 && i<panel.size(); col++){
		
			curItem = panel.item(i);
			curItem.x = (58 * col)+xOffset;
			curItem.y= (60 * row) + 29;
			curItem.name = "icon_"+col+"_"+row;
			curItem.leftnavigation="horizNav(-1, "+col+", "+row+");";
			curItem.rightnavigation="horizNav(1, "+col+", "+row+");";
			curItem.upnavigation="vertNav(-1, "+col+", "+row+");";
			curItem.downnavigation="vertNav(1, "+col+", "+row+");";
			i++;
		}
	}
}


function cascadeSwapIcons(curPan, fromIndex, toIndex){
	var tempObj = curPan.item(fromIndex);
	curPan.remove(fromIndex);
	curPan.add(toIndex, tempObj);
	global.movIndex = toIndex;
	global.curXIndex = toIndex % 4;
	global.curYIndex = toIndex/4; 
	tempObj.focus();
	if(fromIndex < toIndex){
		positionPanel(curPan, fromIndex, toIndex);
	}else{
		positionPanel(curPan, toIndex, fromIndex);
	}	
}

function horizNav(dir, curXIndex, curYIndex){
if(!global.navlock){
	global.navlock=true;

	var itemToFoc;
	var nextXIndex = curXIndex + dir;
	var panel = global.curPanel + dir;

	var curCon = ui.panels.item("p"+global.curPanel);
	itemToFoc = curCon.item("icon_"+(nextXIndex)+"_"+curYIndex);

	if(global.moveShortcut!=1){
		if(!(global.curPanel == 1 && nextXIndex < 0) && !(global.curPanel == 3 && nextXIndex > 3))
		{
			global.curXIndex = nextXIndex;
		}		
		if(itemToFoc == null && panel > 0 && panel < 4){  //Moving to another panel
			itemToFoc = getPanelItem(panel, curYIndex, nextXIndex, false);
		}
		global.curSection='panels';
		itemToFoc.focus();
	}else if(global.curSection == 'panels' || global.curSection == 'panelsAdd'){
		global.curSection='_moving';
		curXIndex = (global.movIndex % 4 ) + dir;
		curYIndex = global.movIndex/4;
		
		if(curXIndex < 0 || curXIndex > 3){
			itemToFoc = null;
		}else{
			itemToFoc = curCon.item((curYIndex * 4)+ curXIndex);
		}

		if(itemToFoc.text == "Add"){
			itemToFoc = null;
		}

		if(itemToFoc == null && panel > 0 && panel < 4){  //Moving to another panel
			var destPanel = ui.panels.item("p" + panel);
			var panelSize = destPanel.size();

			var tempObj = curCon.item(global.movIndex);
			curCon.remove(global.movIndex);
			var destIndex = getPanelItem(panel, curYIndex, curXIndex, true);
			if(curYIndex==2 && curXIndex==-1 && panelSize==11 && destPanel.item(10).text != "Add"){ destIndex++; global.curXIndex++;}
			destPanel.add(destIndex, tempObj);
			global.movIndex = destIndex;
			
			if(destPanel.size() == 13 && destPanel.item(12).text != "Add"){
				if(global.bystander != null){
					returnBystander();
				}
				
				//Overflow Panel needs to be calculated
				global.bystander = new Object();
				global.bystander.target = destPanel.item(destPanel.size()-1);
				global.bystander.homePanel = panel;
				
				destPanel.remove(destPanel.size()-1);
			}
			
			positionPanel(destPanel, 0 , destPanel.size());
			positionPanel(curCon, 0 , curCon.size());
			
			destPanel.item(destIndex).focus();
			global.curSection='panels';
		}else{
			if(itemToFoc != null){
				swapIcons(curCon, dir, curXIndex, curYIndex, 'false');
			}else{
				global.curSection='panels';
				global.navlock=false;
				return;
			}
		}
		global.curSection='panels';
// 		itemToFoc.focus();
	}
	global.navlock=false;
}
}
function focusDock(str, index){
	ui.dock.dockFocusImg.visible=1;
	ui.dock.dockFocus.text = str;
	//hardcoded values of highlighted graphics in dock
	var pos = new Array(4, 49, 92, 146, 197);
	var posImg = new Array(-9, 39, 87, 135, 183);
	ui.dock.dockFocus.x = pos[index];
	var dockGraphic = "dockTextlabel_Focus.png";
	
	if(index==0){
	//	dockGraphic = "dockTextLabel_lhs_Focus.png";
	}else if(index==4){
	//	dockGraphic = "dockTextLabel_rhs_Focus.png";
	}
	
	ui.dock.dockFocusImg.src="/CA/img/"+dockGraphic;
	ui.dock.dockFocusImg.x=posImg[index];
	ui.dock.dockFocus.text = str;
	global.dockIndexFoc = index;
}
function blurDock(){
	ui.dock.dockFocus.text = "";
	ui.dock.dockFocusImg.visible=0;
}
function popupSearch(){
	global.searchActive=1;
	var searchCon = ui.item("searchWindow");
	ui.cKey.keycode = 99;
	
 	if(searchCon.item('searchEntry') == null){
	 	var inputBox = new Input();
 		inputBox.name="searchEntry";
 		inputBox.upnavigation="";
 		inputBox.x="37";
 		inputBox.y="36";
 		inputBox.h="20";
 		inputBox.w="156";
 		inputBox.onchange="changeInputBox(this);";
 		inputBox.bordercolor="##ffffff";
 		inputBox.cursorlocation="before";
 		inputBox.highlightletter="true";
 		inputBox.cyclekey="true";
 		inputBox.maxchars="100";
 		inputBox.value="";
 		inputBox.onclick="submitSearchInput();";
	 	searchCon.add(inputBox);
	}else{
		ui.searchWindow.searchEntry.value="";
	}
 	ui.idle=false;
 	ui.fullscreen=false;
 	ui.searchWindow.visible=1;
	
 	ui.searchWindow.searchEntry.focus();

	var lsk = buildSkLabelObj("", "");
	var rsk = buildSkLabelObj("Cancel", "cancelSearchInput();");
	var msk = buildSkLabelObj("", "submitSearchInput();");
	fillSkLabels(lsk, rsk, msk);

 	
}

function submitSearchInput(){
	var inputValue = ui.searchWindow.searchEntry.value;
	var inputValueLength = inputValue.length();
	if(inputValueLength>0){
		event(107,"Search");
		cancelSearchInput();
		ui.searchWindow.remove('searchEntry');
		wap("http://au.m2.yahoo.com/r/sensis/search/telstra?p="+inputValue);
	}
	ui.cKey.keycode = -8;
}

function changeInputBox(obj){
	//ui.dBug.text = obj.value.length();
	var curLength = obj.value.length();
	var msk;
	if(curLength==0){
		msk = buildSkLabelObj("", "submitSearchInput();");
		var lsk = buildSkLabelObj("", "");
		var rsk = buildSkLabelObj("Cancel", "cancelSearchInput();");
	//var msk = buildSkLabelObj("Search", "submitSearchInput();");
		fillSkLabels(lsk, rsk, msk);
	}else if(curLength==1){
		msk = buildSkLabelObj("Search", "submitSearchInput();");
		var lsk = buildSkLabelObj("", "");
		var rsk = buildSkLabelObj("Cancel", "cancelSearchInput();");
		fillSkLabels(lsk, rsk, msk);
	}
	
	
}
function cancelSearchInput(){
	global.searchActive=0;
	ui.idle=1;
	ui.searchWindow.visible=0;
	ui.searchWindow.remove('searchEntry');
	ui.cKey.keycode = -8;
	
	ui.dock.focus();
	var lsk = buildSkLabelObj("Options", "doLsk();");
	var rsk = buildSkLabelObj("Menu", "doRsk();");
	var msk = buildSkLabelObj("Select", "navigator.executefocused();");
	fillSkLabels(lsk, rsk, msk);
}
function updateTime() {
	ui.dock.timelabel.text = stringparser.formattime("h:mm");
	ui.dock.datelabel.text = stringparser.formattime("dd-MMM-yyyy");
	
	ui.dock.opnamelabel.text = getOperatorName();
	ui.dock.celllabel.text = "";
	ui.dock.alarmlabel.text = device.getsystemproperty("com.sonyericsson.active_alarm");
	
	if(ui.dock.alarmlabel.text == null || ui.dock.alarmlabel.text == ""){
		ui.dock.alarmicon.visible = false;
	}else{
		ui.dock.alarmicon.visible = true;
	}
}
function resetUpdateTime(){
	var timeleft = 60 - stringparser.parseint(stringparser.formattime("ss"));
	if(global.updateTimerService != null){
		window.clearinterval(global.updateTimerService);
	}
   	window.settimeout("updateTime(); global.updateTimerService = window.setinterval('updateTime();',60000);", timeleft*1000);

	if(global.stripletUpdateService != null){
		window.clearinterval(global.stripletUpdateService);
	}		
	global.stripletUpdateService = window.setinterval("updateStripletData();", 15000);
	updateStripletData();
}

function getOperatorName(){
    var opname = null;
    if(device.getsystemproperty("com.sonyericsson.net.rat") == null){
    	opname = "Flight Mode";
    }else if(device.getsystemproperty("com.sonyericsson.net.cellid") != null && device.getsystemproperty("com.sonyericsson.net.status") == "No Network"){
//     	opname = "Inactive SIM";
    	opname = "Emergency\nCalls Only";
    }else if(device.getsystemproperty("com.sonyericsson.net.status") == "Forbidden"){
    	opname = "Emergency\nCalls Only";
    }else{
    	opname = device.getsystemproperty("com.sonyericsson.net.networkname");
    }
    if (opname == null || opname=="") {
       opname = device.getsystemproperty("com.sonyericsson.net.serviceprovider");
    }
	if (opname == null || opname=="") {
    	opname = "No Network";
    }
    return opname;
}

function loadStriplets(){
	if(global.widgetDS == null){
		global.widgetDS = new Collection();
	}
	ui.stripletItems.remove('widget');
	window.clearinterval(global.stripletUpdateService);
	global.totalStriplets = 0;
	global.visibleStriplets = 0;
	if(global.striplets == null){
		global.striplets = true;
		
		var widgetList = new List();
		widgetList.name = "widget";
		widgetList.scrollsmooth=2;
		widgetList.drawscrollbar = true;
		widgetList.scrollbarcolor=0xffffff;
		widgetList.scrollbarbgcolor=0x0;
			//height of scrollable container with striplets
		widgetList.h=ui.h-global.bodyY-ui.stripletItems.fixed.h - 3;
		widgetList.w=240;
		widgetList.focusable='false';

		var stripletOrder = stringparser.parsexmlfile("/CA/var/stripletConfig.xml");
		var rootXmlObj = chRoot();	
		if(rootXmlObj == null || rootXmlObj.widgetPath == null){
			global.striplets = null;
			return;
		}
		var widgetObj = rootXmlObj.item(rootXmlObj.widgetPath);
		if(widgetObj == null){
			global.striplets = null;
			return;
		}
		
		var widgetPathRoot = '/CH/'+rootXmlObj.name+'/'+widgetObj.name+'/';
		var stripletctr = 0;
		
		var totalWidgets = widgetObj.size();
		
		if(stripletOrder != null){		
			for(var i=0; i<stripletOrder.size(); i++){
				var widgetName = stripletOrder.item(i).name;
				var widget = widgetObj.item(widgetName);
				var UIPath = widgetPathRoot + widgetName + '/idleui.xml';
				if(widget == null || !device.fileexists(UIPath)){
					stripletOrder.remove(i);
					i--;
				}else if(stripletOrder.item(i).visible){
					global.visibleStriplets++;
					
					global.currentWidget = widget;
					global.WidgetPath = widgetPathRoot + widget.name;
					if(global.widgetDS.item(widget.name) == null){
						global.widgetDataObject = new Object();
						global.widgetDataObject.name = widget.name;
						global.widgetDS.add(global.widgetDataObject);
					}else{
						global.widgetDataObject = global.widgetDS.item(widget.name);
					}
					var stripletContents = stringparser.preprocessxmlfile(UIPath);
					if(stripletContents != null){
						var stripletToAdd = new Container();
						stripletToAdd.add(stripletContents);
						stripletToAdd.name = widget.name;
						stripletToAdd.focus="global.movIndex = " + stripletctr;
						stripletctr++;
						widgetList.add(stripletToAdd);
	
						widgetList.focusable='true';
					}
				}
			}
		}
	
		for(var i=0; i<widgetObj.length; i++){
			var widget = widgetObj.item(i);
			var UIPath = widgetPathRoot + widget.name + '/idleui.xml';
			//only increment if the striplet is present
			if(device.fileexists(UIPath))global.totalStriplets++;
			
			if(device.fileexists(UIPath) && stripletOrder.item(widget.name) == null){
				global.visibleStriplets++;

				
				global.currentWidget = widget;
				global.WidgetPath = widgetPathRoot + widget.name;

				if(global.widgetDS.item(widget.name) == null){
					global.widgetDataObject = new Object();
					global.widgetDataObject.name = widget.name;
					global.widgetDS.add(global.widgetDataObject);
				}else{
					global.widgetDataObject = global.widgetDS.item(widget.name);
				}

				var stripletContents = stringparser.preprocessxmlfile(UIPath);
				if(stripletContents != null){
					var stripletToAdd = new Container();
					stripletToAdd.add(stripletContents);
					stripletToAdd.name = widget.name;
					stripletToAdd.focus="global.movIndex = " + stripletctr;
					stripletctr++;
					widgetList.add(stripletToAdd);
	
					var striplet = new Object();
					striplet.name = widget.name;
					striplet.visible = true;
					stripletOrder.add(striplet);
					widgetList.focusable='true';
				}
			}
		}
		
		global.striplets = widgetList;
		
		ui.stripletItems.add(widgetList);
		
		writeStripletXMLObj(stripletOrder);
	}else{
		ui.stripletItems.add(global.striplets);
	}
}

function updateStripletData(){
	var rootXmlObj = chRoot();	

	if(rootXmlObj.widgetPath == null || rootXmlObj == null){
		global.striplets = null;
		return;
	}

	var widgetObj = rootXmlObj.item(rootXmlObj.widgetPath);

	if(widgetObj == null){
		global.striplets = null;
		return;
	}
	
	var widgetPathRoot = '/CH/'+rootXmlObj.name+'/'+widgetObj.name+'/';
	
	var widgetList = ui.stripletItems.item('widget');
	var totalWidgets = widgetList.size();
	//go through the channels and determine if they have include files for idle (striplet integration)
	for(var i=0; i<totalWidgets; i++){
		var striplet = widgetList.item(i);
		var widget = widgetObj.item(striplet.name);
		var UIPath = widgetPathRoot + widget.name;
		
		document.flushfunction("updateWidget");
			
		stringparser.evalurl(UIPath + "/update.js");
		var dataStore = global.widgetDS.item(widget.name);

		updateWidget(striplet, UIPath, widget, dataStore);		
	}
}
function switchToggle(){
	var lsk = buildSkLabelObj("Done", "confirmStriplets();");
	var rsk = buildSkLabelObj("Cancel", "doRsk();");
	var msk = buildSkLabelObj("Select", "navigator.executefocused();");
	fillSkLabels(lsk, rsk, msk);
	global.changeStriplets=true;
}

function configureStriplets(){
	cancelSkMenu();
	global.manageStriplets=1;
	global.changeStriplets=false;
	//hideNote("Done", "Cancel", "Select");
	var lsk = buildSkLabelObj("", "");
	var rsk = buildSkLabelObj("Cancel", "doRsk();");
	var msk = buildSkLabelObj("Select", "navigator.executefocused();switchToggle();");
	fillSkLabels(lsk, rsk, msk);
	
	ui.hiddenStriplets.visible=1;
	var listCon = new List();
		listCon.w = 238;
			//height of show hidden striplet popup 
		listCon.h = 76;
		listCon.y = 60;
		listCon.wrap=true;
		listCon.name="listCon";
		listCon.scrollsmooth=2;
		//listCon.scrollable=true;
		//listCon.autoscroll=true;
		listCon.drawscrollbar = true;
		listCon.scrollbarcolor=0xffffff;
		listCon.scrollbarbgcolor=0x0;
	
	var rootXmlObj = chRoot();	
	var xmlObj = rootXmlObj.item(rootXmlObj.widgetPath);
	
	//ui.dBug.text = "rootXmlObj: " + rootXmlObj.name;
	//ui.dBug.text += "\nxmlObj: " + xmlObj.name;
	
	var widgetPathRoot = '/CH/'+rootXmlObj.name+'/'+xmlObj.name+'/';
	
	//var widgetPathRoot = '/CH/'+rootXmlObj.name+'/'+xmlObj+'/';
	
	var stripletOrder = stringparser.parsexmlfile("var/stripletConfig.xml");
	var totalWidgets = xmlObj.length;
	
	//go through the channels and determine if they have include files for idle (striplet integration)
	global.numselected=0;
	for(var n=0; n<totalWidgets; n++){
		
		var widgetName = xmlObj.item(n).name;
		var UIPath = widgetPathRoot + widgetName + '/idleui.xml';
		var fileExists = device.fileexists(UIPath);
	
		if(fileExists==true){
			//output in list
			var listBtn = new Button();
				listBtn.text = xmlObj.item(n).friendlyName;//needs to be friendly name
				listBtn.name = xmlObj.item(n).name;
				listBtn.bgimage = "/CA/img/List_sm_btn_unfocused.png";
				listBtn.selectedbgimage = "/CA/img/List_sm_btn_focused.png";
				
				listBtn.icon = "/CA/img/List_sm_checkbox_on.png";
				listBtn.checked = true;
				listBtn.font="/CA/fonts/regular_white.bf2";
				listBtn.selectedfont="/CA/fonts/regular_black.bf2";
				listBtn.onclick="toggleCheckBox(this);switchToggle();";
				listBtn.h = 26;
				listBtn.w = 230;
				
				for(var p=0; p<stripletOrder.length; p++){
					if(widgetName==stripletOrder.item(p).name && stripletOrder.item(p).visible=="false"){
						listBtn.icon = "/CA/img/List_sm_checkbox_off.png";
						listBtn.checked = false;
					}
				}
			listCon.add(listBtn);
		}
	}
	ui.hiddenStriplets.add(listCon);
	ui.hiddenStriplets.listCon.focus();
}
function toggleCheckBox(obj){
	global.numselected=1;
	if(obj.checked==true){
		obj.checked=false;
		obj.icon = "/CA/img/List_sm_checkbox_off.png";		
	}else{
		obj.checked=true;
		obj.icon = "/CA/img/List_sm_checkbox_on.png";
	}
	/*
	if(global.numselected==0){
		hideNote("", "Cancel", "Select");	
	}else{
		hideNote("Done", "Cancel", "Select");
	}
	*/
}

function confirmStriplets(){
//if(global.changeStriplets==true){
	global.manageStriplets=0;
	var lsk = buildSkLabelObj("Options", "doLsk();");
	var rsk = buildSkLabelObj("Menu", "doRsk();");
	var msk = buildSkLabelObj("Select", "navigator.executefocused();");
	fillSkLabels(lsk, rsk, msk);
	
	var stripletVisibleArray = getStripletVisiblity();
	writeStripletXML(stripletVisibleArray);
	
	ui.hiddenStriplets.visible=0;
	//ui.stripletItems.focus();
	//remove the popup for removal of widgets
	ui.hiddenStriplets.remove("listCon");
 	
	global.striplets = null;
	
	if(ui.stripletItems.widget.size()>0){
		ui.stripletItems.widget.focusable=1;
	}else{
		ui.stripletItems.widget.focusable=0;
	}
	//if item zero exists, set focus to that object
	if(global.curSection=="dock"){
		ui.dock.focus();
	}else{
		ui.dock.focus();
		//ui.stripletItems.focus();	
	}
	loadStriplets();
//}
}
function writeStripletXML(data){
	var theFile = '/CA/var/stripletConfig.xml';
	var outputFile = connector.open("file://" + theFile);
	connector.write(outputFile, '<items>\n');
	var str = "<items>\n";
	for(var n=0; n<data.length; n++){
		str += '    <icon name="'+data[n]+'" visible="'+data[n+1]+'"/>\n';
		n=n+1;
	}
	str += "</items>";
	
	connector.write(outputFile, str);
	connector.close(outputFile);
}

function writeStripletXMLObj(data){
	var theFile = '/CA/var/stripletConfig.xml';
	var outputFile = connector.open("file://" + theFile);
	connector.write(outputFile, '<items>\n');
	var str = "<items>\n";
	if(data != null)
	{
		for(var n=0; n<data.size(); n++)
		{	
			str += '    <icon name="'+data.item(n).name+'" visible="'+data.item(n).visible+'"/>\n';
		}
	}	
	str += "</items>";
	connector.write(outputFile, str);
	connector.close(outputFile);
}


function getStripletVisiblity(){
	var objArray = new Array();
	
	var listLength = ui.hiddenStriplets.listCon.size();
	var rootXmlObj = chRoot();	
	var xmlObj = rootXmlObj.item(0);
	var widgetPathRoot = '/CH/'+rootXmlObj.name+'/'+xmlObj.name+'/';
	//global.totalStriplets=0;
	//go through the channels and determine if they have include files for idle (striplet integration)
	var arrayIndex=0;
	var listIndex=0;
	for(var n=0; n<listLength; n++){
		var curObj = ui.hiddenStriplets.listCon.item(n);
		
		var checkFlag = curObj.checked;
		if(checkFlag==null)checkFlag="false";

		objArray[arrayIndex] = curObj.name;
		objArray[arrayIndex+1] = checkFlag;
		
		//var UIPath = widgetPathRoot + widgetName + '/idleui.xml';
		//var fileExists = device.fileexists(UIPath);
		//listIndex++;
		arrayIndex+=2;
		
	}
	return objArray;
}

function cancelStriplets(){
	global.manageStriplets=0;
	//fillSkLabels("Options", "Menu");
	var lsk = buildSkLabelObj("Options", "doLsk();");
	var rsk = buildSkLabelObj("Menu", "doRsk();");
	var msk = buildSkLabelObj("Select", "navigator.executefocused();");
	fillSkLabels(lsk, rsk, msk);
	
	//window.alert(ui.stripletItems.size());
	
	if(global.curSection=="dock"){
		ui.dock.focus();
	}else{
		ui.stripletItems.focus();
	}
	
	ui.hiddenStriplets.visible=0;
	ui.hiddenStriplets.remove("listCon");
}

function focusSection(section, obj){
	
	global.curSection = section;
	if(section=='dock'){
		global.skmState = global.skmState_idle_1;
	}else if(section=='panels'){
		updateMyFoc(obj);
		global.skmState = global.skmState_idle_2;
	}else if(section=='panelsAdd'){
		updateMyFoc(obj);
		global.skmState = global.skmState_idle_2add;
		global.curSection = "panels";
	}else if(section=='striplets'){
		global.skmState = global.skmState_idle_3;
	}
}

function hideStriplet(){
	cancelSkMenu();
	//hard coded for one item, currenly
	var focStriplet = global.lastFocItem.split('.');
	var stripletToHide = focStriplet[3];
	var stripletOrder = stringparser.parsexmlfile("var/stripletConfig.xml");
	var totStriplets = 	stripletOrder.size();
	var parentCon = ui.stripletItems.widget.item(stripletToHide);
	
	var visStriplets=ui.stripletItems.widget.size();
	var data = new Array();
	var n=0;
	var listObj;
	for(var p=0; p<totStriplets; p++){
		var widgetName = stripletOrder.item(p).name;
		var widgetVisible = stripletOrder.item(p).visible;
		data[n] = widgetName;
		n++;
		data[n] = widgetVisible;
		if(widgetName==stripletToHide)data[n] = "false";
		n++;
	}
	writeStripletXML(data);
	
	ui.stripletItems.widget.remove(stripletToHide);
	
	if(ui.stripletItems.widget.size()>0){
		ui.stripletItems.widget.focus();
	}else{
		ui.dock.focus();
	}
	global.visibleStriplets=ui.stripletItems.widget.size();
	global.striplets=null;
}

//////////////////////////////////////////////////////////////////////////////////////////////
//syncinc.xml
logNow("Parsing Syncinc start");
function blurWidget()
{
  	ui.addCont.blur();
	ui.addCont.enabled="false";
	ui.termsCont.enabled="false";
}
function subscribeSync(description)
{	
	global.syncObject = new Object();
	
	global.syncActive = true;
	global.disableKeys=1;
	global.tempKeys=0;
	ui.updatePopup.updateContents.iconPrev.src = "/CA/img/alertPanel_ico_02.png";
	
	if(device.isroaming() || device.getsystemproperty("com.sonyericsson.net.rat") == null || device.getsystemproperty("com.sonyericsson.net.status") == "No Network")
 	{
		ui.curtain.visible = 0;
		killDots();
		ui.progressInd.visible=0;
		if(device.getsystemproperty("com.sonyericsson.net.rat") == null || device.getsystemproperty("com.sonyericsson.net.status") == "No Network")
		{
			global.noNetworkFlag = true;
			displayNote('No network available','i','','Cancel', 'Retry','tempMsk();');		
		}else{
			displayNote('You are outside the Telstra 3G/NextG coverage area.  Data roaming charges will apply.','q','','Cancel', 'Continue', 'tempRsk(); startSync();');
		}
		global.disableKeys=0;
		return;
	}
	else
	{
		//cancelSkMenu();
		global.skMenuActive=0;
		ui.optionsHold.clear();
		ui.optionsHold.focusable=0;
		ui.optionsHold.yscrollpos=0;
		
		var lsk = buildSkLabelObj("", "");
		var rsk;
		//disable cancle on idle screen until a fix to make it works is found
		if(ui.h <320)
		{
			rsk = buildSkLabelObj("", "");
			global.updateUI.updatePopup.updateContents.curStatus.text = "Connecting...";
			global.updateUI.updatePopup.visible = 1;
			//global.updateUI.updatePopup.yscrollpos = 180;
			global.updateUI.updatePopup.focus();
		}
		else
		{
			global.updateUI.updatePopup.updateContents.curStatus.text = global.syncObject.description;
			rsk = buildSkLabelObj(" ", "");
			global.flashBar = window.setinterval('flashProgress();', 750);
			global.flashBarOn = 1;
			ui.progressInd.visible=1;
			ui.progressInd.focus();
			animateDots();
		}
		var msk = buildSkLabelObj("", "");
	
		fillSkLabels(lsk, rsk, msk);	
		ui.curtain.visible = 1;
	  	ui.panels.blur();
	  	ui.panels.enabled=false;
		
		global.syncObject.description = description;
		global.manSync = true;
		
		global.syncTimeout = window.settimeout('defCallBack(0,-33,0,0);',60000);
		channelmanager.commit('defCallBack');
	}
}

function standardSync(nextPage, description,syncFilter)
{
	global.syncObject = new Object();

	cancelSkMenu();
	global.syncObject.nextPage = nextPage;
	global.syncObject.description = description;
	global.syncActive = true;
	ui.updatePopup.updateContents.iconPrev.src = "/CA/img/alertPanel_ico_02.png";
 	if(device.isroaming() || device.getsystemproperty("com.sonyericsson.net.rat") == null || device.getsystemproperty("com.sonyericsson.net.status") == "No Network")
 	{
		ui.curtain.visible = 0;
		killDots();
		ui.progressInd.visible=0;
		if(device.getsystemproperty("com.sonyericsson.net.rat") == null || device.getsystemproperty("com.sonyericsson.net.status") == "No Network")
		{
			global.noNetworkFlag = true;
			displayNote('No network available','i','','Cancel', 'Retry','tempMsk();');		
		}else{
			displayNote('You are outside the Telstra 3G/NextG coverage area.  Data roaming charges will apply.','q','','Cancel', 'Continue', 'tempRsk(); startSync();');
		}
		global.disableKeys=0;
		return;
	}else{
		startSync(syncFilter);
	}
}

function cancelSync(){
 	
	sync.reset();
	//global.syncActive = false;
	global.manSync = false;
	killDots();
	global.disableKeys=0;
	ui.updatePopup.visible=0;
	ui.updatePopup.updateContents.progressInd.w=0;
	ui.progressInd.visible=0;
	ui.curtain.visible=0;
	global.tempKeys = 0;
	window.cleartimeout(global.syncTimeout);
}

function startSync(syncFilter){
	//this is called once object are drawn and inplace
	//this will be called in case of failure for whatever reason and 'retry' is selected
	global.disableKeys=1;
	global.tempKeys=0;
	global.syncActive = true;
// 	ui.updatePopup.yscrollpos = 200;
	var lsk = buildSkLabelObj("", "");
	var rsk = buildSkLabelObj("Cancel", "");
	var msk = buildSkLabelObj("", "");

	ui.rsk.onclick="doRsk();";
	
	fillSkLabels(lsk, rsk, msk);
	
	ui.curtain.visible = 1;
	global.syncType = "standard";
	global.updateUI.updatePopup.updateContents.curStatus.text = global.syncObject.description;
	global.flashBar = window.setinterval('flashProgress();', 750);
	global.flashBarOn = 1;
	
	ui.progressInd.visible=1;
	global.manSync = true;
	if(syncFilter!=null){
		sync.dosync('defCallBack',syncFilter);
	}
	else{
		sync.dosync('defCallBack');
	}
	
	global.syncTimeout = window.settimeout('defCallBack(0,-33,0,0);',60000);
	
	animateDots();
	ui.progressInd.focus();
}

function animateDots()
{
	ui.progressDots.visible=1;
	global.curDot = 1;
	global.animateDotsObj = window.setinterval('cycleDotAnimation();', 500);
}

function cycleDotAnimation()
{
	ui.progressDots.dot1.visible=0;
	ui.progressDots.dot2.visible=0;
	ui.progressDots.dot3.visible=0;
	var theDot = ui.item("dot" + global.curDot);
	theDot.visible = 1;
	if(global.curDot<3){
		global.curDot++;
	}else{
		global.curDot=1;
	}
}
function killDots()
{
	window.clearinterval(global.animateDotsObj);
	ui.progressDots.visible=0;
}

function flashProgress()
{
	ui.updatePopup.updateContents.progressIndicator.w = 10;
	if(ui.updatePopup.updateContents.progressIndicator.visible==1){
		ui.updatePopup.updateContents.progressIndicator.visible=0;
	}else{
		ui.updatePopup.updateContents.progressIndicator.visible=1;	
	}
}

function callbackUpdate(event,error,rec,tot)
{
// 	document.log('ev: ' + event + ' er : ' + error + ' rec : ' + rec + ' tot : ' + tot + 'synctype: ' + global.syncType + '\n');
	//syncType = "standard" or "subscription"
	var curPercent;
	var progressWidth;
	
	//only do majority of work if error is zero - normal case
	if(error==0)
	{
		window.cleartimeout(global.syncTimeout);
		global.syncTimeout = window.settimeout('defCallBack(0,-33,0,0);',60000);
		//only animate the progressbar when there is an update of more than 1Kb
		if(tot == 2 && event == 0){
			window.cleartimeout(global.syncTimeout);
			if(global.syncType == "standard"){
// 			ui.updatePopup.updateContents.progressIndicator.w = progressWidth;
				global.noUpdateFlag = true;
				displayNote('No update available','i','','', 'OK','tempMsk();');
				killDots();
				ui.progressInd.visible=false;
				global.syncType = "NoUpdate";
				
			}
			
		}else if(event==1)
		{

			if(tot > 0){
				if(global.syncType != "subscriptionPhase2" && global.syncType != "removeWidgetFromIdleUpdate")
				{
					progressWidth = (rec * 94) / tot;
					ui.updatePopup.updateContents.progressIndicator.w = progressWidth;
				}
				else
				{
					progressWidth = 188;
				}
			}
			if(global.flashBarOn==1)
			{
				ui.updatePopup.updateContents.progressIndicator.visible=1;
				window.clearinterval(global.flashBar);
				global.flashBarOn=0;
				killDots();
			}
			ui.progressInd.visible=0;
			//ui.updatePopup.yscrollpos = 180;
			ui.updatePopup.focus();
			if(global.syncType == "subscription" || global.syncType == "removeWidgetFromIdle")
			{
				ui.updatePopup.updateContents.iconPrev.src = 
						"/CH/" +  chRoot().name + "/" + chRoot().widgetPath + "/" +
						global.pageVars.curWidgetObject.serverName + "/preview/icon_sel.png";
				if(global.pageVars.curWidgetObject.subscribed == true)
				{
					if(global.pageVars.curWidgetObject.billingInfo == "bill")
					{
						ui.updatePopup.updateContents.curStatus.text = "Unsubscribing from " + global.pageVars.curWidgetObject.name;
					}
					else
					{
						ui.updatePopup.updateContents.curStatus.text = "Removing " + global.pageVars.curWidgetObject.name;
					}
				}
				else
				{
					if(global.pageVars.curWidgetObject.billingInfo == "bill")
					{
						ui.updatePopup.updateContents.curStatus.text = "Subscribing to " + global.pageVars.curWidgetObject.name;
					}
					else
					{
						ui.updatePopup.updateContents.curStatus.text = "Downloading " + global.pageVars.curWidgetObject.name;
					}
				}
				ui.updatePopup.visible = 1;
			}
			else
			{
				if(global.syncType == "standard")
				{
					ui.updatePopup.updateContents.curStatus.text = "Updating...";
					ui.updatePopup.visible = 1;
				}
			}
		}
		else if(event==2)
		{
			if(global.syncType == "subscription" || global.syncType == "removeWidgetFromIdle")
			{
				if(global.pageVars.curWidgetObject.subscribed == false)
				{
					ui.updatePopup.updateContents.curStatus.text = "Downloading " + global.pageVars.curWidgetObject.name;
				}
				else
				{
					ui.updatePopup.updateContents.curStatus.text = "Removing " + global.pageVars.curWidgetObject.name;
				}
			}
			else
			{
				if(global.syncType == "standard")
				{
					ui.updatePopup.updateContents.curStatus.text = "Updating...";
				}
			}
			if(tot > 0){
				if(global.syncType != "subscriptionPhase2" && global.syncType != "removeWidgetFromIdleUpdate")
				{
					progressWidth = ((rec * 94) / tot) + 94;
					ui.updatePopup.updateContents.progressIndicator.w = progressWidth;
				}
				else
				{
					progressWidth = 188;
				}
			}
		}
		else if(event==5)
		{
			window.cleartimeout(global.syncTimeout);
			global.manSync = false;
			global.chRootReload = true;
			ui.panels.enabled=true;
			deployFilesWhenReady();
			if(global.syncType == "NoUpdate"){
				global.syncType="background";
				return;
			}
			
			if(global.syncType == "removeWidgetFromIdle"){
				global.syncType = "removeWidgetFromIdleUpdate";
				global.manSync = true;
				//sw: need to clear timeout before re-creating one.
				//sw: test needs verification
				window.cleartimeout(global.syncTimeout);
				global.syncTimeout = window.settimeout('defCallBack(0,-33,0,0);',60000);
				sync.dosync("defCallBack");
			}
			else if(global.syncType == "removeWidgetFromIdleUpdate")
			{
				ui.updatePopup.updateContents.curStatus.text = "Update Complete - Please Wait";
				ui.updatePopup.updateContents.progressIndicator.w = 188;
				ui.updatePopup.visible = 0;
				//ui.updatePopup.yscrollpos = 0;
				//ui.updatePopup.updateContents.progressIndicator.w = 188;
				//ui.updatePopup.updateContents.curStatus.text = "Update Complete - Please Wait";
				global.disableKeys=0;
				global.globalCont = null;
				var nextPage = global.syncObject.nextPage;
				global.syncObject = null;
				var curTime = device.gettime();
				var lastUpdateStr = stringparser.formattime("h:mmaa dd/MM/yyyy");
				device.setappproperty('lastHeartbeat', curTime);
				device.setappproperty('lastHeartbeatStr', lastUpdateStr);
				global.syncType = "background";
				global.manSync = false;
				global.syncActive = false;
				ui.cKey.keycode="-8";
				finishRemoveWidgetSync();
				loadStriplets();
			}
			else if(global.syncType == "subscription")
			{
				global.syncType = "subscriptionPhase2";
				global.manSync = true;
				//sw: need to clear timeout before re-creating one.
				//sw: test needs verification
				window.cleartimeout(global.syncTimeout);
				global.syncTimeout = window.settimeout('defCallBack(0,-33,0,0);',60000);
				sync.dosync("defCallBack");
			}
			else if(global.syncType == "subscriptionPhase2")
			{
				ui.updatePopup.updateContents.curStatus.text = "Update Complete - Please Wait";
				ui.updatePopup.updateContents.progressIndicator.w = 188;
				global.syncSuccessFlag = 1;
				global.disableKeys=0;
				global.globalCont = null;
				global.syncObject = null;
				var curTime = device.gettime();
				var lastUpdateStr = stringparser.formattime("h:mmaa dd/MM/yyyy");
				device.setappproperty('lastHeartbeat', curTime);
				device.setappproperty('lastHeartbeatStr', lastUpdateStr);
				global.syncType = "background";
				global.manSync = false;
				global.syncActive = false;
				finishSubscribe();
			}	
			else{
				ui.updatePopup.updateContents.progressIndicator.w = 188;
				ui.updatePopup.updateContents.curStatus.text = "Update Complete - Please Wait";
				global.disableKeys=0;
				global.globalCont = null;
				var nextPage = global.syncObject.nextPage;
				global.syncObject = null;
				var curTime = device.gettime();
				var lastUpdateStr = stringparser.formattime("h:mmaa dd/MM/yyyy");
				device.setappproperty('lastHeartbeat', curTime);
				device.setappproperty('lastHeartbeatStr', lastUpdateStr);
				global.syncType = "background";
				global.manSync = false;
				global.syncActive = false;
				if(nextPage != null)
				{
					//navigator.next(nextPage);
					global.nextPageRef = nextPage;        
			        if (device.isinforeground()) {
			            navigator.next(nextPage);
			        } else {
			            navigator.next("/CA/updateCompleted.xml");
			        }
								
				}
			}
		}
	//end of error case
	}
	else
	{
		if(global.syncType == "subscriptionPhase2" || global.syncType == "removeWidgetFromIdleUpdate"){
			defCallBack(5,0,0,0);
		}
		window.cleartimeout(global.syncTimeout);
		if(global.flashBarOn==1)
		{
			ui.updatePopup.updateContents.progressIndicator.visible=0;
			window.clearinterval(global.flashBar);
			global.flashBarOn=0;
		}
		ui.curtain.visible = 0;
		killDots();
		ui.progressInd.visible=0;
		//ui.updatePopup.yscrollpos = -200;
		cancelSync();
		if(error == -33)
		{
			displayNote('Unable to connect. Try again later.','i','','Cancel', 'Retry', 'tempMsk();');
		}
		else
		{
			if(global.syncType == "subscription" || global.syncType == "removeWidgetFromIdle")
			{
				if(global.pageVars.curWidgetObject.billingInfo != "bill"){
					displayNote('The update failed.','i','','Cancel', 'Retry', 'tempMsk();');
				}else if(global.pageVars.curWidgetObject.subscribed)
				{
					global.subscribeFailedFlag = true;
					displayNote('The request to cancel your subscription to ' + global.pageVars.curWidgetObject.name + ' could not be completed. Please try again later or call 125111 (or 1258880 for Prepaid) for assistance (call charges apply).(Code '+error+')','i',' ',' ', 'OK', 'tempMsk();');
				}
				else
				{
					global.subscribeFailedFlag = true;
					displayNote('The request to subscribe to ' + global.pageVars.curWidgetObject.name + ' could not be completed. Please try again later or call 125111 (or 1258880 for Prepaid) for assistance (call charges apply).(Code '+error+')','i',' ',' ', 'OK', 'tempMsk();');	
				}
			}
			else
			{
				displayNote('The update failed.','i','','Cancel', 'Retry', 'tempMsk();');
			}
		}

		global.manSync = false;
		//global.syncActive = false;
		global.disableKeys=0;
		//global.tempKeys=1;
	}
}

function tempMsk()
{
	if(ui.h < 320)
	{
		hideNote('Options', 'Back', 'Select');
		ui.panels.item("p"+global.curPanel).focus();
	}
	else
	{
		hideNote('Options', 'Back', '');
		if(ui.item('addCont') != null)
		{
			ui.addCont.focus();
		}
	}
	if(global.subscribeFailedFlag == false && global.noUpdateFlag == false)
	{
		global.noNetworkFlag = false;
		
		if(global.syncType == "subscription" || global.syncType == "removeWidgetFromIdle")
		{
			subscribeSync();
		}
		else
		{
			standardSync(global.syncObject.nextPage, global.syncObject.description);
		}
	}
	else
	{
		ui.aboutBody.focus();
		global.subscribeFailedFlag = false;
		global.noUpdateFlag = false;
		cancelSync();
		global.syncActive = false;
	}
	
}

function tempLsk(){
	//doNothing
}

function tempRsk()
{
	if(global.noUpdateFlag == false && global.subscribeFailedFlag == false)
	{
		if(ui.h < 320)
		{
			
			hideNote('Options', 'Back', 'Select');
			ui.panels.item("p"+global.curPanel).focus();
		}
		else
		{
			hideNote('Options', 'Back', '');
			if(ui.item('addCont') != null)
			{
				ui.addCont.focus();
			}
			else if(ui.item('aboutBody') != null)
			{
				ui.aboutBody.focus();
			}
			else
			{
				ui.panels.focus();
			}
		}
		
		cancelSync();
		global.syncActive = false;
	}
}