function parseWidgets()
{
	var rootXmlObj = chRoot();
	if(rootXmlObj != null && rootXmlObj.size() > 0)
	{
		var xmlObj = rootXmlObj.item(rootXmlObj.widgetPath);
		var len=xmlObj.size();
		if(len > 0)		{
			
			for(var i = 0; i < len; i++)
			{
				var widgetInfo = new Object();
				widgetInfo.name = xmlObj.item(i).friendlyName;
				widgetInfo.id = xmlObj.item(i).id;
				widgetInfo.subscriptionCost = xmlObj.item(i).subscriptionCost;
				widgetInfo.canBesubscribedTo = xmlObj.item(i).canBeSubscribedTo;
				widgetInfo.subscriptionAutoRenew = xmlObj.item(i).subscriptionAutoRenew;
				widgetInfo.offerid = xmlObj.item(i).offerid;
				widgetInfo.providerid = xmlObj.item(i).providerid;
				widgetInfo.billingInfo = xmlObj.item(i).billingInfo;
				widgetInfo.subscriptionPeriod = xmlObj.item(i).subscriptionPeriod;
				widgetInfo.subscriptionCost = xmlObj.item(i).subscriptionCost;
				widgetInfo.subscribed = xmlObj.item(i).subscribed;
				widgetInfo.autoDelivery = xmlObj.item(i).autoDelivery;
				widgetInfo.description = xmlObj.item(i).description;
				widgetInfo.serverName = xmlObj.item(i).name;
				widgetInfo.onclick = "";
				widgetInfo.image = "/CH/" + rootXmlObj.name + "/" + rootXmlObj.widgetPath + "/" + widgetInfo.serverName + "/preview/icon_sel.png";
				if(widgetInfo.billingInfo == "free")
				{	
					if(global.pageVars.catIcons[0] == null)
					{
						global.pageVars.catIcons[0] = new Array();
					}
					global.pageVars.catIcons[0][global.pageVars.catIcons[0].length] = widgetInfo;
				}
				else if(widgetInfo.billingInfo == "data")
				{
					if(global.pageVars.catIcons[1] == null)
					{
						global.pageVars.catIcons[1] = new Array();
					}
					global.pageVars.catIcons[1][global.pageVars.catIcons[1].length] = widgetInfo;
				}
				else if(widgetInfo.billingInfo == "bill")
				{
					if(global.pageVars.catIcons[2] == null)
					{
						global.pageVars.catIcons[2] = new Array();
					}

					global.pageVars.catIcons[2][global.pageVars.catIcons[2].length] = widgetInfo;
				}
			}
		}
		else
		{
			global.pageVars.noWidgets = true;
			createNoWidgetsUI();
		}	
	}
	else
	{
		global.pageVars.noWidgets = true;
		createNoWidgetsUI();
	}	
}

function createNoWidgetsUI()
{
	var noWidgLab = new Label();
	noWidgLab.text = "No widgets are currently available, please try again later.";
	noWidgLab.wrap = true;
	noWidgLab.w=230;
	noWidgLab.x=5;
	noWidgLab.y=25;
	noWidgLab.font="/CA/fonts/regular_white.bf2";
	ui.add(noWidgLab);
	var lsk = buildSkLabelObj("", "");
	var rsk = buildSkLabelObj("Back", "doRsk();");
	var msk = buildSkLabelObj("", "");
	fillSkLabels(lsk, rsk, msk);
}

function drawSections()
{
	var header = new Image();
	var header2 = new Image();
	var header3 = new Image();
	header.src= "/CA/img/List_subheading_bg.png";
	header2.src= "/CA/img/List_subheading_bg.png";
	header3.src= "/CA/img/List_subheading_bg.png";
	
	docuement.log(global.pageVars.catIcons[0]);
	
	if(global.pageVars.catIcons[0].length > 0)
	{		
		header.y = global.pageVars.yPosCounter - 24;
		var heading = new Label();
		heading.name = "headingLab";
		heading.y = global.pageVars.yPosCounter - 21;
		heading.x = 10;	
		heading.font = "fonts/regular_white.bf2";
		heading.text = "Free Widgets";
		ui.iconCont.add(header);
		ui.iconCont.add(heading);
		//Add Featured icons
		buildWidgetCont(global.pageVars.catIcons[0]);
	}
	
	if(global.pageVars.catIcons[1].length > 0)
	{
		header3.y = global.pageVars.yPosCounter - 24;
		var heading3 = new Label();
		heading3.name = "headingLab";
		heading3.y = global.pageVars.yPosCounter - 21;
		heading3.x = 10;
		heading3.font = "fonts/regular_white.bf2";			
		heading3.text = "Data Charged Widgets";
		ui.iconCont.add(header3);
		ui.iconCont.add(heading3);
		//Add Featured icons
		buildWidgetCont(global.pageVars.catIcons[1]);
	}
	
	if(global.pageVars.catIcons[2].length > 0)
	{
		header2.y = global.pageVars.yPosCounter - 24;
		var heading2 = new Label();
		heading2.name = "headingLab";
		heading2.y = global.pageVars.yPosCounter - 21;
		heading2.x = 10;
		heading2.font = "fonts/regular_white.bf2";
		heading2.text = "Monthly Subscriptions";
		ui.iconCont.add(header2);
	 	ui.iconCont.add(heading2);
		//Add Featured icons
		buildWidgetCont(global.pageVars.catIcons[2]);
	}
	
	ui.iconCont.icon_0_0.focus();
	
	//this is a quick workaround - needs propper implementation
	//implementation here not working yet
	global.scrollContainerYPos = ui.iconCont.y;
	global.containerStructure = "ui.iconCont";
	configScrollbar(global.containerStructure);
}

function buildWidgetCont(data)
{
	var newWidgets = global.Updates.item('updates').item('Widgets');
	for(var n=0; n<data.length; n++)
	{
		var iconToAdd = buildIcon(data[n]);
		iconToAdd.x = 58 * global.pageVars.col;	
		iconToAdd.y = global.pageVars.yPosCounter;

		iconToAdd.name = "icon_"+global.pageVars.col+"_"+global.pageVars.row;
		
		var index=0;
		if(data[n].billingInfo == "free")
		{
			index = 0;
		}else if(data[n].billingInfo == "data")
		{
			index = 1;
		}else if(data[n].billingInfo == "bill")
		{
			index = 2;
		}
		
		iconToAdd.onfocus = "global.pageVars.index1=" + index +";global.pageVars.index2=" + n + "; widFocus(this);";
		iconToAdd.onclick = "launchWidgSub(" + index + "," + n +");";

		iconToAdd.leftnavigation="focus("+(global.pageVars.col-1)+", "+global.pageVars.row+");";
		iconToAdd.rightnavigation="focus("+(global.pageVars.col+1)+", "+global.pageVars.row+");";
		iconToAdd.upnavigation="focus("+global.pageVars.col+", "+(global.pageVars.row-1)+");";
		iconToAdd.downnavigation="focus("+global.pageVars.col+", "+(global.pageVars.row+1)+");";

		var check = new Image();
		check.name = "check_"+global.pageVars.col+"_"+global.pageVars.row;	
		check.focusable = false;
		check.x = iconToAdd.x + 39;	
		check.y = iconToAdd.y + 29;
		check.src = "img/tile_status_subscribed.png";

		if(data[n].subscribed == true)
		{
			check.visible = true;
			data[n].checked = true;
		}
		else
		{
			check.visible = false;
			data[n].checked = false;
		}
		if((global.pageVars.col + 1)%4==0 && global.pageVars.col != 0)
		{
			global.pageVars.col=0;
			global.pageVars.row++;
			global.pageVars.yPosCounter += 60;
		}
		else
		{
			global.pageVars.col++;
		}
		//data.iconArray[n] = curObj;
		ui.iconCont.add(iconToAdd);
		ui.iconCont.add(check);
		
		if(newWidgets.item(iconToAdd.text) != null){
			addStar(iconToAdd,ui.iconCont);
		}
		
		if(n+1 == data.length)
		{
			if(global.pageVars.col == 0)
			{
				global.pageVars.yPosCounter += 27;
			}
			else
			{
				global.pageVars.col = 0;
				global.pageVars.row++;
				global.pageVars.yPosCounter += 87;
			}
		}
	}
	ui.iconCont.add(global.highlightObj);
}

function launchWidgSub(index1, index2)
{	
	global.pageVars.curWidgetObject = global.pageVars.catIcons[index1][index2];
	if(index1 == 0)
	{
		navigator.next("catalogue_widgets_free_add.xml");
	}
	else if(index1 == 1)
	{
		navigator.next("catalogue_widgets_data_add.xml");
	}
	else if(index1 == 2)
	{
    navigator.next("catalogue_widgets_subscribe_add.xml");
	}
}

function buildWidgDynMenu()
{
	var iconObj = global.pageVars.catIcons[global.pageVars.index1][global.pageVars.index2];
	var skm_AddRem = new Object();
	if(iconObj != null)
	{	
		if(iconObj.checked == false)
		{
			skm_AddRem.name="add";
			skm_AddRem.readName="Add " + iconObj.name;
		}
		else
		{
			skm_AddRem.name="remove";
			skm_AddRem.readName="Remove " + iconObj.name;
		}
		skm_AddRem.onclick="launchWidgSub(" + global.pageVars.index1 + ", " + global.pageVars.index2 + ");";
		var addRemSKM = buildListItem(skm_AddRem);
		global.skmState = new Array(addRemSKM, global.helpSKM);
	}
	else
	{
		global.skmState = global.skmState_BpWeb_catalogue_default;
	}	
}

function focus(col, row){
	ui.iconCont.item("icon_"+col+"_"+row).focus();
}
