/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Highlander;

public abstract class Controller
extends Highlander {
    public byte mAbsolute;
    public int mControlledValueCode;
    public byte mStartState;
    public byte mCacheState;
    public int[] mValueBuffer = new int[12];
    public Highlander mControllee;

    public Controller() {
        super(50);
    }

    public void OnSerialize(Highlander highlander) {
        this.mControllee = (Highlander)highlander.SerializePointer((byte)0, true, false);
        this.mControlledValueCode = highlander.ReadLong();
        this.SetIsAbsolute(highlander.SerializeIntrinsicBool());
    }

    public final void SetControlParameters(Highlander highlander, int n) {
        this.mControllee = highlander;
        this.mControlledValueCode = n;
        this.mStartState = 0;
        this.mCacheState = 0;
    }

    public final void SetIsAbsolute(boolean bl) {
        boolean bl2 = this.mAbsolute == 0;
        if (bl != bl2) {
            bl2 = !bl;
            this.mAbsolute = (byte)(bl2 ? 1 : 0);
            this.mStartState = 0;
        }
    }

    public abstract void OnTime(int var1, int var2);
}

