/*
 * Decompiled with CFR 0.152.
 */
package com.jw.text;

import com.jw.text.TextConstants;
import com.jw.text.TextScroller;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class KaixinTextScroller
extends TextScroller {
    int[][] textInfo;
    static Sprite[] statusFaceSprite;
    static Sprite[] messageFaceSprite;
    Sprite[] faceSprite;
    int faceWidth;
    int faceHeight;
    String[] faceData;
    public int maxLineNum;
    int currentLine;
    String pp = "...";
    int startWid = 0;

    public KaixinTextScroller() {
    }

    public KaixinTextScroller(int scrollerType, String text, int posX, int posY, int wid, int hei, Font font, int color, int lineSpace, int autospeed, int maxLineNum) {
        this.scrollerType = scrollerType;
        this.text = text;
        this.posX = posX;
        this.posY = posY;
        this.wid = wid;
        this.hei = hei;
        this.font = font;
        this.color = color;
        this.lineSpace = lineSpace;
        this.maxLineNum = maxLineNum;
        this.fontHeight = font.getHeight();
        this.lineHeight = this.fontHeight + lineSpace;
        this.isEnd = false;
        this.curPosX = posX;
        this.curPosY = posY;
        this.autoMoveSpeed = autospeed;
        this.manualMoveSpeed = 4;
        this.isHcenter = false;
        this.faceWidth = 15;
        this.faceHeight = 15;
        this.faceData = TextConstants.statusTextTag;
        if (statusFaceSprite == null) {
            statusFaceSprite = this.loadAllSprite(1);
        }
        this.faceData = TextConstants.messageTextTag;
        if (messageFaceSprite == null) {
            messageFaceSprite = this.loadAllSprite(2);
        }
        this.faceData = TextConstants.messageTextTag;
        this.faceSprite = messageFaceSprite;
        this.init();
    }

    public KaixinTextScroller(int scrollerType, boolean isstatus, String text, int posX, int posY, int wid, int hei, int w0, Font font, int color, int lineSpace, int autospeed, int maxLineNum) {
        this.scrollerType = scrollerType;
        this.text = text;
        this.posX = posX;
        this.posY = posY;
        this.wid = wid;
        this.hei = hei;
        this.font = font;
        this.color = color;
        this.lineSpace = lineSpace;
        this.maxLineNum = maxLineNum;
        this.fontHeight = font.getHeight();
        this.lineHeight = this.fontHeight + lineSpace;
        this.isEnd = false;
        this.curPosX = posX;
        this.curPosY = posY;
        this.autoMoveSpeed = autospeed;
        this.manualMoveSpeed = 4;
        this.isHcenter = false;
        this.startWid = w0;
        this.faceWidth = 15;
        this.faceHeight = 15;
        this.faceData = TextConstants.statusTextTag;
        if (statusFaceSprite == null) {
            statusFaceSprite = this.loadAllSprite(1);
        }
        this.faceData = TextConstants.messageTextTag;
        if (messageFaceSprite == null) {
            messageFaceSprite = this.loadAllSprite(2);
        }
        if (isstatus) {
            this.faceData = TextConstants.statusTextTag;
            this.faceSprite = statusFaceSprite;
        } else {
            this.faceData = TextConstants.messageTextTag;
            this.faceSprite = messageFaceSprite;
        }
        this.init();
    }

    public void startScroll(boolean start) {
        if (start) {
            this.curPosX = this.posX;
            this.curPosY = this.posY;
            this.autoMoveSpeed = 6;
        } else {
            this.curPosX = this.posX;
            this.curPosY = this.posY;
            this.autoMoveSpeed = 0;
        }
    }

    public KaixinTextScroller(int scrollerType, boolean isstatus, String text, int posX, int posY, int wid, int hei, Font font, int color, int lineSpace, int autospeed, int maxLineNum) {
        this.scrollerType = scrollerType;
        this.text = text;
        this.posX = posX;
        this.posY = posY;
        this.wid = wid;
        this.hei = hei;
        this.font = font;
        this.color = color;
        this.lineSpace = lineSpace;
        this.maxLineNum = maxLineNum;
        this.fontHeight = font.getHeight();
        this.lineHeight = this.fontHeight + lineSpace;
        this.isEnd = false;
        this.curPosX = posX;
        this.curPosY = posY;
        this.autoMoveSpeed = autospeed;
        this.manualMoveSpeed = 4;
        this.isHcenter = false;
        this.faceWidth = 15;
        this.faceHeight = 15;
        this.faceData = TextConstants.statusTextTag;
        if (statusFaceSprite == null) {
            statusFaceSprite = this.loadAllSprite(1);
        }
        this.faceData = TextConstants.messageTextTag;
        if (messageFaceSprite == null) {
            messageFaceSprite = this.loadAllSprite(2);
        }
        if (isstatus) {
            this.faceData = TextConstants.statusTextTag;
            this.faceSprite = statusFaceSprite;
        } else {
            this.faceData = TextConstants.messageTextTag;
            this.faceSprite = messageFaceSprite;
        }
        this.init();
    }

    public Sprite[] loadAllSprite(int index) {
        if (this.faceData == null || this.faceData.length <= 0) {
            return null;
        }
        Sprite[] result = null;
        try {
            Image testImg;
            int len = this.faceData.length / 2;
            result = new Sprite[len];
            Image img = null;
            img = index == 1 ? Image.createImage((String)"/face/statusface.png") : Image.createImage((String)"/face/messageface.png");
            int lineNum = img.getWidth() / 15;
            int i = 0;
            while (i < len) {
                testImg = null;
                int offsetX = i % lineNum * 15;
                int offsetY = i / lineNum * 15;
                testImg = Image.createImage((Image)img, (int)offsetX, (int)offsetY, (int)15, (int)15, (int)0);
                result[i] = new Sprite(testImg, this.faceWidth, this.faceHeight);
                ++i;
            }
            testImg = null;
            img = null;
        }
        catch (Exception e) {
            System.out.println("loadAllSprite error:" + e.toString());
        }
        return result;
    }

    public void loadAllFaceSprite() {
        if (this.faceData == null || this.faceData.length <= 0) {
            return;
        }
        if (statusFaceSprite == null) {
            try {
                Image testImg;
                int len = this.faceData.length / 2;
                statusFaceSprite = new Sprite[len];
                Image img = Image.createImage((String)"/statusface.png");
                int lineNum = img.getWidth() / 15;
                int i = 0;
                while (i < len) {
                    testImg = null;
                    int offsetX = i % lineNum * 15;
                    int offsetY = i / lineNum * 15;
                    testImg = Image.createImage((Image)img, (int)offsetX, (int)offsetY, (int)15, (int)15, (int)0);
                    KaixinTextScroller.statusFaceSprite[i] = new Sprite(testImg, this.faceWidth, this.faceHeight);
                    ++i;
                }
                testImg = null;
                img = null;
            }
            catch (Exception e) {
                System.out.println("loadAllFaceSprite error:" + e.toString());
            }
        }
    }

    void parseText() {
        if (this.scrollerType == 0) {
            this.parseTextVertical();
        } else if (this.scrollerType == 1) {
            this.parseTextHorizontal();
        }
    }

    void parseTextVertical() {
        int faceLength = this.faceData.length / 2;
        String s = this.text;
        Vector<String> result = new Vector<String>();
        Vector<int[]> info = new Vector<int[]>();
        int currentWidth = 0;
        currentWidth = this.startWid;
        this.currentLine = 0;
        boolean parseEnd = false;
        while (!parseEnd && s != null && s.length() > 0) {
            boolean haveFace = false;
            int nearId = -1;
            int nearOffset = -1;
            int i = 0;
            while (i < faceLength) {
                int j = s.indexOf(this.faceData[i * 2]);
                if (j > -1) {
                    if (!haveFace) {
                        haveFace = true;
                        nearId = i;
                        nearOffset = j;
                    }
                    if (nearOffset > j) {
                        nearId = i;
                        nearOffset = j;
                    }
                }
                ++i;
            }
            if (nearOffset > 0 && !parseEnd) {
                String[] buffer;
                String s0 = s.substring(0, nearOffset);
                if (currentWidth + this.font.stringWidth("\u4e00") > this.wid) {
                    currentWidth = 0;
                    ++this.currentLine;
                    if (this.maxLineNum > 0 && this.currentLine >= this.maxLineNum) {
                        result.addElement(this.pp);
                        info.addElement(new int[]{-1, currentWidth});
                        parseEnd = true;
                        break;
                    }
                }
                if ((buffer = TextScroller.changeToArrayVertical(s0, this.font, currentWidth, this.wid)) != null && buffer.length > 0 && !parseEnd) {
                    int m = 0;
                    while (m < buffer.length) {
                        if (m == 0) {
                            info.addElement(new int[]{-1, currentWidth});
                            if (currentWidth == 0) {
                                ++this.currentLine;
                            }
                        } else {
                            int[] nArray = new int[2];
                            nArray[0] = -1;
                            info.addElement(nArray);
                            ++this.currentLine;
                        }
                        if (this.maxLineNum > 0 && this.currentLine >= this.maxLineNum && m < buffer.length - 1) {
                            if (buffer[m].length() == 1) {
                                result.addElement(this.pp);
                            } else {
                                result.addElement(String.valueOf(buffer[m].substring(0, buffer[m].length() - 1)) + this.pp);
                            }
                            parseEnd = true;
                            break;
                        }
                        result.addElement(buffer[m]);
                        ++m;
                    }
                }
                currentWidth = TextScroller.nowWidth;
            }
            if (nearId >= 0 && !parseEnd) {
                if (currentWidth + this.faceWidth > this.wid) {
                    currentWidth = 0;
                    ++this.currentLine;
                    if (this.maxLineNum > 0 && this.currentLine >= this.maxLineNum) {
                        result.addElement(this.pp);
                        info.addElement(new int[]{-1, currentWidth});
                        parseEnd = true;
                        break;
                    }
                }
                result.addElement(this.faceData[nearId * 2]);
                info.addElement(new int[]{nearId, currentWidth});
                currentWidth += this.faceWidth;
                s = s.substring(nearOffset + this.faceData[nearId * 2].length());
            }
            if (s != null && s.length() > 0 && currentWidth + this.font.stringWidth("\u4e00") > this.wid) {
                currentWidth = 0;
                ++this.currentLine;
                if (this.maxLineNum > 0 && this.currentLine >= this.maxLineNum) {
                    result.addElement(this.pp);
                    info.addElement(new int[]{-1, currentWidth});
                    parseEnd = true;
                    break;
                }
            }
            if (haveFace || parseEnd) continue;
            String[] buffer = TextScroller.changeToArrayVertical(s, this.font, currentWidth, this.wid);
            s = null;
            if (buffer != null && buffer.length > 0) {
                int m = 0;
                while (m < buffer.length) {
                    if (m == 0) {
                        info.addElement(new int[]{-1, currentWidth});
                        if (currentWidth == 0) {
                            ++this.currentLine;
                        }
                    } else {
                        int[] nArray = new int[2];
                        nArray[0] = -1;
                        info.addElement(nArray);
                        ++this.currentLine;
                    }
                    if (this.maxLineNum > 0 && this.currentLine >= this.maxLineNum && m < buffer.length - 1) {
                        if (buffer[m].length() == 1) {
                            result.addElement(this.pp);
                        } else {
                            result.addElement(String.valueOf(buffer[m].substring(0, buffer[m].length() - 1)) + this.pp);
                        }
                        parseEnd = true;
                        break;
                    }
                    result.addElement(buffer[m]);
                    ++m;
                }
            }
            currentWidth = TextScroller.nowWidth;
        }
        int len1 = result.size();
        int len2 = info.size();
        int len = Math.min(len1, len2);
        this.textArray = new String[len];
        this.textInfo = new int[len][];
        this.totalLength = 0;
        int i = 0;
        while (i < len) {
            this.textArray[i] = (String)result.elementAt(i);
            this.textInfo[i] = (int[])info.elementAt(i);
            if (this.textInfo[i][1] == 0 && i != 0) {
                this.totalLength += this.lineHeight;
            }
            ++i;
        }
        this.totalLength += this.lineHeight;
        result = null;
        info = null;
    }

    void parseTextHorizontal() {
        int faceLength = this.faceData.length / 2;
        String s = this.text;
        Vector<String> result = new Vector<String>();
        Vector<int[]> info = new Vector<int[]>();
        int currentWidth = 0;
        while (s != null && s.length() > 0) {
            boolean haveFace = false;
            int nearId = -1;
            int nearOffset = -1;
            int i = 0;
            while (i < faceLength) {
                int j = s.indexOf(this.faceData[i * 2]);
                if (j > -1) {
                    if (!haveFace) {
                        haveFace = true;
                        nearId = i;
                        nearOffset = j;
                    }
                    if (nearOffset > j) {
                        nearId = i;
                        nearOffset = j;
                    }
                }
                ++i;
            }
            if (nearOffset > 0) {
                String s0 = s.substring(0, nearOffset);
                result.addElement(s0);
                info.addElement(new int[]{-1, currentWidth});
                currentWidth += this.font.stringWidth(s0);
            }
            if (nearId >= 0) {
                result.addElement(this.faceData[nearId * 2]);
                info.addElement(new int[]{nearId, currentWidth});
                currentWidth += this.faceWidth;
                s = s.substring(nearOffset + this.faceData[nearId * 2].length());
            }
            if (haveFace) continue;
            result.addElement(s);
            info.addElement(new int[]{-1, currentWidth});
            currentWidth += this.font.stringWidth(s);
            s = null;
        }
        int len1 = result.size();
        int len2 = info.size();
        int len = Math.min(len1, len2);
        this.textArray = new String[len];
        this.textInfo = new int[len][];
        this.totalLength = 0;
        int i = 0;
        while (i < len) {
            this.textArray[i] = (String)result.elementAt(i);
            this.textInfo[i] = (int[])info.elementAt(i);
            ++i;
        }
        this.totalLength = currentWidth;
        result = null;
        info = null;
    }

    public void paint(Graphics g) {
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        g.setClip(this.posX, this.posY, this.wid, this.hei);
        g.setColor(this.color);
        g.setFont(this.font);
        if (this.scrollerType == 0) {
            this.paintV(g);
        } else if (this.scrollerType == 1) {
            this.paintH(g);
        }
        g.setClip(clipX, clipY, clipWidth, clipHeight);
        this.update();
    }

    public void paint(Graphics g, int hh) {
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        g.setClip(this.posX, this.posY, this.wid, hh);
        g.setColor(this.color);
        g.setFont(this.font);
        if (this.scrollerType == 0) {
            this.paintV(g);
        } else if (this.scrollerType == 1) {
            this.paintH(g);
        }
        g.setClip(clipX, clipY, clipWidth, clipHeight);
        this.update();
    }

    public void update() {
        super.update();
        if (this.faceSprite != null && this.faceSprite.length > 0) {
            int i = 0;
            while (i < this.faceSprite.length) {
                this.faceSprite[i].nextFrame();
                ++i;
            }
        }
    }

    void paintV(Graphics g) {
        int py = this.curPosY;
        if (this.textArray != null && this.textArray.length > 0) {
            int len = this.textArray.length;
            int i = 0;
            while (i < len) {
                if (this.textInfo[i][1] == 0 && i != 0) {
                    py += this.lineHeight;
                }
                if (py >= -30 && py >= this.posY - 20) {
                    if (py > 320 || py > this.posY + this.hei) {
                        return;
                    }
                    if (this.textInfo[i][0] == -1) {
                        g.drawString(this.textArray[i], this.curPosX + this.textInfo[i][1], py, 0);
                    } else {
                        this.faceSprite[this.textInfo[i][0]].setPosition(this.curPosX + this.textInfo[i][1], py + (this.fontHeight - this.faceHeight) / 2);
                        this.faceSprite[this.textInfo[i][0]].paint(g);
                    }
                }
                ++i;
            }
        }
    }

    void paintH(Graphics g) {
        int py = this.curPosY;
        if (this.textArray != null && this.textArray.length > 0) {
            int len = this.textArray.length;
            int i = 0;
            while (i < len) {
                int px = this.curPosX + this.textInfo[i][1];
                if (px > 240) {
                    return;
                }
                if (this.textInfo[i][0] == -1) {
                    g.drawString(this.textArray[i], px, py, 0);
                } else {
                    this.faceSprite[this.textInfo[i][0]].setPosition(px, py + (this.fontHeight - this.faceHeight) / 2);
                    this.faceSprite[this.textInfo[i][0]].paint(g);
                }
                ++i;
            }
        }
    }
}

