/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.data;

import com.sina.http.HttpEngine;
import com.sina.http.HttpListener;
import com.sina.http.URLEncoder;
import com.sina.parser.xml.XMLDataBlock;
import com.sina.parser.xml.XMLDataListener;
import com.sina.weibo.ClientManager;
import com.sina.weibo.comm.G;
import com.sina.weibo.data.Account;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Image;

public class WebAccountListModel
implements XMLDataListener,
HttpListener {
    public Vector account = new Vector();
    private ClientManager cm;
    public int type;
    public int pagesize = 20;
    public int count;
    public boolean loadHead;
    private int loadHeadIndex;
    public boolean loading;
    public int pageId = 1;
    public boolean loadList;
    public String accountID;
    private int currentID;

    public WebAccountListModel(ClientManager cm, int type) {
        this.cm = cm;
        this.type = type;
        this.accountID = cm.currentAccount.accountID;
    }

    public void getAcount(int index) {
        StringBuffer send = new StringBuffer();
        send.append(G.serverPath);
        send.append("attention.php?");
        send.append("sid=");
        send.append(this.cm.currentAccount.sessionID);
        send.append("&gsid=");
        send.append(this.cm.currentAccount.gsid);
        send.append("&cat=");
        send.append(this.type);
        send.append("&page=");
        send.append(index);
        send.append("&pagesize=");
        send.append(this.pagesize);
        this.cm.httpEngine.HttpConnect(0, 0, send.toString(), null, this, HttpEngine.HIGH);
        this.loadList = true;
        this.cm.setWait(true);
    }

    public boolean blockArrived(XMLDataBlock data) {
        block36: {
            if (data.getTagName().equals("rss")) break block36;
            return false;
        }
        try {
            if (this.currentID == 3) {
                Vector childvc = data.getChildBlocks();
                boolean err = false;
                if (childvc != null) {
                    int i = 0;
                    while (i < childvc.size()) {
                        XMLDataBlock itemdata = (XMLDataBlock)childvc.elementAt(i);
                        if (itemdata.getTagName().equals("sid")) {
                            this.cm.currentAccount.sessionID = itemdata.getText();
                        } else if (itemdata.getTagName().equals("result")) {
                            if ("0".equals(itemdata.getText())) {
                                err = true;
                            }
                        } else if (itemdata.getTagName().equals("errno")) {
                            err = true;
                        } else {
                            itemdata.getTagName().equals("errmsg");
                        }
                        itemdata.close();
                        ++i;
                    }
                }
                data.close();
                if (!err) {
                    this.cm.showAlert("\u53d1\u9001\u6210\u529f\uff01");
                } else {
                    this.cm.showAlert("\u53d1\u9001\u5931\u8d25\uff01");
                }
                this.cm.setWait(false);
            } else {
                this.account.removeAllElements();
                Vector childvc = data.getChildBlocks();
                if (childvc != null) {
                    int i = 0;
                    while (i < childvc.size()) {
                        XMLDataBlock itemdata = (XMLDataBlock)childvc.elementAt(i);
                        if (itemdata.getTagName().equals("info")) {
                            Account item = new Account();
                            Vector child2 = itemdata.getChildBlocks();
                            if (child2 != null) {
                                int j = 0;
                                while (j < child2.size()) {
                                    XMLDataBlock cc = (XMLDataBlock)child2.elementAt(j);
                                    if (cc.getTagName().equals("nick")) {
                                        item.nick = cc.getText();
                                    } else if (cc.getTagName().equals("uid")) {
                                        item.uid = cc.getText();
                                    } else if (cc.getTagName().equals("num")) {
                                        item.fensishu = "\u7c89\u4e1d:" + cc.getText();
                                    } else if (cc.getTagName().equals("portrait")) {
                                        item.headUrl = cc.getText();
                                    } else if (cc.getTagName().equals("gender")) {
                                        item.sex = "0".equals(cc.getText()) ? "\u7537" : "\u5973";
                                    } else if (cc.getTagName().equals("relation")) {
                                        item.relation = Integer.parseInt(cc.getText());
                                    }
                                    cc.close();
                                    ++j;
                                }
                            }
                            this.account.addElement(item);
                        } else if (itemdata.getTagName().equals("count")) {
                            this.count = Integer.parseInt(itemdata.getText());
                        } else if (itemdata.getTagName().equals("sid")) {
                            this.cm.currentAccount.sessionID = itemdata.getText();
                        }
                        ++i;
                    }
                }
                data.close();
                this.loadHead = true;
                this.loadHeadIndex = 0;
                this.cm.updateView(11, 0);
                this.cm.setWait(false);
                System.gc();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void handleHttpError(int httpid, String errostr) {
        this.cm.showAlert("\u7f51\u7edc\u8fde\u63a5\u5931\u8d25\uff01\u8bf7\u5c1d\u8bd5\u5728\u5e10\u6237\u9875\u91cd\u7f6e\u7f51\u7edc\u3002");
        this.cm.setWait(false);
    }

    public boolean receiveHttpResponse(int httpid, int type, byte[] dis) {
        block7: {
            this.currentID = httpid;
            if (httpid != 2) {
                return this.cm.xmlEngine.receiveHttpResponse(dis, this);
            }
            if (this.loadHead) break block7;
            this.loading = false;
            return true;
        }
        try {
            Account b = (Account)this.account.elementAt(this.loadHeadIndex);
            b.headIMG = Image.createImage((byte[])dis, (int)0, (int)dis.length);
            int i = this.loadHeadIndex + 1;
            while (i < this.account.size()) {
                Account b1 = (Account)this.account.elementAt(i);
                if (b1.headUrl.equals(b.headUrl)) {
                    b1.headIMG = b.headIMG;
                }
                ++i;
            }
            this.cm.updateView(11, 1);
            ++this.loadHeadIndex;
            if (this.loadHeadIndex == this.account.size()) {
                this.loadHead = false;
                this.loadHeadIndex = 0;
            }
            this.loading = false;
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void loadNextHead() {
        this.loading = true;
        if (((Account)this.account.elementAt((int)this.loadHeadIndex)).headIMG == null) {
            this.cm.httpEngine.HttpConnect(2, 0, ((Account)this.account.elementAt((int)this.loadHeadIndex)).headUrl, null, this, HttpEngine.HIGH);
        } else {
            ++this.loadHeadIndex;
            if (this.loadHeadIndex >= this.account.size()) {
                this.loadHead = false;
                this.loadHeadIndex = 0;
            }
            this.loading = false;
        }
    }

    public void sendSixin(String text, String uid) {
        StringBuffer send = new StringBuffer();
        send.append("act=send&sid=");
        send.append(this.cm.currentAccount.sessionID);
        send.append("&gsid=");
        send.append(this.cm.currentAccount.gsid);
        send.append("&uid=");
        send.append(uid);
        this.cm.httpEngine.HttpConnect(3, 0, String.valueOf(G.serverPath) + "dealmsg.php?" + send.toString(), "&content=" + URLEncoder.encode(text, "UTF-8"), this, HttpEngine.HIGH);
        this.cm.setWait(true);
    }
}

