/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo;

import com.sina.weibo.ClientManager;
import com.sina.weibo.comm.G;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;

public class LCanvas
extends GameCanvas
implements Runnable {
    public static final int FRAME_TIME = 25;
    public static boolean needFlush = true;
    public boolean run = true;
    private ClientManager clientManager;

    public ClientManager getClientManager() {
        if (this.clientManager != null) {
            return this.clientManager;
        }
        return null;
    }

    public LCanvas(ClientManager manager) {
        super(false);
        this.setFullScreenMode(true);
        this.clientManager = manager;
        this.run = true;
        new Thread(this).start();
    }

    protected void sizeChanged(int w, int h) {
    }

    public void run() {
        long lastUpdateTime = System.currentTimeMillis();
        long dis = 0L;
        while (this.run) {
            long startTime = System.currentTimeMillis();
            dis = startTime - lastUpdateTime;
            try {
                this.update(dis);
                lastUpdateTime = startTime;
                if (dis >= 25L) continue;
                Thread.sleep(25L - dis);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showNotify() {
        LCanvas lCanvas = this;
        synchronized (lCanvas) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideNotify() {
        try {
            LCanvas lCanvas = this;
            synchronized (lCanvas) {
                this.wait(1000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void update(long time) {
        try {
            if (this.clientManager != null) {
                this.clientManager.tick(time);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (needFlush) {
            needFlush = false;
            this.repaint();
        }
    }

    public void keyPressed(int keyCode) {
        if (this.clientManager != null) {
            try {
                this.clientManager.keyPressed(keyCode);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        needFlush = true;
    }

    public void keyRepeated(int keyCode) {
        if (this.clientManager != null) {
            try {
                this.clientManager.keyRepeated(keyCode);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void paint(Graphics g) {
        g.setFont(G.SHOW_FONT);
        if (this.clientManager != null) {
            try {
                this.clientManager.paint(g);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void updateScreenSetting() {
        G.inite(240, 320);
    }

    public void forceRepaint() {
        this.repaint();
        this.serviceRepaints();
    }
}

