/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.data;

import com.sina.http.HttpEngine;
import com.sina.http.URLEncoder;
import com.sina.parser.xml.XMLDataBlock;
import com.sina.weibo.ClientManager;
import com.sina.weibo.comm.G;
import com.sina.weibo.comm.Tools;
import com.sina.weibo.data.AbstractBowenList;
import com.sina.weibo.data.Pinglun;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Image;

public class PinglunListModel
extends AbstractBowenList {
    private int currentID;
    public boolean loadHead = true;
    public boolean loading;
    public int loadHeadIndex;
    public boolean loadList;
    public int pageId = 1;
    public int pagesize = 20;
    public int count = 20;

    public PinglunListModel(ClientManager cm) {
        super(cm);
    }

    public void getBowenList(int pageid) {
        StringBuffer send = new StringBuffer();
        send.append("type=1&sid=");
        send.append(this.cm.currentAccount.sessionID);
        send.append("&gsid=");
        send.append(this.cm.currentAccount.gsid);
        send.append("&page=");
        send.append(pageid);
        send.append("&pagesize=");
        send.append(this.pagesize);
        this.cm.httpEngine.HttpConnect(1, 0, String.valueOf(G.serverPath) + "getmycomment.php?" + send.toString(), null, this, HttpEngine.HIGH);
        this.loadList = true;
        this.loadHead = false;
        this.loadHeadIndex = 0;
        this.cm.setWait(true);
    }

    public boolean blockArrived(XMLDataBlock data) {
        if (this.currentID == 1) {
            return this.parseBowenList(data);
        }
        if (this.currentID == 3) {
            this.parseAddBowen(data);
        } else if (this.currentID == 4) {
            this.parseAddPinglun(data);
        } else if (this.currentID == 5) {
            this.parseAddZhuanfa(data);
        }
        return true;
    }

    private void parseAddBowen(XMLDataBlock data) {
        try {
            if (!data.getTagName().equals("rss")) {
                this.cm.showAlert("\u53d1\u9001\u5931\u8d25");
                this.cm.setWait(false);
                return;
            }
            Vector childvc = data.getChildBlocks();
            boolean err = false;
            if (childvc != null) {
                int i = 0;
                while (i < childvc.size()) {
                    XMLDataBlock itemdata = (XMLDataBlock)childvc.elementAt(i);
                    if (itemdata.getTagName().equals("sid")) {
                        this.cm.currentAccount.sessionID = itemdata.getText();
                    } else if (itemdata.getTagName().equals("result")) {
                        if ("0".equals(itemdata.getText())) {
                            err = true;
                        }
                    } else if (itemdata.getTagName().equals("errno")) {
                        err = true;
                    } else if (!itemdata.getTagName().equals("errmsg")) {
                        itemdata.getTagName().equals("url");
                    }
                    itemdata.close();
                    ++i;
                }
            }
            data.close();
            if (!err) {
                this.cm.showAlert("\u53d1\u9001\u6210\u529f");
                this.cm.back(true);
            } else {
                this.cm.showAlert("\u53d1\u9001\u5931\u8d25\uff01");
            }
            this.cm.setWait(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean parseBowenList(XMLDataBlock data) {
        block41: {
            if (data.getTagName().equals("rss")) break block41;
            return false;
        }
        try {
            this.bowenvc.removeAllElements();
            Vector childvc = data.getChildBlocks();
            if (childvc != null) {
                int i = 0;
                while (i < childvc.size()) {
                    XMLDataBlock itemdata = (XMLDataBlock)childvc.elementAt(i);
                    if (itemdata.getTagName().equals("msg")) {
                        Pinglun item = new Pinglun();
                        Vector child2 = itemdata.getChildBlocks();
                        if (child2 != null) {
                            int j = 0;
                            while (j < child2.size()) {
                                String s;
                                XMLDataBlock cc = (XMLDataBlock)child2.elementAt(j);
                                if (cc.getTagName().equals("mblognick")) {
                                    item.mblognick = cc.getText();
                                } else if (cc.getTagName().equals("mbloguid")) {
                                    item.mbloguid = cc.getText();
                                } else if (cc.getTagName().equals("mblogid")) {
                                    item.mblogid = cc.getText();
                                } else if (cc.getTagName().equals("mblogcontent")) {
                                    s = cc.getText();
                                    item.mblogcontent = Tools.replace(s, "\\n", "\n");
                                } else if (cc.getTagName().equals("srcid")) {
                                    item.srcid = cc.getText();
                                } else if (cc.getTagName().equals("srcuid")) {
                                    item.srcuid = cc.getText();
                                } else if (cc.getTagName().equals("srcnick")) {
                                    item.srcnick = cc.getText();
                                } else if (cc.getTagName().equals("srccontent")) {
                                    s = cc.getText();
                                    item.srccontent = Tools.replace(s, "\\n", "\n");
                                } else if (cc.getTagName().equals("commentid")) {
                                    item.commentid = cc.getText();
                                } else if (cc.getTagName().equals("commentuid")) {
                                    item.commentuid = cc.getText();
                                } else if (cc.getTagName().equals("commentnick")) {
                                    item.commentnick = cc.getText();
                                } else if (cc.getTagName().equals("commentcontent")) {
                                    s = cc.getText();
                                    item.commentcontent = Tools.replace(s, "\\n", "\n");
                                } else if (cc.getTagName().equals("commentportrait")) {
                                    item.headURL = cc.getText();
                                } else if (cc.getTagName().equals("commenttime")) {
                                    try {
                                        item.realtime = Long.parseLong(cc.getText());
                                        item.updateTime();
                                    }
                                    catch (RuntimeException runtimeException) {
                                        // empty catch block
                                    }
                                }
                                cc.close();
                                ++j;
                            }
                        }
                        item.updateTime();
                        this.bowenvc.addElement(item);
                    } else if (itemdata.getTagName().equals("count")) {
                        this.count = Integer.parseInt(itemdata.getText());
                    } else if (itemdata.getTagName().equals("sid")) {
                        this.cm.currentAccount.sessionID = itemdata.getText();
                    }
                    ++i;
                }
            }
            data.close();
            this.loadHead = true;
            this.loadHeadIndex = 0;
            this.cm.updateView(21, 0);
            this.cm.setWait(false);
            System.gc();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void handleHttpError(int httpid, String errostr) {
        this.cm.showAlert("\u7f51\u7edc\u8fde\u63a5\u5931\u8d25\uff01\u8bf7\u5c1d\u8bd5\u5728\u5e10\u6237\u9875\u91cd\u7f6e\u7f51\u7edc\u3002");
        this.cm.setWait(false);
    }

    public boolean receiveHttpResponse(int httpid, int type, byte[] dis) {
        block7: {
            block8: {
                this.currentID = httpid;
                if (this.currentID != 2) break block7;
                if (this.loadHead) break block8;
                this.loading = false;
                return true;
            }
            try {
                Pinglun b = (Pinglun)this.bowenvc.elementAt(this.loadHeadIndex);
                b.headIcon = Image.createImage((byte[])dis, (int)0, (int)dis.length);
                int i = this.loadHeadIndex + 1;
                while (i < this.bowenvc.size()) {
                    Pinglun b1 = (Pinglun)this.bowenvc.elementAt(i);
                    if (b1.headURL.equals(b.headURL)) {
                        b1.headIcon = b.headIcon;
                    }
                    ++i;
                }
                this.cm.updateView(21, 1);
                ++this.loadHeadIndex;
                if (this.loadHeadIndex == this.bowenvc.size()) {
                    this.loadHead = false;
                    this.loadHeadIndex = 0;
                }
                this.loading = false;
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
        return this.cm.xmlEngine.receiveHttpResponse(dis, this);
    }

    public void loadNextHead() {
        this.loading = true;
        if (((Pinglun)this.bowenvc.elementAt((int)this.loadHeadIndex)).headIcon == null) {
            this.cm.httpEngine.HttpConnect(2, 0, ((Pinglun)this.bowenvc.elementAt((int)this.loadHeadIndex)).headURL, null, this, HttpEngine.HIGH);
        } else {
            ++this.loadHeadIndex;
            if (this.loadHeadIndex >= this.bowenvc.size()) {
                this.loadHead = false;
                this.loadHeadIndex = 0;
            }
            this.loading = false;
        }
    }

    public void addComment(int id, String text) {
        Pinglun pinglun = (Pinglun)this.bowenvc.elementAt(id);
        StringBuffer send = new StringBuffer();
        send.append("act=addReply&sid=");
        send.append(this.cm.currentAccount.sessionID);
        send.append("&gsid=");
        send.append(this.cm.currentAccount.gsid);
        send.append("&srcuid=");
        send.append(pinglun.mbloguid);
        send.append("&srcid=");
        send.append(pinglun.mblogid);
        send.append("&cmtuid=");
        send.append(pinglun.commentuid);
        send.append("&cmtid=");
        send.append(pinglun.commentid);
        this.cm.httpEngine.HttpConnect(4, 0, String.valueOf(G.serverPath) + "dealcomment.php?" + send.toString(), "&content=" + URLEncoder.encode(text, "UTF-8"), this, HttpEngine.HIGH);
        this.cm.setWait(true);
    }
}

