/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.layouts;

import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.Layout;
import com.sun.lwuit.plaf.Style;

public class BorderLayout
extends Layout {
    private Component a;
    private Component b;
    private Component c;
    private Component d;
    private Component e;
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String CENTER = "Center";
    public static final String WEST = "West";
    public static final String EAST = "East";

    public void addLayoutComponent(Object object, Component component, Container container) {
        if (object == null) {
            throw new IllegalArgumentException("Cannot add component to BorderLayout Container without constraint parameter");
        }
        Component component2 = null;
        if (CENTER.equals(object)) {
            component2 = this.c;
            this.c = component;
        } else if (NORTH.equals(object)) {
            component2 = this.a;
            this.a = component;
        } else if (SOUTH.equals(object)) {
            component2 = this.b;
            this.b = component;
        } else if (EAST.equals(object)) {
            component2 = this.e;
            this.e = component;
        } else if (WEST.equals(object)) {
            component2 = this.d;
            this.d = component;
        } else {
            throw new IllegalArgumentException("cannot add to layout: unknown constraint: " + object);
        }
        if (component2 != null && component2 != component) {
            container.removeComponent(component2);
        }
    }

    public void removeLayoutComponent(Component component) {
        if (component == this.c) {
            this.c = null;
        } else if (component == this.a) {
            this.a = null;
        } else if (component == this.b) {
            this.b = null;
        } else if (component == this.e) {
            this.e = null;
        } else if (component == this.d) {
            this.d = null;
        }
    }

    public Object getComponentConstraint(Component component) {
        if (component == this.c) {
            return CENTER;
        }
        if (component == this.a) {
            return NORTH;
        }
        if (component == this.b) {
            return SOUTH;
        }
        if (component == this.e) {
            return EAST;
        }
        return WEST;
    }

    public void layoutContainer(Container container) {
        Component component;
        Style style = container.getStyle();
        int n2 = style.getPadding(0);
        int n3 = container.getLayoutHeight() - container.getBottomGap() - style.getPadding(2);
        int n4 = style.getPadding(1);
        int n5 = container.getLayoutWidth() - container.getSideGap() - style.getPadding(3);
        int n6 = container.getWidth();
        int n7 = container.getHeight();
        if (this.a != null) {
            component = this.a;
            this.b(component, n5, n4, n7);
            component.setY(n2 + component.getStyle().getMargin(0));
            n2 += component.getHeight() + component.getStyle().getMargin(0) + component.getStyle().getMargin(2);
        }
        if (this.b != null) {
            component = this.b;
            this.b(component, n5, n4, n7);
            component.setY(n3 - component.getHeight() - component.getStyle().getMargin(0));
            n3 -= component.getHeight() + component.getStyle().getMargin(0) + component.getStyle().getMargin(2);
        }
        if (this.e != null) {
            component = this.e;
            this.a(this.e, n6, n3, n2);
            component.setX(n5 - component.getWidth() - component.getStyle().getMargin(1));
            n5 -= component.getWidth() + component.getStyle().getMargin(1) + component.getStyle().getMargin(3);
        }
        if (this.d != null) {
            component = this.d;
            this.a(this.d, n6, n3, n2);
            component.setX(n4 + component.getStyle().getMargin(1));
            n4 += component.getWidth() + component.getStyle().getMargin(1) + component.getStyle().getMargin(3);
        }
        if (this.c != null) {
            component = this.c;
            component.setWidth(n5 - n4 - component.getStyle().getMargin(1) - component.getStyle().getMargin(3));
            component.setHeight(n3 - n2 - component.getStyle().getMargin(0) - component.getStyle().getMargin(2));
            component.setX(n4 + component.getStyle().getMargin(1));
            component.setY(n2 + component.getStyle().getMargin(0));
        }
    }

    private void a(Component component, int n2, int n3, int n4) {
        component.setWidth(Math.min(n2, component.getPreferredW()));
        component.setHeight(n3 - n4 - component.getStyle().getMargin(0) - component.getStyle().getMargin(2));
        component.setY(n4 + component.getStyle().getMargin(0));
    }

    private void b(Component component, int n2, int n3, int n4) {
        component.setWidth(n2 - n3 - component.getStyle().getMargin(1) - component.getStyle().getMargin(3));
        component.setHeight(Math.min(n4, component.getPreferredH()));
        component.setX(n3 + component.getStyle().getMargin(1));
    }

    public Dimension getPreferredSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        if (this.e != null) {
            dimension.setWidth(this.e.getPreferredW() + this.e.getStyle().getMargin(1) + this.e.getStyle().getMargin(3));
            dimension.setHeight(Math.max(this.e.getPreferredH() + this.e.getStyle().getMargin(0) + this.e.getStyle().getMargin(2), dimension.getHeight()));
        }
        if (this.d != null) {
            dimension.setWidth(dimension.getWidth() + this.d.getPreferredW() + this.d.getStyle().getMargin(1) + this.d.getStyle().getMargin(3));
            dimension.setHeight(Math.max(this.d.getPreferredH() + this.d.getStyle().getMargin(0) + this.d.getStyle().getMargin(2), dimension.getHeight()));
        }
        if (this.c != null) {
            dimension.setWidth(dimension.getWidth() + this.c.getPreferredW() + this.c.getStyle().getMargin(1) + this.c.getStyle().getMargin(3));
            dimension.setHeight(Math.max(this.c.getPreferredH() + this.c.getStyle().getMargin(0) + this.c.getStyle().getMargin(2), dimension.getHeight()));
        }
        if (this.a != null) {
            dimension.setWidth(Math.max(this.a.getPreferredW() + this.a.getStyle().getMargin(1) + this.a.getStyle().getMargin(3), dimension.getWidth()));
            dimension.setHeight(dimension.getHeight() + this.a.getPreferredH() + this.a.getStyle().getMargin(0) + this.a.getStyle().getMargin(2));
        }
        if (this.b != null) {
            dimension.setWidth(Math.max(this.b.getPreferredW() + this.b.getStyle().getMargin(1) + this.b.getStyle().getMargin(3), dimension.getWidth()));
            dimension.setHeight(dimension.getHeight() + this.b.getPreferredH() + this.b.getStyle().getMargin(0) + this.b.getStyle().getMargin(2));
        }
        dimension.setWidth(dimension.getWidth() + container.getStyle().getPadding(1) + container.getStyle().getPadding(3));
        dimension.setHeight(dimension.getHeight() + container.getStyle().getPadding(0) + container.getStyle().getPadding(2));
        return dimension;
    }
}

