/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.kx.widget;

import com.sonyericsson.Log;
import com.sonyericsson.kx.widget.ItemHolder;
import com.sonyericsson.kx.widget.WidgetListener;
import com.sonyericsson.lcdui.IdleItem;
import com.sonyericsson.res.Images;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class KaixinWidget
extends IdleItem {
    private static final int WIDTH_LOADING = 18;
    private static final int STYLE = 20;
    public Command backCmd;
    public Command viewCmd;
    public Command refreshCmd;
    private WidgetListener wListener;
    private Image header;
    private ItemHolder holder;
    private int testHeight = 148;
    public boolean wantsFocus = true;

    public KaixinWidget() {
        this("Kaixin Widget");
        this.header = Images.createImage("/widget/headline.png");
        this.holder = ItemHolder.getInstance();
        this.holder.widget = this;
        this.backCmd = new Command("\u8fd4\u56de", 7, 0);
        this.viewCmd = new Command("\u67e5\u770b", 4, 0);
        this.refreshCmd = new Command("\u66f4\u65b0", 4, 0);
        this.addCommand(this.backCmd);
        if (this.holder.isLogin) {
            this.addCommand(this.refreshCmd);
        }
        this.addCommand(this.viewCmd);
    }

    protected KaixinWidget(String s) {
        super(s);
    }

    protected int getMinContentHeight() {
        return 0;
    }

    protected int getMinContentWidth() {
        return 0;
    }

    protected int getPrefContentHeight(int h) {
        return 0;
    }

    protected int getPrefContentWidth(int w) {
        return 0;
    }

    protected void paint(Graphics g, int width, int height) {
        if (!this.holder.isLogin && Images.LOGIN != null) {
            g.drawImage(Images.LOGIN, 0, 0, 20);
        } else {
            if (this.header != null) {
                g.drawImage(this.header, 0, 0, 20);
            }
            g.setClip(0, 36, width, height);
            this.holder.draw(g, 0, height);
        }
        if (this.holder.isDownloading() && Images.LOADING != null) {
            g.setClip(100, 13, 118, 31);
            g.drawRegion(Images.LOADING, this.holder.downloadStatus * 18, 0, 18, 18, 0, 100, 13, 20);
        }
    }

    protected void sizeChanged(int w, int h) {
        block0 : switch (h) {
            case 200: {
                this.holder.mode = 2;
                System.out.println("in interactive");
                break;
            }
            case 148: {
                this.holder.mode = 0;
                this.wListener.inSmall();
                break;
            }
            default: {
                switch (this.holder.mode) {
                    case 0: {
                        System.out.println("out of small");
                        this.holder.mode = 1;
                        break block0;
                    }
                    case 2: {
                        System.out.println("out of interactive");
                        this.holder.mode = 1;
                        break block0;
                    }
                }
            }
        }
    }

    public void testInteractive() {
        new Thread(new Runnable(){

            public void run() {
                block7: {
                    block6: {
                        if (KaixinWidget.this.testHeight != 148) break block6;
                        while (KaixinWidget.this.testHeight < 200) {
                            KaixinWidget kaixinWidget = KaixinWidget.this;
                            kaixinWidget.testHeight = kaixinWidget.testHeight + 4;
                            KaixinWidget.this.sizeChanged(210, KaixinWidget.this.testHeight);
                            KaixinWidget.this.repaint(0, 0, 210, 200);
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                        break block7;
                    }
                    if (KaixinWidget.this.testHeight != 200) break block7;
                    while (KaixinWidget.this.testHeight > 148) {
                        KaixinWidget kaixinWidget = KaixinWidget.this;
                        kaixinWidget.testHeight = kaixinWidget.testHeight - 4;
                        KaixinWidget.this.sizeChanged(210, KaixinWidget.this.testHeight);
                        KaixinWidget.this.repaint(0, 0, 210, 200);
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }).start();
    }

    public void setMcListener(WidgetListener mcListener) {
        this.wListener = mcListener;
    }

    protected boolean traverse(int dir, int viewportWidth, int viewportHeight, int[] visRect_inout) {
        Log.info("traverse dir: " + dir);
        switch (dir) {
            case 1: {
                this.keyPressed(50);
                break;
            }
            case 6: {
                this.keyPressed(56);
            }
        }
        return this.wantsFocus;
    }

    protected void traverseOut() {
        this.wantsFocus = true;
    }

    public void refresh() {
        this.repaint();
    }

    protected void showNotify() {
        switch (this.holder.mode) {
            case 3: {
                this.wListener.outFullScreen();
                this.holder.mode = 2;
                this.wListener.inInteractive();
                break;
            }
            case 0: {
                break;
            }
        }
        super.showNotify();
    }

    public void animateSmallMode() {
    }

    public void go2SmallMode() {
        this.wantsFocus = false;
        this.invalidate();
    }

    protected void paint(Graphics g) {
        g.fillRect(0, 0, 210, 200);
        this.paint(g, 210, this.testHeight);
    }

    protected synchronized void keyPressed(int keyCode) {
        if (this.holder.mode != 2) {
            return;
        }
        int action = this.getGameAction(keyCode);
        switch (action) {
            case 1: {
                this.wListener.moveUp();
                break;
            }
            case 6: {
                this.wListener.moveDown();
                break;
            }
        }
        super.keyPressed(keyCode);
    }

    public void updateCommand() {
        if (this.holder.isLogin) {
            this.addCommand(this.refreshCmd);
        } else {
            this.removeCommand(this.refreshCmd);
        }
    }
}

