/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.data;

import com.sina.http.HttpEngine;
import com.sina.http.URLEncoder;
import com.sina.parser.xml.XMLDataBlock;
import com.sina.weibo.Client4widget;
import com.sina.weibo.ClientManager;
import com.sina.weibo.comm.G;
import com.sina.weibo.comm.Tools;
import com.sina.weibo.data.AbstractBowenList;
import com.sina.weibo.data.Bowen;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class BowenListModel
extends AbstractBowenList {
    private int currentID;
    public boolean loadHead;
    public boolean loading;
    public int loadHeadIndex;
    public boolean loadList;
    public int pageId = 1;
    public int pagesize = 20;
    public int count = 20;

    public BowenListModel(ClientManager cm) {
        super(cm);
        this.loadBowenList();
        if (this.bowenvc.size() > 0) {
            this.loadHeadList();
        }
        if (cm.currentAccount.sessionID == null || "".equals(cm.currentAccount.sessionID)) {
            this.login();
        } else if (this.bowenvc.size() == 0) {
            this.getBowenList(0, 0);
        }
    }

    public void getBowenList(int pageid, int type) {
        this.cm.setWait(true);
        if (pageid < 2) {
            this.pageId = 1;
        }
        StringBuffer send = new StringBuffer();
        send.append("picsize=176&sid=");
        send.append(this.cm.currentAccount.sessionID);
        send.append("&gsid=");
        send.append(this.cm.currentAccount.gsid);
        send.append("&page=");
        send.append(pageid);
        send.append("&pagesize=");
        send.append(this.pagesize);
        this.cm.httpEngine.HttpConnect(1, 0, String.valueOf(G.serverPath) + "getattmbloglist.php?" + send.toString(), null, this, HttpEngine.HIGH);
        this.loadList = true;
        this.loadHead = false;
        this.loadHeadIndex = 0;
    }

    public void loadBowenList() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)this.cm.currentAccount.accountID, (boolean)true);
            if (recordStore.getNumRecords() == 0) {
                recordStore.closeRecordStore();
                return;
            }
            RecordEnumeration recordenumeration = recordStore.enumerateRecords(null, null, false);
            while (recordenumeration.hasNextElement()) {
                ByteArrayInputStream bytearrayinputstream = new ByteArrayInputStream(recordStore.getRecord(recordenumeration.nextRecordId()));
                DataInputStream datainputstream = new DataInputStream(bytearrayinputstream);
                Bowen b = new Bowen(this.cm);
                b.userName = datainputstream.readUTF();
                b.realtime = datainputstream.readLong();
                b.updateTime();
                b.content = datainputstream.readUTF();
                b.rtrootnick = datainputstream.readUTF();
                b.rtreason = datainputstream.readUTF();
                b.uid = datainputstream.readUTF();
                b.mblogid = datainputstream.readUTF();
                b.pinglun = datainputstream.readInt();
                b.zhuanfa = datainputstream.readInt();
                b.headURL = datainputstream.readUTF();
                b.picURL = datainputstream.readUTF();
                datainputstream.close();
                datainputstream = null;
                this.bowenvc.insertElementAt(b, 0);
            }
            this.count = this.bowenvc.size();
            this.cm.updateView(3, 0);
            Client4widget.requestBack(this.bowenvc);
            recordStore.closeRecordStore();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveBowenList() {
        if (this.bowenvc.size() > 0) {
            try {
                RecordStore.deleteRecordStore((String)this.cm.currentAccount.accountID);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int i = 0;
        while (i < this.bowenvc.size()) {
            Bowen b = (Bowen)this.bowenvc.elementAt(i);
            ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
            DataOutputStream dataoutputstream = new DataOutputStream(bytearrayoutputstream);
            try {
                dataoutputstream.writeUTF(b.userName);
                dataoutputstream.writeLong(b.realtime);
                dataoutputstream.writeUTF(b.content);
                if (b.rtrootnick != null) {
                    dataoutputstream.writeUTF(b.rtrootnick);
                } else {
                    dataoutputstream.writeUTF("");
                }
                if (b.rtreason != null) {
                    dataoutputstream.writeUTF(b.rtreason);
                } else {
                    dataoutputstream.writeUTF("");
                }
                dataoutputstream.writeUTF(b.uid);
                dataoutputstream.writeUTF(b.mblogid);
                dataoutputstream.writeInt(b.pinglun);
                dataoutputstream.writeInt(b.zhuanfa);
                if (b.headURL != null) {
                    dataoutputstream.writeUTF(b.headURL);
                } else {
                    dataoutputstream.writeUTF("");
                }
                if (b.picURL != null) {
                    dataoutputstream.writeUTF(b.picURL);
                } else {
                    dataoutputstream.writeUTF("");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            byte[] abyte0 = bytearrayoutputstream.toByteArray();
            try {
                bytearrayoutputstream.close();
                bytearrayoutputstream = null;
                RecordStore recordStore = RecordStore.openRecordStore((String)this.cm.currentAccount.accountID, (boolean)true);
                recordStore.addRecord(abyte0, 0, abyte0.length);
                recordStore.closeRecordStore();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }

    private void clearHead() {
        try {
            RecordStore.deleteRecordStore((String)("HEAD" + this.cm.currentAccount.accountID));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addHead(String url, byte[] data) {
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        DataOutputStream dataoutputstream = new DataOutputStream(bytearrayoutputstream);
        try {
            dataoutputstream.writeUTF(url);
            if (data != null) {
                dataoutputstream.writeInt(data.length);
                int j = 0;
                while (j < data.length) {
                    dataoutputstream.writeByte(data[j]);
                    ++j;
                }
            } else {
                dataoutputstream.writeInt(0);
            }
        }
        catch (IOException j) {
            // empty catch block
        }
        byte[] abyte0 = bytearrayoutputstream.toByteArray();
        try {
            bytearrayoutputstream.close();
            bytearrayoutputstream = null;
            RecordStore recordStore = RecordStore.openRecordStore((String)("HEAD" + this.cm.currentAccount.accountID), (boolean)true);
            recordStore.addRecord(abyte0, 0, abyte0.length);
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadHeadList() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)("HEAD" + this.cm.currentAccount.accountID), (boolean)true);
            if (recordStore.getNumRecords() == 0) {
                recordStore.closeRecordStore();
                return;
            }
            RecordEnumeration recordenumeration = recordStore.enumerateRecords(null, null, false);
            while (recordenumeration.hasNextElement()) {
                ByteArrayInputStream bytearrayinputstream = new ByteArrayInputStream(recordStore.getRecord(recordenumeration.nextRecordId()));
                DataInputStream datainputstream = new DataInputStream(bytearrayinputstream);
                String url = datainputstream.readUTF();
                int len = datainputstream.readInt();
                if (len > 0) {
                    byte[] headIconByte = new byte[len];
                    int i = 0;
                    while (i < len) {
                        headIconByte[i] = datainputstream.readByte();
                        ++i;
                    }
                    try {
                        Image image = Image.createImage((byte[])headIconByte, (int)0, (int)headIconByte.length);
                        int i2 = 0;
                        while (i2 < this.bowenvc.size()) {
                            Bowen b = (Bowen)this.bowenvc.elementAt(i2);
                            if (url.equals(b.headURL)) {
                                b.headIcon = image;
                            }
                            ++i2;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                datainputstream.close();
                datainputstream = null;
            }
            if (Client4widget.mainCanvas != null) {
                this.cm.updateView(3, 0);
            }
            recordStore.closeRecordStore();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void login() {
        StringBuffer send = new StringBuffer();
        send.append("u=");
        send.append(URLEncoder.encode(this.cm.currentAccount.accountID, "UTF-8"));
        send.append("&p=");
        send.append(this.cm.currentAccount.pass);
        send.append("&c=java&s=");
        send.append(this.cm.currentAccount.md5);
        this.cm.httpEngine.HttpConnect(0, 0, String.valueOf(G.serverPath) + "login.php?" + send.toString(), null, this, HttpEngine.HIGH);
        if (this.bowenvc.size() == 0) {
            this.cm.setWait(true);
        }
    }

    public boolean blockArrived(XMLDataBlock data) {
        if (this.currentID == 0) {
            return this.parseLogin(data);
        }
        if (this.currentID == 1) {
            return this.parseBowenList(data);
        }
        if (this.currentID == 3) {
            this.parseAddBowen(data);
        } else if (this.currentID == 4) {
            this.parseAddPinglun(data);
        } else if (this.currentID == 5) {
            this.parseAddZhuanfa(data);
        }
        return true;
    }

    private void parseAddBowen(XMLDataBlock data) {
        try {
            if (!data.getTagName().equals("rss")) {
                this.cm.showAlert("\u53d1\u9001\u5931\u8d25");
                this.cm.setWait(false);
                return;
            }
            Vector childvc = data.getChildBlocks();
            boolean err = false;
            if (childvc != null) {
                int i = 0;
                while (i < childvc.size()) {
                    XMLDataBlock itemdata = (XMLDataBlock)childvc.elementAt(i);
                    if (itemdata.getTagName().equals("sid")) {
                        this.cm.currentAccount.sessionID = itemdata.getText();
                    } else if (itemdata.getTagName().equals("result")) {
                        if ("0".equals(itemdata.getText())) {
                            err = true;
                        }
                    } else if (itemdata.getTagName().equals("errno")) {
                        err = true;
                    } else if (!itemdata.getTagName().equals("errmsg")) {
                        itemdata.getTagName().equals("url");
                    }
                    itemdata.close();
                    ++i;
                }
            }
            data.close();
            if (!err) {
                this.cm.showAlert("\u53d1\u9001\u6210\u529f");
                if (!Client4widget.isCamera) {
                    this.cm.back(true);
                }
            } else {
                this.cm.showAlert("\u53d1\u9001\u5931\u8d25\uff01");
            }
            this.cm.setWait(false);
            System.gc();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean parseLogin(XMLDataBlock data) {
        block20: {
            if (data.getTagName().equals("rss")) break block20;
            return false;
        }
        try {
            Vector childvc = data.getChildBlocks();
            boolean re = true;
            String errstr = null;
            if (childvc != null) {
                int i = 0;
                while (i < childvc.size()) {
                    XMLDataBlock item = (XMLDataBlock)childvc.elementAt(i);
                    if (item.getTagName().equals("gsid")) {
                        this.cm.currentAccount.gsid = item.getText();
                    } else if (item.getTagName().equals("errno")) {
                        re = false;
                    } else if (item.getTagName().equals("errmsg")) {
                        errstr = item.getText();
                    } else if (item.getTagName().equals("sid")) {
                        this.cm.currentAccount.sessionID = item.getText();
                    } else if (item.getTagName().equals("status")) {
                        this.cm.currentAccount.isFull = "1".equals(item.getText());
                    } else if (item.getTagName().equals("nick")) {
                        this.cm.currentAccount.nick = item.getText();
                    }
                    item.close();
                    ++i;
                }
            }
            data.close();
            if (re) {
                if (this.bowenvc.size() == 0) {
                    this.cm.setWait(false);
                    this.getBowenList(0, 0);
                } else {
                    this.loadHead = true;
                }
            } else {
                this.cm.showAlert(errstr);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean parseBowenList(XMLDataBlock data) {
        block44: {
            if (data.getTagName().equals("rss")) break block44;
            return false;
        }
        try {
            this.bowenvc.removeAllElements();
            Vector childvc = data.getChildBlocks();
            if (childvc != null) {
                int i = 0;
                while (i < childvc.size()) {
                    XMLDataBlock itemdata = (XMLDataBlock)childvc.elementAt(i);
                    if (itemdata.getTagName().equals("mblog")) {
                        Bowen item = new Bowen(this.cm);
                        Vector child2 = itemdata.getChildBlocks();
                        if (child2 != null) {
                            int j = 0;
                            while (j < child2.size()) {
                                XMLDataBlock cc = (XMLDataBlock)child2.elementAt(j);
                                if (cc.getTagName().equals("nick")) {
                                    item.userName = cc.getText();
                                } else if (cc.getTagName().equals("uid")) {
                                    item.uid = cc.getText();
                                } else if (cc.getTagName().equals("mblogid")) {
                                    item.mblogid = cc.getText();
                                } else if (cc.getTagName().equals("content")) {
                                    String s = cc.getText();
                                    item.content = Tools.replace(s, "\\n", "\n");
                                } else if (cc.getTagName().equals("rtnum")) {
                                    try {
                                        item.zhuanfa = Integer.parseInt(cc.getText());
                                    }
                                    catch (RuntimeException e) {
                                        e.printStackTrace();
                                    }
                                } else if (cc.getTagName().equals("commentnum")) {
                                    try {
                                        item.pinglun = Integer.parseInt(cc.getText());
                                    }
                                    catch (RuntimeException e) {
                                        e.printStackTrace();
                                    }
                                } else if (cc.getTagName().equals("portrait")) {
                                    item.headURL = cc.getText();
                                } else if (cc.getTagName().equals("rtrootnick")) {
                                    item.rtrootnick = cc.getText();
                                } else if (cc.getTagName().equals("rtreason")) {
                                    item.rtreason = cc.getText();
                                } else if (cc.getTagName().equals("time")) {
                                    try {
                                        item.realtime = Long.parseLong(cc.getText());
                                        item.updateTime();
                                    }
                                    catch (RuntimeException runtimeException) {}
                                } else if (cc.getTagName().equals("pic")) {
                                    item.picURL = cc.getText();
                                }
                                cc.close();
                                ++j;
                            }
                        }
                        item.updateContent();
                        this.bowenvc.addElement(item);
                    } else if (itemdata.getTagName().equals("count")) {
                        this.count = Integer.parseInt(itemdata.getText());
                    } else if (itemdata.getTagName().equals("sid")) {
                        this.cm.currentAccount.sessionID = itemdata.getText();
                    }
                    ++i;
                }
            }
            data.close();
            this.loadHead = true;
            this.loadHeadIndex = 0;
            try {
                if (Client4widget.mainCanvas != null) {
                    this.cm.updateView(3, 0);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.pageId == 1) {
                Client4widget.requestBack(this.bowenvc);
            }
            this.cm.setWait(false);
            if (this.pageId == 1) {
                this.clearHead();
                this.saveBowenList();
            }
            System.gc();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void handleHttpError(int httpid, String errostr) {
        if (Client4widget.mainCanvas != null) {
            this.cm.showAlert("\u7f51\u7edc\u8fde\u63a5\u5931\u8d25\uff01\u8bf7\u5c1d\u8bd5\u5728\u5e10\u6237\u9875\u91cd\u7f6e\u7f51\u7edc\u3002");
            this.cm.setWait(false);
        }
    }

    public boolean receiveHttpResponse(int httpid, int type, byte[] dis) {
        block14: {
            block15: {
                this.currentID = httpid;
                if (dis == null) {
                    if (type == 0) {
                        this.cm.showAlert("\u6570\u636e\u53d1\u9001\u5931\u8d25\uff01");
                        this.cm.setWait(false);
                    }
                    return true;
                }
                if (this.currentID != 2) break block14;
                if (this.loadHead) break block15;
                this.loading = false;
                return true;
            }
            try {
                Bowen b = (Bowen)this.bowenvc.elementAt(this.loadHeadIndex);
                b.headIcon = Image.createImage((byte[])dis, (int)0, (int)dis.length);
                int i = this.loadHeadIndex + 1;
                while (i < this.bowenvc.size()) {
                    Bowen b1 = (Bowen)this.bowenvc.elementAt(i);
                    if (b1.headURL.equals(b.headURL)) {
                        b1.headIcon = b.headIcon;
                    }
                    ++i;
                }
                try {
                    if (Client4widget.mainCanvas != null) {
                        this.cm.updateView(3, 1);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (this.pageId == 1) {
                    this.addHead(b.headURL, dis);
                }
                ++this.loadHeadIndex;
                if (this.loadHeadIndex == this.bowenvc.size()) {
                    this.loadHead = false;
                    this.loadHeadIndex = 0;
                }
                this.loading = false;
                if (this.pageId == 1) {
                    Client4widget.updateHead(b.uid, b.headIcon);
                }
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
        return this.cm.xmlEngine.receiveHttpResponse(dis, this);
    }

    public void loadNextHead() {
        this.loading = true;
        Bowen b = (Bowen)this.bowenvc.elementAt(this.loadHeadIndex);
        if (b.headIcon == null) {
            this.cm.httpEngine.HttpConnect(2, 0, b.headURL, null, this, HttpEngine.HIGH);
        } else {
            ++this.loadHeadIndex;
            if (this.loadHeadIndex >= this.bowenvc.size()) {
                this.loadHead = false;
                this.loadHeadIndex = 0;
            }
            this.loading = false;
            if (this.pageId == 1) {
                Client4widget.updateHead(b.uid, b.headIcon);
            }
        }
    }

    public void addBowen(String bowenContent, byte[] pic) {
        StringBuffer send = new StringBuffer();
        send.append("sid=");
        send.append(this.cm.currentAccount.sessionID);
        send.append("&gsid=");
        send.append(this.cm.currentAccount.gsid);
        if (pic != null) {
            byte[] content;
            StringBuffer bytearray = new StringBuffer();
            bytearray.append("-----------------------------7d33a816d302b6");
            bytearray.append("\r\nContent-Disposition: form-data; name=\"gsid\"");
            bytearray.append("\r\n\r\n");
            bytearray.append(this.cm.currentAccount.gsid);
            bytearray.append("\r\n-----------------------------7d33a816d302b6");
            bytearray.append("\r\nContent-Disposition: form-data; name=\"content\"");
            bytearray.append("\r\n\r\n");
            byte[] begin = bytearray.toString().getBytes();
            try {
                content = bowenContent.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                content = bowenContent.getBytes();
                e.printStackTrace();
            }
            bytearray = new StringBuffer();
            bytearray.append("\r\n-----------------------------7d33a816d302b6");
            bytearray.append("\r\nContent-Disposition: form-data; name=\"pic\"; filename=\"flower.jpg\"");
            bytearray.append("\r\nContent-Type: image/jpeg");
            bytearray.append("\r\n\r\n");
            byte[] picbyte = bytearray.toString().getBytes();
            byte[] end = "\r\n-----------------------------7d33a816d302b6\r\n".getBytes();
            byte[] data = new byte[begin.length + content.length + picbyte.length + pic.length + end.length];
            System.arraycopy(begin, 0, data, 0, begin.length);
            System.arraycopy(content, 0, data, begin.length, content.length);
            System.arraycopy(picbyte, 0, data, begin.length + content.length, picbyte.length);
            System.arraycopy(pic, 0, data, begin.length + content.length + picbyte.length, pic.length);
            System.arraycopy(end, 0, data, begin.length + content.length + picbyte.length + pic.length, end.length);
            this.cm.httpEngine.HttpConnect(3, String.valueOf(G.serverPath) + "addmblog.php?" + send.toString(), data, this);
        } else {
            String s = "&content=" + URLEncoder.encode(bowenContent, "UTF-8");
            this.cm.httpEngine.HttpConnect(3, 0, String.valueOf(G.serverPath) + "addmblog.php?" + send.toString(), s, this, HttpEngine.HIGH);
        }
        this.cm.setWait(true);
    }
}

