/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.view;

import com.sina.ui.BackItem;
import com.sina.ui.InputBox;
import com.sina.ui.InputListener;
import com.sina.ui.ListItem;
import com.sina.ui.ListListener;
import com.sina.ui.ListRollContainer;
import com.sina.ui.MenuItem;
import com.sina.ui.TabBar;
import com.sina.ui.WeiboListItem;
import com.sina.weibo.ClientManager;
import com.sina.weibo.comm.G;
import com.sina.weibo.comm.SMSManager;
import com.sina.weibo.comm.Tools;
import com.sina.weibo.data.Account;
import com.sina.weibo.data.TuijianAccountListModel;
import com.sina.weibo.view.AbstractView;

public class TuijianAccountListView
extends AbstractView
implements ListListener,
InputListener {
    private String[] menuItems = new String[]{"\u6253\u5f00", "\u53d1\u8868\u5fae\u535a", "\u641c\u7d22", "\u5207\u6362\u7528\u6237", "\u63a8\u8350\u597d\u53cb", "\u9000\u51fa"};
    private TuijianAccountListModel blm;

    public TuijianAccountListView(ClientManager cm, TuijianAccountListModel blm) {
        super(cm);
        this.viewID = 15;
        this.blm = blm;
        this.init();
    }

    public void keyPressed(int keyCode) {
        if (this.menu.isOpen) {
            this.menuKeyPressed(keyCode);
            return;
        }
        byte keyType = Tools.keyCompare(keyCode);
        switch (keyType) {
            case 5: 
            case 7: {
                super.keyPressed(keyCode);
                break;
            }
            case 6: {
                this.blm.getAcount();
                break;
            }
            case 3: {
                this.cm.back(false);
                break;
            }
            case 1: {
                if (!this.list.movePre()) break;
                this.list.gotFocus((byte)1);
                break;
            }
            case 2: {
                if (!this.list.moveNext()) break;
                this.list.gotFocus((byte)0);
                break;
            }
            case 4: {
                this.cm.changeStageWithId(this.viewID, 16, 0, false);
            }
        }
    }

    public void destroy() {
    }

    public void doMenuItem(int id) {
        if (this.cm.currentAccount == null && id < 3) {
            this.cm.showRegAlert("\u53ea\u6709\u767b\u5f55\u7528\u6237\u624d\u80fd\u4f7f\u7528\u8be5\u529f\u80fd\uff01");
            this.closeMenuList();
            return;
        }
        switch (id) {
            case 0: {
                this.list.doEntry();
                break;
            }
            case 1: {
                this.cm.changeStageWithId(this.viewID, 5, 0, false);
                break;
            }
            case 2: {
                this.cm.search();
                break;
            }
            case 3: {
                this.cm.changeStageWithId(this.viewID, 7, 0, false);
                break;
            }
            case 4: {
                new InputBox("\u624b\u673a\u53f7\uff1a", "", 17, 3, this, 1);
                break;
            }
            case 5: {
                this.cm.quit();
            }
        }
        this.closeMenuList();
    }

    private void init() {
        BackItem li = null;
        li = this.cm.currentAccount == null ? new BackItem("\u5f53\u524d\u7528\u6237\uff1a\u5fae\u535a\u6e38\u5ba2") : new BackItem("\u5f53\u524d\u7528\u6237\uff1a" + this.cm.currentAccount.nick);
        li.setPaintx(0);
        li.setPainty(0);
        li.setWidth(G.W);
        this.lrc.addItem(li);
        TabBar tb = null;
        tb = this.cm.currentAccount == null ? new TabBar(G.CommTabItems, 1) : new TabBar(G.TabItems, 8);
        tb.setPainty(li.getHeight());
        this.list = new ListRollContainer(G.W, G.H - li.getHeight() - G.MenuBarHeight - tb.getHeight());
        this.list.setPainty(li.getHeight() + tb.getHeight());
        this.lrc.addItem(this.list);
        this.lrc.addItem(tb);
        this.menu.setRight("\u5237\u65b0");
        this.update(0);
    }

    public void update(int type) {
        if (this.blm.account.size() > 0) {
            if (type == 1) {
                int i = 0;
                while (i < this.blm.account.size()) {
                    WeiboListItem li = (WeiboListItem)this.list.getItem(i);
                    Account bowen = (Account)this.blm.account.elementAt(i);
                    li.setIcon(bowen.headIMG);
                    ++i;
                }
                this.render();
                return;
            }
            if (type == 0) {
                this.list.removeAll();
                if (this.blm != null && this.blm.account != null) {
                    this.blm.loadList = false;
                    int i = 0;
                    while (i < this.blm.account.size()) {
                        Account bowen = (Account)this.blm.account.elementAt(i);
                        WeiboListItem li = new WeiboListItem(bowen.nick, bowen.sex, bowen.fensishu, "", i, this, this.list);
                        li.setIcon(bowen.headIMG);
                        this.list.addItem(li);
                        ++i;
                    }
                }
            }
        } else {
            this.list.removeAll();
            ListItem li = new ListItem("\u8bf7\u5237\u65b0\u6570\u636e", -99, (ListListener)this, this.list, 1);
            this.list.addItem(li);
        }
        this.list.gotFocus((byte)1);
        this.render();
    }

    public void listitemPressed(int id) {
        if (id >= 0) {
            if (this.cm.currentAccount == null) {
                this.cm.showRegAlert("\u53ea\u6709\u767b\u5f55\u7528\u6237\u624d\u80fd\u4f7f\u7528\u8be5\u529f\u80fd\uff01");
            } else {
                this.cm.changeStageWithObject(this.viewID, 13, this.blm.account.elementAt(id), false);
            }
        } else if (id == -99) {
            this.blm.getAcount();
        }
    }

    protected void showMenu() {
        if (this.menu.empty()) {
            int i = 0;
            while (i < this.menuItems.length) {
                MenuItem menuitem = new MenuItem(this.menuItems[i], i, this);
                this.menu.addItem(menuitem);
                ++i;
            }
        }
        this.openMenuList();
    }

    public void tick(long time) {
        if (this.blm.loadHead && !this.blm.loading && this.blm.account.size() > 0) {
            this.blm.loadNextHead();
        }
    }

    public void setText(String text, int id) {
        if (text != null && !"".equals(text)) {
            if (this.cm.currentAccount != null) {
                SMSManager.sendSMS("Hi\uff0c\u6211\u5f00\u901a\u4e86\u5fae\u535a\uff0c\u4f60\u53ef\u4ee5\u901a\u8fc7\u201c\u5173\u6ce8\u6211\u201d\u4e86\u89e3\u6211\u7684\u8fd1\u51b5\uff0c\u968f\u65f6\u4e0e\u6211\u4fdd\u6301\u8054\u7cfb\u3002\nhttp://t.sina.cn/" + this.cm.currentAccount.uid, text);
            } else {
                SMSManager.sendSMS("Hi\uff0c\u770b\u770b\u5927\u5bb6\u90fd\u5728\u804a\u4ec0\u4e48\uff1f\u52a0\u5165\u65b0\u6d6a\u5fae\u535a,\u968f\u65f6\u968f\u5730\u5206\u4eab\u65b0\u9c9c\u4e8b\u513f!\nhttp://t.sina.cn/", text);
            }
        }
    }
}

