/*
 * Decompiled with CFR 0.152.
 */
package com.sina.parser.xml;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class XMLDataBlock {
    private String tagName;
    protected Vector childBlocks;
    protected StringBuffer textData = null;
    protected XMLDataBlock parent;
    public Hashtable attributes;

    public XMLDataBlock() {
        this("unknown", null, null);
    }

    public void close() {
        this.tagName = null;
        if (this.childBlocks != null) {
            this.childBlocks.removeAllElements();
        }
        this.childBlocks = null;
        this.textData = null;
        if (this.attributes != null) {
            this.attributes.clear();
        }
        this.attributes = null;
    }

    public XMLDataBlock(XMLDataBlock _parent) {
        this("unknown", _parent, null);
    }

    public XMLDataBlock(XMLDataBlock _parent, Hashtable _attributes) {
        this("unknown", _parent, _attributes);
    }

    public XMLDataBlock(String _tagName, XMLDataBlock _parent, Hashtable _attributes) {
        this.parent = _parent;
        this.attributes = _attributes;
        this.tagName = _tagName;
    }

    public void addChild(XMLDataBlock newData) {
        if (this.childBlocks == null) {
            this.childBlocks = new Vector(11);
        }
        this.childBlocks.addElement(newData);
    }

    public static void addChildDataBlock(String _tagName, XMLDataBlock _parent, Hashtable _attributes, String resource) {
        XMLDataBlock resourceBlock = new XMLDataBlock(_tagName, _parent, _attributes);
        resourceBlock.addText(resource);
        _parent.addChild(resourceBlock);
    }

    public void addText(String text) {
        if (this.textData == null) {
            this.textData = new StringBuffer();
        }
        this.textData.append(text);
    }

    public XMLDataBlock getParent() {
        return this.parent;
    }

    public String getText() {
        if (this.textData == null) {
            return "";
        }
        return XMLDataBlock.explainReStr(this.textData.toString());
    }

    public static String explainReStr(String restr) {
        if (restr == null || restr.length() < 1) {
            return "";
        }
        if (restr.indexOf("&") < 0) {
            return restr;
        }
        StringBuffer sendsb = new StringBuffer();
        char[] chars = restr.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '&') {
                if (chars[i + 1] == 'l' && chars[i + 2] == 't' && chars[i + 3] == ';') {
                    sendsb.append('<');
                    i += 4;
                    continue;
                }
                if (chars[i + 1] == 'q' && chars[i + 2] == 'u' && chars[i + 3] == 'o' && chars[i + 4] == 't' && chars[i + 5] == ';') {
                    sendsb.append('\"');
                    i += 6;
                    continue;
                }
                if (chars[i + 1] == 'a' && chars[i + 2] == 'p' && chars[i + 3] == 'o' && chars[i + 4] == 's' && chars[i + 5] == ';') {
                    sendsb.append('\'');
                    i += 6;
                    continue;
                }
                if (chars[i + 1] == 'a' && chars[i + 2] == 'm' && chars[i + 3] == 'p' && chars[i + 4] == ';') {
                    sendsb.append('&');
                    i += 5;
                    continue;
                }
                sendsb.append(chars[i]);
                ++i;
                continue;
            }
            sendsb.append(chars[i]);
            ++i;
        }
        return sendsb.toString();
    }

    public String getAttribute(String attributeName) {
        if (this.attributes == null) {
            return "";
        }
        return XMLDataBlock.explainReStr((String)this.attributes.get(attributeName));
    }

    public void setAttribute(String attributeName, String value) {
        if (attributeName == null || value == null) {
            return;
        }
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        this.attributes.put(attributeName, value);
    }

    public Vector getChildBlocks() {
        return this.childBlocks;
    }

    public String toString() {
        String tagStart = this.getTagStart();
        StringBuffer data = new StringBuffer(tagStart);
        if (this.textData != null) {
            data.append((Object)this.textData);
        }
        if (this.childBlocks != null) {
            Enumeration e = this.childBlocks.elements();
            while (e.hasMoreElements()) {
                XMLDataBlock thisBlock = (XMLDataBlock)e.nextElement();
                data.append(thisBlock.toString());
            }
        }
        String endTag = this.getTagEnd();
        data.append(endTag);
        return data.toString();
    }

    protected void addAttributeToStringBuffer(StringBuffer buffer) {
        Enumeration e = this.attributes.keys();
        while (e.hasMoreElements()) {
            String nextKey = (String)e.nextElement();
            String nextValue = (String)this.attributes.get(nextKey);
            buffer.append(String.valueOf(' ') + nextKey + "=\"" + nextValue + '\"');
        }
    }

    public String getTagStart() {
        StringBuffer tagStart = new StringBuffer("<" + this.getTagName());
        if (this.attributes != null) {
            this.addAttributeToStringBuffer(tagStart);
        }
        if (this.childBlocks == null && this.textData == null) {
            tagStart.append("/>");
        } else {
            tagStart.append('>');
        }
        return tagStart.toString();
    }

    public String getTagEnd() {
        if (this.childBlocks == null && this.textData == null) {
            return "";
        }
        StringBuffer end = new StringBuffer("</" + this.getTagName() + '>');
        return end.toString();
    }

    public String getTagName() {
        return this.tagName;
    }

    public void removegetAttribute(String name) {
        this.attributes.remove(name);
    }
}

