/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.sina.widget;

import com.sina.weibo.Client4widget;
import com.sina.weibo.ClientManager;
import com.sina.weibo.data.Account;
import com.sonyericsson.lcdui.IdleItem;
import com.sonyericsson.sina.img.ImageComForm;
import com.sonyericsson.sina.util.DynamicItem;
import com.sonyericsson.sina.util.LoginData;
import com.sonyericsson.sina.util.LoginDataAccess;
import com.sonyericsson.sina.util.NetworkThread;
import com.sonyericsson.sina.widget.ItemHolder;
import com.sonyericsson.sina.widget.SinaWidget;
import com.sonyericsson.sina.widget.TimerThread;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.amms.GlobalManager;
import javax.microedition.amms.MediaProcessor;
import javax.microedition.amms.control.ImageFormatControl;
import javax.microedition.amms.control.imageeffect.ImageTransformControl;
import javax.microedition.content.ContentHandlerServer;
import javax.microedition.content.Invocation;
import javax.microedition.content.Registry;
import javax.microedition.content.RequestListener;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class SinawidgetMIDlet
extends MIDlet
implements RequestListener,
ItemCommandListener,
CommandListener {
    private SinaWidget widget;
    public static Display display;
    public ItemHolder holder;
    LoginData loginInfo;
    private TimerThread timerThread;
    public NetworkThread networkThread;
    public static SinawidgetMIDlet instance;
    private ImageComForm imgf;
    private List listRefreshSet = null;
    private ContentHandlerServer server;
    static boolean Debug;
    int selectedIndexImg;

    static {
        Debug = false;
    }

    public SinawidgetMIDlet() {
        instance = this;
        display = Display.getDisplay((MIDlet)this);
    }

    protected void destroyApp(boolean arg0) throws MIDletStateChangeException {
        if (LoginDataAccess.loginDataExists()) {
            ClientManager.getInstance().destroyApp();
            Client4widget.desdroy();
            LoginDataAccess.deleteRecordStore();
        }
    }

    protected void pauseApp() {
    }

    protected void startApp() {
        this.imgf = new ImageComForm("");
        this.widget = new SinaWidget();
        this.holder = ItemHolder.getInstance();
        this.networkThread = new NetworkThread();
        this.widget.setMcListener(this.holder);
        this.widget.setItemCommandListener(this);
        this.widget.listRefreshSet.setCommandListener((CommandListener)this);
        IdleItem.setOnDisplay((Display)display, (IdleItem)this.widget);
        String classname = super.getClass().getName();
        try {
            this.server = Registry.getServer((String)classname);
            this.server.setListener((RequestListener)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.loginInfo = new LoginData();
        this.holder.isLogin = false;
    }

    public void myAccount(Account account) {
        if (account != null) {
            this.loginInfo.gsid = account.gsid;
            this.loginInfo.strLogin = account.nick;
            this.loginInfo.strPassword = account.pass;
            this.loginInfo.bNetPrompt = true;
            this.loginInfo.bStorePassword = true;
            LoginDataAccess.writeConfig(this.loginInfo);
            this.updateStatus();
            if (this.timerThread == null) {
                this.timerThread = new TimerThread(this);
                new Thread(this.timerThread).start();
            }
            if (!this.timerThread.isAlive()) {
                this.timerThread.start();
            }
            if (!this.timerThread.isRunning) {
                this.timerThread.notify();
            }
        }
    }

    private void updateSetRe() {
        int nUp = this.loginInfo.nAutoUpdateFrequency / 60;
        switch (nUp) {
            case 5: {
                this.widget.setRe = 1;
                break;
            }
            case 10: {
                this.widget.setRe = 2;
                break;
            }
            case 30: {
                this.widget.setRe = 3;
                break;
            }
            case 60: {
                this.widget.setRe = 4;
                break;
            }
            case 43200: {
                this.widget.setRe = 0;
            }
        }
    }

    public void showWidget() {
        display.setCurrent(null);
        Client4widget.mainCanvas.run = false;
        Client4widget.mainCanvas = null;
        ClientManager.getInstance().destroyApp();
        System.gc();
    }

    public String[] handleRequest() {
        return null;
    }

    public void handleRequests() {
        Invocation invoc;
        if (this.server == null) {
            return;
        }
        do {
            if ((invoc = this.server.getRequest(false)) == null) continue;
            String url = invoc.getURL();
            String[] out = this.handleRequest();
            if (url.startsWith("file:")) {
                try {
                    this.imgf.photoData = null;
                    InputStream is = null;
                    FileConnection fc = null;
                    fc = (FileConnection)Connector.open((String)url);
                    is = fc.openInputStream();
                    ByteArrayOutputStream baos1 = new ByteArrayOutputStream();
                    this.scaleImage(is, baos1, true, this.imgf.sizeX[this.imgf.DATA_phoneSizeType], this.imgf.sizeY[this.imgf.DATA_phoneSizeType]);
                    this.imgf.photoData = baos1.toByteArray();
                    Client4widget.isCamera = true;
                    Client4widget.sendWeibo(this.loginInfo.gsid, this.imgf.photoData);
                    is.close();
                    is = null;
                    baos1.close();
                    baos1 = null;
                    is = fc.openInputStream();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (invoc.getResponseRequired()) {
                invoc.setArgs(out);
            }
            this.server.finish(invoc, 5);
        } while (invoc != null);
    }

    public void scaleImage(InputStream is, OutputStream os, boolean maintainAspectRatio, int wid, int hei) {
        try {
            MediaProcessor processor = GlobalManager.createMediaProcessor((String)"image/jpeg");
            processor.setInput(is, is.available());
            processor.setOutput(os);
            ImageTransformControl transform = (ImageTransformControl)processor.getControl("javax.microedition.amms.control.imageeffect.ImageTransformControl");
            ImageFormatControl format = (ImageFormatControl)processor.getControl("javax.microedition.amms.control.ImageFormatControl");
            transform.setEnabled(true);
            int sourceWidth = transform.getSourceWidth();
            int sourceHeight = transform.getSourceHeight();
            int width = wid;
            int height = hei;
            this.imgf.horizontalMode = true;
            if (sourceWidth < sourceHeight) {
                this.imgf.horizontalMode = false;
                int temp = width;
                width = height;
                height = temp;
            }
            if (maintainAspectRatio && sourceWidth > sourceHeight) {
                height = width * sourceHeight / sourceWidth;
            } else if (maintainAspectRatio) {
                width = height * sourceWidth / sourceHeight;
            }
            transform.setSourceRect(0, 0, sourceWidth, sourceHeight);
            transform.setTargetSize(width, height, 0);
            format.setFormat("image/jpeg");
            format.setParameter("quality", 75);
            processor.complete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void invocationRequestNotify(ContentHandlerServer server) {
        if (Client4widget.mainCanvas != null) {
            this.showWidget();
        }
        display.setCurrent(null);
        this.listRefreshSet = null;
        this.handleRequests();
    }

    public void updateStatus() {
        this.holder.isLogin = this.isLogin();
        this.widget.updateCommand();
    }

    private boolean isLogin() {
        return this.loginInfo != null && this.loginInfo.gsid != null && !this.loginInfo.equals("");
    }

    public void commandAction(Command c, Displayable d) {
        if (Client4widget.mainCanvas != null) {
            this.showWidget();
        }
        if (d.equals(this.listRefreshSet)) {
            if (c.equals(this.widget.backCmd)) {
                int selectedIndex = this.widget.listRefreshSet.getSelectedIndex();
                if (!this.timerThread.isAlive) {
                    this.timerThread.isAlive = true;
                    new Thread(this.timerThread).start();
                }
                switch (selectedIndex) {
                    case 1: {
                        this.loginInfo.nAutoUpdateFrequency = 300;
                        LoginDataAccess.writeConfig(this.loginInfo);
                        break;
                    }
                    case 2: {
                        this.loginInfo.nAutoUpdateFrequency = 600;
                        LoginDataAccess.writeConfig(this.loginInfo);
                        break;
                    }
                    case 3: {
                        this.loginInfo.nAutoUpdateFrequency = 1800;
                        LoginDataAccess.writeConfig(this.loginInfo);
                        break;
                    }
                    case 4: {
                        this.loginInfo.nAutoUpdateFrequency = 3600;
                        LoginDataAccess.writeConfig(this.loginInfo);
                        break;
                    }
                    case 0: {
                        this.timerThread.close();
                        this.loginInfo.nAutoUpdateFrequency = 2592000;
                        LoginDataAccess.writeConfig(this.loginInfo);
                    }
                }
                this.updateSetRe();
                display.setCurrent(null);
                this.listRefreshSet = null;
            }
        } else {
            d.equals((Object)this.imgf);
        }
    }

    public void commandAction(Command c, Item item) {
        if (Client4widget.mainCanvas != null) {
            this.showWidget();
        }
        if (item.equals(this.imgf.cgSizeOfImage)) {
            this.selectedIndexImg = this.imgf.cgSizeOfImage.getSelectedIndex();
        }
        if (item != null && item.equals((Object)this.widget)) {
            if (c.equals(this.widget.backCmd)) {
                this.widget.go2SmallMode();
            } else if (c.equals(this.widget.viewCmd)) {
                Client4widget.isCamera = false;
                if (!this.isLogin()) {
                    Client4widget.gotoLogin();
                    return;
                }
                DynamicItem dItem = this.holder.get(0);
                if (dItem == null) {
                    Client4widget.gotoViewList(this.loginInfo.gsid, 0);
                } else {
                    Client4widget.gotoViewList(this.loginInfo.gsid, this.holder.getFocusedIndex());
                }
                ItemHolder.mode = 3;
            } else if (c.equals(this.widget.refreshCmd)) {
                this.readNetWork();
            } else if (c.equals(this.widget.refreshSetCmd)) {
                display.setCurrent(null);
                this.listRefreshSet = this.widget.listRefreshSet;
                display.setCurrent((Displayable)this.listRefreshSet);
            } else if (c.equals(this.widget.updateBlogCmd)) {
                try {
                    Client4widget.sendWeibo(this.loginInfo.gsid, null);
                }
                catch (Throwable t) {
                    System.out.println("sendweibo: " + t.toString());
                }
            }
        }
    }

    public void readNetWork() {
        this.readNetWork(false);
    }

    public void readNetWork(boolean isImage) {
        this.networkThread.trigRead(this.loginInfo.gsid, isImage);
    }

    public void deleteUser(String gsid) {
        if (gsid != null && gsid.equals(this.loginInfo.gsid)) {
            LoginDataAccess.deleteRecordStore();
            this.loginInfo = new LoginData();
            this.holder.isLogin = false;
            this.widget.updateCommand();
        }
    }
}

