/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public class Log {
    private static final String COLON = ": ";
    private static final String LINE_SEPARETOR = "\n";
    private static final String DEBUG = "DEBUG";
    private static final String INFO = "INFO";
    private static final String ERROR = "ERROR";
    private static FileConnection fileConn;
    private static final String PATH = "file:///c:/other/kxw.log";
    private static DataOutputStream os;

    private Log() {
    }

    public static void debug(String content) {
        Log.addStringItem(content, DEBUG);
    }

    public static void info(String content) {
        Log.addStringItem(content, INFO);
    }

    public static void error(String content) {
        Log.addStringItem(content, ERROR);
    }

    private static void addStringItem(String content, String string) {
        Log.wiriteContent(string);
        Log.wiriteContent(COLON);
        Log.wiriteContent(content);
        Log.wiriteContent(LINE_SEPARETOR);
    }

    public static void openFileConnection() {
        try {
            fileConn = (FileConnection)Connector.open((String)PATH);
            ByteArrayOutputStream out = null;
            if (fileConn.exists()) {
                InputStream in = fileConn.openInputStream();
                int n = -1;
                byte[] buffer = new byte[1024];
                out = new ByteArrayOutputStream();
                while ((n = in.read(buffer)) != -1) {
                    out.write(buffer, 0, n);
                }
                buffer = null;
                in.close();
                fileConn.delete();
            }
            fileConn.create();
            if (fileConn.canWrite()) {
                os = new DataOutputStream(fileConn.openOutputStream());
                if (out != null && out.size() > 0) {
                    os.write(out.toByteArray(), 0, out.size());
                    out.close();
                    out = null;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static synchronized void wiriteContent(String content) {
        System.out.print(content);
        if (os != null) {
            try {
                os.writeUTF(content);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeFileConnection() {
        if (os != null) {
            try {
                os.flush();
                os.close();
                os = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (fileConn != null) {
            try {
                fileConn.close();
                fileConn = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

