/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.lcdui;

import javax.microedition.lcdui.Graphics;
import org.netbeans.microedition.lcdui.TablePaintStrategy;
import org.netbeans.microedition.lcdui.laf.TableColorSchema;

class TableColorSchemaStrategy
implements TablePaintStrategy {
    private TableColorSchema myColorSchema;

    TableColorSchemaStrategy(TableColorSchema colorSchema) {
        this.myColorSchema = colorSchema;
    }

    public void drawHeaderBackground(Graphics g, int index, int x, int y, int width, int height) {
        if (this.getColorSchema().isHeaderTransparent(index)) {
            return;
        }
        g.setColor(this.getColorSchema().getHeaderColor(index, 0));
        g.fillRect(x, y, width, height);
    }

    public int getForegroundHeaderColor(int x) {
        return this.getColorSchema().getHeaderColor(x, 1);
    }

    public int getColor(int x, int y, int colorSpecifier) {
        return this.getColorSchema().getColor(x, y, colorSpecifier);
    }

    public void drawCell(Graphics g, int column, int row, int x, int y, int width, int height, int colorSpecifier) {
        if (this.getColorSchema().isBackgroundTransparent(column, row)) {
            return;
        }
        g.setColor(this.getColorSchema().getColor(column, row, colorSpecifier));
        g.fillRect(x, y, width, height);
    }

    private TableColorSchema getColorSchema() {
        return this.myColorSchema;
    }
}

