/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.kx.widget;

import com.jw.text.TextConstants;
import com.sonyericsson.kx.DynamicItem;
import com.sonyericsson.kx.LoginData;
import com.sonyericsson.kx.LoginDataAccess;
import com.sonyericsson.kx.MainAppWatcher;
import com.sonyericsson.kx.NetworkThread;
import com.sonyericsson.kx.SessionData;
import com.sonyericsson.kx.SessionDataAccess;
import com.sonyericsson.kx.StatusData;
import com.sonyericsson.kx.widget.CommandSender;
import com.sonyericsson.kx.widget.ItemHolder;
import com.sonyericsson.kx.widget.KaixinWidget;
import com.sonyericsson.kx.widget.KxBaseThread;
import com.sonyericsson.kx.widget.KxItemPresenter;
import com.sonyericsson.kx.widget.TimerThread;
import com.sonyericsson.kx.widget.WidgetListener;
import com.sonyericsson.lcdui.IdleItem;
import com.sonyericsson.res.Images;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.content.ContentHandlerException;
import javax.microedition.content.ContentHandlerServer;
import javax.microedition.content.Invocation;
import javax.microedition.content.Registry;
import javax.microedition.content.RequestListener;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class KxWidgetMidlet
extends MIDlet
implements RequestListener,
WidgetListener,
ItemCommandListener {
    private static final int ROTATE_INTERVAL = 3000;
    public static final String MAGIC_DATA = "JW_MAGIC";
    public static final String STORENAME_LOGONINFO = "LOGONINFO";
    public static final String STORENAME_SESSION = "SESSION";
    public static final String STORNAME_CACHE = "CACHE";
    public static final String STORNAME_UPGRADE = "UPGRADE";
    public static final String INVOC_START = "START";
    public static final String INVOC_STOP = "STOP";
    public static final String INVOC_CONFIG = "CONFIG";
    public static final String INVOC_SESSION = "SESSION";
    public static final String INVOC_UPGRADE = "UPGRADE";
    public static final String INVOC_SHOW = "SHOW";
    public static final String INVOC_REFRESH = "REFRESH";
    public static final String INVOC_UPDATE_STATUS = "UPDATE_STATUS";
    public static final String INVOC_SHOW_BIRTHDAY = "SHOW_BIRTHDAY";
    public static final String INVOC_SHOW_STATUS = "SHOW_STATUS";
    public static final String INVOC_SHOW_MESSAGE = "SHOW_MESSAGE";
    public static final String KAIXIN_HOST = "http://ksa2.kaixin001.com";
    public static final int STATUS_INITIAL = 0;
    public static final int STATUS_WAITLOGIN = 1;
    public static final int STATUS_AUTOLOGIN = 2;
    public static final int STATUS_UPGRADING = 3;
    boolean isAutoLogin;
    private ItemHolder holder;
    private KaixinWidget widget;
    private CommandSender sender;
    private Display display;
    public LoginData loginInfo;
    private SessionData sessionInfo;
    private Timer timer;
    private RotateTask rotateTask;
    private RotateTriggerTask rotateTrigger;
    public NetworkThread networkThread;
    private TimerThread timerThread;
    private ScrollDownTask scrollDownTask;

    protected void destroyApp(boolean arg0) throws MIDletStateChangeException {
        if (MainAppWatcher.isExist()) {
            this.sender.sendSync(INVOC_STOP, null);
        }
    }

    protected void pauseApp() {
    }

    protected void startApp() throws MIDletStateChangeException {
        this.loginInfo = new LoginData();
        this.sessionInfo = new SessionData();
        LoginDataAccess.readConfig(this.loginInfo);
        SessionDataAccess.readConfig(this.sessionInfo);
        this.widget = new KaixinWidget();
        this.holder = ItemHolder.getInstance();
        this.timer = new Timer();
        this.networkThread = new NetworkThread(KAIXIN_HOST);
        new Thread(this.networkThread).start();
        this.timerThread = new TimerThread(this);
        new Thread(this.timerThread).start();
        this.widget.setMcListener(this);
        this.display = Display.getDisplay((MIDlet)this);
        String classname = this.getClass().getName();
        try {
            ContentHandlerServer server = Registry.getServer((String)classname);
            server.setListener((RequestListener)this);
            server = null;
        }
        catch (ContentHandlerException server) {
            // empty catch block
        }
        Registry registry = Registry.getRegistry((String)classname);
        this.sender = new CommandSender(registry);
        if (this.hasSession() && this.loginInfo.bStorePassword) {
            this.holder.isLogin = true;
            this.isAutoLogin = true;
            this.holder.readCache();
            this.startRotateTrigger();
            this.widget.updateCommand();
        } else {
            this.holder.isLogin = false;
            this.isAutoLogin = false;
        }
        this.widget.setItemCommandListener(this);
        IdleItem.setOnDisplay((Display)this.display, (IdleItem)this.widget);
    }

    public void invocationRequestNotify(ContentHandlerServer server) {
        if (server != null) {
            Invocation invocation = null;
            while ((invocation = server.getRequest(false)) != null) {
                this.handleRequest(invocation);
                if (invocation.getResponseRequired()) {
                    invocation.setArgs(new String[0]);
                }
                server.finish(invocation, 5);
                invocation = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequest(Invocation invocation) {
        String url = invocation.getURL();
        byte[] data = invocation.getData();
        if (url.compareTo(INVOC_REFRESH) == 0) {
            if (this.holder.isLogin || !this.holder.isDownloading()) {
                this.holder.timeStamp = 0L;
                this.readNetWork();
            }
        } else if (url.compareTo(INVOC_CONFIG) == 0) {
            this.holder.isLogin = false;
            LoginData login = LoginDataAccess.getData(data);
            if (login != null) {
                this.loginInfo.strLogin = login.strLogin;
                this.loginInfo.strPassword = login.strPassword;
                this.loginInfo.bStorePassword = login.bStorePassword;
                this.loginInfo.nAutoUpdateFrequency = login.nAutoUpdateFrequency;
                this.loginInfo.bNetPrompt = login.bNetPrompt;
                this.loginInfo.bAutoRun = login.bAutoRun;
                this.holder.writeLogin(login);
                this.updateStatus();
            }
        } else if (url.compareTo("SESSION") == 0) {
            SessionData sess = SessionDataAccess.getData(data);
            if (sess != null) {
                boolean bNeedToLoad = false;
                if (sess.strUid != null && !sess.strUid.equals(this.sessionInfo.strUid)) {
                    bNeedToLoad = true;
                }
                this.sessionInfo.strUid = sess.strUid;
                this.sessionInfo.strVerify = sess.strVerify;
                this.sessionInfo.strWapVerify = sess.strWapVerify;
                this.holder.writeSession(sess);
                if (bNeedToLoad) {
                    this.holder.timeStamp = 0L;
                    this.readNetWork();
                }
                TimerThread timerThread = this.timerThread;
                synchronized (timerThread) {
                    this.timerThread.notifyAll();
                }
            }
        } else if (INVOC_UPDATE_STATUS.equals(url) && data != null) {
            StatusData sd = LoginDataAccess.getStatus(data);
            DynamicItem myStatus = new DynamicItem();
            myStatus.flogo = "logo";
            this.holder.cacheImages.remove(myStatus.flogo);
            if (sd.iconData != null && sd.iconData.length > 0) {
                try {
                    myStatus.setImage(Image.createImage((byte[])sd.iconData, (int)0, (int)sd.iconData.length));
                    this.holder.cacheImages.put(myStatus.flogo, sd.iconData);
                }
                catch (Exception e) {
                    myStatus.setImage(Images.DEFAULT);
                }
            } else {
                myStatus.setImage(Images.DEFAULT);
            }
            myStatus.type = 3;
            myStatus.setStrMessage("\u66f4\u65b0\u4e86\u72b6\u6001 " + sd.note);
            myStatus.fname = sd.name;
            myStatus.ctime = sd.time != null && sd.time.length() > 0 ? Long.parseLong(sd.time) : 0L;
            this.holder.addMyStatus(myStatus);
            this.holder.writeCache();
            this.widget.refresh();
        }
    }

    public void inInteractive() {
        this.cancelRotateTrigger();
    }

    public void outFullScreen() {
        this.holder.timeStamp = 0L;
        this.readNetWork();
    }

    public void inSmall() {
        if (this.holder.isLogin && this.rotateTrigger == null) {
            this.startRotateTrigger();
        }
    }

    private void updateStatus() {
        if (this.hasSession()) {
            this.holder.isLogin = true;
            this.isAutoLogin = this.loginInfo.bStorePassword;
            this.widget.updateCommand();
        } else {
            this.isAutoLogin = false;
            this.holder.isLogin = false;
            this.widget.updateCommand();
        }
    }

    private boolean hasSession() {
        return this.sessionInfo.strUid != null && this.sessionInfo.strUid.length() > 0 && this.sessionInfo.strVerify != null && this.sessionInfo.strVerify.length() > 0;
    }

    public void commandAction(Command c, Item item) {
        if (item != null && item.equals((Object)this.widget)) {
            if (c.equals(this.widget.backCmd)) {
                this.widget.go2SmallMode();
            } else if (c.equals(this.widget.viewCmd)) {
                DynamicItem dItem = this.holder.get(0);
                if (dItem == null) {
                    this.sender.sendAsync(INVOC_SHOW, null);
                } else {
                    switch (dItem.type) {
                        case 1: {
                            this.sender.sendAsync(INVOC_SHOW_BIRTHDAY, LoginDataAccess.getData(dItem.fuid, null));
                            break;
                        }
                        case 2: {
                            this.sender.sendAsync(INVOC_SHOW_STATUS, LoginDataAccess.getData(dItem.fuid, null));
                            break;
                        }
                        case 4: {
                            this.sender.sendAsync(INVOC_SHOW_MESSAGE, null);
                            break;
                        }
                        case 3: {
                            this.sender.sendAsync(INVOC_SHOW, null);
                            break;
                        }
                        default: {
                            this.sender.sendAsync(INVOC_SHOW, null);
                        }
                    }
                }
                this.holder.mode = 3;
            } else if (c.equals(this.widget.refreshCmd)) {
                this.readNetWork();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRotate() {
        if (this.rotateTask == null) {
            this.rotateTask = new RotateTask();
            new Thread(this.rotateTask).start();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (!(this.rotateTask.isRunning || this.scrollDownTask != null && this.scrollDownTask.isRunning)) {
            this.holder.step = 0;
            RotateTask rotateTask = this.rotateTask;
            synchronized (rotateTask) {
                this.rotateTask.notifyAll();
            }
        }
    }

    private void startRotateTrigger() {
        if (this.rotateTrigger == null) {
            this.rotateTrigger = new RotateTriggerTask();
            this.timer.schedule((TimerTask)this.rotateTrigger, 3000L);
        }
    }

    private void cancelRotateTrigger() {
        if (this.rotateTrigger != null) {
            this.rotateTrigger.cancel();
            this.rotateTrigger = null;
        }
    }

    public void readNetWork() {
        if (this.networkThread.isAlive && !this.networkThread.isRunning) {
            this.networkThread.trigRead(this.sessionInfo.strUid, this.sessionInfo.strVerify, this.holder, this.holder.cacheImages);
        }
    }

    public void moveDown() {
        this.holder.stopTextScrolling();
        this.startRotate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveUp() {
        this.holder.stopTextScrolling();
        if (this.scrollDownTask == null) {
            this.scrollDownTask = new ScrollDownTask();
            new Thread(this.scrollDownTask).start();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (!this.scrollDownTask.isRunning && !this.rotateTask.isRunning) {
            ScrollDownTask scrollDownTask = this.scrollDownTask;
            synchronized (scrollDownTask) {
                this.scrollDownTask.notifyAll();
            }
        }
    }

    private void triggerScroll() {
        DynamicItem item = this.holder.get(0);
        if (item == null || item.strMessage == null) {
            return;
        }
        String message = item.strMessage;
        int substringWidth = 0;
        switch (item.type) {
            case 2: 
            case 3: {
                substringWidth = KxItemPresenter.TEXT_FONT.substringWidth(message, 5, message.length() - 5);
                break;
            }
            case 1: 
            case 4: {
                substringWidth = KxItemPresenter.TEXT_FONT.stringWidth(message);
            }
        }
        if (item.sprites != null) {
            String[] constants = item.type != 4 ? TextConstants.statusTextTag : TextConstants.messageTextTag;
            int size = item.sprites.length;
            substringWidth += size * 15;
            int i = 0;
            while (i < size) {
                String symbol = constants[item.sprites[i][2] * 2];
                int width = KxItemPresenter.TEXT_FONT.stringWidth(symbol);
                substringWidth -= width;
                ++i;
            }
        }
        if (substringWidth > 110) {
            this.holder.textScroller.xOffset = substringWidth - 110;
            this.holder.startTextScrolling();
        }
    }

    static /* synthetic */ void access$2(KxWidgetMidlet kxWidgetMidlet) {
        kxWidgetMidlet.triggerScroll();
    }

    static /* synthetic */ void access$3(KxWidgetMidlet kxWidgetMidlet) {
        kxWidgetMidlet.startRotateTrigger();
    }

    private final class RotateTask
    extends KxBaseThread {
        private RotateTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        public void run() {
            while (this.isAlive) {
                var1_1 /* !! */  = this;
                synchronized (var1_1 /* !! */ ) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.isAlive) ** GOTO lbl37
                return;
lbl-1000:
                // 1 sources

                {
                    this.isRunning = true;
                    KxWidgetMidlet.access$0((KxWidgetMidlet)KxWidgetMidlet.this).bRefreshing = true;
                    if (KxWidgetMidlet.access$0((KxWidgetMidlet)KxWidgetMidlet.this).refreshThread != null) {
                        var1_1 /* !! */  = KxWidgetMidlet.access$0((KxWidgetMidlet)KxWidgetMidlet.this).refreshThread;
                        synchronized (var1_1 /* !! */ ) {
                            if (!KxWidgetMidlet.access$0((KxWidgetMidlet)KxWidgetMidlet.this).refreshThread.isRunning) {
                                KxWidgetMidlet.access$0((KxWidgetMidlet)KxWidgetMidlet.this).refreshThread.notifyAll();
                            }
                        }
                    }
                    ++KxWidgetMidlet.access$0((KxWidgetMidlet)KxWidgetMidlet.this).step;
                    try {
                        Thread.sleep(25L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (this.isAlive) continue;
                    this.isRunning = false;
                    if (KxWidgetMidlet.access$0(KxWidgetMidlet.this) != null) {
                        KxWidgetMidlet.access$0((KxWidgetMidlet)KxWidgetMidlet.this).step = 0;
                    }
                    return;
lbl37:
                    // 2 sources

                    ** while (KxWidgetMidlet.access$0((KxWidgetMidlet)KxWidgetMidlet.this) != null && KxWidgetMidlet.access$0((KxWidgetMidlet)KxWidgetMidlet.this).step < 10)
                }
lbl38:
                // 1 sources

                this.isRunning = false;
                if (KxWidgetMidlet.access$0(KxWidgetMidlet.this) == null) continue;
                KxWidgetMidlet.access$0((KxWidgetMidlet)KxWidgetMidlet.this).step = 0;
                KxWidgetMidlet.access$0(KxWidgetMidlet.this).focusNext();
                KxWidgetMidlet.access$2(KxWidgetMidlet.this);
                if (KxWidgetMidlet.access$0((KxWidgetMidlet)KxWidgetMidlet.this).mode != 0) continue;
                KxWidgetMidlet.access$3(KxWidgetMidlet.this);
            }
        }
    }

    private final class RotateTriggerTask
    extends TimerTask {
        private RotateTriggerTask() {
        }

        public void run() {
            if (KxWidgetMidlet.this.holder != null && ((KxWidgetMidlet)KxWidgetMidlet.this).holder.mode == 0) {
                while (KxWidgetMidlet.this.holder != null && ((KxWidgetMidlet)KxWidgetMidlet.this).holder.textScroller != null && ((KxWidgetMidlet)KxWidgetMidlet.this).holder.textScroller.isRunning) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (KxWidgetMidlet.this.holder != null && ((KxWidgetMidlet)KxWidgetMidlet.this).holder.mode == 0) {
                    KxWidgetMidlet.this.startRotate();
                }
            }
            KxWidgetMidlet.this.cancelRotateTrigger();
        }
    }

    private final class ScrollDownTask
    extends KxBaseThread {
        private ScrollDownTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        public void run() {
            while (this.isAlive) {
                var1_1 /* !! */  = this;
                synchronized (var1_1 /* !! */ ) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException var2_3) {
                        // empty catch block
                    }
                }
                if (this.isAlive) ** GOTO lbl34
                return;
lbl-1000:
                // 1 sources

                {
                    this.isRunning = true;
                    KxWidgetMidlet.access$0((KxWidgetMidlet)KxWidgetMidlet.this).bRefreshing = true;
                    if (KxWidgetMidlet.access$0((KxWidgetMidlet)KxWidgetMidlet.this).refreshThread != null) {
                        var1_1 /* !! */  = KxWidgetMidlet.access$0((KxWidgetMidlet)KxWidgetMidlet.this).refreshThread;
                        synchronized (var1_1 /* !! */ ) {
                            if (!KxWidgetMidlet.access$0((KxWidgetMidlet)KxWidgetMidlet.this).refreshThread.isRunning) {
                                KxWidgetMidlet.access$0((KxWidgetMidlet)KxWidgetMidlet.this).refreshThread.notifyAll();
                            }
                        }
                    }
                    --KxWidgetMidlet.access$0((KxWidgetMidlet)KxWidgetMidlet.this).step;
                    try {
                        Thread.sleep(25L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (this.isAlive) continue;
                    return;
lbl34:
                    // 2 sources

                    ** while (KxWidgetMidlet.access$0((KxWidgetMidlet)KxWidgetMidlet.this) != null && -KxWidgetMidlet.access$0((KxWidgetMidlet)KxWidgetMidlet.this).step < 10)
                }
lbl35:
                // 1 sources

                KxWidgetMidlet.access$0((KxWidgetMidlet)KxWidgetMidlet.this).step = 0;
                KxWidgetMidlet.access$0(KxWidgetMidlet.this).focusUp();
                this.isRunning = false;
                KxWidgetMidlet.access$2(KxWidgetMidlet.this);
            }
        }
    }
}

