/*
 * Decompiled with CFR 0.152.
 */
package com.jw.http;

import com.jw.http.CmwapConnection;
import com.jw.http.Connect;
import com.sonyericsson.ams.Application;
import com.sonyericsson.ams.ApplicationManager;
import com.sonyericsson.ams.Installer;
import com.sonyericsson.kx.KxMIDlet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.HttpConnection;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;

public class Upgrade {
    private static String STRINGUSERAGENT = "Profile/MIDP-2.1 Configuration/CLDC-1.1";
    public static final String STORNAME_UPGRADE = "UPGRADE";
    private static String strMainUrl = null;
    private static String strMainVer = null;
    private static String strHsUrl = null;
    private static String strHsVer = null;
    public static int code = 0;

    public static boolean upgrade() {
        RecordStore store = null;
        try {
            store = RecordStore.openRecordStore((String)STORNAME_UPGRADE, (boolean)true);
        }
        catch (Exception e) {
            System.out.println("Can't create UPGRADE recordstroe for upgrade!");
            return false;
        }
        try {
            store.closeRecordStore();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean upgrading() {
        RecordStore store = null;
        try {
            store = RecordStore.openRecordStore((String)STORNAME_UPGRADE, (boolean)false);
        }
        catch (Exception e) {
            return false;
        }
        try {
            store.closeRecordStore();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static void finish() {
        try {
            RecordStore.deleteRecordStore((String)STORNAME_UPGRADE);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getAppVersion(boolean bMainAPP) {
        ApplicationManager appMan = ApplicationManager.getApplicationManager();
        Application[] apps = appMan.getApplications();
        int i = 0;
        while (i < apps.length) {
            String strClass = bMainAPP ? "com.sonyericsson.kx.KxMIDlet" : "com.sonyericsson.kx.KxHSMIDlet";
            Application.EntryPoint[] entrys = apps[i].getEntryPoints();
            int j = 0;
            while (j < entrys.length) {
                Application.EntryPoint e1 = entrys[j];
                if (strClass.equals(e1.className)) {
                    System.out.println(String.valueOf(strClass) + "  found, version:" + apps[i].getProperty("MIDlet-Version"));
                    return apps[i].getProperty("MIDlet-Version");
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public static boolean isAppInstalled(boolean bMainAPP) {
        ApplicationManager appMan = ApplicationManager.getApplicationManager();
        Application[] apps = appMan.getApplications();
        int i = 0;
        while (i < apps.length) {
            String strClass = bMainAPP ? "com.sonyericsson.kx.KxMIDlet" : "com.sonyericsson.kx.KxHSMIDlet";
            Application.EntryPoint[] entrys = apps[i].getEntryPoints();
            int j = 0;
            while (j < entrys.length) {
                Application.EntryPoint e1 = entrys[j];
                if (strClass.equals(e1.className)) {
                    System.out.print(String.valueOf(strClass) + "  found, start:" + apps[i].isStarted());
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public static boolean isAppRunning(boolean bMainAPP) {
        ApplicationManager appMan = ApplicationManager.getApplicationManager();
        Application[] apps = appMan.getApplications();
        int i = 0;
        while (i < apps.length) {
            String strClass = bMainAPP ? "com.sonyericsson.kx.KxMIDlet" : "com.sonyericsson.kx.KxHSMIDlet";
            Application.EntryPoint[] entrys = apps[i].getEntryPoints();
            int j = 0;
            while (j < entrys.length) {
                Application.EntryPoint e1 = entrys[j];
                if (strClass.equals(e1.className)) {
                    System.out.print(String.valueOf(strClass) + "  found, start:" + apps[i].isStarted());
                    return apps[i].isStarted();
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public static boolean isUpgradeAvailable(MIDlet midlet, int nMode) {
        if (nMode == 0) {
            return false;
        }
        strMainVer = Upgrade.getAppVersion(true);
        strHsVer = Upgrade.getAppVersion(false);
        System.out.println("Main Version:" + strMainVer);
        System.out.println("HS Version:" + strHsVer);
        if (strMainVer == null || strHsVer == null) {
            return true;
        }
        if (!strHsVer.equals(strMainVer)) {
            return true;
        }
        strMainUrl = Upgrade.getUpgradeUrl(midlet, true);
        if (strMainUrl == null || strMainUrl.length() == 0) {
            return false;
        }
        if ((strMainUrl = Upgrade.getJadUrl(strMainUrl, nMode)) == null) {
            strMainUrl = Upgrade.getJadUrl(strMainUrl, nMode);
        }
        if (strMainUrl == null) {
            strMainUrl = Upgrade.getJadUrl(strMainUrl, nMode);
        }
        return strMainUrl != null;
    }

    public static boolean upgrade(int nType, MIDlet midlet, int nMode) {
        String str;
        if (nType < 0 || nType > 2) {
            return false;
        }
        if (nType == 0 || nType == 1) {
            strMainUrl = Upgrade.getUpgradeUrl(midlet, true);
        }
        if (nType == 0 || nType == 2) {
            strHsUrl = Upgrade.getUpgradeUrl(midlet, false);
        }
        if (KxMIDlet.Debug) {
            System.out.println("Main URL:" + strMainUrl);
            System.out.println("HS URL:" + strHsUrl);
        }
        boolean bRet = false;
        if (strMainUrl != null && (nType == 0 || nType == 1)) {
            str = Upgrade.getJadUrl(strMainUrl, nMode);
            if (str == null) {
                str = Upgrade.getJadUrl(strMainUrl, nMode);
            }
            if (str == null) {
                str = Upgrade.getJadUrl(strMainUrl, nMode);
            }
            if (KxMIDlet.Debug) {
                System.out.println("getJadUrl:" + str);
            }
            if (str == null) {
                return false;
            }
            bRet = Upgrade.upgradeApp(true, str, nMode);
            if (!bRet) {
                bRet = Upgrade.upgradeApp(true, str, nMode);
            }
            if (!bRet) {
                bRet = Upgrade.upgradeApp(true, str, nMode);
            }
            if (!bRet) {
                return bRet;
            }
        }
        if (strHsUrl != null && (nType == 0 || nType == 2)) {
            str = Upgrade.getJadUrl(strHsUrl, nMode);
            if (str == null) {
                str = Upgrade.getJadUrl(strHsUrl, nMode);
            }
            if (str == null) {
                str = Upgrade.getJadUrl(strHsUrl, nMode);
            }
            if (str == null) {
                return false;
            }
            bRet = Upgrade.upgradeApp(false, str, nMode);
            if (!bRet) {
                bRet = Upgrade.upgradeApp(false, str, nMode);
            }
            if (!bRet) {
                bRet = Upgrade.upgradeApp(false, str, nMode);
            }
            if (!bRet) {
                return bRet;
            }
        }
        return bRet;
    }

    private static String getUpgradeUrl(MIDlet midlet, boolean bUpdateMainAPP) {
        String str;
        StringBuffer sb = new StringBuffer();
        sb.append(Upgrade.getUpgradeURL(midlet));
        sb.append('?');
        sb.append("ver=");
        if (bUpdateMainAPP) {
            str = Upgrade.getAppVersion(true);
            if (str != null) {
                sb.append(str);
            }
        } else {
            str = Upgrade.getAppVersion(false);
            if (str != null) {
                sb.append(str);
            }
        }
        if (bUpdateMainAPP) {
            sb.append("&kxopt=main");
        } else {
            sb.append("&kxopt=hs");
        }
        sb.append("&model=");
        sb.append(Upgrade.getModel());
        sb.append("&plt=");
        sb.append(Upgrade.getJavaPlatform());
        str = sb.toString();
        System.out.println(str);
        return str;
    }

    public static String getJavaPlatform() {
        String str = System.getProperty("com.sonyericsson.java.platform");
        if (str == null) {
            return "JP-8.4.2";
        }
        return str;
    }

    public static String getModel() {
        String str = System.getProperty("microedition.platform");
        if (str == null) {
            return "Norika";
        }
        int nPos = str.indexOf("/");
        if (nPos > 0) {
            return str.substring(0, nPos);
        }
        return "Norika";
    }

    private static String getUpgradeURL(MIDlet midlet) {
        String str = midlet.getAppProperty("KXUpgradeURL");
        if (str == null || str.length() == 0) {
            return "http://m.sonyericsson.com/kaixin001";
        }
        return str;
    }

    public static int getErrorCode() {
        return code;
    }

    private static String getJadUrl(String url, int nMode) {
        String ret;
        block15: {
            boolean bWap = false;
            if (nMode == 0) {
                return null;
            }
            bWap = nMode != 1;
            String host = "";
            if (bWap) {
                host = Connect.findString(url, "http://", "/");
                if (host.indexOf(":") < 0) {
                    host = String.valueOf(host) + ":80";
                }
                url = "http://10.0.0.172:80/" + Connect.findString(url, "/", 10);
            }
            CmwapConnection conn = null;
            OutputStream os = null;
            InputStream is = null;
            ret = null;
            try {
                try {
                    conn = CmwapConnection.open(url);
                    if (bWap) {
                        conn.setRequestProperty("User-Agent", STRINGUSERAGENT);
                        conn.setRequestProperty("X-online-Host", host);
                        conn.setRequestProperty("Accept", "*/*");
                    } else {
                        conn.setRequestProperty("User-Agent", STRINGUSERAGENT);
                    }
                    conn.setRequestMethod("GET");
                    os = conn.openOutputStream();
                    os.flush();
                    is = conn.openInputStream();
                    int rc = conn.getResponseCode();
                    System.out.println("HTTP status code:" + rc);
                    if (rc == 200) {
                        code = rc;
                        ret = null;
                    } else if (rc == 307 || rc == 301 || rc == 302) {
                        code = rc;
                        Upgrade.close(conn, is, os);
                        String str = conn.getHeaderField("Location");
                        if (str == null || str.length() == 0) {
                            ret = null;
                        }
                        ret = str;
                    } else {
                        code = rc;
                        ret = null;
                    }
                }
                catch (Exception e) {
                    code = 0;
                    ret = null;
                    Upgrade.close(conn, is, os);
                    break block15;
                }
            }
            catch (Throwable throwable) {
                Upgrade.close(conn, is, os);
                throw throwable;
            }
            Upgrade.close(conn, is, os);
        }
        return ret;
    }

    private static void close(HttpConnection conn, InputStream is, OutputStream os) {
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        is = null;
        if (os != null) {
            try {
                os.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        os = null;
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        conn = null;
    }

    private static String stripName(String path) {
        int pos = path.lastIndexOf(47);
        return path.substring(pos + 1);
    }

    private static void feedOutputStream(InputStream from, OutputStream to, int nLen) throws IOException {
        if (nLen == 0) {
            try {
                int ch;
                while ((ch = from.read()) != -1) {
                    ++nLen;
                    to.write(ch);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("nLen=" + nLen);
        } else {
            byte[] temp = new byte[1024];
            int nPos = 0;
            try {
                int tLen;
                int n;
                while ((n = from.read(temp, 0, tLen = nLen - nPos > 1024 ? 1024 : nLen - nPos)) != -1) {
                    if (n > 0) {
                        to.write(temp, 0, n);
                    }
                    if ((nPos += n) < nLen) continue;
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            temp = null;
            System.out.println("nPos=" + nPos);
        }
        to.flush();
        to.close();
        to = null;
        System.out.println("nLen=" + nLen);
    }

    private static boolean upgradeApp(boolean bMainApp, String strUrl, int nMode) {
        String strJad = "";
        String strJar = "";
        CmwapConnection jad = null;
        CmwapConnection jar = null;
        InputStream isJad = null;
        InputStream isJar = null;
        OutputStream osJad = null;
        OutputStream osJar = null;
        Installer installer = null;
        boolean bRet = false;
        if (strUrl == null) {
            return false;
        }
        if (strUrl.endsWith("jad")) {
            strJad = strUrl;
            strJar = String.valueOf(strUrl.substring(0, strUrl.length() - 4)) + ".jar";
        } else if (strUrl.endsWith("jar")) {
            strJar = strUrl;
            strJad = String.valueOf(strUrl.substring(0, strUrl.length() - 4)) + ".jad";
        } else {
            return false;
        }
        System.out.println(strJar);
        System.out.println(strJad);
        boolean bWap = false;
        if (nMode == 0) {
            return false;
        }
        bWap = nMode != 1;
        String host = "";
        if (bWap) {
            host = Connect.findString(strJar, "http://", "/");
            if (host.indexOf(":") < 0) {
                host = String.valueOf(host) + ":80";
            }
            strJad = "http://10.0.0.172:80/" + Connect.findString(strJad, "/", 10);
            strJar = "http://10.0.0.172:80/" + Connect.findString(strJar, "/", 10);
        }
        try {
            try {
                String sLen;
                int nLen;
                jad = CmwapConnection.open(strJad);
                if (bWap) {
                    jad.setRequestProperty("User-Agent", STRINGUSERAGENT);
                    jad.setRequestProperty("X-online-Host", host);
                    jad.setRequestProperty("Accept", "*/*");
                } else {
                    jad.setRequestProperty("User-Agent", STRINGUSERAGENT);
                }
                jad.setRequestMethod("GET");
                osJad = jad.openOutputStream();
                osJad.flush();
                isJad = jad.openInputStream();
                int rc = jad.getResponseCode();
                System.out.println("Open Installer");
                installer = ApplicationManager.getApplicationManager().getInstaller(true);
                System.out.println("Open Installer ok");
                if (rc == 200) {
                    nLen = 0;
                    sLen = jad.getHeaderField("Content-Length");
                    if (sLen == null) {
                        sLen = jad.getHeaderField("Content-length");
                    }
                    try {
                        if (sLen != null && sLen.length() != 0) {
                            sLen = sLen.trim();
                            nLen = Integer.parseInt(sLen);
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Content-Length:" + sLen);
                        nLen = 0;
                    }
                    System.out.println("Feed jad into installer:" + nLen);
                    Upgrade.feedOutputStream(isJad, installer.addJad(Upgrade.stripName(strJad)), nLen);
                    System.out.println("Feed jad into installer OK");
                }
                jar = CmwapConnection.open(strJar);
                if (bWap) {
                    jar.setRequestProperty("User-Agent", STRINGUSERAGENT);
                    jar.setRequestProperty("X-online-Host", host);
                    jar.setRequestProperty("Accept", "*/*");
                } else {
                    jar.setRequestProperty("User-Agent", STRINGUSERAGENT);
                }
                jar.setRequestMethod("GET");
                osJar = jar.openOutputStream();
                osJar.flush();
                isJar = jar.openInputStream();
                rc = jar.getResponseCode();
                if (rc == 200) {
                    nLen = 0;
                    sLen = jar.getHeaderField("Content-Length");
                    if (sLen == null) {
                        sLen = jar.getHeaderField("Content-length");
                    }
                    try {
                        if (sLen != null && sLen.length() != 0) {
                            sLen = sLen.trim();
                            nLen = Integer.parseInt(sLen);
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Content-Length:" + sLen);
                        nLen = 0;
                    }
                    System.out.println("Feed jar into installer:" + nLen);
                    Upgrade.feedOutputStream(isJar, installer.addJar(Upgrade.stripName(strJar)), nLen);
                    System.out.println("Feed jar into installer OK");
                }
                try {
                    System.out.println("start installer");
                    installer.start();
                    System.out.println("Installed");
                    bRet = true;
                }
                catch (Exception e1) {
                    System.out.println("install app failed:" + e1.getMessage());
                    System.out.println("install app failed:" + e1.toString());
                    bRet = false;
                }
            }
            catch (Exception e) {
                bRet = false;
                if (osJad != null) {
                    try {
                        osJad.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                osJad = null;
                if (isJad != null) {
                    try {
                        isJad.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                isJad = null;
                if (jad != null) {
                    try {
                        jad.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                jad = null;
                if (osJar != null) {
                    try {
                        osJar.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                osJar = null;
                if (isJar != null) {
                    try {
                        isJar.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                isJar = null;
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                jar = null;
                installer = null;
            }
        }
        finally {
            if (osJad != null) {
                try {
                    osJad.close();
                }
                catch (Exception exception) {}
            }
            osJad = null;
            if (isJad != null) {
                try {
                    isJad.close();
                }
                catch (Exception exception) {}
            }
            isJad = null;
            if (jad != null) {
                try {
                    jad.close();
                }
                catch (Exception exception) {}
            }
            jad = null;
            if (osJar != null) {
                try {
                    osJar.close();
                }
                catch (Exception exception) {}
            }
            osJar = null;
            if (isJar != null) {
                try {
                    isJar.close();
                }
                catch (Exception exception) {}
            }
            isJar = null;
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (Exception exception) {}
            }
            jar = null;
            installer = null;
        }
        return bRet;
    }
}

