/*
 * Decompiled with CFR 0.152.
 */
package com.jw.text;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class TextScroller {
    static final boolean DEBUG = false;
    static final int SCROLLTYPE_VERTICAL = 0;
    static final int SCROLLTYPE_HORIZONTAL = 1;
    static final int ACTION_NONE = -1;
    static boolean isChinese = true;
    int scrollerType;
    public String text;
    String[] textArray;
    int posX;
    int posY;
    int wid;
    int hei;
    Font font;
    int color;
    int lineSpace;
    int autoMoveSpeed;
    int manualMoveSpeed;
    int fontHeight;
    public int lineHeight;
    int totalLength;
    int currentAction = -1;
    boolean isEnd = false;
    static int FPS = 100;
    int curPosX;
    int curPosY;
    public boolean isHcenter;
    static int nowWidth = 0;
    int juli = 0;
    static final char[] SIGN_ALL = new char[]{':', ',', '.', '?', '!', ' ', ';', '\uff0c', '\u3002', '\uff1f', '\uff01', '\uff1b', '\u3001'};

    public TextScroller() {
    }

    public TextScroller(int scrollerType, String text, int posX, int posY, int wid, int hei, Font font, int color, int lineSpace) {
        this.scrollerType = scrollerType;
        this.text = text;
        this.posX = posX;
        this.posY = posY;
        this.wid = wid;
        this.hei = hei;
        this.font = font;
        this.color = color;
        this.lineSpace = lineSpace;
        this.fontHeight = font.getHeight();
        this.lineHeight = this.fontHeight + lineSpace;
        this.isEnd = false;
        this.curPosX = posX;
        this.curPosY = posY;
        this.autoMoveSpeed = 1;
        this.manualMoveSpeed = 4;
        this.isHcenter = false;
        this.init();
    }

    void init() {
        nowWidth = 0;
        this.parseText();
    }

    public void setPosition(int x, int y) {
        this.curPosX += x - this.posX;
        this.curPosY += y - this.posY;
        this.posX = x;
        this.posY = y;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public int getHeight() {
        return this.totalLength;
    }

    public int getViewHeight() {
        return this.totalLength > this.hei ? this.hei : this.totalLength;
    }

    public void refreshText(String s) {
        this.text = s;
        this.isEnd = false;
        this.curPosX = this.posX;
        this.curPosY = this.posY;
        this.init();
    }

    public void paint(Graphics g) {
        if (this.textArray != null) {
            int clipX = g.getClipX();
            int clipY = g.getClipY();
            int clipWidth = g.getClipWidth();
            int clipHeight = g.getClipHeight();
            g.setColor(this.color);
            g.setClip(this.posX, this.posY, this.wid, this.hei);
            g.setFont(this.font);
            if (this.scrollerType == 0) {
                this.paintV(g);
            } else if (this.scrollerType == 1) {
                this.paintH(g);
            }
            g.setClip(clipX, clipY, clipWidth, clipHeight);
        }
        this.update();
    }

    void paintV(Graphics g) {
        int i = 0;
        while (i < this.textArray.length) {
            int py = this.curPosY + i * this.lineHeight;
            if (py + this.lineHeight >= this.posY) {
                if (py > this.posY + this.hei) break;
                if (this.isHcenter) {
                    g.drawString(this.textArray[i], this.curPosX + this.wid / 2, py, 17);
                } else {
                    g.drawString(this.textArray[i], this.curPosX, py, 20);
                }
            }
            ++i;
        }
    }

    void paintH(Graphics g) {
        int i = 0;
        while (i < this.textArray.length) {
            g.drawString(this.textArray[i], this.curPosX, this.curPosY, 20);
            ++i;
        }
    }

    void update() {
        if (this.scrollerType == 0) {
            this.updateV();
        } else if (this.scrollerType == 1) {
            this.updateH();
        }
    }

    void updateV() {
        int speed = 0;
        this.juli += this.autoMoveSpeed;
        if (this.juli > 10) {
            speed = this.juli / 10;
            this.juli = 0;
        }
        if (this.currentAction == -1) {
            if (this.curPosY + this.totalLength > this.posY + this.hei) {
                this.curPosY -= speed;
            }
        } else if (this.currentAction == 1) {
            if (this.curPosY < this.posY) {
                this.curPosY += this.manualMoveSpeed;
            }
        } else if (this.currentAction == 6 && this.curPosY + this.totalLength > this.posY + this.hei) {
            this.curPosY -= this.manualMoveSpeed;
        }
    }

    void updateH() {
        if (this.totalLength > this.wid && this.curPosX + this.totalLength > this.posX + this.wid) {
            this.curPosX -= this.autoMoveSpeed;
        } else if (this.totalLength > this.wid && this.curPosX + this.totalLength <= this.posX + this.wid) {
            this.curPosX = this.posX;
        }
    }

    public void keyPressed(int action) {
        this.currentAction = action;
    }

    public void keyReleased(int action) {
        this.currentAction = -1;
    }

    public void setPercentage(int percent) {
    }

    public int getPercentage() {
        int per = 0;
        if (this.scrollerType == 0) {
            per = this.totalLength <= this.hei ? 100 : (this.posY - this.curPosY + this.hei) * 100 / this.totalLength;
        } else if (this.scrollerType == 1) {
            per = this.totalLength <= this.wid ? 100 : (this.posX - this.curPosX + this.wid) * 100 / this.totalLength;
        }
        if (per > 100) {
            per = 100;
        }
        return per;
    }

    void parseText() {
        if (this.scrollerType == 0) {
            this.textArray = TextScroller.changeToArrayVertical(this.text, this.font, 0, this.wid);
            if (this.textArray != null) {
                this.totalLength = this.lineHeight * this.textArray.length;
            }
        } else if (this.scrollerType == 1) {
            this.textArray = this.changeToArrayHorizontal(this.text, this.font);
            if (this.textArray != null) {
                this.totalLength = this.font.stringWidth(this.textArray[0]);
            }
        }
    }

    String[] changeToArrayHorizontal(String str, Font font) {
        String[] s = new String[]{str};
        return s;
    }

    static final String[] changeToArrayVertical(String str, Font font, int w0, int w) {
        if (!isChinese) {
            return TextScroller.changeToArrayEn(str, font, w0, w);
        }
        return TextScroller.changeToArrayCn(str, font, w0, w);
    }

    public static final String[] changeToArrayCn(String str, Font font, int w0, int width) {
        nowWidth = w0;
        Vector<String> result = new Vector<String>();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            int chWidth = font.charWidth(ch);
            if (ch == '\n' | ch == '|') {
                chWidth = 0;
            }
            if (ch == '\n' | ch == '|') {
                result.addElement(buffer.toString());
                buffer = new StringBuffer();
                nowWidth = 0;
            } else {
                if ((nowWidth += chWidth) >= width && !TextScroller.isSign(ch)) {
                    result.addElement(buffer.toString());
                    buffer = new StringBuffer();
                    nowWidth = chWidth;
                }
                buffer.append(ch);
            }
            ++i;
        }
        if (buffer.length() > 0) {
            result.addElement(buffer.toString());
        }
        String[] s = new String[result.size()];
        int i2 = 0;
        while (i2 < s.length) {
            s[i2] = (String)result.elementAt(i2);
            ++i2;
        }
        return s;
    }

    public static final String[] changeToArrayEn(String str, Font font, int w0, int width) {
        nowWidth = w0;
        Vector<String> result = new Vector<String>();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            block11: {
                char ch;
                block12: {
                    int chWidth;
                    block14: {
                        char pre;
                        block13: {
                            block10: {
                                ch = str.charAt(i);
                                if (ch != '\n') break block10;
                                result.addElement(buffer.toString());
                                buffer = new StringBuffer();
                                nowWidth = 0;
                                break block11;
                            }
                            chWidth = font.charWidth(ch);
                            if (ch == '\n') {
                                chWidth = 0;
                            }
                            if ((nowWidth += chWidth) < width) break block12;
                            pre = str.charAt(i - 1);
                            if (ch != ' ') break block13;
                            result.addElement(buffer.toString());
                            buffer = new StringBuffer();
                            nowWidth = 0;
                            break block11;
                        }
                        if (!TextScroller.isSign(pre)) break block14;
                        result.addElement(buffer.toString());
                        buffer = new StringBuffer();
                        nowWidth = chWidth;
                        break block12;
                    }
                    boolean backSuccesfully = false;
                    int b = buffer.length() - 1;
                    while (b >= 0) {
                        char chB = buffer.charAt(b);
                        if (chB == ' ') {
                            i -= buffer.length() - b;
                            buffer.delete(b, buffer.length());
                            result.addElement(buffer.toString());
                            buffer = new StringBuffer();
                            nowWidth = 0;
                            backSuccesfully = true;
                            break;
                        }
                        if (TextScroller.isSign(chB)) {
                            i -= buffer.length() - b;
                            buffer.delete(b + 1, buffer.length());
                            result.addElement(buffer.toString());
                            buffer = new StringBuffer();
                            nowWidth = 0;
                            backSuccesfully = true;
                            break;
                        }
                        --b;
                    }
                    if (backSuccesfully) break block11;
                    buffer.append('-');
                    result.addElement(buffer.toString());
                    buffer = new StringBuffer();
                    nowWidth = chWidth;
                }
                buffer.append(ch);
            }
            ++i;
        }
        if (buffer.length() > 0) {
            result.addElement(buffer.toString());
        }
        String[] s = new String[result.size()];
        int i2 = 0;
        while (i2 < s.length) {
            s[i2] = (String)result.elementAt(i2);
            ++i2;
        }
        return s;
    }

    static final boolean isSign(char ch) {
        return false;
    }
}

